/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.util.primitive.ByteArrayList;
import com.cognos.xqe.util.primitive.DoubleArrayList;
import com.cognos.xqe.util.primitive.ShortArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CompactTupleValueList
implements List<TupleValue>,
RandomAccess {
    private static final int NUM_EXTRA_ITEMS = 1000;
    private final ArrayList<IMember>[] members;
    private final IMember[] fixedMembers;
    private final DoubleArrayList values;
    private short globalFormatId = 0;
    private byte globalFlagByte = 0;
    private ShortArrayList formatIds = null;
    private ByteArrayList flagBytes = null;
    private int arrayAllocationSize;

    public CompactTupleValueList(int numHiersInTuple) {
        this(numHiersInTuple, 0);
    }

    public CompactTupleValueList(int numHiersInTuple, int initialSize) {
        this.members = new ArrayList[numHiersInTuple];
        this.fixedMembers = new IMember[numHiersInTuple];
        this.arrayAllocationSize = initialSize;
        this.values = new DoubleArrayList(this.getNewArraySize(0));
    }

    public void add(IMember[] tupleMbrs, double value, short formatId, byte flags) {
        int j;
        int numExistingItems = this.size();
        if (numExistingItems == 0) {
            System.arraycopy(tupleMbrs, 0, this.fixedMembers, 0, this.fixedMembers.length);
            this.globalFormatId = formatId;
            this.globalFlagByte = flags;
            this.values.add(value);
            return;
        }
        for (int i = 0; i < this.fixedMembers.length; ++i) {
            if (this.fixedMembers[i] == null) {
                this.members[i].add(tupleMbrs[i]);
                continue;
            }
            if (this.fixedMembers[i] == tupleMbrs[i]) continue;
            this.members[i] = new ArrayList(this.getNewArraySize(numExistingItems));
            for (int j2 = 0; j2 < numExistingItems; ++j2) {
                this.members[i].add(this.fixedMembers[i]);
            }
            this.members[i].add(tupleMbrs[i]);
            this.fixedMembers[i] = null;
        }
        if (this.formatIds != null) {
            this.formatIds.add(formatId);
        } else if (this.globalFormatId != formatId) {
            this.formatIds = new ShortArrayList(this.getNewArraySize(numExistingItems));
            for (j = 0; j < numExistingItems; ++j) {
                this.formatIds.add(this.globalFormatId);
            }
            this.formatIds.add(formatId);
        }
        if (this.flagBytes != null) {
            this.flagBytes.add(flags);
        } else if (this.globalFlagByte != flags) {
            this.flagBytes = new ByteArrayList(this.getNewArraySize(numExistingItems));
            for (j = 0; j < numExistingItems; ++j) {
                this.flagBytes.add(this.globalFlagByte);
            }
            this.flagBytes.add(flags);
        }
        this.values.add(value);
    }

    public void addAll(CompactTupleValueList other) {
        TupleValue tupleValue = null;
        int numElements = other.size();
        for (int i = 0; i < numElements; ++i) {
            tupleValue = other.get(i, tupleValue);
            this.add(tupleValue);
        }
    }

    @Override
    public boolean addAll(Collection<? extends TupleValue> tupleValues) {
        for (TupleValue tupleValue : tupleValues) {
            this.add(tupleValue);
        }
        return true;
    }

    @Override
    public boolean add(TupleValue tupleValue) {
        DoubleValue dv = (DoubleValue)tupleValue.getCell().getValue();
        this.add(tupleValue.getTuple().getMembers(), dv.getDouble(), dv.getInternalFormatId(), dv.getState().getState());
        return true;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public void trim() {
        this.values.trim();
        if (this.formatIds != null) {
            this.formatIds.trim();
        }
        if (this.flagBytes != null) {
            this.flagBytes.trim();
        }
        for (ArrayList<IMember> mbrs : this.members) {
            if (mbrs == null) continue;
            mbrs.trimToSize();
        }
    }

    @Override
    public TupleValue get(int index) {
        return this.get(index, null);
    }

    public TupleValue get(int index, TupleValue tupleValue) {
        DoubleValue doubleValue;
        if (tupleValue == null) {
            IMember[] tupleMembers = this.fetchMembers(index, null);
            doubleValue = DataValueFactory.createDoubleValue();
            tupleValue = new TupleValue(new Tuple(tupleMembers, false), new Cell(doubleValue));
        } else {
            this.fetchMembers(index, tupleValue.getTuple().getMembers());
            doubleValue = (DoubleValue)tupleValue.getCell().getValue();
        }
        doubleValue.set(this.values.get(index));
        if (this.formatIds != null) {
            doubleValue.setInternalFormatId(this.formatIds.get(index));
        } else {
            doubleValue.setInternalFormatId(this.globalFormatId);
        }
        if (this.flagBytes != null) {
            doubleValue.setState(ValueState.getValueState(this.flagBytes.get(index)));
        } else {
            doubleValue.setState(ValueState.getValueState(this.globalFlagByte));
        }
        return tupleValue;
    }

    @Override
    public Iterator<TupleValue> iterator() {
        return this.iterator(null, 0, this.size());
    }

    public Iterator<TupleValue> iterator(TupleValue[] tupleValuesToReuse, int startIndex, int endIndex) {
        return new CompactTupleValueListIterator(tupleValuesToReuse, startIndex, endIndex);
    }

    private IMember[] fetchMembers(int index, IMember[] mbrs) {
        if (mbrs == null) {
            mbrs = new IMember[this.fixedMembers.length];
        }
        for (int i = 0; i < this.fixedMembers.length; ++i) {
            mbrs[i] = this.fixedMembers[i] != null ? this.fixedMembers[i] : this.members[i].get(index);
        }
        return mbrs;
    }

    private int getNewArraySize(int numExistingItems) {
        if (this.arrayAllocationSize > numExistingItems) {
            return this.arrayAllocationSize;
        }
        return numExistingItems + 1000;
    }

    @Override
    public void add(int arg0, TupleValue arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends TupleValue> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TupleValue> listIterator() {
        return new CompactTupleValueListIterator(null, 0, this.size());
    }

    @Override
    public ListIterator<TupleValue> listIterator(int arg0) {
        return new CompactTupleValueListIterator(null, arg0, this.size());
    }

    @Override
    public TupleValue remove(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleValue set(int arg0, TupleValue arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TupleValue> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        TupleValue[] tvArray = new TupleValue[this.size()];
        return this.toArray(tvArray);
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        int i;
        int numValues = this.size();
        if (arg0.length < numValues) {
            Class<?> ct = arg0.getClass().getComponentType();
            arg0 = (Object[])Array.newInstance(ct, numValues);
        }
        for (i = 0; i < arg0.length && i < numValues; ++i) {
            arg0[i] = this.get(i);
        }
        for (i = numValues; i < arg0.length; ++i) {
            arg0[i] = null;
        }
        return arg0;
    }

    public class CompactTupleValueListIterator
    implements ListIterator<TupleValue> {
        private final TupleValue[] tupleValuesToReuse;
        private int nextTupleValueToReuse;
        private final int endIndex;
        private int currentIndex;

        public CompactTupleValueListIterator(TupleValue[] aTupleValuesToReuse, int startIndex, int aEndIndex) {
            this.tupleValuesToReuse = aTupleValuesToReuse;
            this.endIndex = aEndIndex;
            this.currentIndex = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.endIndex;
        }

        @Override
        public TupleValue next() {
            return CompactTupleValueList.this.get(this.currentIndex++, this.getNextCommonTupleValue());
        }

        private TupleValue getNextCommonTupleValue() {
            if (this.tupleValuesToReuse == null) {
                return null;
            }
            int curIndex = this.nextTupleValueToReuse++;
            if (this.nextTupleValueToReuse >= this.tupleValuesToReuse.length) {
                this.nextTupleValueToReuse = 0;
            }
            return this.tupleValuesToReuse[curIndex];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(TupleValue arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex + 1;
        }

        @Override
        public TupleValue previous() {
            if (this.currentIndex == 0) {
                throw new NoSuchElementException();
            }
            return CompactTupleValueList.this.get(this.currentIndex - 1, this.getNextCommonTupleValue());
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void set(TupleValue arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

