/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;

public class LevelCombination
implements Comparable<LevelCombination> {
    int[] levelIndexes;
    long quickScore;
    int combinationId;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public int getCombinationId() {
        return this.combinationId;
    }

    public void setCombinationId(int theCombinationId) {
        this.combinationId = theCombinationId;
    }

    public LevelCombination(int[] i, long theQuickScore) {
        this.levelIndexes = i;
        this.quickScore = theQuickScore;
    }

    @Override
    public int compareTo(LevelCombination o) {
        long l = this.quickScore - o.getQuickScore();
        if (l == 0L) {
            return 0;
        }
        if (l < 0L) {
            return -1;
        }
        return 1;
    }

    public int getLevelIndex(int dimensionIndex) {
        return this.levelIndexes[dimensionIndex];
    }

    public long getQuickScore() {
        return this.quickScore;
    }

    public boolean covers(Tuple t) {
        boolean result = true;
        for (int i = 1; i < t.size() && result; ++i) {
            if (((Level)t.getMember(i).getLevel()).getIndex() <= this.levelIndexes[i]) continue;
            result = false;
        }
        return result;
    }

    public ArrayList<IMember>[] getDependentMembers(Tuple t) {
        XQEDebugLog.out.println(this.toString());
        ArrayList[] result = new ArrayList[t.size()];
        result[0] = new ArrayList();
        result[0].add(t.getMember(0));
        for (int i = 1; i < t.size(); ++i) {
            IMember m = t.getMember(i);
            IDimension d = m.getDimension();
            int levelIndex = this.getLevelIndex(i);
            ILevel l = d.getLevel(levelIndex);
            try {
                ArrayList<IMember> descendants;
                result[i] = descendants = ((IMemberCubics)m).getDescendants(l);
                continue;
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        return result;
    }

    public ArrayList<IMember>[] getDependentMembersExperimental(Tuple t) {
        XQEDebugLog.out.println(this.toString());
        ArrayList[] result = new ArrayList[t.size()];
        result[0] = new ArrayList();
        result[0].add(t.getMember(0));
        for (int i = 1; i < t.size(); ++i) {
            IMember m = t.getMember(i);
            Dimension d = (Dimension)m.getDimension();
            int levelIndex = this.getLevelIndex(i);
            ILevel l = d.getLevel(levelIndex);
            try {
                ArrayList<IMember> descendants = ((IMemberCubics)m).getDescendants(l);
                XQEDebugLog.out.println("Dim : " + d.getName() + " Descs: " + descendants.toString());
                result[i] = descendants;
                continue;
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        return result;
    }

    public boolean equals(Object ck) {
        return ck.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String result = "Level Combination :";
        for (int i = 0; i < this.levelIndexes.length; ++i) {
            int index = this.levelIndexes[i];
            result = result + index + ":";
        }
        return result;
    }
}

