/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.olap.mdx.functions.IMDXFunctionProcessor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import java.util.ArrayList;

public class MDXMathOperatorProcessor
implements IMDXFunctionProcessor {
    private static final long IEEE_INDETERMINATE = -2251799813685248L;
    protected int op;
    protected Value v1;
    protected Value v2;

    @Override
    public void setFunctionCode(int operatorCode, int parameterSize) {
        this.op = operatorCode;
        this.v1 = null;
        this.v2 = null;
    }

    @Override
    public Object addParameter(InterpreterContext interpreterContext, Object cellValueObj) {
        if (this.v1 == null) {
            this.v1 = (Value)cellValueObj;
        } else {
            this.v2 = (Value)cellValueObj;
        }
        return null;
    }

    @Override
    public Object getResult(InterpreterContext interpreterContext) {
        DoubleValue v = null;
        if (this.op == 20) {
            v = DataValueFactory.createDoubleValue();
            ((Value)v).set(this.v1.getDouble() + this.v2.getDouble());
            if (this.v1.isDivByZero() || this.v2.isDivByZero()) {
                v.setState(ValueState.DIV_BY_ZERO);
            } else {
                ArrayList<FormatId> idList = new ArrayList<FormatId>();
                idList.add(this.v1.getFormatId());
                idList.add(this.v2.getFormatId());
                v.setFormatId(FormatService.getInstance().formatResult("Add", idList));
            }
        } else if (this.op == 22) {
            v = DataValueFactory.createDoubleValue();
            ((Value)v).set(this.v1.getDouble() - this.v2.getDouble());
            if (this.v1.isDivByZero() || this.v2.isDivByZero()) {
                v.setState(ValueState.DIV_BY_ZERO);
            } else {
                ArrayList<FormatId> idList = new ArrayList<FormatId>();
                idList.add(this.v1.getFormatId());
                idList.add(this.v2.getFormatId());
                v.setFormatId(FormatService.getInstance().formatResult("Subtract", idList));
            }
        } else if (this.op == 26) {
            v = DataValueFactory.createDoubleValue();
            ((Value)v).set(this.v1.getDouble() * this.v2.getDouble());
            if (this.v1.isDivByZero() || this.v2.isDivByZero()) {
                v.setState(ValueState.DIV_BY_ZERO);
            } else {
                ArrayList<FormatId> idList = new ArrayList<FormatId>();
                idList.add(this.v1.getFormatId());
                idList.add(this.v2.getFormatId());
                v.setFormatId(FormatService.getInstance().formatResult("Multiply", idList));
            }
        } else if (this.op == 24) {
            double d2;
            double d1;
            v = DataValueFactory.createDoubleValue();
            v.setFormatId(this.v1.getFormatId());
            try {
                d1 = this.v1.getDouble();
                d2 = this.v2.getDouble();
            }
            catch (Exception e) {
                return TextValue.ERROR_VALUE;
            }
            if (d2 != 0.0) {
                ((Value)v).set(d1 / d2);
            } else {
                if (d1 == 0.0) {
                    if (Double.doubleToRawLongBits(d1) == 0L) {
                        ((Value)v).set(Double.longBitsToDouble(-2251799813685248L));
                    } else {
                        ((Value)v).set(Double.NaN);
                    }
                } else if (d1 > 0.0) {
                    ((Value)v).set(Double.POSITIVE_INFINITY);
                } else {
                    ((Value)v).set(Double.NEGATIVE_INFINITY);
                }
                v.setState(ValueState.DIV_BY_ZERO);
            }
            if (this.v1.isDivByZero() || this.v2.isDivByZero()) {
                v.setState(ValueState.DIV_BY_ZERO);
            } else {
                ArrayList<FormatId> idList = new ArrayList<FormatId>();
                idList.add(this.v1.getFormatId());
                idList.add(this.v2.getFormatId());
                v.setFormatId(FormatService.getInstance().formatResult("Divide", idList));
            }
        }
        return v;
    }
}

