/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AbstractResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSetHelper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.SecuredPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;

public class SecuredResultSet
extends ResultSet {
    SecuredResultSetHelper srsh;

    protected SecuredResultSet(CrossJoinedSet qs, InterpreterContext ic) {
        super(qs);
        this.srsh = new SecuredResultSetHelper(ic);
        if (this.srsh.getSecurityManager() != null) {
            this.srsh.setTuplesToError(this);
        }
    }

    protected SecuredResultSet(CrossJoinedSet qs, SecurityManagerInterface theSecManager) {
        super(qs);
        this.srsh = new SecuredResultSetHelper(theSecManager);
        this.srsh.setTuplesToError(this);
    }

    protected SecuredResultSet(ISet[] a, ISet s, InterpreterContext ic) {
        super(a, s);
        this.srsh = new SecuredResultSetHelper(ic);
        this.srsh.setTuplesToError(this);
    }

    public SecuredResultSet(InterpreterContext interpreterContext) {
        super(interpreterContext);
        this.srsh = new SecuredResultSetHelper(interpreterContext);
        this.srsh.setTuplesToError(this);
    }

    protected SecuredResultSet(AbstractResultSet rs) {
        super(rs);
        if (rs instanceof SecuredResultSet) {
            this.srsh = ((SecuredResultSet)rs).srsh;
        } else if (rs instanceof SecuredPipelineResultSet) {
            this.srsh = ((SecuredPipelineResultSet)rs).getSecurityHelper();
        }
    }

    public SecuredResultSet() {
    }

    @Override
    public boolean isTupleValueVisible(Number cellOrdinal) {
        return this.srsh.isTupleValueVisible(cellOrdinal, this);
    }

    @Override
    public boolean isTupleValueVisible(ITuple tuple) {
        return this.srsh.isTupleValueVisible(tuple);
    }

    @Override
    public void captureSecuredOrdinal(Number cellOrdinal) {
        this.srsh.captureSecuredOrdinal(cellOrdinal);
    }

    @Override
    public boolean isSecuredOrdinal(Number ordinal) {
        return this.srsh.isSecuredOrdinal(ordinal);
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.srsh.isSecurityEnabled();
    }
}

