/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;

public class TupleValue
implements Comparable<Object> {
    private final Tuple tuple;
    private final Cell cell;
    Comparable tiesComp = null;

    public TupleValue(ITuple t, Cell c) {
        this.cell = c;
        this.tuple = (Tuple)t;
    }

    public double getCellValue() {
        return this.cell.getNumericValue();
    }

    public String getCellStringValue() {
        return this.cell.getStringValue();
    }

    @Override
    public int compareTo(Object o) {
        Object value1 = this.getCell().getObjectValue();
        Object value2 = ((TupleValue)o).getCell().getObjectValue();
        int compValue = 0;
        if (value1 instanceof Value) {
            compValue = ((Value)value1).compareTo(value2);
        } else if (value1 instanceof String && value2 instanceof String) {
            compValue = ((String)value1).compareToIgnoreCase((String)value2);
        } else {
            compValue = Double.compare(this.getCellValue(), ((TupleValue)o).getCellValue());
            if (Double.isNaN(this.getCellValue()) || Double.isNaN(((TupleValue)o).getCellValue())) {
                compValue *= -1;
            }
        }
        if (compValue == 0 && this.tiesComp != null && ((TupleValue)o).tiesComp != null) {
            compValue = this.tiesComp.compareTo(((TupleValue)o).tiesComp);
        }
        return compValue;
    }

    public String toString() {
        return "t:" + this.tuple + "value :" + this.cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public void setTiesComp(Comparable theTiesComp) {
        this.tiesComp = theTiesComp;
    }
}

