/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter;

import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TypeCoercion {
    private static final String ERROR_DETAIL_STR = "String, Boolean, Integer, Double, NULL";

    public static Boolean getBooleanOperand(Object o) throws InterpreterException {
        if (o == null || o instanceof NullObject) {
            return Boolean.FALSE;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Double) {
            if ((Double)o == 0.0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new InterpreterException("X01490", new String[]{o.getClass().toString(), "getBooleanOperand", "String, Boolean, Double"});
    }

    public static Double getDoubleOperand(Object o) throws InterpreterException {
        if (o == null || o instanceof NullObject) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return new Double(((Integer)o).doubleValue());
        }
        if (o instanceof Boolean) {
            if (!((Boolean)o).booleanValue()) {
                return 0.0;
            }
            return 1.0;
        }
        if (o instanceof String) {
            if ("#ERR".equals(o)) {
                return Double.NaN;
            }
            try {
                return Double.valueOf((String)o);
            }
            catch (Exception e) {
                Double d = TypeCoercion.getDoubleDateOperand(o);
                if (d == null) {
                    throw new InterpreterException("X01434", new String[]{o.getClass().getSimpleName(), "CMP_TYPENUMERIC"}, e);
                }
                return d;
            }
        }
        if (o instanceof Timestamp) {
            return new Double(((Timestamp)o).getTime());
        }
        throw new InterpreterException("X01434", new String[]{o.getClass().toString(), ERROR_DETAIL_STR});
    }

    public static double getDouble(Value v) throws InterpreterException {
        double d;
        if (v.isNull()) {
            d = 0.0;
        } else if (v instanceof BooleanValue) {
            boolean b = v.getBoolean();
            d = b ? 1.0 : 0.0;
        } else {
            try {
                d = v.getDouble();
            }
            catch (Exception e) {
                throw new InterpreterException("X01434", new String[]{v.getClass().toString(), ERROR_DETAIL_STR}, e);
            }
        }
        return d;
    }

    private static Double getDoubleDateOperand(Object o) {
        long time = 0L;
        SimpleDateFormat df = null;
        try {
            df = new SimpleDateFormat();
            time = df.parse((String)o).getTime();
            return new Double(time);
        }
        catch (ParseException parseException) {
            String[] formats;
            for (String format : formats = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy.MM.dd G 'at' HH:mm:ss z", "EEE, MMM d, ''yy", "h:mm a", "hh 'o''clock' a, zzzz", "K:mm a, z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "HH:mm:ss", "yyyy-MM-dd"}) {
                try {
                    df = new SimpleDateFormat(format);
                    time = df.parse((String)o).getTime();
                    return new Double(time);
                }
                catch (ParseException parseException2) {
                }
            }
            return null;
        }
    }
}

