/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SolveOrderComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class CrossJoinTupleList
extends TupleList {
    ITupleList[] childTupleLists;
    long size;
    BigInteger bigSize = null;
    int width;
    long listSize;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
    private static final String TUPLELIST_FIND_RESULT_TOO_LARGE = "TupleList.Find result too large: ";

    private CrossJoinTupleList(List<ITupleList> theChildTupleLists) {
        this.childTupleLists = new ITupleList[theChildTupleLists.size()];
        this.size = 1L;
        this.width = 0;
        this.listSize = 0L;
        boolean distinct = true;
        ArrayList<ITupleList> chTLs = new ArrayList<ITupleList>();
        for (int inx = 0; inx < theChildTupleLists.size(); ++inx) {
            ITupleList subTl = theChildTupleLists.get(inx);
            if (subTl == null) continue;
            chTLs.add(subTl);
            this.width += subTl.width();
            this.listSize += subTl.listSize();
            if (subTl.getDistinctFlag()) continue;
            distinct = false;
        }
        this.setDistinctFlag(distinct);
        this.childTupleLists = chTLs.toArray(new ITupleList[chTLs.size()]);
        this.setSize();
        if (this.listSize == 0L) {
            this.size = 0L;
        }
    }

    private void setSize() {
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            long childSize = this.childTupleLists[inx].size();
            if (childSize < 0L) {
                this.size = Long.MIN_VALUE;
                break;
            }
            this.size = NumberOp.multiplyQuantities(this.size, childSize);
            if (this.size < 0L) break;
        }
        if (this.size < 0L) {
            this.setBigSize();
        }
    }

    private void setBigSize() {
        this.bigSize = BigInteger.ONE;
        if (this.childTupleLists.length == 0) {
            this.bigSize = BigInteger.ZERO;
        }
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            if (this.childTupleLists[inx] == null) continue;
            this.bigSize = this.bigSize.multiply(this.childTupleLists[inx].noOverflowSize());
        }
    }

    public static ITupleList construct(List<ITupleList> childTupleLists) {
        if (childTupleLists.size() == 0) {
            return null;
        }
        if (childTupleLists.size() == 1) {
            return childTupleLists.get(0);
        }
        ArrayList<ITupleList> expandedTupleLists = new ArrayList<ITupleList>();
        for (int inx = 0; inx < childTupleLists.size(); ++inx) {
            ITupleList tl = childTupleLists.get(inx);
            if (tl instanceof CrossJoinTupleList) {
                CrossJoinTupleList cjtl = (CrossJoinTupleList)tl;
                for (int inx2 = 0; inx2 < cjtl.childTupleLists.length; ++inx2) {
                    expandedTupleLists.add(cjtl.childTupleLists[inx2]);
                }
                continue;
            }
            if (tl == null) continue;
            expandedTupleLists.add(tl);
        }
        if (expandedTupleLists.size() == 1) {
            return (ITupleList)expandedTupleLists.get(0);
        }
        return new CrossJoinTupleList(expandedTupleLists);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public BigInteger noOverflowSize() {
        if (this.bigSize == null) {
            this.setBigSize();
        }
        return this.bigSize;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public long listSize() {
        return this.listSize;
    }

    @Override
    public void replaceMember(int memIndex, IMember m) {
        this.setDistinctFlag(false);
        int firstMemIdx = 0;
        int lastMemIdx = this.childTupleLists[0].width() - 1;
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (memIndex <= lastMemIdx) {
                this.childTupleLists[i].replaceMember(memIndex - firstMemIdx, m);
                break;
            }
            firstMemIdx = lastMemIdx + 1;
            lastMemIdx += this.childTupleLists[i].width();
        }
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        int currPos = 0;
        long runningSize = 1L;
        ArrayList<List<Number>> subIndices = new ArrayList<List<Number>>(this.childTupleLists.length);
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            ITupleList subTl = this.childTupleLists[inx];
            IMember[] subMems = new IMember[subTl.width()];
            System.arraycopy(findMems, currPos, subMems, 0, subTl.width());
            List<Number> subIndex = subTl.find(subMems, first);
            if (subIndex.size() == 0) {
                return subIndex;
            }
            subIndices.add(subIndex);
            runningSize *= (long)subIndex.size();
            currPos += subTl.width();
        }
        if (runningSize > Integer.MAX_VALUE) {
            throw new InternalError(TUPLELIST_FIND_RESULT_TOO_LARGE + runningSize);
        }
        ArrayList<Number> indices = new ArrayList<Number>((int)runningSize);
        if (this.size() < 0L) {
            this.findSetIndex(0, this.noOverflowSize(), subIndices, (Number)0L, indices);
        } else {
            this.findSetIndex(0, this.size(), (List<List<Number>>)subIndices, 0L, (List<Number>)indices);
        }
        return indices;
    }

    @Override
    public List<Number> findSubTuple(IMember[] findMems, boolean first) {
        long runningSize = 1L;
        ArrayList<List<Number>> subIndices = new ArrayList<List<Number>>(this.childTupleLists.length);
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            ITupleList subTl = this.childTupleLists[inx];
            IHierarchy[] subHierarchies = subTl.iterator().next().getHierarchies();
            IMember[] subMems = this.getMembers(findMems, subHierarchies);
            List<Object> subIndex = null;
            if (subMems.length == 0) {
                subIndex = new ArrayList();
                for (long i = 0L; i < subTl.size(); ++i) {
                    subIndex.add(i);
                }
            } else {
                subIndex = subTl.findSubTuple(subMems, first);
            }
            if (subIndex.size() == 0) {
                return subIndex;
            }
            subIndices.add(subIndex);
            runningSize *= (long)subIndex.size();
        }
        if (runningSize > Integer.MAX_VALUE) {
            throw new InternalError(TUPLELIST_FIND_RESULT_TOO_LARGE + runningSize);
        }
        ArrayList<Number> indices = new ArrayList<Number>((int)runningSize);
        if (this.size() < 0L) {
            this.findSetIndex(0, this.noOverflowSize(), subIndices, (Number)0L, indices);
        } else {
            this.findSetIndex(0, this.size(), (List<List<Number>>)subIndices, 0L, (List<Number>)indices);
        }
        return indices;
    }

    private IMember[] getMembers(IMember[] tupleMembers, IHierarchy[] hierarchies) {
        ArrayList<IMetadata> out = new ArrayList<IMetadata>();
        HashSet<IHierarchy> hiers = new HashSet<IHierarchy>(hierarchies.length);
        for (IHierarchy iHierarchy : hierarchies) {
            hiers.add(iHierarchy);
        }
        for (IMetadata iMetadata : tupleMembers) {
            if (!hiers.contains(iMetadata.getHierarchy())) continue;
            out.add(iMetadata);
            if (out.size() == hierarchies.length) break;
        }
        return out.toArray(new IMember[out.size()]);
    }

    @Override
    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        ArrayList<Number> result = new ArrayList<Number>(1);
        Number[] sizes = new Number[this.childTupleLists.length];
        ArrayList<List<Number>> axesOrdinal = new ArrayList<List<Number>>();
        for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
            TupleList aChildTupleList = (TupleList)this.childTupleLists[inx];
            List<Number> ordinals = aChildTupleList.find(tuple, cache);
            if (ordinals.isEmpty()) {
                result.clear();
                return result;
            }
            axesOrdinal.add(0, ordinals);
            long childSize = this.childTupleLists[inx].size();
            sizes[this.childTupleLists.length - 1 - inx] = childSize < 0L ? this.childTupleLists[inx].noOverflowSize() : Long.valueOf(childSize);
        }
        ArrayList<Number[]> tupleOrdinals = new ArrayList<Number[]>();
        CrossJoinTupleList.computeTupleOrdinals(axesOrdinal, tupleOrdinals, true);
        for (Number[] tupleOrdinal : tupleOrdinals) {
            Number cellOrdinal = ResultSetMetadata.computeCellOrdinal(tupleOrdinal, sizes);
            result.add(cellOrdinal);
        }
        return result;
    }

    @Override
    public boolean containsNullMembers() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsNullMembers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsCalculatedMembers() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsCalculatedMembers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMeasures() {
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            if (!this.childTupleLists[i].containsMeasures()) continue;
            return true;
        }
        return false;
    }

    @Override
    public HashSet<IMember> getCalculatedMembers() {
        HashSet<IMember> calculatedMembers = new HashSet<IMember>();
        for (long idx = 0L; idx < (long)this.childTupleLists.length; ++idx) {
            HashSet<IMember> calcMembers = this.childTupleLists[(int)idx].getCalculatedMembers();
            if (calcMembers.size() <= 0) continue;
            calculatedMembers.addAll(calcMembers);
        }
        return calculatedMembers;
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        for (long idx = 0L; idx < (long)this.childTupleLists.length; ++idx) {
            IMember[] m = this.childTupleLists[(int)idx].getMembers(d);
            if (m.length <= 0) continue;
            return m;
        }
        return new IMember[0];
    }

    @Override
    public IMember[][] getMembers(IDimension[] d) {
        if (this.childTupleLists.length == 0) {
            return new IMember[0][0];
        }
        IMember[][] mergedMembers = this.childTupleLists[0].getMembers(d);
        for (long idx = 1L; idx < (long)this.childTupleLists.length; ++idx) {
            IMember[][] childMembers = this.childTupleLists[(int)idx].getMembers(d);
            for (int dimIdx = 0; dimIdx < d.length; ++dimIdx) {
                if (childMembers[dimIdx].length <= 0) continue;
                mergedMembers[dimIdx] = childMembers[dimIdx];
            }
        }
        return mergedMembers;
    }

    @Override
    public IMember[][] getMembers(IHierarchy[] h) {
        if (this.childTupleLists.length == 0) {
            return new IMember[0][0];
        }
        IMember[][] mergedMembers = this.childTupleLists[0].getMembers(h);
        for (long idx = 1L; idx < (long)this.childTupleLists.length; ++idx) {
            IMember[][] childMembers = this.childTupleLists[(int)idx].getMembers(h);
            for (int dimIdx = 0; dimIdx < h.length; ++dimIdx) {
                if (childMembers[dimIdx].length <= 0) continue;
                mergedMembers[dimIdx] = childMembers[dimIdx];
            }
        }
        return mergedMembers;
    }

    @Override
    public IMember[][] getMembers(int[] dimHierIdx) {
        IMember[][] dimHierMembers = new IMember[dimHierIdx.length][];
        int startPosition = -1;
        int endPosition = -1;
        for (ITupleList child : this.childTupleLists) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            int currentWidth = child.width();
            int[] currentDimHierIdx = new int[dimHierIdx.length];
            startPosition = endPosition + 1;
            endPosition = startPosition + currentWidth - 1;
            for (int i = 0; i < dimHierIdx.length; ++i) {
                currentDimHierIdx[i] = dimHierIdx[i] >= startPosition && dimHierIdx[i] <= endPosition ? dimHierIdx[i] - startPosition : -1;
            }
            IMember[][] memberArrays = ((TupleList)child).getMembers(currentDimHierIdx);
            for (int i = 0; i < dimHierIdx.length; ++i) {
                if (memberArrays[i].length <= 0) continue;
                dimHierMembers[i] = memberArrays[i];
            }
        }
        return dimHierMembers;
    }

    @Override
    public void getCalculatedMemberSets(HashMap<CalculatedMember, Set> calculatedMemToSet, List<Set> baseSetList, ICube cube) {
        ITupleIterator iter = this.iterator();
        if (iter.hasNext()) {
            if (cube == null) {
                Tuple tuple = (Tuple)iter.next();
                cube = tuple.getCube();
            }
        } else {
            baseSetList.add(new Set(new Tuple[0]));
            return;
        }
        SolveOrderComparator solveOrderComp = new SolveOrderComparator(cube);
        ArrayList childBaseSetList = new ArrayList();
        ArrayList<HashMap<CalculatedMember, Set>> calculatedMemToSetList = new ArrayList<HashMap<CalculatedMember, Set>>();
        HashMap<Integer, Integer> childIndexToCalculatedMemSetIndex = new HashMap<Integer, Integer>();
        HashMap<CalculatedMember, Integer> calculatedMemToChildIndex = new HashMap<CalculatedMember, Integer>();
        int nonEmptySetIndex = 0;
        for (int i = 0; i < this.childTupleLists.length; ++i) {
            HashMap<CalculatedMember, Set> tmpCalculatedMemToSet = new HashMap<CalculatedMember, Set>();
            ArrayList<Set> tmpBaseSetList = new ArrayList<Set>();
            this.childTupleLists[i].getCalculatedMemberSets(tmpCalculatedMemToSet, tmpBaseSetList, cube);
            java.util.Set<CalculatedMember> set = tmpCalculatedMemToSet.keySet();
            Iterator<CalculatedMember> setIt = set.iterator();
            while (setIt.hasNext()) {
                calculatedMemToChildIndex.put(setIt.next(), i);
            }
            if (!tmpCalculatedMemToSet.isEmpty()) {
                calculatedMemToSetList.add(tmpCalculatedMemToSet);
                childIndexToCalculatedMemSetIndex.put(i, nonEmptySetIndex);
                ++nonEmptySetIndex;
            } else {
                childIndexToCalculatedMemSetIndex.put(i, -1);
            }
            if (!tmpBaseSetList.isEmpty()) {
                childBaseSetList.add(tmpBaseSetList.get(0));
                continue;
            }
            childBaseSetList.add(new Set(new Tuple[0]));
        }
        if (childBaseSetList.size() > 1) {
            long nonEmptySets = 0L;
            for (Set childBaseSet : childBaseSetList) {
                if (childBaseSet.size() <= 0L) continue;
                ++nonEmptySets;
            }
            if (nonEmptySets != (long)this.childTupleLists.length) {
                baseSetList.add(new Set(new Tuple[0]));
            } else {
                ISet[] sets = childBaseSetList.toArray(new Set[childBaseSetList.size()]);
                CrossJoinedSet cjs = new CrossJoinedSet(sets);
                baseSetList.add(cjs);
            }
        } else if (childBaseSetList.size() == 1) {
            baseSetList.add((Set)childBaseSetList.get(0));
        }
        HashMap[] calculatedMemToSetArray = calculatedMemToSetList.toArray(new HashMap[0]);
        for (int i = 0; i < calculatedMemToSetArray.length; ++i) {
            java.util.Set set = calculatedMemToSetArray[i].keySet();
            for (CalculatedMember calculatedMem : set) {
                ArrayList<Object> allChildrenSetList = new ArrayList<Object>();
                for (int j = 0; j < this.childTupleLists.length; ++j) {
                    ArrayList<ITupleList> cousinSetList = new ArrayList<ITupleList>();
                    if (j != (Integer)calculatedMemToChildIndex.get(calculatedMem)) {
                        ITupleList tl;
                        if (!childBaseSetList.isEmpty() && (tl = ((Set)childBaseSetList.get(j)).getTupleList()) != null) {
                            cousinSetList.add(tl);
                        }
                        if ((Integer)childIndexToCalculatedMemSetIndex.get(j) != -1) {
                            HashMap cousinCalculatedMemToSet = calculatedMemToSetArray[(Integer)childIndexToCalculatedMemSetIndex.get(j)];
                            for (CalculatedMember cousinCalculatedMem : cousinCalculatedMemToSet.keySet()) {
                                if (cousinCalculatedMem == calculatedMem || solveOrderComp.compare(calculatedMem, cousinCalculatedMem) >= 0) continue;
                                cousinSetList.add(((Set)cousinCalculatedMemToSet.get(cousinCalculatedMem)).getTupleList());
                            }
                        }
                    } else {
                        allChildrenSetList.add(calculatedMemToSetArray[i].get(calculatedMem));
                    }
                    if (cousinSetList.size() > 1) {
                        allChildrenSetList.add(new Set(UnionTupleList.construct(cousinSetList)));
                        continue;
                    }
                    if (cousinSetList.size() != 1) continue;
                    allChildrenSetList.add(new Set((ITupleList)cousinSetList.get(0)));
                }
                if (allChildrenSetList.size() != this.childTupleLists.length) continue;
                calculatedMemToSet.put(calculatedMem, new CrossJoinedSet(allChildrenSetList.toArray(new Set[allChildrenSetList.size()])));
            }
        }
    }

    private void findSetIndex(int subInx, Number subSize, List<List<Number>> subIndices, Number childIndex, List<Number> indices) {
        if (subInx < this.childTupleLists.length) {
            ITupleList subTl = this.childTupleLists[subInx];
            subSize = NumberOp.divide(subSize, (Number)subTl.size());
            List<Number> subIndex = subIndices.get(subInx);
            for (int inx = 0; inx < subIndex.size(); ++inx) {
                this.findSetIndex(subInx + 1, subSize, subIndices, NumberOp.add(childIndex, NumberOp.multiply(subIndex.get(inx), subSize)), indices);
            }
        } else {
            indices.add(childIndex);
        }
    }

    private void findSetIndex(int subInx, long subSize, List<List<Number>> subIndices, long childIndex, List<Number> indices) {
        if (subInx < this.childTupleLists.length) {
            ITupleList subTl = this.childTupleLists[subInx];
            subSize /= subTl.size();
            List<Number> subIndex = subIndices.get(subInx);
            for (int inx = 0; inx < subIndex.size(); ++inx) {
                this.findSetIndex(subInx + 1, subSize, subIndices, childIndex + (Long)subIndex.get(inx) * subSize, indices);
            }
        } else {
            indices.add(new Long(childIndex));
        }
    }

    @Override
    public ITupleIterator iterator() {
        return new CrossJoinTupleIterator(this);
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            ArrayList<ITupleList> clonedChildTLs = new ArrayList<ITupleList>(this.childTupleLists.length);
            for (int inx = 0; inx < this.childTupleLists.length; ++inx) {
                clonedChildTLs.add(this.childTupleLists[inx].copy());
            }
            tl = new CrossJoinTupleList(clonedChildTLs);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    public ITupleList[] getChildTupleLists() {
        return this.childTupleLists;
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        ArrayList<List<Set>> childLists = new ArrayList<List<Set>>();
        for (ITupleList tl : this.childTupleLists) {
            List<Set> childList = tl.getSymmetricSets(splitAsymmetricSets);
            if (childList == null) {
                return null;
            }
            childLists.add(childList);
        }
        ArrayList<Set> simpleList = new ArrayList<Set>();
        this.populateCJSList(new Set[childLists.size()], 0, childLists, simpleList);
        return simpleList;
    }

    private void populateCJSList(Set[] groups, int i, List<List<Set>> subsetList, List<Set> cjsList) {
        if (i >= subsetList.size()) {
            cjsList.add(new CrossJoinedSet(groups));
        } else {
            for (Set set : subsetList.get(i)) {
                Set[] setsDuplicate = (Set[])groups.clone();
                setsDuplicate[i] = set;
                this.populateCJSList(setsDuplicate, i + 1, subsetList, cjsList);
            }
        }
    }

    private final class CrossJoinTupleIterator
    extends TupleIterator {
        TupleIterator[] childTupleListIterators;
        IMember[] currMembers;

        private CrossJoinTupleIterator(TupleList tl) {
            super(tl);
            this.currMembers = null;
            this.childTupleListIterators = new TupleIterator[CrossJoinTupleList.this.childTupleLists.length];
            for (int inx = 0; inx < CrossJoinTupleList.this.childTupleLists.length; ++inx) {
                this.childTupleListIterators[inx] = (TupleIterator)CrossJoinTupleList.this.childTupleLists[inx].iterator();
            }
            this.currMembers = new IMember[CrossJoinTupleList.this.width];
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            int totalNumberOfMembersAdded = this.fetchMembers(index, this.currMembers, 0);
            this.throwWrongWidthException(totalNumberOfMembersAdded);
            return this.currMembers;
        }

        protected void throwWrongWidthException(int totalNumberOfMembersAdded) {
            if (totalNumberOfMembersAdded != CrossJoinTupleList.this.width) {
                throw new XQERuntimeException(new Throwable("Wrong number of members. Expected {" + CrossJoinTupleList.this.width + "}, but only got {" + totalNumberOfMembersAdded + "}"));
            }
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            int totalNumberOfMembersAdded = 0;
            if (index < CrossJoinTupleList.this.childTupleLists[CrossJoinTupleList.this.childTupleLists.length - 1].size() && index >= 0L) {
                for (int i = 0; i < CrossJoinTupleList.this.childTupleLists.length; ++i) {
                    long subIndex = 0L;
                    if (i == CrossJoinTupleList.this.childTupleLists.length - 1) {
                        subIndex = index;
                    }
                    int numOfMembersAdded = this.childTupleListIterators[i].fetchMembers(subIndex, membersArray, indexToStart);
                    indexToStart += numOfMembersAdded;
                    totalNumberOfMembersAdded += numOfMembersAdded;
                }
            } else {
                long childIndex = index;
                long n = CrossJoinTupleList.this.size();
                if (n < 0L) {
                    this.getMembers(BigInteger.valueOf(childIndex), membersArray, indexToStart);
                } else {
                    for (int i = 0; i < CrossJoinTupleList.this.childTupleLists.length; ++i) {
                        ITupleList subTl = CrossJoinTupleList.this.childTupleLists[i];
                        long subIndex = childIndex / (n /= subTl.size());
                        childIndex -= subIndex * n;
                        int numOfMembersAdded = this.childTupleListIterators[i].fetchMembers(subIndex, membersArray, indexToStart);
                        indexToStart += numOfMembersAdded;
                        totalNumberOfMembersAdded += numOfMembersAdded;
                    }
                }
            }
            return totalNumberOfMembersAdded;
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            int totalNumberOfMembersAdded = this.fetchMembers(index, this.currMembers, 0);
            this.throwWrongWidthException(totalNumberOfMembersAdded);
            return this.currMembers;
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            if (CrossJoinTupleList.this.size < 0L) {
                return this.getMembers(index, membersArray, indexToStart);
            }
            return this.fetchMembers(index.longValue(), membersArray, indexToStart);
        }

        @Override
        public ITuple getTuple(BigInteger theIndex) {
            this.checkForCancelRequest();
            IMember[] sourceMembers = new IMember[CrossJoinTupleList.this.width];
            this.fetchMembers(theIndex, sourceMembers, 0);
            Tuple retTuple = new Tuple(new IMember[sourceMembers.length], false);
            retTuple.setMembers(sourceMembers);
            return retTuple;
        }

        private void getMembers(BigInteger index) {
            int currPos = 0;
            BigInteger bSize = CrossJoinTupleList.this.noOverflowSize();
            for (int i = 0; i < CrossJoinTupleList.this.childTupleLists.length; ++i) {
                ITupleList subTl = CrossJoinTupleList.this.childTupleLists[i];
                bSize = bSize.divide(subTl.noOverflowSize());
                BigInteger[] dvdAndRdr = index.divideAndRemainder(bSize);
                index = dvdAndRdr[1];
                IMember[] mems = this.childTupleListIterators[i].fetchMembers(dvdAndRdr[0]);
                System.arraycopy(mems, 0, this.currMembers, currPos, mems.length);
                currPos += mems.length;
            }
        }

        private int getMembers(BigInteger index, IMember[] memberArray, int currPos) {
            int totalNumberOfMembersAdded = 0;
            BigInteger bSize = CrossJoinTupleList.this.noOverflowSize();
            for (int i = 0; i < CrossJoinTupleList.this.childTupleLists.length; ++i) {
                ITupleList subTl = CrossJoinTupleList.this.childTupleLists[i];
                bSize = bSize.divide(subTl.noOverflowSize());
                BigInteger[] dvdAndRdr = index.divideAndRemainder(bSize);
                index = dvdAndRdr[1];
                int numberOfMembersAdded = this.childTupleListIterators[i].fetchMembers(dvdAndRdr[0], memberArray, currPos);
                totalNumberOfMembersAdded += numberOfMembersAdded;
                currPos += numberOfMembersAdded;
            }
            return totalNumberOfMembersAdded;
        }
    }
}

