/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SolveOrderComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.UnionTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public final class ExtractTupleList
extends TupleList {
    TupleList childTupleList;
    int[] dimMap;

    private ExtractTupleList(ITupleList child, int[] theDimMap) {
        this.childTupleList = (TupleList)child;
        this.dimMap = theDimMap;
        if (theDimMap.length != child.width()) {
            this.setDistinctFlag(false);
        }
    }

    public static ITupleList construct(ITupleList child, int[] dimMap) {
        if (child == null) {
            return null;
        }
        if (dimMap == null || dimMap.length == 0) {
            return null;
        }
        if (child.width() == dimMap.length) {
            int inx;
            for (inx = 0; inx < dimMap.length && dimMap[inx] == inx; ++inx) {
            }
            if (inx == dimMap.length) {
                return child;
            }
        }
        ExtractTupleList tl = new ExtractTupleList(child, dimMap);
        tl.setInvalidTuplesRemoved(child.getInvalidTuplesRemoved());
        return tl;
    }

    public static ITupleList construct(ITupleList child, ListOrderedSet hiersToRemove, boolean retainDuplicates) {
        ITupleList tl;
        if (child instanceof CrossJoinTupleList && (tl = ExtractTupleList.constructCrossJoinTupleList((CrossJoinTupleList)child, hiersToRemove, retainDuplicates)) != null) {
            return tl;
        }
        IHierarchy[] allHiers = child.iterator().getTuple(0L).getHierarchies();
        int[] hierMap = new int[allHiers.length - hiersToRemove.size()];
        int j = 0;
        for (int i = 0; i < allHiers.length; ++i) {
            if (hiersToRemove.contains((Object)allHiers[i])) continue;
            hierMap[j] = i;
            ++j;
        }
        if (child instanceof UnionTupleList) {
            ITupleList[] unionChildren = ((UnionTupleList)child).getChildTupleLists();
            ArrayList<ITupleList> unionTL = new ArrayList<ITupleList>();
            for (int i = 0; i < unionChildren.length; ++i) {
                ITupleList tl2 = unionChildren[i];
                ITupleList xjTL = null;
                if (tl2 instanceof CrossJoinTupleList) {
                    xjTL = ExtractTupleList.constructCrossJoinTupleList((CrossJoinTupleList)tl2, hiersToRemove, retainDuplicates);
                    if (xjTL == null) {
                        xjTL = ExtractTupleList.construct(tl2, hierMap);
                    }
                } else {
                    xjTL = ExtractTupleList.construct(tl2, hierMap);
                }
                if (xjTL == null) continue;
                unionTL.add(xjTL);
            }
            return UnionTupleList.construct(unionTL);
        }
        return ExtractTupleList.construct(child, hierMap);
    }

    private static ITupleList constructCrossJoinTupleList(CrossJoinTupleList tl, ListOrderedSet hiersToRemove, boolean retainDuplicates) {
        ArrayList<ITupleList> newChildTupleList = new ArrayList<ITupleList>();
        ITupleList[] childTupleLists = tl.getChildTupleLists();
        long duplicateTimes = -1L;
        for (int i = 0; i < childTupleLists.length; ++i) {
            IHierarchy[] tlHierarchies = childTupleLists[i].iterator().getTuple(0L).getHierarchies();
            boolean allContained = true;
            for (int j = 0; j < tlHierarchies.length; ++j) {
                if (hiersToRemove.contains((Object)tlHierarchies[j])) continue;
                allContained = false;
                break;
            }
            if (allContained) {
                if (!retainDuplicates) continue;
                if (childTupleLists[i].size() < 0L) {
                    return null;
                }
                if (childTupleLists[i].size() <= 1L) continue;
                if (i == 0) {
                    duplicateTimes = childTupleLists[i].size();
                    continue;
                }
                return null;
            }
            boolean allExcluded = true;
            for (int j = 0; j < tlHierarchies.length; ++j) {
                if (!hiersToRemove.contains((Object)tlHierarchies[j])) continue;
                allExcluded = false;
                break;
            }
            if (!allExcluded) {
                if (childTupleLists[i].size() == 1L) {
                    ITuple tuple = childTupleLists[i].iterator().getTuple(0L);
                    for (int j = 0; j < tlHierarchies.length; ++j) {
                        if (!hiersToRemove.contains((Object)tlHierarchies[j])) continue;
                        tuple = tuple.remove(tlHierarchies[j]);
                    }
                    newChildTupleList.add(SimpleTupleList.construct(new ITuple[]{tuple}));
                    continue;
                }
                return null;
            }
            newChildTupleList.add(childTupleLists[i]);
        }
        if (duplicateTimes <= 0L) {
            return CrossJoinTupleList.construct(newChildTupleList);
        }
        ArrayList<ITupleList> duplicatedTupleList = new ArrayList<ITupleList>();
        for (long l = 0L; l < duplicateTimes; ++l) {
            duplicatedTupleList.add(CrossJoinTupleList.construct(newChildTupleList));
        }
        return UnionTupleList.construct(duplicatedTupleList);
    }

    @Override
    public void getCalculatedMemberSets(HashMap<CalculatedMember, Set> calculatedMemToSet, List<Set> baseSetList, ICube cube) {
        ITupleIterator it = this.iterator();
        if (it.hasNext()) {
            if (cube == null) {
                Tuple tuple = (Tuple)it.next();
                cube = tuple.getCube();
            }
        } else {
            baseSetList.add(new Set(new Tuple[0]));
            return;
        }
        SolveOrderComparator solveOrderComp = new SolveOrderComparator(cube);
        ITupleIterator tupleIter = this.iterator();
        TupleListFilter filter = new TupleListFilter(this.size());
        HashSet<Tuple> distinctBaseTuples = new HashSet<Tuple>((int)(this.size() / 2L));
        HashMap calculatedMemToTupleList = new HashMap();
        if (this.size() < 0L) {
            if (!this.containsCalculatedMembers()) {
                baseSetList.add(new Set(this));
                return;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The size of the set in the ExtractTupleList is too large: " + this.noOverflowSize().toString());
        }
        for (long i = 0L; i < this.size(); ++i) {
            Tuple tuple = (Tuple)tupleIter.getTuple(i);
            int tupleType = tuple.getTupleType();
            if (Tuple.containsNullMember(tupleType) || Tuple.containsPaddingMember(tupleType)) continue;
            if (!Tuple.containsCalculatedMember(tupleType)) {
                if (!distinctBaseTuples.add(tuple)) continue;
                filter.enable(i);
                continue;
            }
            ArrayList<CalculatedMember> tupleCalculatedMems = new ArrayList<CalculatedMember>();
            for (int k = 0; k < tuple.size(); ++k) {
                IMember m = tuple.getMember(k);
                if (!m.isCalculatedMember()) continue;
                tupleCalculatedMems.add((CalculatedMember)m);
            }
            Collections.sort(tupleCalculatedMems, solveOrderComp);
            CalculatedMember calculatedMem = (CalculatedMember)tupleCalculatedMems.get(0);
            if (!calculatedMemToTupleList.containsKey(calculatedMem)) {
                calculatedMemToTupleList.put(calculatedMem, new ArrayList());
            }
            List tuples = (List)calculatedMemToTupleList.get(calculatedMem);
            if (!distinctBaseTuples.add(tuple)) continue;
            tuples.add(tuple);
        }
        if (filter.cardinality() > 0L) {
            ITupleList filteredTupleList = FilteredTupleList.construct(this, filter);
            baseSetList.add(new Set(filteredTupleList));
        }
        java.util.Set set = calculatedMemToTupleList.keySet();
        for (CalculatedMember m : set) {
            List tuples = (List)calculatedMemToTupleList.get(m);
            calculatedMemToSet.put(m, new Set(tuples.toArray(new Tuple[0])));
        }
    }

    @Override
    public ITupleIterator iterator() {
        return new ExtractTupleIterator(this);
    }

    @Override
    public long size() {
        return this.childTupleList.size();
    }

    @Override
    public BigInteger noOverflowSize() {
        return this.childTupleList.noOverflowSize();
    }

    @Override
    public int width() {
        return this.dimMap.length;
    }

    @Override
    public long listSize() {
        return this.childTupleList.listSize();
    }

    @Override
    public ITupleList copy() {
        ITupleList tl = SimpleTupleList.cloneAsSimpleTupleList(this);
        if (tl == null) {
            tl = new ExtractTupleList(this.childTupleList.copy(), this.dimMap);
            tl.setDistinctFlag(this.getDistinctFlag());
        }
        return tl;
    }

    @Override
    public boolean containsNullMembers() {
        if (this.childTupleList instanceof CrossJoinTupleList && !this.childTupleList.containsNullMembers()) {
            return false;
        }
        IHierarchy[] hierarchies = this.childTupleList.iterator().next().getHierarchies();
        if (hierarchies == null) {
            return false;
        }
        ArrayList<IHierarchy> tlHierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < this.dimMap.length; ++i) {
            tlHierarchies.add(hierarchies[this.dimMap[i]]);
        }
        IMember[][] tlMembers = this.childTupleList.getMembers(tlHierarchies.toArray(new IHierarchy[tlHierarchies.size()]));
        for (int i = 0; i < tlMembers.length; ++i) {
            for (int j = 0; j < tlMembers[i].length; ++j) {
                if (!(tlMembers[i][j] instanceof NullMember)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsCalculatedMembers() {
        IHierarchy[] hierarchies = this.childTupleList.iterator().next().getHierarchies();
        if (hierarchies == null) {
            return false;
        }
        ArrayList<IHierarchy> tlHierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < this.dimMap.length; ++i) {
            tlHierarchies.add(hierarchies[this.dimMap[i]]);
        }
        IMember[][] tlMembers = this.childTupleList.getMembers(tlHierarchies.toArray(new IHierarchy[tlHierarchies.size()]));
        for (int i = 0; i < tlMembers.length; ++i) {
            for (int j = 0; j < tlMembers[i].length; ++j) {
                if (!tlMembers[i][j].isCalculatedMember()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IMember[][] getMembers(IDimension[] dims) {
        IDimension[] childDimensions = this.childTupleList.iterator().next().getDimensions();
        HashSet<IDimension> tlDimensions = new HashSet<IDimension>();
        for (int i = 0; i < this.dimMap.length; ++i) {
            tlDimensions.add(childDimensions[this.dimMap[i]]);
        }
        IDimension[] dimensions = new IDimension[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            if (!tlDimensions.contains(dims[i])) continue;
            dimensions[i] = dims[i];
        }
        return this.childTupleList.getMembers(dimensions);
    }

    @Override
    public IMember[][] getMembers(IHierarchy[] hiers) {
        IHierarchy[] childHierarchies = this.childTupleList.iterator().next().getHierarchies();
        HashSet<IHierarchy> tlHierarchies = new HashSet<IHierarchy>();
        for (int i = 0; i < this.dimMap.length; ++i) {
            tlHierarchies.add(childHierarchies[this.dimMap[i]]);
        }
        IHierarchy[] hierarchies = new IHierarchy[hiers.length];
        for (int i = 0; i < hiers.length; ++i) {
            if (!tlHierarchies.contains(hiers[i])) continue;
            hierarchies[i] = hiers[i];
        }
        return this.childTupleList.getMembers(hierarchies);
    }

    @Override
    public IMember[] getMembers(IDimension dimension) {
        IDimension[] childDimensions = this.childTupleList.iterator().next().getDimensions();
        for (int i = 0; i < this.dimMap.length; ++i) {
            if (dimension != childDimensions[this.dimMap[i]]) continue;
            return this.childTupleList.getMembers(dimension);
        }
        return new IMember[0];
    }

    @Override
    public IMember[] getMembers(IHierarchy hierarchy) {
        IHierarchy[] childHierarchies = this.childTupleList.iterator().next().getHierarchies();
        for (int i = 0; i < this.dimMap.length; ++i) {
            if (!hierarchy.equals(childHierarchies[this.dimMap[i]])) continue;
            return this.childTupleList.getMembers(hierarchy);
        }
        return new IMember[0];
    }

    @Override
    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        return this.childTupleList.findSubTuple(this.extractMembers(tuple, cache), false);
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        Set set = new Set(this);
        if (SymmetricSubqueryIterator.isAsymmetric(set)) {
            if (!splitAsymmetricSets) {
                return null;
            }
            return SymmetricSubqueryIterator.getSymmetricSubsets(set, new HashSet<IHierarchy>());
        }
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(set);
        return sets;
    }

    private final class ExtractTupleIterator
    extends TupleIterator {
        TupleIterator childTupleListIterator;

        private ExtractTupleIterator(TupleList tl) {
            super(tl);
            this.childTupleListIterator = (TupleIterator)ExtractTupleList.this.childTupleList.iterator();
        }

        @Override
        protected IMember[] fetchMembers(long index) {
            IMember[] childMembers = this.childTupleListIterator.fetchMembers(index);
            IMember[] mems = this.extractFromChildTlMembers(childMembers);
            return mems;
        }

        @Override
        protected IMember[] fetchMembers(BigInteger index) {
            IMember[] childMembers = this.childTupleListIterator.fetchMembers(index);
            IMember[] mems = this.extractFromChildTlMembers(childMembers);
            return mems;
        }

        @Override
        protected int fetchMembers(long index, IMember[] membersArray, int indexToStart) {
            IMember[] childMembers = this.childTupleListIterator.fetchMembers(index);
            IMember[] mems = this.extractFromChildTlMembers(childMembers);
            System.arraycopy(mems, 0, membersArray, indexToStart, mems.length);
            return mems.length;
        }

        @Override
        protected int fetchMembers(BigInteger index, IMember[] membersArray, int indexToStart) {
            IMember[] childMembers = this.childTupleListIterator.fetchMembers(index);
            IMember[] mems = this.extractFromChildTlMembers(childMembers);
            System.arraycopy(mems, 0, membersArray, indexToStart, mems.length);
            return mems.length;
        }

        private IMember[] extractFromChildTlMembers(IMember[] childMembers) {
            int tWidth = this.parent().width();
            IMember[] mems = new IMember[tWidth];
            for (int i = 0; i < tWidth; ++i) {
                mems[i] = childMembers[ExtractTupleList.this.dimMap[i]];
            }
            return mems;
        }

        @Override
        public ITuple getTuple(BigInteger theIndex) {
            this.checkForCancelRequest();
            IMember[] sourceMembers = new IMember[this.parent().width()];
            this.fetchMembers(theIndex, sourceMembers, 0);
            Tuple retTuple = new Tuple(new IMember[sourceMembers.length], false);
            retTuple.setMembers(sourceMembers);
            return retTuple;
        }
    }
}

