/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public final class SingleHierarchySimpleTupleList
extends TupleList {
    private final IMember[] members;
    private SoftReference<HashMap<IMember, List<Number>>> tupleToOrdinalsMapRef = new SoftReference<Object>(null);

    public static ITupleList construct(IMember[] memberArray) {
        if (memberArray == null || memberArray.length == 0) {
            return null;
        }
        return new SingleHierarchySimpleTupleList(memberArray);
    }

    private SingleHierarchySimpleTupleList(IMember[] memberArray) {
        this.members = memberArray;
    }

    public List<IMember> getMemberList() {
        return Collections.unmodifiableList(Arrays.asList(this.members));
    }

    @Override
    public IMember[][] getMembers(int[] dimHierIdx) {
        IMember[][] dimHierMembers = new IMember[dimHierIdx.length][];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            if (dimHierIdx[i] == 0) {
                if (this.getDistinctFlag()) {
                    dimHierMembers[i] = this.members;
                    continue;
                }
                ListOrderedSet distinctMembers = ListOrderedSet.decorate(new HashSet(this.members.length));
                distinctMembers.addAll(Arrays.asList(this.members));
                dimHierMembers[i] = (IMember[])distinctMembers.toArray((Object[])new IMember[distinctMembers.size()]);
                continue;
            }
            dimHierMembers[i] = new IMember[0];
        }
        return dimHierMembers;
    }

    @Override
    public IMember[][] getMembersRetainDuplicates(int[] dimHierIdx) {
        IMember[][] dimHierMembers = new IMember[dimHierIdx.length][];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            dimHierMembers[i] = dimHierIdx[i] == 0 ? this.members : new IMember[0];
        }
        return dimHierMembers;
    }

    @Override
    public long size() {
        return this.members.length;
    }

    @Override
    public BigInteger noOverflowSize() {
        return BigInteger.valueOf(this.members.length);
    }

    @Override
    public int width() {
        return 1;
    }

    @Override
    public ITupleList copy() throws UnsupportedOperationException {
        IMember[] copyMembers = new IMember[this.members.length];
        System.arraycopy(this.members, 0, copyMembers, 0, this.members.length);
        return new SingleHierarchySimpleTupleList(copyMembers);
    }

    @Override
    public ITupleIterator iterator() {
        return new SingleHierarchySimpleTupleIterator(this);
    }

    @Override
    public long listSize() {
        return this.size();
    }

    @Override
    public void replaceMember(int memIndex, IMember m) {
        if (memIndex != 0) {
            return;
        }
        this.setDistinctFlag(false);
        Arrays.fill(this.members, m);
    }

    @Override
    public boolean replaceMember(int memIndex, IMember[] m) {
        if ((long)m.length != this.size() || memIndex != 0) {
            return false;
        }
        this.setDistinctFlag(false);
        int idx = 0;
        while ((long)idx < this.size()) {
            this.members[idx] = m[idx];
            ++idx;
        }
        return true;
    }

    private HashMap<IMember, List<Number>> buildTupleToOrdinalsMap() {
        HashMap<IMember, List<Number>> tupleToOrdinalMap = new HashMap<IMember, List<Number>>();
        for (int i = 0; i < this.members.length; ++i) {
            List<Number> ordinalList = tupleToOrdinalMap.get(this.members[i]);
            if (ordinalList == null) {
                ordinalList = new ArrayList<Number>(1);
                tupleToOrdinalMap.put(this.members[i], ordinalList);
            }
            ordinalList.add(XQESoftLongPool.getLong(i));
        }
        return tupleToOrdinalMap;
    }

    @Override
    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        List<Number> result;
        int[] subTupleMap;
        HashMap<IMember, List<Number>> tupleToOrdinalsMap = this.tupleToOrdinalsMapRef.get();
        if (tupleToOrdinalsMap == null) {
            tupleToOrdinalsMap = this.buildTupleToOrdinalsMap();
            this.tupleToOrdinalsMapRef = new SoftReference<HashMap<IMember, List<Number>>>(tupleToOrdinalsMap);
        }
        IMember member = null;
        if (cache != null && (subTupleMap = cache.getTupleListSubTupleMap(this)) != null) {
            member = tuple.getMember(subTupleMap[0]);
        }
        if (member == null) {
            member = this.getSubTuple(tuple, cache).getMember(0);
        }
        if ((result = tupleToOrdinalsMap.get(member)) == null) {
            result = new ArrayList<Number>(0);
        }
        return result;
    }

    @Override
    public boolean containsNullMembers() {
        for (int i = 0; i < this.members.length; ++i) {
            if (!(this.members[i] instanceof NullMember)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Set> getSymmetricSets(boolean splitAsymmetricSets) {
        ArrayList<Set> sets = new ArrayList<Set>();
        sets.add(new Set(this));
        return sets;
    }

    private final class SingleHierarchySimpleTupleIterator
    extends TupleIterator {
        private SingleHierarchySimpleTupleIterator(TupleList tl) {
            super(tl);
        }

        @Override
        protected IMember[] fetchMembers(long theIndex) {
            return new IMember[]{SingleHierarchySimpleTupleList.this.members[(int)theIndex]};
        }

        @Override
        protected IMember[] fetchMembers(BigInteger theIndex) {
            return new IMember[]{SingleHierarchySimpleTupleList.this.members[theIndex.intValue()]};
        }

        @Override
        protected int fetchMembers(long theIndex, IMember[] membersArray, int indexToStart) {
            membersArray[indexToStart] = SingleHierarchySimpleTupleList.this.members[(int)theIndex];
            return 1;
        }

        @Override
        protected int fetchMembers(BigInteger theIndex, IMember[] membersArray, int indexToStart) {
            membersArray[indexToStart] = SingleHierarchySimpleTupleList.this.members[theIndex.intValue()];
            return 1;
        }

        @Override
        public ITuple getTuple(long index) {
            this.checkForCancelRequest();
            if ((int)index >= SingleHierarchySimpleTupleList.this.members.length || index < 0L) {
                this.logWrongSizeWarning(index);
            }
            return new Tuple(SingleHierarchySimpleTupleList.this.members[(int)index]);
        }

        @Override
        public ITuple getTuple(BigInteger index) {
            this.checkForCancelRequest();
            return new Tuple(SingleHierarchySimpleTupleList.this.members[index.intValue()]);
        }

        private void logWrongSizeWarning(long index) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.WARN).log("Getting tuple at index: " + (int)index + " but tuple.length is " + SingleHierarchySimpleTupleList.this.members.length);
        }
    }
}

