/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.math.BigInteger;

public abstract class TupleIterator
implements ITupleIterator {
    private final ITupleList parent;
    private long index = 0L;
    private long lastTupleIndex;
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

    public TupleIterator(ITupleList theParent) {
        this.parent = theParent;
        this.lastTupleIndex = theParent.size() - 1L;
        if (this.isLargerThanLongMax(theParent)) {
            this.lastTupleIndex = Long.MAX_VALUE;
        }
    }

    private boolean isLargerThanLongMax(ITupleList theParent) {
        return !(theParent instanceof SimpleTupleList) && theParent.size() < 0L;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.isIndexValid(this.index);
    }

    private boolean isIndexValid(long idx) {
        return idx >= 0L && idx <= this.lastTupleIndex;
    }

    protected abstract IMember[] fetchMembers(long var1);

    protected abstract IMember[] fetchMembers(BigInteger var1);

    protected abstract int fetchMembers(long var1, IMember[] var3, int var4);

    protected abstract int fetchMembers(BigInteger var1, IMember[] var2, int var3);

    @Override
    public ITuple getTuple(long theIndex) {
        this.checkForCancelRequest();
        if (!this.isIndexValid(theIndex)) {
            return null;
        }
        IMember[] sourceMembers = new IMember[this.parent.width()];
        this.fetchMembers(theIndex, sourceMembers, 0);
        Tuple tupleToReturn = new Tuple(new IMember[sourceMembers.length], false);
        tupleToReturn.setMembers(sourceMembers);
        return tupleToReturn;
    }

    @Override
    public abstract ITuple getTuple(BigInteger var1);

    @Override
    public ITuple next() {
        this.checkForCancelRequest();
        if (!this.hasNext()) {
            return null;
        }
        ITuple tuple = this.getTuple(this.index);
        this.advanceIterator();
        return tuple;
    }

    protected void checkForCancelRequest() {
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
    }

    protected void advanceIterator() {
        ++this.index;
    }

    @Override
    public ITupleList parent() {
        return this.parent;
    }

    @Override
    public void release() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

