/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SolveOrderComparator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESoftLongPool;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.set.ListOrderedSet;

public abstract class TupleList
implements ITupleList {
    private final CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
    private static final int MAX_TUPLES_TO_DISPLAY = 1000;
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger INT_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private boolean isDistinct = false;
    private boolean invalidTuplesRemoved = false;
    private SoftReference<HashMap<ITuple, List<Number>>> tupleToOrdinalsMapRef = new SoftReference<Object>(null);

    @Override
    public abstract long size();

    @Override
    public abstract BigInteger noOverflowSize();

    @Override
    public abstract int width();

    @Override
    public abstract ITupleList copy() throws UnsupportedOperationException;

    @Override
    public abstract ITupleIterator iterator();

    @Override
    public abstract long listSize();

    @Override
    public boolean getDistinctFlag() {
        return this.isDistinct;
    }

    @Override
    public void setDistinctFlag(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public void replaceMember(int memIndex, IMember m) {
        this.setDistinctFlag(false);
        ITupleIterator it = this.iterator();
        for (long idx = 0L; idx < this.size(); ++idx) {
            ((Tuple)it.getTuple(idx)).replaceMember(memIndex, m);
        }
    }

    @Override
    public boolean replaceMember(int memIndex, IMember[] m) {
        if ((long)m.length != this.size()) {
            return false;
        }
        this.setDistinctFlag(false);
        ITupleIterator it = this.iterator();
        for (long idx = 0L; idx < this.size(); ++idx) {
            ((Tuple)it.getTuple(idx)).replaceMember(memIndex, m[(int)idx]);
        }
        return true;
    }

    @Override
    public List<Number> find(IMember[] findMems, boolean first) {
        ArrayList<Number> indices = new ArrayList<Number>();
        ITupleIterator iter = this.iterator();
        while (iter.hasNext()) {
            long currIndex = iter.getIndex();
            ITuple currTuple = iter.next();
            boolean match = true;
            for (int memIndex = 0; memIndex < findMems.length; ++memIndex) {
                if (findMems[memIndex] == null || findMems[memIndex].equals(currTuple.getMember(memIndex))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            indices.add(currIndex);
            if (!first) continue;
            return indices;
        }
        return indices;
    }

    public ITuple getSubTuple(ITuple tuple, TupleOrdinalCalculationCache cache) {
        return new Tuple(this.extractMembers(tuple, cache), false);
    }

    @Override
    public List<Number> findSubTuple(IMember[] findMems, boolean first) {
        ArrayList<Number> indices = new ArrayList<Number>();
        ITupleIterator iter = this.iterator();
        while (iter.hasNext()) {
            long index = iter.getIndex();
            ITuple currTuple = iter.next();
            boolean found = currTuple.contains(new Tuple(findMems, false));
            if (!found) continue;
            indices.add(index);
            if (!first) continue;
            return indices;
        }
        return indices;
    }

    public IMember[] extractMembers(ITuple tuple, TupleOrdinalCalculationCache cache) {
        if (this.size() == 0L) {
            return new IMember[0];
        }
        if (cache == null) {
            return this.extractMembers(tuple);
        }
        int[] subTupleMap = cache.getTupleListSubTupleMap(this);
        if (subTupleMap == null) {
            return this.extractMembers(tuple);
        }
        IMember[] result = new IMember[subTupleMap.length];
        for (int i = 0; i < subTupleMap.length; ++i) {
            result[i] = tuple.getMember(subTupleMap[i]);
        }
        return result;
    }

    private IMember[] extractMembers(ITuple tuple) {
        ITuple currTuple = this.iterator().next();
        IHierarchy[] tupleListHiers = currTuple.getHierarchies();
        IMember[] result = new IMember[tupleListHiers.length];
        for (int memIndex = 0; memIndex < tupleListHiers.length; ++memIndex) {
            IHierarchy hier = tupleListHiers[memIndex];
            result[memIndex] = tuple.getMember(hier);
        }
        return result;
    }

    private HashMap<ITuple, List<Number>> buildTupleToOrdinalsMap() {
        HashMap<ITuple, List<Number>> tupleToOrdinalMap = new HashMap<ITuple, List<Number>>();
        ITupleIterator it = this.iterator();
        while (it.hasNext()) {
            long currIndex = it.getIndex();
            ITuple currTuple = it.next();
            List<Number> ordinalList = tupleToOrdinalMap.get(currTuple);
            if (ordinalList == null) {
                ordinalList = new ArrayList<Number>(1);
                tupleToOrdinalMap.put(currTuple, ordinalList);
            }
            ordinalList.add(XQESoftLongPool.getLong(currIndex));
        }
        return tupleToOrdinalMap;
    }

    public List<Number> find(ITuple tuple, TupleOrdinalCalculationCache cache) {
        if (this.size() > 0L) {
            List<Number> result;
            HashMap<ITuple, List<Number>> tupleToOrdinalsMap = this.tupleToOrdinalsMapRef.get();
            if (tupleToOrdinalsMap == null) {
                tupleToOrdinalsMap = this.buildTupleToOrdinalsMap();
                this.tupleToOrdinalsMapRef = new SoftReference<HashMap<ITuple, List<Number>>>(tupleToOrdinalsMap);
            }
            if ((result = tupleToOrdinalsMap.get(this.getSubTuple(tuple, cache))) == null) {
                result = new ArrayList<Number>(0);
            }
            return result;
        }
        return this.find(this.extractMembers(tuple, cache), false);
    }

    public static long computeCellOrdinal(long[] tupleOrdinals, long[] axesSizes) {
        long cellOrdinal = tupleOrdinals[0];
        long multiplier = 1L;
        for (int i = 1; i < tupleOrdinals.length; ++i) {
            multiplier = axesSizes[i - 1] * multiplier;
            cellOrdinal += tupleOrdinals[i] * multiplier;
        }
        return cellOrdinal;
    }

    public static void computeTupleOrdinals(List<List<Number>> tupleIndexesInSet, List<long[]> result) {
        int i;
        int numberOfTupleOrdinals = 1;
        for (i = 0; i < tupleIndexesInSet.size(); ++i) {
            numberOfTupleOrdinals *= tupleIndexesInSet.get(i).size();
        }
        if (numberOfTupleOrdinals > 0) {
            for (i = result.size() - 1; i >= 0; --i) {
                if (result.get(i).length == tupleIndexesInSet.size()) continue;
                result.remove(i);
            }
            if (result.size() > numberOfTupleOrdinals) {
                for (i = result.size() - 1; i >= numberOfTupleOrdinals; --i) {
                    result.remove(i);
                }
            } else if (result.size() < numberOfTupleOrdinals) {
                for (i = result.size(); i < numberOfTupleOrdinals; ++i) {
                    result.add(new long[tupleIndexesInSet.size()]);
                }
            }
            int duplicates = 1;
            for (int setIndex = tupleIndexesInSet.size() - 1; setIndex >= 0; --setIndex) {
                List<Number> indexes = tupleIndexesInSet.get(setIndex);
                int indexPosition = 0;
                int numberOfCopy = 0;
                for (int tupleOrdinalIndex = 0; tupleOrdinalIndex < result.size(); ++tupleOrdinalIndex) {
                    if (indexPosition == indexes.size()) {
                        indexPosition = 0;
                    }
                    int index = indexPosition++;
                    long aTupleIndexInSet = (Long)indexes.get(index);
                    long[] aTupleOrdinal = result.get(tupleOrdinalIndex);
                    aTupleOrdinal[setIndex] = aTupleIndexInSet;
                    if (++numberOfCopy != duplicates) continue;
                    numberOfCopy = 0;
                }
                duplicates *= indexes.size();
            }
        } else if (result != null) {
            result.clear();
        }
    }

    public static void computeTupleOrdinals(List<List<Number>> tupleIndexesInSet, List<Number[]> result, boolean overload) {
        int i;
        int numberOfTupleOrdinals = 1;
        for (i = 0; i < tupleIndexesInSet.size(); ++i) {
            numberOfTupleOrdinals *= tupleIndexesInSet.get(i).size();
        }
        if (numberOfTupleOrdinals > 0) {
            for (i = 0; i < numberOfTupleOrdinals; ++i) {
                result.add(new Number[tupleIndexesInSet.size()]);
            }
            int duplicates = 1;
            for (int setIndex = tupleIndexesInSet.size() - 1; setIndex >= 0; --setIndex) {
                List<Number> indexes = tupleIndexesInSet.get(setIndex);
                int indexPosition = 0;
                int numberOfCopy = 0;
                for (int tupleOrdinalIndex = 0; tupleOrdinalIndex < result.size(); ++tupleOrdinalIndex) {
                    if (indexPosition == indexes.size()) {
                        indexPosition = 0;
                    }
                    int index = indexPosition++;
                    Number aTupleIndexInSet = indexes.get(index);
                    Number[] aTupleOrdinal = result.get(tupleOrdinalIndex);
                    aTupleOrdinal[setIndex] = aTupleIndexInSet;
                    if (++numberOfCopy != duplicates) continue;
                    numberOfCopy = 0;
                }
                duplicates *= indexes.size();
            }
        }
    }

    @Override
    public boolean containsNullMembers() {
        for (ITuple tuple : this) {
            if (!((Tuple)tuple).containsNullMember()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IMember[] getMembers(IDimension d) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        IDimension[] setDims = this.iterator().next().getDimensions();
        for (int i = 0; i < setDims.length; ++i) {
            if (setDims[i] != d) continue;
            result.addAll(Arrays.asList(this.getMembers(new int[]{i})[0]));
        }
        if (result.isEmpty()) {
            return new IMember[0];
        }
        return result.toArray(new IMember[0]);
    }

    @Override
    public IMember[] getMembers(IHierarchy h) {
        int hierIdx = -1;
        IHierarchy[] setHiers = this.iterator().next().getHierarchies();
        for (int i = 0; i < setHiers.length; ++i) {
            if (setHiers[i] != h) continue;
            hierIdx = i;
            break;
        }
        if (hierIdx == -1) {
            return new IMember[0];
        }
        return this.getMembers(new int[]{hierIdx})[0];
    }

    @Override
    public IMember[][] getMembers(IDimension[] d) {
        IDimension[] setDims = this.iterator().next().getDimensions();
        int[] dimIdx = new int[d.length];
        block0: for (int i = 0; i < dimIdx.length; ++i) {
            dimIdx[i] = -1;
            for (int j = 0; j < setDims.length; ++j) {
                if (setDims[j] != d[i]) continue;
                dimIdx[i] = j;
                continue block0;
            }
        }
        return this.getMembers(dimIdx);
    }

    @Override
    public IMember[][] getMembers(IHierarchy[] h) {
        IHierarchy[] setHiers = this.iterator().next().getHierarchies();
        int[] hierIdx = new int[h.length];
        block0: for (int i = 0; i < hierIdx.length; ++i) {
            hierIdx[i] = -1;
            for (int j = 0; j < setHiers.length; ++j) {
                if (setHiers[j] != h[i]) continue;
                hierIdx[i] = j;
                continue block0;
            }
        }
        return this.getMembers(hierIdx);
    }

    public IMember[][] getMembers(int[] dimHierIdx) {
        ListOrderedSet[] allMembers = new ListOrderedSet[dimHierIdx.length];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            allMembers[i] = ListOrderedSet.decorate(new HashSet());
        }
        return this.getMembers(dimHierIdx, (Collection[])allMembers);
    }

    public IMember[][] getMembersRetainDuplicates(int[] dimHierIdx) {
        Collection[] allMembers = new ArrayList[dimHierIdx.length];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            allMembers[i] = new ArrayList();
        }
        return this.getMembers(dimHierIdx, allMembers);
    }

    private IMember[][] getMembers(int[] dimHierIdx, Collection[] allMembers) {
        ITupleIterator it = this.iterator();
        long tlSize = this.size();
        for (long idx = 0L; idx < tlSize; ++idx) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            ITuple tuple = it.getTuple(idx);
            for (int j = 0; j < dimHierIdx.length; ++j) {
                IMember m;
                if (dimHierIdx[j] < 0 || (m = tuple.getMember(dimHierIdx[j])) == null) continue;
                allMembers[j].add(m);
            }
        }
        IMember[][] dimHierMembers = new IMember[dimHierIdx.length][];
        for (int i = 0; i < dimHierIdx.length; ++i) {
            dimHierMembers[i] = allMembers[i].toArray(new IMember[allMembers[i].size()]);
        }
        return dimHierMembers;
    }

    @Override
    public HashSet<IMember> getCalculatedMembers() {
        HashSet<IMember> calculatedMembers = new HashSet<IMember>();
        ITupleIterator it = this.iterator();
        long tlSize = this.size();
        for (long idx = 0L; idx < tlSize; ++idx) {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            ITuple tuple = it.getTuple(idx);
            for (int j = 0; j < tuple.size(); ++j) {
                IMember m = tuple.getMember(j);
                if (!m.isCalculatedMember()) continue;
                calculatedMembers.add(m);
            }
        }
        return calculatedMembers;
    }

    @Override
    public void getCalculatedMemberSets(HashMap<CalculatedMember, Set> calculatedMemToSet, List<Set> baseSetList, ICube cube) {
        ITupleIterator it = this.iterator();
        if (it.hasNext()) {
            if (cube == null) {
                ITuple tuple = it.next();
                cube = tuple.getCube();
            }
        } else {
            baseSetList.add(new Set(new Tuple[0]));
            return;
        }
        SolveOrderComparator solveOrderComp = new SolveOrderComparator(cube);
        ITupleIterator tupleIter = this.iterator();
        TupleListFilter filter = new TupleListFilter(this.size());
        HashSet<Tuple> distinctBaseTuples = new HashSet<Tuple>((int)(this.size() / 2L));
        HashMap calculatedMemToTupleList = new HashMap();
        for (long i = 0L; i < this.size(); ++i) {
            Tuple tuple = (Tuple)tupleIter.getTuple(i);
            int tupleType = tuple.getTupleType();
            if (Tuple.containsNullMember(tupleType) || Tuple.containsPaddingMember(tupleType)) continue;
            if (!Tuple.containsCalculatedMember(tupleType)) {
                if (!distinctBaseTuples.add(tuple)) continue;
                filter.enable(i);
                continue;
            }
            ArrayList<CalculatedMember> tupleCalculatedMems = new ArrayList<CalculatedMember>();
            for (int k = 0; k < tuple.size(); ++k) {
                IMember m = tuple.getMember(k);
                if (!m.isCalculatedMember()) continue;
                tupleCalculatedMems.add((CalculatedMember)m);
            }
            Collections.sort(tupleCalculatedMems, solveOrderComp);
            CalculatedMember calculatedMem = (CalculatedMember)tupleCalculatedMems.get(0);
            if (!calculatedMemToTupleList.containsKey(calculatedMem)) {
                calculatedMemToTupleList.put(calculatedMem, new ArrayList());
            }
            List tuples = (List)calculatedMemToTupleList.get(calculatedMem);
            if (!distinctBaseTuples.add(tuple)) continue;
            tuples.add(tuple);
        }
        if (filter.cardinality() > 0L) {
            ITupleList filteredTupleList = FilteredTupleList.construct(this, filter);
            baseSetList.add(new Set(filteredTupleList));
        }
        java.util.Set set = calculatedMemToTupleList.keySet();
        for (CalculatedMember m : set) {
            List tuples = (List)calculatedMemToTupleList.get(m);
            calculatedMemToSet.put(m, new Set(tuples.toArray(new Tuple[tuples.size()])));
        }
    }

    public String toString() {
        if (this.size() > 1000L) {
            String s = "Large TL (" + this.size() + " tuples)";
            return s;
        }
        if (this.size() < 0L) {
            String s = "Huge TL (" + this.noOverflowSize() + " tuples) ";
            return s;
        }
        String s = "<empty>";
        ITupleIterator tupleIter = this.iterator();
        if (tupleIter.hasNext()) {
            ITuple tuple = tupleIter.next();
            s = tuple.toString();
            while (tupleIter.hasNext()) {
                tuple = tupleIter.next();
                s = s + "," + tuple.toString() + "\r\n";
            }
        }
        return s;
    }

    @Override
    public void setInvalidTuplesRemoved(boolean flag) {
        this.invalidTuplesRemoved = flag;
    }

    @Override
    public boolean getInvalidTuplesRemoved() {
        return this.invalidTuplesRemoved;
    }

    @Override
    public boolean containsCalculatedMembers() {
        for (ITuple tuple : this) {
            if (!((Tuple)tuple).containsCalculation()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMeasures() {
        for (ITuple tuple : this) {
            if (!((Tuple)tuple).containsMeasure()) continue;
            return true;
        }
        return false;
    }
}

