/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTCharacterStringLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.ASTStringValueExpression;
import com.cognos.xqe.ast.mdx.parser.ASTStringValueExpressionPrimary;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.Node;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SecuredResultSetHelper;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculationCache;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Measure;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CalculatedMember
extends Measure {
    private static final String FORMAT_PROP_NAME = "format";
    private static final String RIGHT_BRACE = "]";
    private static final String SINGLE_QUOTE = "'";
    private static final String PARSER = "parser : ";
    private static final String PREPARE = "prepare";
    private static final String UTF_8 = "UTF-8";
    private static final String DOUBLE_QUOTE = "\"";
    private String calculationString;
    private Node node;
    private int solveOrder;
    protected FormatId formatId = null;
    private XMdxCalculatedMember runtreeCalculatedMember = null;
    private XMdxNode runtreeCalculationValue = null;
    private final Set<Long> errExceptions = new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L));
    ConcurrentMap<String, ArrayList<CrossJoinedSet>> sessionToCachedContextSets = null;
    private ReentrantReadWriteLock readWriteLock = null;
    String originalV5UniqueName = null;
    String originalUniqueName = null;
    HashMap<String, String> uniqueNamesMap;
    IMember originalCalculatedMember = null;
    private ILocalizedString lzCaption = null;

    public boolean isAggregateMember() {
        return false;
    }

    public void setOriginalV5Name(String name) {
        this.originalV5UniqueName = name;
        if (name != null) {
            this.formatId = ROLAPCalculatedMember.getFormatId(name, this.getLevel());
        }
    }

    public void setOriginalUniqueName(String name) {
        this.originalUniqueName = name;
    }

    public FormatId getFormatId() {
        return this.formatId;
    }

    public String getOriginalV5Name() {
        return this.originalV5UniqueName;
    }

    public String getOriginalUniqueName() {
        return this.originalUniqueName;
    }

    public void setOriginalCalculatedMember(IMember member) {
        this.originalCalculatedMember = member;
    }

    public IMember getOriginalCalculatedMember() {
        return this.originalCalculatedMember;
    }

    public void setLocalizedCaption(ILocalizedString caption) {
        this.lzCaption = caption;
    }

    public ILocalizedString getLocalizedCaption() {
        return this.lzCaption;
    }

    @Override
    public String getCaption() {
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        ILocalizedString lcCaption = this.getLocalizedCaption();
        String runLocaleCaption = null;
        if (lcCaption != null) {
            runLocaleCaption = lcCaption.toString(locale);
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = super.getCaption();
        }
        return runLocaleCaption;
    }

    public CalculatedMember(String s, ILevel level, Object calculationObj, String[] identifiers, XMdxNode xNode) throws MetadataException {
        super(s, level);
        if (xNode != null) {
            if (xNode instanceof XMdxCalculatedMember) {
                this.runtreeCalculatedMember = (XMdxCalculatedMember)xNode;
            } else {
                this.runtreeCalculationValue = xNode;
            }
        }
        this.caption = s;
        if (identifiers != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(identifiers[0]);
            sb.append(RIGHT_BRACE);
            for (int i = 1; i < identifiers.length; ++i) {
                sb.append(".[");
                sb.append(identifiers[i]);
                sb.append(RIGHT_BRACE);
            }
            this.setUniqueName(sb.toString());
        }
        if (calculationObj instanceof String) {
            this.parseCalculationString((String)calculationObj);
        } else {
            this.node = (Node)calculationObj;
        }
        this.sessionToCachedContextSets = new ConcurrentHashMap<String, ArrayList<CrossJoinedSet>>();
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    protected void parseCalculationString(String calculationObj) {
        IPlanningEnvironment pe;
        ByteArrayInputStream inputStream;
        this.calculationString = CalculatedMember.unescapeCalculationString(calculationObj);
        try {
            inputStream = new ByteArrayInputStream(this.calculationString.getBytes(UTF_8));
        }
        catch (IOException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        MDXParser parser = new MDXParser(inputStream, UTF_8);
        if (this.runtreeCalculatedMember != null && (pe = this.runtreeCalculatedMember.getPlanningEnvironment()) != null) {
            parser.setNodeFactory(pe.getNodeFactory());
        }
        try {
            ParseException e = parser.ValueExpression();
            if (e != null) {
                throw e;
            }
            this.node = parser.getParsedRootNode();
            if (this.node instanceof ASTStringValueExpression && this.node.jjtGetNumChildren() == 1) {
                this.node = this.node.jjtGetChild(0);
                if (this.node instanceof ASTStringValueExpressionPrimary && this.node.jjtGetNumChildren() == 1) {
                    this.node = this.node.jjtGetChild(0);
                }
            }
        }
        catch (ParseException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
    }

    public CalculatedMember(String s, ILevel level, Object calculationStr, String[] identifiers) throws MetadataException {
        this(s, level, calculationStr, identifiers, null);
    }

    public CalculatedMember(String s, ILevel level, Object calculationNode) throws MetadataException {
        this(s, level, calculationNode, null, null);
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public void setUniqueName(String uniqueName) {
        super.setUniqueName(uniqueName);
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasuresDimension();
    }

    public void setIsMeasure(boolean isMeasure) {
        if (isMeasure) {
            ((Dimension)this.getDimension()).setType(DimensionTypeEnum.MEASURE);
        }
    }

    @Override
    public boolean isRelational() {
        if (this.getConnection().getModelDataSources().size() > 0) {
            return this.getConnection().getModelDataSources().get(0).isRelational();
        }
        return false;
    }

    @Override
    public void setParentMember(IMember parent) {
        super.setParentMember(parent);
    }

    public void setSolveOrder(int solveOrd) {
        this.solveOrder = solveOrd;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    @Override
    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCalculationString(String calcString) {
        this.calculationString = calcString;
    }

    public String getCalculationString() {
        return this.calculationString;
    }

    public String getUnescapeCalculationString() {
        return CalculatedMember.unescapeCalculationString(this.calculationString);
    }

    @Override
    public boolean isCalculatedMember() {
        return true;
    }

    public boolean isNullTag() {
        Boolean isNullTag = (Boolean)this.getProperty("nullTag");
        return isNullTag != null && isNullTag != false;
    }

    public XMdxCalculatedMember getRuntreeCalculatedMember() {
        return this.runtreeCalculatedMember;
    }

    public void setRuntreeCalculatedMember(XMdxNode xNode) {
        this.runtreeCalculatedMember = (XMdxCalculatedMember)xNode;
    }

    public OrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        return new OrderedMap<IMember>();
    }

    @Override
    public IMember getChildMember(String memberName) throws MetadataException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet executeToResultSet(InterpreterContext interpreterContext) throws InterpreterException {
        Block retBlock = null;
        String sessionId = "";
        if (interpreterContext.getSession() != null) {
            sessionId = interpreterContext.getSession().getSessionId();
        }
        ArrayList<CrossJoinedSet> cachedContextSets = null;
        this.readWriteLock.readLock().lock();
        try {
            cachedContextSets = (ArrayList<CrossJoinedSet>)this.sessionToCachedContextSets.get(sessionId);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (cachedContextSets == null) {
            cachedContextSets = new ArrayList<CrossJoinedSet>();
        } else {
            CrossJoinedSet contextSet = interpreterContext.getContextSet();
            for (int i = 0; i < cachedContextSets.size(); ++i) {
                if (CrossJoinedSet.notEqualCJS(contextSet, (CrossJoinedSet)cachedContextSets.get(i))) continue;
                retBlock = new Block(interpreterContext, TextValue.ERROR_VALUE);
                return retBlock.toResultSet();
            }
        }
        this.readWriteLock.writeLock().lock();
        try {
            cachedContextSets.add(interpreterContext.getContextSet());
            this.sessionToCachedContextSets.put(sessionId, cachedContextSets);
            retBlock = this.executeToBlock(interpreterContext);
        }
        finally {
            this.popCachedContextSet(sessionId, cachedContextSets);
            this.readWriteLock.writeLock().unlock();
        }
        IResultSet retRs = null;
        boolean hasValidCells = true;
        Object blockObj = retBlock.first();
        if (blockObj instanceof IMember) {
            boolean bl = hasValidCells = !interpreterContext.isDeferredGettingValue();
        }
        if (hasValidCells) {
            String format = (String)this.getProperty(FORMAT_PROP_NAME);
            if (format != null) {
                if (retBlock.isPipelining()) {
                    retBlock.materializePipeline();
                }
                retRs = retBlock.toResultSet();
                this.applyFormatToCMResult(retRs);
            } else {
                retRs = retBlock.toResultSet();
            }
        } else {
            ArrayListInt mapSetsToEvalSets = new ArrayListInt();
            LongArrayList blockOrdMap = new LongArrayList();
            ISet[] evalSets = retBlock.getEvaluationSet(true, mapSetsToEvalSets, blockOrdMap, null);
            retRs = SecuredResultSetHelper.createSecuredResultSet(evalSets, null, interpreterContext, false);
            retRs.setCalculatedMemberResult((IMember)blockObj);
        }
        return retRs;
    }

    public void applyFormatToCMResult(IResultSet retRs) {
        String format = (String)this.getProperty(FORMAT_PROP_NAME);
        if (retRs != null && !retRs.isEmpty()) {
            for (Cell cell : retRs) {
                this.applyFormatToCMResult(cell, format);
            }
        }
    }

    public void applyFormatToCMResult(Cell cell, String format) {
        if (format != null) {
            cell.setCellFormat(format);
        }
    }

    private Block executeToBlock(InterpreterContext interpreterContext) throws InterpreterException {
        Interpreter interpreter = new Interpreter(interpreterContext, null);
        interpreter.setInterpreterSubject(this.getUniqueName());
        Object calcMemResult = this.getCalcMemberResult(interpreterContext, interpreter);
        Block retBlock = (Block)calcMemResult;
        Object blockObj = retBlock.first();
        if (!(blockObj == null || blockObj instanceof Double || blockObj instanceof String || blockObj instanceof Integer || blockObj instanceof Boolean || blockObj instanceof Value)) {
            if (blockObj instanceof com.cognos.xqe.runtree.olap.mdx.interpreter.Set) {
                retBlock = new Block(interpreterContext, TextValue.ERROR_VALUE);
            } else if (blockObj instanceof IMember || blockObj instanceof ITuple) {
                if (blockObj instanceof ITuple || !interpreterContext.isDeferredGettingValue()) {
                    retBlock.getValues(interpreterContext);
                }
            } else if (blockObj instanceof NullObject) {
                retBlock = new Block(interpreterContext, (Object)null);
            } else {
                throw new InterpreterException("X01409", new String[]{interpreterContext.getCube().getName(), this.getUniqueName()});
            }
        }
        return retBlock;
    }

    public Object getCalcMemberResult(InterpreterContext interpreterContext, Interpreter interpreter) throws InterpreterException {
        Object calcMemResult = null;
        if (this.runtreeCalculatedMember != null) {
            calcMemResult = this.getCalcMemberResultFromRuntreeCalcMember(interpreterContext);
        } else if (this.runtreeCalculationValue != null) {
            calcMemResult = ((CubicsValue)this.runtreeCalculationValue.execute(interpreterContext.getXDataContext())).getCubicsObject();
        } else if (this.node instanceof ASTCharacterStringLiteral) {
            ByteArrayInputStream inputStream;
            calcMemResult = interpreter.interpretCalculation(this.node);
            String calculationStr = (String)calcMemResult;
            this.calculationString = calculationStr = CalculatedMember.unescapeCalculationString(calculationStr);
            try {
                inputStream = new ByteArrayInputStream(calculationStr.getBytes(UTF_8));
            }
            catch (IOException e) {
                throw new MetadataException("X01499", new String[]{e.toString()}, e);
            }
            MDXParser parser = new MDXParser(inputStream, UTF_8);
            try {
                ParseException e = parser.ValueExpression();
                if (e != null) {
                    throw e;
                }
            }
            catch (ParseException e) {
                throw new MetadataException("X01499", new String[]{e.toString()}, e);
            }
            interpreter = new Interpreter(interpreterContext, parser);
            try {
                calcMemResult = interpreter.interpretCalculation();
            }
            catch (InterpreterException interpreterException) {
                if (this.errExceptions.contains(interpreterException.getID())) {
                    calcMemResult = TextValue.ERROR_VALUE;
                }
                throw interpreterException;
            }
            catch (MDXEngineException mdxException) {
                if (this.errExceptions.contains(mdxException.getID())) {
                    calcMemResult = TextValue.ERROR_VALUE;
                }
                throw mdxException;
            }
        } else if (this.node instanceof ASTMDXNode) {
            this.calculationString = ((ASTMDXNode)this.node).getText();
            calcMemResult = new Block(interpreterContext, CalculatedMember.unescapeCalculationString(this.calculationString));
        } else {
            try {
                calcMemResult = interpreter.interpretCalculation(this.node);
            }
            catch (InterpreterException ie) {
                if (this.errExceptions.contains(ie.getID())) {
                    calcMemResult = TextValue.ERROR_VALUE;
                }
                throw ie;
            }
        }
        return calcMemResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCalcMemberResultFromRuntreeCalcMember(InterpreterContext interpreterContext) throws InterpreterException {
        Object calcMemResult;
        block10: {
            calcMemResult = null;
            if (this.runtreeCalculatedMember.getNumberChildren() == 0) {
                calcMemResult = new Block(interpreterContext, this.runtreeCalculatedMember.getValue());
            } else {
                XDataContext dataContext = interpreterContext.getXDataContext();
                InterpreterContext oldContext = dataContext.getInterpreterContext();
                CrossJoinedSet cjs = interpreterContext.getContextSet();
                dataContext.setInterpreterContext(new InterpreterContext(interpreterContext, cjs));
                XMdxNode xNode = (XMdxNode)this.runtreeCalculatedMember.getChild(0);
                try {
                    calcMemResult = ((CubicsValue)xNode.execute(dataContext)).getCubicsObject();
                }
                catch (MDXEngineException e) {
                    if (e.getCause() instanceof InterpreterException) {
                        InterpreterException ie = (InterpreterException)e.getCause();
                        if (this.errExceptions.contains(ie.getID())) {
                            calcMemResult = new Block(interpreterContext, TextValue.ERROR_VALUE);
                            break block10;
                        }
                        throw e;
                    }
                    if (this.errExceptions.contains(e.getID())) {
                        calcMemResult = new Block(interpreterContext, TextValue.ERROR_VALUE);
                        break block10;
                    }
                    throw e;
                }
                finally {
                    com.cognos.xqe.runtree.olap.mdx.interpreter.CalculationCache currentCalculationCache = dataContext.getInterpreterContext().getCalculationCache();
                    oldContext.setCalculationCache(currentCalculationCache);
                    interpreterContext.setCalculationCache(currentCalculationCache);
                    dataContext.setInterpreterContext(oldContext);
                }
            }
        }
        return calcMemResult;
    }

    private void popCachedContextSet(String sessionId, ArrayList<CrossJoinedSet> cachedContextSets) {
        if (cachedContextSets.size() > 0) {
            cachedContextSets.remove(cachedContextSets.size() - 1);
        }
        if (cachedContextSets.isEmpty()) {
            this.sessionToCachedContextSets.remove(sessionId);
        }
    }

    public static String unescapeCalculationString(String calculationString) {
        if (calculationString.trim().startsWith(SINGLE_QUOTE) && calculationString.trim().endsWith(SINGLE_QUOTE)) {
            calculationString = calculationString.trim();
            calculationString = calculationString.substring(1, calculationString.lastIndexOf(39));
            calculationString = CalculatedMember.unescapeQuotes(calculationString, '\'');
        } else if (calculationString.trim().startsWith(DOUBLE_QUOTE) && calculationString.trim().endsWith(DOUBLE_QUOTE)) {
            calculationString = calculationString.trim();
            calculationString = calculationString.substring(1, calculationString.lastIndexOf(34));
            calculationString = CalculatedMember.unescapeQuotes(calculationString, '\"');
        }
        return calculationString;
    }

    public static String unescapeQuotes(String input, char quote) {
        StringBuilder buff = new StringBuilder();
        boolean justSeenQuote = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == quote) {
                if (!justSeenQuote) {
                    buff.append(c);
                    justSeenQuote = true;
                    continue;
                }
                justSeenQuote = false;
                continue;
            }
            buff.append(c);
            justSeenQuote = false;
        }
        return buff.toString();
    }

    public IResultSet fetchTupleValues(CrossJoinedSet cjs, InterpreterContext interpreterContext) throws InterpreterException {
        ICube cube = this.getDimension().getCube();
        IResultSet retResultSet = null;
        if (cube instanceof CalculationCache) {
            List<IDimension> dimsList = cube.getDimensions();
            IDimension[] dims = dimsList.toArray(new Dimension[0]);
            HashSet<IMember>[] selections = cjs.selectionsInDimensions(dims);
            HashMap<IMember, HashMap<HashSet<IMember>[], IResultSet>> calcSelectionsToResults = ((CalculationCache)((Object)cube)).getCalcsToSelectionsToResults();
            HashMap<Object, IResultSet> selectionsToResults = calcSelectionsToResults.get(this);
            if (selectionsToResults != null) {
                Iterator<HashSet<IMember>[]> selIt = selectionsToResults.keySet().iterator();
                while (!cjs.isEmpty() && selIt.hasNext()) {
                    HashSet<IMember>[] alreadyRunSelection = selIt.next();
                    boolean subset = true;
                    for (int i = 0; subset && i < selections.length; ++i) {
                        if (alreadyRunSelection[i].containsAll(selections[i])) continue;
                        subset = false;
                    }
                    if (!subset) continue;
                    retResultSet = selectionsToResults.get(alreadyRunSelection);
                    cjs = new CrossJoinedSet(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[0]);
                }
            }
            if (!cjs.isEmpty()) {
                InterpreterContext newInterpreterContext = new InterpreterContext(interpreterContext, cjs);
                retResultSet = this.executeToResultSet(newInterpreterContext);
                interpreterContext.setCalculationCache(newInterpreterContext.getCalculationCache());
                if (selectionsToResults == null) {
                    selectionsToResults = new HashMap();
                    calcSelectionsToResults.put(this, selectionsToResults);
                }
                selectionsToResults.put(selections, retResultSet);
            }
        } else {
            InterpreterContext newInterpreterContext = new InterpreterContext(interpreterContext, cjs);
            newInterpreterContext.setInterpreterSubject(this.getUniqueName());
            retResultSet = this.executeToResultSet(newInterpreterContext);
            interpreterContext.setCalculationCache(newInterpreterContext.getCalculationCache());
        }
        return retResultSet;
    }

    @Override
    public Object getBusinessKey() {
        IMember origCalcMember = this.getOriginalCalculatedMember();
        if (origCalcMember != null && origCalcMember.isExtendedCalculatedMember()) {
            return origCalcMember.getBusinessKey();
        }
        return null;
    }

    @Override
    public String getDescription() {
        IMember origCalcMember = this.getOriginalCalculatedMember();
        if (origCalcMember != null && origCalcMember.isExtendedCalculatedMember()) {
            return origCalcMember.getDescription();
        }
        return super.getDescription();
    }

    public void setFormatId(FormatId format) {
        this.formatId = format;
    }

    private MDXParser parseValueExpression(String valueExpression, IXQENodeFactory nodeFactory) {
        MDXParser parser = null;
        valueExpression = CalculatedMember.unescapeCalculationString(valueExpression);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(valueExpression.getBytes(UTF_8));
            parser = new MDXParser(inputStream, UTF_8);
            parser.setNodeFactory(nodeFactory);
            ParseException e = parser.ValueExpression();
            if (e != null) {
                throw e;
            }
        }
        catch (UnsupportedEncodingException exec) {
            throw new MetadataException("X01499", new String[]{exec.toString()}, exec);
        }
        catch (ParseException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        return parser;
    }

    public XMdxCalculatedMember generateXMdxCalculatedMember(String mdxExpression, RequestEnvironment reqEnv) {
        PlanningEnvironment planEnv = this.prepareEnvironment(reqEnv);
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        XMdxCalculatedMember xNode = (XMdxCalculatedMember)nodeFactory.createNode(501101);
        xNode.addToIndex();
        MDXParser parser = this.parseValueExpression(mdxExpression, planEnv.getNodeFactory());
        xNode.addChild((IXQEQueryNode)((Object)parser.getParsedRootNode()));
        TransformationEngine.getInstance().applyTransformations(xNode, planEnv);
        return xNode;
    }

    private PlanningEnvironment prepareEnvironment(RequestEnvironment reqEnv) {
        Element commandElement = DocumentHelper.createElement((String)PREPARE);
        Element requestIDElement = commandElement.addElement("requestID");
        String requestID = new UID().toString();
        requestIDElement.addAttribute("value", requestID);
        QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
        reqEnv.extractParametersFromCommand(commandElement);
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        return planEnv;
    }

    public String getV5UniqueName(String cubeName) {
        String v5UniqueName;
        if (this.uniqueNamesMap == null) {
            this.uniqueNamesMap = new HashMap();
        } else {
            v5UniqueName = this.uniqueNamesMap.get(cubeName);
            if (v5UniqueName != null) {
                return v5UniqueName;
            }
        }
        v5UniqueName = this.getV5UniqueName();
        String leftPart = UniqueNameGenerator.extractLeftPartFromCognosMUN(v5UniqueName);
        String rightPart = UniqueNameGenerator.extractRightPartFromCognosMUN(v5UniqueName);
        if (leftPart != null) {
            try {
                String[] parts = UniqueNameParser.parse(leftPart);
                if (!parts[0].equals(cubeName)) {
                    parts[0] = cubeName;
                    String updatedLeftPart = UniqueNameGenerator.createUniqueName(parts);
                    v5UniqueName = UniqueNameGenerator.joinModelPhysicalParts(updatedLeftPart, rightPart);
                }
            }
            catch (UniqueNameParserException e) {
                throw new RuntimeException(" Unable to parse: " + v5UniqueName + " for the cube name.");
            }
            if (v5UniqueName != null) {
                this.uniqueNamesMap.put(cubeName, v5UniqueName);
            }
        }
        return v5UniqueName;
    }

    public static boolean getQSReturnCalculatedMemberLUN() {
        return ROLAPCubeManager.getInstance().getConfig().isCalculatedMemberLUNReturned();
    }
}

