/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.ast.olap.util.DescendantsRangeFlagEnum;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ICalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullObject;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.util.IntegerSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class MemberOperations {
    private static final String SAP_BUSINESS_KEY = "SAP_BUSINESS_KEY";
    private static final String ROLLUP_TYPE = "ROLLUP_TYPE";
    public static final String FALSE = "false";
    public static final String LIMITED = "limited";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String[] KNOWN_MEMBER_PROPERTIES = new String[]{"MEMBER_TYPE", "MEMBER_GUID", "MEMBER_ORDINAL", "PARENT_COUNT", "PARENT_UNIQUE_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_UNIQUE_NAME", "MEMBER_NAME", "NAME", "MEMBER_CAPTION", "DESCRIPTION", "CAPTION", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "KEY", "MEMBER_KEY"};
    private static HashMap<String, String> mPropertyMap = new HashMap();

    public static SecurityManagerInterface getSecurityManager(InterpreterContext interpreterContext) {
        ICube c;
        SecurityManagerInterface sec = null;
        if (interpreterContext != null && (c = interpreterContext.getCube()) != null) {
            Provider provider = interpreterContext.getProvider();
            sec = ((Cube)c).getSecurityManager(provider);
        }
        return sec;
    }

    public static ArrayList<IMember> applySecurityToMembers(List<IMember> members, IHierarchy hier, InterpreterContext interpreterContext, ROLAPUserSecurityContext secContext) {
        ArrayList<IMember> result = null;
        result = members instanceof ArrayList ? (ArrayList<IMember>)members : new ArrayList<IMember>(members);
        if (interpreterContext != null) {
            IMember[] memberArray = result.toArray(new IMember[result.size()]);
            memberArray = MemberOperations.applySecurityToMembers(memberArray, hier, interpreterContext, secContext);
            result = new ArrayList(memberArray.length);
            for (int i = 0; i < memberArray.length; ++i) {
                result.add(memberArray[i]);
            }
        }
        return result;
    }

    public static IMember[] applySecurityToMembers(IMember[] members, IHierarchy hier, InterpreterContext interpreterContext) {
        return MemberOperations.applySecurityToMembers(members, hier, interpreterContext, null);
    }

    public static IMember[] applySecurityToMembers(IMember[] members, IHierarchy hier, InterpreterContext interpreterContext, ROLAPUserSecurityContext secContext) {
        IMember[] result = members;
        if (interpreterContext != null) {
            if (secContext != null) {
                SecManager secManager = (SecManager)secContext.getSecurityManager();
                if (secManager != null) {
                    result = secManager.applySecurity(secContext, members, hier);
                }
            } else {
                SecurityManagerInterface sec = MemberOperations.getSecurityManager(interpreterContext);
                if (sec != null) {
                    result = sec.applySecurity(members, hier);
                }
            }
        }
        return result;
    }

    public static boolean isSecured(IMember member, InterpreterContext interpreterContext) {
        return MemberOperations.applySecurityToMember(member, interpreterContext) == null;
    }

    public static boolean isValueSecured(IMember member, InterpreterContext interpreterContext) {
        SecurityManagerInterface sec;
        boolean secured = false;
        if (interpreterContext != null && (sec = MemberOperations.getSecurityManager(interpreterContext)) != null) {
            secured = sec.isValueSecured(member);
        }
        return secured;
    }

    public static ISet filterSecureValueMembers(ISet set, InterpreterContext interpreterContext) throws InterpreterException {
        SecurityManagerInterface sec;
        ISet returnSet = set;
        if (interpreterContext != null && (sec = MemberOperations.getSecurityManager(interpreterContext)) != null) {
            returnSet = sec.filterSecureValueMembers(set);
        }
        return returnSet;
    }

    public static IMember applySecurityToMember(IMember member, InterpreterContext interpreterContext) {
        return MemberOperations.applySecurityToMember(member, interpreterContext, null);
    }

    public static IMember applySecurityToMember(IMember member, InterpreterContext interpreterContext, ROLAPUserSecurityContext secContext) {
        if (interpreterContext == null || member == null) {
            return member;
        }
        IMember result = member;
        if (secContext != null) {
            SecManager secManager = (SecManager)secContext.getSecurityManager();
            if (secManager != null) {
                IMember[] arrayInput = new IMember[]{member};
                IMember[] arrayOutput = secManager.applySecurity(secContext, arrayInput, member.getHierarchy());
                result = arrayOutput.length > 0 ? arrayOutput[0] : null;
            }
        } else {
            SecurityManagerInterface sec = MemberOperations.getSecurityManager(interpreterContext);
            if (sec != null) {
                IMember[] arrayInput = new IMember[]{member};
                IMember[] arrayOutput = sec.applySecurity(arrayInput, member.getHierarchy());
                result = arrayOutput.length > 0 ? arrayOutput[0] : null;
            }
        }
        return result;
    }

    public static IMember getDefaultMemberOp(IDimension dim, InterpreterContext interpreterContext) throws MetadataException {
        IMember result = null;
        result = interpreterContext == null ? dim.getDefaultHierarchy().getDefaultMember() : ((Dimension)dim).getDefaultMemberWithSecurity();
        return result;
    }

    public static IMember getDefaultMemberOp(IHierarchy hier, InterpreterContext interpreterContext) throws MetadataException {
        return MemberOperations.getDefaultMemberOp(interpreterContext.getCube(), hier, interpreterContext);
    }

    public static IMember getDefaultMemberOp(ICube cube, IHierarchy hier, InterpreterContext interpreterContext) throws MetadataException {
        IMember result = null;
        result = interpreterContext == null ? hier.getDefaultMember() : (cube != null ? ((Hierarchy)hier).getDefaultMemberWithSecurity(cube) : ((Hierarchy)hier).getDefaultMemberWithSecurity());
        if (result == null) {
            result = NullMember.getNullMember(hier);
        }
        return result;
    }

    public static IMember[] getSiblingsOp(IMember mem, boolean includeSelf) throws MetadataException {
        return MemberOperations.getSiblingsOp(mem, includeSelf, null);
    }

    public static IMember[] getSiblingsOp(IMember mem, boolean includeSelf, InterpreterContext interpreterContext) throws MetadataException {
        IMember[] result;
        if (mem instanceof NullMember || MemberOperations.applySecurityToMember(mem, interpreterContext) == null) {
            return new IMember[0];
        }
        if (MemberOperations.isRegularCalculatedMember(mem) || MemberOperations.isExtendedCalculatedMemberTypeParent(mem)) {
            return new IMember[0];
        }
        ArrayList<IMember> siblings = new ArrayList<IMember>();
        try {
            IMember parent = MemberOperations.getParentOp(mem.getParent(), false, interpreterContext);
            if (parent == null) {
                List<Object> topMembers = null;
                if (!mem.isExtendedCalculatedMember()) {
                    topMembers = ((Level)mem.getLevel()).getMembers(true, false);
                } else {
                    topMembers = new ArrayList();
                    ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
                    ArrayList<IMember> calcMembers = calcEngine.getCalculatedMembers(mem.getLevel());
                    for (IMember calcMember : calcMembers) {
                        if (!calcMember.isExtendedCalculatedMember()) continue;
                        topMembers.add(calcMember);
                    }
                }
                for (int i = 0; i < topMembers.size(); ++i) {
                    IMemberCubics m = (IMemberCubics)topMembers.get(i);
                    if (MemberOperations.isRegularCalculatedMember(m) || MemberOperations.isExtendedCalculatedMemberTypeParent(m)) continue;
                    if (MemberOperations.isSecured(m, interpreterContext)) {
                        List<IMember> nonSecuredChildren = MemberOperations.getChildrenOp(m, false, interpreterContext);
                        siblings.addAll(nonSecuredChildren);
                        continue;
                    }
                    if (m.isFillerMember()) {
                        List<IMember> nonFillerChildren = m.getChildren(false);
                        siblings.addAll(nonFillerChildren);
                        continue;
                    }
                    siblings.add(m);
                }
            } else {
                if (!((IMemberCubics)parent).hasGotAllChildren()) {
                    ((IMemberCubics)parent).populateChildren();
                }
                List<IMember> children = MemberOperations.getChildrenOp((IMemberCubics)parent, false, interpreterContext);
                siblings.addAll(children);
            }
        }
        catch (MetadataException e) {
            throw new MetadataException("X01510", new String[]{mem.getName()}, e);
        }
        if (!includeSelf) {
            ArrayList v = new ArrayList();
            for (int i = 0; i < siblings.size(); ++i) {
                if (siblings.get(i) == mem) continue;
                v.add(siblings.get(i));
            }
            result = v.toArray(new IMember[v.size()]);
        } else {
            result = siblings.toArray(new IMember[siblings.size()]);
        }
        if (interpreterContext != null) {
            result = MemberOperations.applySecurityToMembers(result, mem.getHierarchy(), interpreterContext);
        }
        return result;
    }

    public static IMember getPreviousMemberOp(IMember mem, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getPreviousMemberOp(mem, includeFillerMembers, true, null);
    }

    public static IMember getPreviousMemberOp(IMember mem, boolean includeFillerMembers, InterpreterContext interpreterContext) throws MetadataException {
        return MemberOperations.getPreviousMemberOp(mem, includeFillerMembers, true, interpreterContext);
    }

    private static IMember getPreviousMemberOp(IMember mem, boolean includeFillerMembers, boolean applySec, InterpreterContext interpreterContext) throws MetadataException {
        if (mem instanceof NullMember) {
            return mem;
        }
        if (applySec && MemberOperations.applySecurityToMember(mem, interpreterContext) == null) {
            return NullMember.getNullMember(mem);
        }
        if (MemberOperations.isRegularCalculatedMember(mem) || MemberOperations.isExtendedCalculatedMemberTypeParent(mem)) {
            return NullMember.getNullMember(mem);
        }
        IMember currentParent = null;
        currentParent = includeFillerMembers && mem.isExtendedCalculatedMember() ? ((Member)mem).getParent(includeFillerMembers) : mem.getParent();
        IMember prevMember = null;
        IMember nullMember = NullMember.getNullMember(mem.getHierarchy());
        int memberLevelIdx = mem.getLevel().getIndex();
        int parentLevelIdx = memberLevelIdx - 1;
        if (currentParent != null && currentParent != nullMember) {
            parentLevelIdx = currentParent.getLevel().getIndex();
        }
        if (currentParent == null || currentParent == nullMember || parentLevelIdx != memberLevelIdx - 1) {
            List<IMember> levelMemberList = null;
            if (!mem.isExtendedCalculatedMember()) {
                levelMemberList = mem.getLevel().getMembers();
            } else {
                levelMemberList = new ArrayList<IMember>();
                ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
                ArrayList<IMember> calcMembers = calcEngine.getCalculatedMembers(mem.getLevel());
                for (IMember calcMember : calcMembers) {
                    if (!calcMember.isExtendedCalculatedMember()) continue;
                    levelMemberList.add(calcMember);
                }
            }
            IMember[] levelMembers = levelMemberList.toArray(new IMember[0]);
            int memberIndex = -1;
            for (int i = 0; memberIndex == -1 && i < levelMembers.length; ++i) {
                if (!levelMembers[i].equals(mem)) continue;
                memberIndex = i;
            }
            while (memberIndex >= 0 && prevMember == null) {
                --memberIndex;
                while (memberIndex >= 0 && (((IMemberCubics)levelMembers[memberIndex]).isHidden() || MemberOperations.isRegularCalculatedMember(levelMembers[memberIndex]) || MemberOperations.isExtendedCalculatedMemberTypeParent(levelMembers[memberIndex]) || !includeFillerMembers && ((IMemberCubics)levelMembers[memberIndex]).isFillerMember())) {
                    --memberIndex;
                }
                if (memberIndex < 0) continue;
                prevMember = levelMembers[memberIndex];
                if (!applySec) continue;
                prevMember = MemberOperations.applySecurityToMember(prevMember, interpreterContext);
            }
        } else {
            boolean currentParentIsMemberParent = true;
            while (currentParent != null && currentParent != nullMember && prevMember == null) {
                IMemberCubics parent = (IMemberCubics)currentParent;
                if (parent.isPopulateChildrenRequired()) {
                    parent.populateChildren();
                }
                IMember[] children = (IMember[])parent.getChildrenOrderedMap().toArray(new IMember[0]);
                int memberIndex = children.length - 1;
                if (currentParentIsMemberParent) {
                    currentParentIsMemberParent = false;
                    memberIndex = -1;
                    for (int i = 0; memberIndex == -1 && i < children.length; ++i) {
                        if (!children[i].equals(mem)) continue;
                        memberIndex = i;
                    }
                    --memberIndex;
                }
                while (prevMember == null && memberIndex >= 0) {
                    while (memberIndex >= 0 && (((IMemberCubics)children[memberIndex]).isHidden() || MemberOperations.isRegularCalculatedMember(children[memberIndex]) || MemberOperations.isExtendedCalculatedMemberTypeParent(children[memberIndex]) || !includeFillerMembers && ((IMemberCubics)children[memberIndex]).isFillerMember())) {
                        --memberIndex;
                    }
                    if (memberIndex < 0) continue;
                    prevMember = children[memberIndex];
                    if (applySec) {
                        prevMember = MemberOperations.applySecurityToMember(prevMember, interpreterContext);
                    }
                    --memberIndex;
                }
                if (prevMember != null) continue;
                currentParent = MemberOperations.getPreviousMemberOp(currentParent, true, false, interpreterContext);
            }
        }
        if (prevMember == null) {
            prevMember = NullMember.getNullMember(mem.getHierarchy());
        }
        return prevMember;
    }

    public static IMember[] getMembers(Level level, InterpreterContext ic) {
        IROLAPSecurityManager sec = (IROLAPSecurityManager)((Cube)ic.getCube()).getSecurityManager();
        if (sec != null) {
            ROLAPUserSecurityContext secContext = null;
            if (sec instanceof SecManager) {
                secContext = ((SecManager)sec).getUserSecurityContext();
            }
            if (sec.hasSecurityPaddingMembers(level)) {
                List<IMember> secMembers = level.getMembersWithSecurity(ic, sec, secContext, level);
                return secMembers.toArray(new IMember[secMembers.size()]);
            }
            ArrayList<IMember> secMembers = null;
            if (sec instanceof SecManager) {
                return ((SecManager)sec).applySecurity(secContext, level);
            }
            List<IMember> levelMembers = level.getMembers();
            secMembers = MemberOperations.applySecurityToMembers(levelMembers, level.getHierarchy(), ic, secContext);
            return secMembers.toArray(new IMember[secMembers.size()]);
        }
        List<IMember> levelMembers = level.getMembersWithContext(ic);
        return levelMembers.toArray(new IMember[levelMembers.size()]);
    }

    public static IMember[] getMembers(IHierarchy hierarchy, InterpreterContext interpreterContext) {
        Hierarchy hier = (Hierarchy)hierarchy;
        IROLAPSecurityManager sec = (IROLAPSecurityManager)((Cube)interpreterContext.getCube()).getSecurityManager();
        if (sec != null && sec.hasSecurityPaddingMembers(hierarchy)) {
            return hier.getMembers(interpreterContext);
        }
        return hier.getMembers();
    }

    public static IMember getNextMemberOp(IMember mem, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getNextMemberOp(mem, includeFillerMembers, true, null);
    }

    public static IMember getNextMemberOp(IMember mem, boolean includeFillerMembers, InterpreterContext interpreterContext) throws MetadataException {
        return MemberOperations.getNextMemberOp(mem, includeFillerMembers, true, interpreterContext);
    }

    private static IMember getNextMemberOp(IMember mem, boolean includeFillerMembers, boolean applySec, InterpreterContext interpreterContext) throws MetadataException {
        if (mem instanceof NullMember) {
            return mem;
        }
        if (applySec && MemberOperations.applySecurityToMember(mem, interpreterContext) == null) {
            return NullMember.getNullMember(mem);
        }
        if (MemberOperations.isRegularCalculatedMember(mem) || MemberOperations.isExtendedCalculatedMemberTypeParent(mem)) {
            return NullMember.getNullMember(mem);
        }
        IMember currentParent = null;
        currentParent = includeFillerMembers && mem.isExtendedCalculatedMember() ? ((Member)mem).getParent(includeFillerMembers) : mem.getParent();
        IMember nextMember = null;
        IMember nullMember = NullMember.getNullMember(mem.getHierarchy());
        int memberLevelIdx = mem.getLevel().getIndex();
        int parentLevelIdx = memberLevelIdx - 1;
        if (currentParent != null && currentParent != nullMember) {
            parentLevelIdx = currentParent.getLevel().getIndex();
        }
        if (currentParent == null || currentParent == nullMember || parentLevelIdx != memberLevelIdx - 1) {
            List<IMember> levelMemberList = null;
            if (!mem.isExtendedCalculatedMember()) {
                levelMemberList = mem.getLevel().getMembers();
            } else {
                levelMemberList = new ArrayList<IMember>();
                ICalculationEngine calcEngine = interpreterContext.getCalculationEngine();
                ArrayList<IMember> calcMembers = calcEngine.getCalculatedMembers(mem.getLevel());
                for (IMember calcMember : calcMembers) {
                    if (!calcMember.isExtendedCalculatedMember()) continue;
                    levelMemberList.add(calcMember);
                }
            }
            IMember[] levelMembers = levelMemberList.toArray(new IMember[0]);
            int memberIndex = -1;
            for (int i = 0; memberIndex == -1 && i < levelMembers.length; ++i) {
                if (!levelMembers[i].equals(mem)) continue;
                memberIndex = i;
            }
            while (memberIndex < levelMembers.length && nextMember == null) {
                ++memberIndex;
                while (memberIndex < levelMembers.length && (((IMemberCubics)levelMembers[memberIndex]).isHidden() || MemberOperations.isRegularCalculatedMember(levelMembers[memberIndex]) || MemberOperations.isExtendedCalculatedMemberTypeParent(levelMembers[memberIndex]) || !includeFillerMembers && ((IMemberCubics)levelMembers[memberIndex]).isFillerMember())) {
                    ++memberIndex;
                }
                if (memberIndex >= levelMembers.length) continue;
                nextMember = levelMembers[memberIndex];
                if (!applySec) continue;
                nextMember = MemberOperations.applySecurityToMember(nextMember, interpreterContext);
            }
        } else {
            boolean currentParentIsMemberParent = true;
            while (currentParent != null && currentParent != nullMember && nextMember == null) {
                IMemberCubics parent = (IMemberCubics)currentParent;
                if (parent.isPopulateChildrenRequired()) {
                    parent.populateChildren();
                }
                IMember[] children = (IMember[])parent.getChildrenOrderedMap().toArray(new IMember[0]);
                int memberIndex = 0;
                if (currentParentIsMemberParent) {
                    currentParentIsMemberParent = false;
                    memberIndex = -1;
                    for (int i = 0; memberIndex == -1 && i < children.length; ++i) {
                        if (!children[i].equals(mem)) continue;
                        memberIndex = i;
                    }
                    ++memberIndex;
                }
                while (nextMember == null && memberIndex < children.length) {
                    while (memberIndex < children.length && (((IMemberCubics)children[memberIndex]).isHidden() || MemberOperations.isRegularCalculatedMember(children[memberIndex]) || MemberOperations.isExtendedCalculatedMemberTypeParent(children[memberIndex]) || !includeFillerMembers && ((IMemberCubics)children[memberIndex]).isFillerMember())) {
                        ++memberIndex;
                    }
                    if (memberIndex >= children.length) continue;
                    nextMember = children[memberIndex];
                    if (applySec) {
                        nextMember = MemberOperations.applySecurityToMember(nextMember, interpreterContext);
                    }
                    ++memberIndex;
                }
                if (nextMember != null) continue;
                currentParent = MemberOperations.getNextMemberOp(currentParent, true, false, interpreterContext);
            }
        }
        if (nextMember == null) {
            nextMember = NullMember.getNullMember(mem.getHierarchy());
        }
        return nextMember;
    }

    public static IMember getParentOp(IMember immediateParentMember, boolean includeFillerMembers) {
        return MemberOperations.getParentOp(immediateParentMember, includeFillerMembers, null);
    }

    public static IMember getParentOp(IMember immediateParentMember, boolean includeFillerMembers, InterpreterContext interpreterContext) {
        boolean resultSecured;
        if (immediateParentMember instanceof NullMember) {
            return immediateParentMember;
        }
        IMemberCubics result = (IMemberCubics)immediateParentMember;
        boolean bl = resultSecured = MemberOperations.applySecurityToMember(result, interpreterContext) == null;
        while (result != null && (resultSecured || result.isHidden() || !includeFillerMembers && result.isFillerMember())) {
            resultSecured = MemberOperations.applySecurityToMember(result = (IMemberCubics)result.getParent(includeFillerMembers), interpreterContext) == null;
        }
        return result;
    }

    public static List<IMember> getChildrenOp(IMemberCubics mem, boolean includeFillerMembers) {
        return MemberOperations.getChildrenOp(mem, includeFillerMembers, null);
    }

    public static List<IMember> getChildrenOp(IMemberCubics mem, boolean includeFillerMembers, InterpreterContext interpreterContext) {
        return MemberOperations.getChildrenOp(mem, includeFillerMembers, false, interpreterContext, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMember> getChildrenOp(IMemberCubics mem, boolean includeFillerMembers, boolean includePaddingMembers, InterpreterContext interpreterContext, boolean forceOpOnSecuredMember, ROLAPUserSecurityContext secContext, List<IMember> resultList) {
        ILevel level;
        if (!forceOpOnSecuredMember && (mem instanceof NullMember || MemberOperations.applySecurityToMember(mem, interpreterContext, secContext) == null)) {
            return new ArrayList<IMember>();
        }
        if (MemberOperations.isRegularCalculatedMember(mem)) {
            return new ArrayList<IMember>();
        }
        IOrderedMap<IMember> children = mem.getChildrenOrderedMap();
        if (children == null) {
            return new ArrayList<IMember>();
        }
        if (mem.isPopulateChildrenRequired()) {
            mem.populateChildren();
            children = mem.getChildrenOrderedMap();
        }
        boolean isCustomRollingTotalMember = false;
        if (mem instanceof ROLAPRelativeTimeMember && !(isCustomRollingTotalMember = ((ROLAPRelativeTimeMember)mem).isCustomRollingTotalMember()) && mem.getParent() instanceof ROLAPRelativeTimeMember) {
            isCustomRollingTotalMember = ((ROLAPRelativeTimeMember)mem.getParent()).isCustomRollingTotalMember();
        }
        boolean mayContainFillers = (level = mem.getLevel()).getHierarchy().isRagged() || level.getHierarchy().isUnbalanced() || isCustomRollingTotalMember;
        List<IMember> filteredMembers = null;
        filteredMembers = resultList != null ? resultList : new ArrayList<IMember>();
        children.lock();
        try {
            for (IMemberCubics iMemberCubics : children) {
                if (!includePaddingMembers && interpreterContext == null && iMemberCubics instanceof ROLAPSecurityPaddingMemberProxy) continue;
                if (mayContainFillers && !includeFillerMembers && iMemberCubics.isFillerMember()) {
                    if (MemberOperations.isSecured(iMemberCubics, interpreterContext)) continue;
                    List<IMember> nonFillerChildren = iMemberCubics.getChildren(false);
                    filteredMembers.addAll(nonFillerChildren);
                    continue;
                }
                if (iMemberCubics.isHidden() || MemberOperations.isRegularCalculatedMember(iMemberCubics) || MemberOperations.isExtendedCalculatedMemberTypeParent(iMemberCubics)) continue;
                filteredMembers.add(iMemberCubics);
            }
        }
        finally {
            children.unlock();
        }
        filteredMembers = MemberOperations.applySecurityToMembers(filteredMembers, mem.getHierarchy(), interpreterContext, secContext);
        return filteredMembers;
    }

    public static IMember getChildMemberOp(IMemberCubics parentMem, String childMemberName) throws MetadataException {
        return MemberOperations.getChildMemberOp(parentMem, childMemberName, null);
    }

    public static IMember getChildMemberOp(IMemberCubics parentMem, String childMemberName, InterpreterContext interpreterContext) throws MetadataException {
        ArrayList<IMember> fillerMembers;
        if (parentMem instanceof NullMember) {
            return parentMem;
        }
        if (MemberOperations.applySecurityToMember(parentMem, interpreterContext) == null) {
            return NullMember.getNullMember(parentMem);
        }
        parentMem.getLevel();
        IMember result = parentMem.searchChildrenOrderedMap(childMemberName);
        if (result == null && !parentMem.hasGotAllChildren()) {
            parentMem.populateChildren();
            result = parentMem.searchChildrenOrderedMap(childMemberName);
        }
        if (result == null && (fillerMembers = parentMem.getChildFillerMembers()) != null) {
            for (int fillerMemIdx = 0; result == null && fillerMemIdx < fillerMembers.size(); ++fillerMemIdx) {
                IMemberCubics member = (IMemberCubics)fillerMembers.get(fillerMemIdx);
                result = MemberOperations.getChildMemberOp(member, childMemberName, interpreterContext);
            }
        }
        if (result != null && !((IMemberCubics)result).isHidden() && MemberOperations.applySecurityToMember(result, interpreterContext) != null) {
            return result;
        }
        return null;
    }

    public static int[] getDescendantsIdsOp(IMemberCubics mem, ILevel l) throws MetadataException {
        int[] result;
        ArrayList descendants = new ArrayList();
        ArrayList<List<IMember>> recurse = new ArrayList<List<IMember>>();
        if (l == mem.getLevel()) {
            result = new int[]{(int)mem.getMemberId()};
        } else {
            OrderedMap chs = new OrderedMap();
            chs.put(mem);
            while (chs != null) {
                for (int i = 0; i < chs.size(); ++i) {
                    IMember m = (IMember)chs.get(i);
                    List<IMember> childMems = m.getChildren();
                    if (childMems == null) continue;
                    recurse.add(childMems);
                }
                if (recurse.size() == 0) {
                    chs = null;
                    continue;
                }
                chs = (OrderedMap)recurse.get(0);
                recurse.remove(0);
            }
            int[][] unionInput = new int[descendants.size()][];
            for (int i = 0; i < descendants.size(); ++i) {
                int[] memIds;
                unionInput[i] = memIds = (int[])descendants.get(i);
            }
            result = IntegerSet.fromArrays(unionInput, false).getData();
        }
        return result;
    }

    public static ArrayList<IMember> getDescendantsOp(IMemberCubics mem, ILevel l, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp(mem, l, includeFillerMembers, null);
    }

    public static ArrayList<IMember> getDescendantsOp(IMemberCubics mem, ILevel l, boolean includeFillerMembers, InterpreterContext interpreterContext) throws MetadataException {
        ArrayList<IMember> result = new ArrayList<IMember>();
        if (mem instanceof NullMember || MemberOperations.applySecurityToMember(mem, interpreterContext) == null) {
            return result;
        }
        if (MemberOperations.isRegularCalculatedMember(mem) && l != mem.getLevel()) {
            return new ArrayList<IMember>();
        }
        if (l == mem.getLevel()) {
            result.add(mem);
        } else if (l == mem.getLevel().getNextLevel()) {
            result = (ArrayList<IMember>)mem.getChildren(includeFillerMembers, l.getIndex());
        } else {
            IOrderedMap<IMember> children;
            if (mem.isPopulateChildrenRequired()) {
                mem.populateChildren();
            }
            if ((children = mem.getChildrenOrderedMap(l.getIndex())) != null) {
                for (int i = 0; i < children.size(); ++i) {
                    IMemberCubics m = (IMemberCubics)children.get(i);
                    result.addAll(MemberOperations.getDescendantsOp(m, l, includeFillerMembers, interpreterContext));
                }
            }
        }
        if (interpreterContext != null) {
            result = MemberOperations.applySecurityToMembers((List<IMember>)result, mem.getHierarchy(), interpreterContext, null);
        }
        return result;
    }

    public static ArrayList<IMember> getDescendantsOp(IMemberCubics mem, ILevel l, int descRangeflagEnum, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp(mem, l, descRangeflagEnum, includeFillerMembers, null);
    }

    public static ArrayList<IMember> getDescendantsOp(IMemberCubics mem, ILevel l, int descRangeflagEnum, boolean includeFillerMembers, InterpreterContext interpreterContext) throws MetadataException {
        ILevel currentLevel;
        if (mem instanceof NullMember || MemberOperations.applySecurityToMember(mem, interpreterContext) == null) {
            return new ArrayList<IMember>();
        }
        int distanceCounter = 0;
        for (currentLevel = mem.getLevel(); currentLevel != null && l != currentLevel; currentLevel = currentLevel.getNextLevel()) {
            ++distanceCounter;
        }
        if (currentLevel == null) {
            currentLevel = mem.getLevel();
            int counter = 0;
            while (currentLevel != null && l != currentLevel) {
                currentLevel = currentLevel.getPreviousLevel();
                --counter;
            }
            if (currentLevel != null) {
                distanceCounter = counter;
            }
        }
        ArrayList<IMember> results = new ArrayList<IMember>();
        if (descRangeflagEnum == -1) {
            descRangeflagEnum = 0;
        }
        MemberOperations.getDescendantsOp(mem, distanceCounter, descRangeflagEnum, includeFillerMembers, results, interpreterContext);
        return results;
    }

    public static void getDescendantsOp(IMemberCubics member, int depth, int descRangeflagEnum, boolean includeFillerMembers, ArrayList<IMember> output, InterpreterContext interpreterContext) throws MetadataException {
        String optimizeDescendantsFunctionInSAL = FALSE;
        IDataSource dataSource = null;
        if (interpreterContext != null) {
            dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        } else {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (execEnv != null) {
                dataSource = execEnv.getDataSource();
            }
        }
        if (dataSource != null && !member.isMeasure()) {
            optimizeDescendantsFunctionInSAL = dataSource.getCapabilities().getStringValue("OptimizeDescendantsFunctionInSAL", optimizeDescendantsFunctionInSAL);
        }
        if (optimizeDescendantsFunctionInSAL.equals(FALSE)) {
            MemberOperations.recursiveAddDescendants(member, depth, descRangeflagEnum, includeFillerMembers, output, interpreterContext);
            return;
        }
        if (optimizeDescendantsFunctionInSAL.equals(LIMITED) && (descRangeflagEnum == 1 && member.getLevel().getIndex() + depth < member.getHierarchy().getLevelCount() || (descRangeflagEnum == 0 || descRangeflagEnum == 5) && member.getLevel().getIndex() + depth < member.getHierarchy().getLevelCount() - 1)) {
            MemberOperations.recursiveAddDescendants(member, depth, descRangeflagEnum, includeFillerMembers, output, interpreterContext);
            return;
        }
        if (depth == 0) {
            if (!(descRangeflagEnum != 7 && descRangeflagEnum != 0 && descRangeflagEnum != 5 || member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
                return;
            }
            if (includeFillerMembers && descRangeflagEnum == 7 || descRangeflagEnum == 1) {
                return;
            }
        }
        if (depth >= 0 && descRangeflagEnum == 8 && MemberOperations.isLeaf(member, interpreterContext) && !member.isFillerMember() && !member.isHidden() && !MemberOperations.isSecured(member, interpreterContext)) {
            output.add(member);
            return;
        }
        IOrderedMap<IMember> descendants = member.getDescendantsOrderedMap(depth, descRangeflagEnum);
        if (descendants == null || descendants.size() == 0) {
            return;
        }
        int leafLevelIndex = member.getLevel().getIndex() + depth;
        switch (descRangeflagEnum) {
            case 1: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() >= leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            case 2: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() <= leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            case 3: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() >= leafLevelIndex && currentLolapMember.getLevel().getIndex() <= leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            case 4: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() < leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            case 5: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() > leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            case 6: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentMember);
                }
                break;
            }
            default: {
                for (IMember currentMember : descendants) {
                    LOLAPMemberProxy currentLolapMember = (LOLAPMemberProxy)currentMember;
                    if (currentLolapMember.isFillerMember() || currentLolapMember.getLevel().getIndex() != leafLevelIndex || currentLolapMember.isHidden() || MemberOperations.isSecured(currentLolapMember, interpreterContext)) continue;
                    output.add(currentLolapMember);
                }
            }
        }
    }

    public static void recursiveAddDescendants(IMember mem, int depth, int descRangeflagEnum, ArrayList<IMember> output) throws MetadataException {
        MemberOperations.recursiveAddDescendants((IMemberCubics)mem, depth, descRangeflagEnum, false, output, null);
    }

    public static void recursiveAddDescendants(IMemberCubics member, int depth, int descRangeflagEnum, boolean includeFillerMembers, ArrayList<IMember> output, InterpreterContext interpreterContext) throws MetadataException {
        boolean recurse = true;
        if (descRangeflagEnum == 7) {
            if (depth == 0) {
                if (!(member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                    output.add(member);
                    recurse = false;
                } else if (includeFillerMembers) {
                    recurse = false;
                }
            } else if (MemberOperations.isLeaf(member, interpreterContext) && !member.isFillerMember() && !member.isHidden() && !MemberOperations.isSecured(member, interpreterContext)) {
                output.add(member);
                recurse = false;
            }
        } else if (descRangeflagEnum == 8) {
            if (depth >= 0 && MemberOperations.isLeaf(member, interpreterContext) && !member.isFillerMember() && !member.isHidden() && !MemberOperations.isSecured(member, interpreterContext)) {
                output.add(member);
                recurse = false;
            }
        } else if (descRangeflagEnum == 0) {
            if (!(depth != 0 || member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
                recurse = false;
            }
        } else if (descRangeflagEnum == 1) {
            if (depth > 0) {
                if (!(member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                    output.add(member);
                }
            } else if (depth < 0) {
                recurse = false;
            }
        } else if (descRangeflagEnum == 2) {
            if (!(depth >= 0 || member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
            }
        } else if (descRangeflagEnum == 4) {
            if (!(depth > 0 || member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
            }
        } else if (descRangeflagEnum == 5) {
            if (depth >= 0) {
                if (!(member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                    output.add(member);
                }
            } else {
                recurse = false;
            }
        } else if (descRangeflagEnum == 3) {
            if (!(depth == 0 || member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
            }
        } else if (descRangeflagEnum == 6) {
            if (!(member.isFillerMember() || member.isHidden() || MemberOperations.isSecured(member, interpreterContext))) {
                output.add(member);
            }
        } else {
            throw new MetadataException("X01490", new String[]{DescendantsRangeFlagEnum.getStringFlag(descRangeflagEnum), "recursiveAddDescendants", "SELF, BEFORE, AFTER, SELF_AND_BEFORE, SELF_AND_AFTER, ..."});
        }
        if (recurse) {
            IOrderedMap<IMember> children;
            int lowestLevelNeededIndex = -1;
            if (depth >= 0) {
                if (descRangeflagEnum == 0 || descRangeflagEnum == 5) {
                    lowestLevelNeededIndex = member.getLevel().getIndex() + depth;
                } else if (descRangeflagEnum == 1 && depth > 0) {
                    lowestLevelNeededIndex = member.getLevel().getIndex() + depth - 1;
                }
            }
            if (!member.isFillerMember() && !MemberOperations.isSecured(member, interpreterContext) || includeFillerMembers) {
                --depth;
            }
            if (lowestLevelNeededIndex != -1 && member.getLevel().getIndex() >= lowestLevelNeededIndex) {
                children = null;
            } else {
                if (member.isPopulateChildrenRequired()) {
                    member.populateChildren();
                }
                children = member.getChildrenOrderedMap(lowestLevelNeededIndex);
            }
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    MemberOperations.recursiveAddDescendants((IMemberCubics)children.get(i), depth, descRangeflagEnum, includeFillerMembers, output, interpreterContext);
                }
            }
        }
    }

    public static boolean isLeaf(IMember mem, InterpreterContext interpreterContext) {
        List<IMember> children;
        IMemberCubics member = (IMemberCubics)mem;
        if (member.isPopulateChildrenRequired()) {
            member.populateChildren();
        }
        boolean result = member.getChildrenCardinality() == 0 ? true : (children = MemberOperations.getChildrenOp(member, false, interpreterContext)).size() == 0;
        return result;
    }

    public static IMember cousin(IMember mem, IMember ancestor) {
        return MemberOperations.cousin(mem, ancestor, null);
    }

    public static IMember cousin(IMember mem, IMember ancestor, InterpreterContext interpreterContext) {
        IMember cousin;
        IMember result = null;
        IMember current = cousin = mem;
        if (ancestor instanceof NullMember) {
            return NullMember.getNullMember(mem);
        }
        if (MemberOperations.isRegularCalculatedMember(mem) || MemberOperations.isExtendedCalculatedMemberTypeParent(mem)) {
            return NullMember.getNullMember(mem);
        }
        if (ancestor.getHierarchy() != mem.getHierarchy()) {
            return NullMember.getNullMember(mem);
        }
        int ancestorLevelNumber = ((Level)ancestor.getLevel()).getIndex();
        if (((Level)current.getLevel()).getIndex() < ancestorLevelNumber) {
            return NullMember.getNullMember(mem);
        }
        ArrayList<Integer> parentIndexes = new ArrayList<Integer>();
        while (current != null && ((Level)current.getLevel()).getIndex() > ancestorLevelNumber) {
            IMember parent = current.getParent();
            int idx = ((IMemberCubics)current).getIndexInParentsChildren();
            if (idx == -1) {
                return NullMember.getNullMember(mem);
            }
            parentIndexes.add(new Integer(idx));
            current = parent;
        }
        if (null == current) {
            return NullMember.getNullMember(mem);
        }
        current = ancestor;
        boolean cousinExists = true;
        for (int j = parentIndexes.size() - 1; j >= 0 && cousinExists; --j) {
            int idx = (Integer)parentIndexes.get(j);
            try {
                List<IMember> ch = MemberOperations.getChildrenOp((IMemberCubics)current, false, interpreterContext);
                if (ch == null || idx >= ch.size()) {
                    cousinExists = false;
                    continue;
                }
                current = ch.get(idx);
                continue;
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        result = cousinExists ? current : NullMember.getNullMember(mem);
        return result;
    }

    public static int hierarchyCompare(IMember a, IMember b, boolean postOrder) throws MetadataException {
        IMember ac = a;
        IMember bc = b;
        IMember ap = a;
        IMember bp = b;
        if (a == b) {
            return 0;
        }
        if (a instanceof NullMember) {
            return -1;
        }
        if (b instanceof NullMember) {
            return 1;
        }
        int levelA = ((Level)ac.getLevel()).getIndex();
        int levelB = ((Level)bc.getLevel()).getIndex();
        while (levelA > levelB && ((IMemberCubics)ac).getParent(true) != null) {
            ap = ac;
            ac = ((IMemberCubics)ac).getParent(true);
            levelA = ((Level)ac.getLevel()).getIndex();
        }
        while (levelB > levelA && ((IMemberCubics)bc).getParent(true) != null) {
            bp = bc;
            bc = ((IMemberCubics)bc).getParent(true);
            levelB = ((Level)bc.getLevel()).getIndex();
        }
        if (ac == bc) {
            if (ac == b) {
                if (postOrder) {
                    return 1;
                }
                return -1;
            }
            if (bc == a) {
                if (postOrder) {
                    return -1;
                }
                return 1;
            }
        }
        while ((ac != null || bc != null) && ac != bc) {
            if (bc != null) {
                bp = bc;
                bc = ((IMemberCubics)bc).getParent(true);
            }
            if (ac == null) continue;
            ap = ac;
            ac = ((IMemberCubics)ac).getParent(true);
        }
        if (ap != null && bp != null) {
            if (ap instanceof CalculatedMember) {
                if (bp instanceof CalculatedMember) {
                    if (((IMemberCubics)ap).getMemberId() < ((IMemberCubics)bp).getMemberId()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (bp instanceof CalculatedMember) {
                return 1;
            }
            if (((IMemberCubics)ap).isFillerMember() && ((IMemberCubics)bp).isFillerMember()) {
                if (((IMemberCubics)a).getIndexInParentsChildren() < ((IMemberCubics)b).getIndexInParentsChildren()) {
                    return 1;
                }
                return -1;
            }
            if (((IMemberCubics)ap).getIndexInParentsChildren() < ((IMemberCubics)bp).getIndexInParentsChildren()) {
                return 1;
            }
            return -1;
        }
        String msg = "Could not work out which member was higher in hierarchyCompare function. Members may not be in the same dimension";
        XQEDebugLog.out.println(msg);
        throw new MetadataException(msg);
    }

    public static Object getPropertyOp(IMetadata item, String propName) {
        Object result = item.getProperty(propName);
        if (result == null) {
            String normProperty = MemberOperations.normalizePropertyName(propName);
            if (normProperty == "NAME") {
                result = item.getName();
            } else if (normProperty == "CAPTION" || normProperty == "DESCRIPTION") {
                result = item.getCaption();
            }
        }
        return result;
    }

    public static Object getPropertyOp(IMember mem, String propName) {
        Object result = null;
        if (mem instanceof NullMember) {
            return null;
        }
        String normProperty = MemberOperations.normalizePropertyName(propName);
        if (propName.equals("_rollupType")) {
            normProperty = ROLLUP_TYPE;
        }
        if (normProperty == "MEMBER_TYPE") {
            result = ((IMemberCubics)mem).getMetadataProperty(normProperty);
            if (result == null) {
                result = mem.isCalculatedMember() ? MemberTypeEnum.CALCULATED : MemberTypeEnum.REGULAR;
            }
        } else if (normProperty == "MEMBER_GUID") {
            result = NullObject.instance();
        } else if (normProperty == "MEMBER_ORDINAL") {
            result = mem instanceof IMemberCubics ? XQEIntegerPool.getInteger(((IMemberCubics)mem).getIndex()) : XQEIntegerPool.getInteger(0);
        } else if (normProperty == "PARENT_UNIQUE_NAME") {
            IMember parent = mem.getParent();
            if (parent != null) {
                result = parent.getUniqueName();
            }
        } else if (normProperty == "CUBE_NAME") {
            result = ((Cube)mem.getDimension().getCube()).getName();
        } else if (normProperty == "DIMENSION_UNIQUE_NAME") {
            result = mem.getDimension().getUniqueName();
        } else if (normProperty == "HIERARCHY_UNIQUE_NAME") {
            result = mem.getHierarchy().getUniqueName();
        } else if (normProperty == "LEVEL_UNIQUE_NAME") {
            result = mem.getLevel().getUniqueName();
        } else if (normProperty == "LEVEL_NUMBER") {
            result = XQEIntegerPool.getInteger(mem.getLevel().getIndex());
        } else if (normProperty == "MEMBER_UNIQUE_NAME" || normProperty == SAP_BUSINESS_KEY) {
            IMemberCubics originalCalculatedMember = null;
            if (mem instanceof CalculatedMember) {
                originalCalculatedMember = (CalculatedMember)((CalculatedMember)mem).getOriginalCalculatedMember();
            }
            result = originalCalculatedMember != null ? originalCalculatedMember.getMUNPropValue() : ((IMemberCubics)mem).getMUNPropValue();
        } else if (normProperty == "MEMBER_NAME") {
            result = mem.getName();
        } else if (normProperty == "NAME") {
            result = mem.getName().trim();
        } else if (normProperty == "MEMBER_CAPTION" || normProperty == "CAPTION") {
            result = mem.getCaptionValue();
        } else if (normProperty == "DESCRIPTION") {
            result = ((IMemberCubics)mem).getDescriptionValue();
        } else if (normProperty == "CHILDREN_CARDINALITY") {
            try {
                result = XQEIntegerPool.getInteger(mem.getChildMembers().length);
            }
            catch (Exception e) {
                mErrorLogger.log(e);
                result = XQEIntegerPool.getInteger(0);
            }
        } else if (normProperty == "PARENT_COUNT") {
            int pCount = mem.getNumberOfParents();
            result = XQEIntegerPool.getInteger(pCount);
        } else if (normProperty == "PARENT_LEVEL") {
            IMember parent = mem.getParent();
            result = parent != null ? XQEIntegerPool.getInteger(((Level)parent.getLevel()).getIndex()) : NullObject.instance();
        } else if (normProperty == "KEY" || normProperty == "MEMBER_KEY") {
            Object key = ((IMemberCubics)mem).getMetadataProperty(normProperty);
            if (key != null) {
                result = key;
            } else {
                key = mem.getBusinessKey();
                if (key != null) {
                    result = key;
                } else if (!(mem instanceof CalculatedMember)) {
                    result = mem.getName();
                }
            }
        } else {
            ICube cube = mem.getDimension().getCube();
            if (((Cube)cube).isMemberAnAttribute(normProperty, mem.getLevel())) {
                normProperty = ((LOLAPCube)cube).getAttributeUniqueName(normProperty, mem.getLevel());
            }
            result = ((IMemberCubics)mem).getMetadataProperty(normProperty);
        }
        return result;
    }

    private static String normalizePropertyName(String name) {
        if (name == null) {
            return name;
        }
        for (int i = 0; i < KNOWN_MEMBER_PROPERTIES.length; ++i) {
            if (KNOWN_MEMBER_PROPERTIES[i] != name) continue;
            return name;
        }
        String foundName = mPropertyMap.get(name.toUpperCase());
        if (foundName != null) {
            return foundName;
        }
        return name;
    }

    public static boolean isAncestorOf(IMember m1, IMember m2) {
        if (m1.getHierarchy() != m2.getHierarchy()) {
            return false;
        }
        if (m2.getLevel().getIndex() <= m1.getLevel().getIndex()) {
            return false;
        }
        for (IMember candidateAncestor = m2.getParent(); candidateAncestor != null; candidateAncestor = candidateAncestor.getParent()) {
            if (candidateAncestor != m1) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegularCalculatedMember(IMember member) {
        return member.isCalculatedMember() && !member.isExtendedCalculatedMember();
    }

    public static boolean isExtendedCalculatedMemberTypeParent(IMember member) {
        return member.isExtendedCalculatedMember() && !member.isExtendedCalculatedMemberTypeChildRef();
    }

    public static Object getOriginalCalculatedMember(Object obj) {
        if (!(obj instanceof CalculatedMember)) {
            return obj;
        }
        IMember originalCalcParentMember = ((CalculatedMember)obj).getOriginalCalculatedMember();
        if (originalCalcParentMember != null && originalCalcParentMember.isExtendedCalculatedMember()) {
            return originalCalcParentMember;
        }
        return obj;
    }

    static {
        for (int i = 0; i < KNOWN_MEMBER_PROPERTIES.length; ++i) {
            mPropertyMap.put(KNOWN_MEMBER_PROPERTIES[i], KNOWN_MEMBER_PROPERTIES[i]);
        }
    }
}

