/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TupleStorageLogger {
    private static Lock readLock;
    private static Lock writeLock;
    private List<String> tupleStorageFiles = new ArrayList<String>();
    private int numFileCreated = 0;
    private int numFileDeleted = 0;
    private static final String NEWLINE = "\n";
    private static SingletonHelper<TupleStorageLogger> singletonHelper;

    private TupleStorageLogger() {
        ReentrantReadWriteLock dimensionsLock = new ReentrantReadWriteLock();
        readLock = dimensionsLock.readLock();
        writeLock = dimensionsLock.writeLock();
    }

    public static TupleStorageLogger getLogger() {
        return singletonHelper.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        readLock.lock();
        try {
            if (this.tupleStorageFiles.size() != this.numFileCreated - this.numFileDeleted) {
                throw new XQERuntimeException();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Number of files created: ");
            sb.append(this.numFileCreated);
            sb.append(NEWLINE);
            sb.append("Number of files deleted: ");
            sb.append(this.numFileDeleted);
            sb.append(NEWLINE);
            sb.append("Number of files not closed: ");
            sb.append(this.numFileCreated - this.numFileDeleted);
            sb.append(NEWLINE);
            for (String file : this.tupleStorageFiles) {
                sb.append(file);
                sb.append(NEWLINE);
            }
            this.getTupleStorageLogger().log(sb.toString());
        }
        finally {
            readLock.unlock();
        }
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public void create(String filePath) {
        writeLock.lock();
        try {
            this.getTupleStorageLogger().log("Creating tuple storage: " + filePath);
            this.tupleStorageFiles.add(filePath);
            ++this.numFileCreated;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void delete(String filePath) {
        writeLock.lock();
        try {
            if (!this.tupleStorageFiles.contains(filePath)) {
                XQELogger logger = this.getTupleStorageLoggerError();
                logger.log("File " + filePath + "is being deleted but has not been registered as opened.");
            } else {
                StringBuilder sb = new StringBuilder("Deleting tuple storage: ");
                sb.append(filePath);
                this.getTupleStorageLogger().log(sb.toString());
                this.tupleStorageFiles.remove(filePath);
                ++this.numFileDeleted;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void reuse(String filePath) {
        this.getTupleStorageLogger().log("Reusing tuple storage: " + filePath);
    }

    public void errorDeleting(String filePath) {
        this.getTupleStorageLogger().log("Error deleting: " + filePath);
    }

    private XQELogger getTupleStorageLogger() {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.INFO);
    }

    private XQELogger getTupleStorageLoggerError() {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.ERROR);
    }

    static {
        singletonHelper = new SingletonHelper<TupleStorageLogger>(){

            @Override
            protected TupleStorageLogger newInstance() {
                return new TupleStorageLogger();
            }

            @Override
            protected void initializeImpl(TupleStorageLogger theInstance) {
            }

            @Override
            protected void releaseImpl(TupleStorageLogger theInstance) {
                theInstance.release();
            }
        };
    }
}

