/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CubeContextKey {
    private static final int NUMBER_31 = 31;
    private final String modelPath;
    private final List<String> detailFilters;
    private final List<String> relationalFilters;
    private String memberStoreTS;
    private String locale;
    private final SecurityContext securityContext;
    private final Map<String, String> filterParameters;
    private final boolean designMode;
    private final long modelModificationTime;
    TreeMap<String, String> keyMap;

    public CubeContextKey(CubeWrapper modelCube, SecurityContext secContext, String memberStorageTS, String lLocale, long lastModTime, TreeMap<String, String> map) {
        this.keyMap = map;
        MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        Parameters parameters = multiRequestContext.getRequestParameters().getParameters();
        this.modelPath = modelCube.getConnection().getModelPath();
        this.detailFilters = new ArrayList<String>();
        this.relationalFilters = new ArrayList<String>();
        this.filterParameters = new HashMap<String, String>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        this.designMode = modelCube.isDesignMode();
        for (CogMDXDetailFilter filter : modelCube.getDetailFilters()) {
            for (IXQEQueryNode boundParameterNode : filter.getDescendantsOfType(201127, false)) {
                parameterNames.add(((V5BoundParameter)boundParameterNode).getParameterName());
            }
            if (filter.isModelFilter()) continue;
            StringBuilder sb = new StringBuilder();
            filter.writeFormattedText(sb);
            sb.append(filter.getPostAutoAggregation());
            sb.append(filter.getPropertyValue("masterDetailDFilter"));
            sb.append(filter.getPropertyValue("dmrSlicer"));
            this.detailFilters.add(sb.toString());
        }
        RQPPrePlan prePlan = modelCube.getRQPPrePlanQuery();
        if (prePlan != null) {
            parameterNames.addAll(PrePlanUtilities.getInvolvedPrompts(prePlan));
            for (IEmbeddedFilter filter : PrePlanUtilities.getInvolvedEmbeddedFilters(prePlan)) {
                if (filter.getExpression() == null) continue;
                this.relationalFilters.add(filter.getExpression());
            }
        }
        for (Map.Entry parameterEntry : parameters.entrySet()) {
            Parameter parameter = (Parameter)parameterEntry.getValue();
            if (!parameter.parameterReplacedByValue()) continue;
            parameterNames.add(parameter.getName());
        }
        for (String parameterName : parameterNames) {
            if (this.filterParameters.get(parameterName) != null) continue;
            Parameter parameter = parameters.getParameter(parameterName);
            String parameterValue = parameter.getParameterValueItems().asDOMString("values");
            this.filterParameters.put(parameterName, parameterValue);
        }
        this.securityContext = secContext;
        this.memberStoreTS = memberStorageTS;
        this.locale = lLocale;
        this.modelModificationTime = lastModTime;
    }

    public CubeContextKey(String modelPathString, boolean isDesignMode, SecurityContext secContext, String memberStorageTS, String lLocale, long lastModTime) {
        this.keyMap = new TreeMap();
        this.modelPath = modelPathString;
        this.detailFilters = Collections.emptyList();
        this.relationalFilters = new ArrayList<String>();
        this.filterParameters = Collections.emptyMap();
        this.designMode = isDesignMode;
        this.securityContext = secContext;
        this.memberStoreTS = memberStorageTS;
        this.locale = lLocale;
        this.modelModificationTime = lastModTime;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CubeContextKey)) {
            return false;
        }
        CubeContextKey other = (CubeContextKey)o;
        HashSet<String> set = new HashSet<String>(other.keyMap.keySet());
        set.retainAll(this.keyMap.keySet());
        for (String string : set) {
            String thisValue;
            String otherValue = other.keyMap.get(string);
            if (otherValue.equals(thisValue = this.keyMap.get(string))) continue;
            return false;
        }
        if (!other.modelPath.equals(this.modelPath)) {
            return false;
        }
        if (!other.memberStoreTS.equals(this.memberStoreTS)) {
            return false;
        }
        if (!other.locale.equals(this.locale)) {
            return false;
        }
        if (other.securityContext == null) {
            if (this.securityContext != null) {
                return false;
            }
        } else {
            if (this.securityContext == null) {
                return false;
            }
            if (!other.securityContext.equals(this.securityContext)) {
                return false;
            }
        }
        if (other.relationalFilters.size() != this.relationalFilters.size()) {
            return false;
        }
        ArrayList<String> myRelationalFilters = new ArrayList<String>(this.relationalFilters);
        for (String otherFilter : other.relationalFilters) {
            if (myRelationalFilters.contains(otherFilter)) continue;
            return false;
        }
        if (other.detailFilters.size() != this.detailFilters.size()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.detailFilters);
        for (String otherFilter : other.detailFilters) {
            if (arrayList.contains(otherFilter)) continue;
            return false;
        }
        if (other.filterParameters.size() != this.filterParameters.size()) {
            return false;
        }
        if (!other.filterParameters.equals(this.filterParameters)) {
            return false;
        }
        return other.designMode == this.designMode;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.modelPath.hashCode();
        hash = hash * 31 + this.memberStoreTS.hashCode();
        hash = hash * 31 + this.locale.hashCode();
        for (String string : this.relationalFilters) {
            hash = hash * 31 + string.hashCode();
        }
        for (String string : this.detailFilters) {
            hash = hash * 31 + string.hashCode();
        }
        for (Map.Entry entry : this.filterParameters.entrySet()) {
            hash = hash * 31 + entry.hashCode();
        }
        if (this.securityContext != null) {
            hash = hash * 31 + this.securityContext.hashCode();
        }
        return hash;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getLocaleStr() {
        return this.locale;
    }

    public String toString() {
        String separator = ".";
        StringBuilder sb = new StringBuilder();
        for (String string : this.relationalFilters) {
            sb.append(string.hashCode());
            sb.append(separator);
        }
        for (String string : this.detailFilters) {
            sb.append(string.hashCode());
            sb.append(separator);
        }
        for (Map.Entry entry : this.filterParameters.entrySet()) {
            sb.append(entry.hashCode());
            sb.append(separator);
        }
        if (this.locale != null) {
            sb.append(this.locale);
            sb.append(separator);
        }
        if (this.securityContext != null) {
            sb.append(this.securityContext);
        }
        sb.append(separator);
        sb.append(this.designMode);
        for (Map.Entry entry : this.keyMap.entrySet()) {
            sb.append((String)entry.getKey() + ":" + (String)entry.getValue());
            sb.append(separator);
        }
        return sb.toString();
    }

    public long getModelModificationTime() {
        return this.modelModificationTime;
    }
}

