/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MemberProxy
implements IMemberCubics {
    private ICacheKey memberKey = null;
    private ILevel memberLevel = null;
    protected IMember parentMember = null;
    protected IOrderedMap<IMember> childrenOrderedMap = null;
    private String memberName = null;
    protected String memberUniqueName = null;
    protected int indexInParentsChildrenList = -1;
    protected volatile int hashCode = -1;
    protected boolean isCached = true;
    protected static final int NUMBER_61 = 61;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public MemberProxy(ICacheKey memKey, String memName, ILevel memLevel) {
        this.memberKey = memKey;
        this.memberName = memName;
        this.memberLevel = memLevel;
    }

    public MemberProxy(String memName, ILevel memLevel) {
        this.memberKey = null;
        this.memberName = memName;
        this.memberLevel = memLevel;
    }

    public MemberProxy(String memName, String memUniqueName, ILevel memLevel) {
        this.memberKey = null;
        this.memberName = memName;
        this.memberUniqueName = memUniqueName;
        this.memberLevel = memLevel;
    }

    @Override
    public void setParentMember(IMember parent) {
        this.parentMember = parent;
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    @Deprecated
    public Object getBusinessKey() {
        return this.getName();
    }

    @Override
    public Value getBusinessKeyValue() {
        StringValue key = DataValueFactory.createStringValue();
        key.set(this.getName());
        return key;
    }

    @Override
    public String getCaption() {
        return (String)this.retrievePropValueFromCache("MEMBER_CAPTION");
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public Value getDescriptionValue() {
        return this.getCaptionValue();
    }

    @Override
    public int getChildIndex(IMember child) {
        return this.getChildIndex(child, false);
    }

    public int getChildIndex(IMember child, boolean includeFillerMembers) {
        List<IMember> children = this.getChildren(includeFillerMembers);
        if (children.size() > 0) {
            return children.indexOf(child);
        }
        return -1;
    }

    @Override
    public IMember[] getChildMembers() {
        return this.getChildren().toArray(new IMember[0]);
    }

    @Override
    public IMember[] getChildMembers(boolean includeFillerMembers) {
        IMember[] result;
        if (includeFillerMembers) {
            result = (IMember[])this.getChildrenOrderedMap().toArray(new IMember[0]);
        } else {
            List<IMember> childs = MemberOperations.getChildrenOp(this, false);
            result = childs.toArray(new IMember[0]);
        }
        return result;
    }

    @Override
    public IMember getChildMember(String memName) {
        return MemberOperations.getChildMemberOp(this, memName);
    }

    @Override
    public List<IMember> getChildren() {
        return MemberOperations.getChildrenOp(this, false);
    }

    public List<IMember> getChildren(int startIndex, int count) {
        return this.getChildren().subList(startIndex, startIndex + count);
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers) {
        return MemberOperations.getChildrenOp(this, includeFillerMembers);
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers, int maxLevelIndex) {
        return this.getChildren(includeFillerMembers);
    }

    @Override
    public int getChildrenCardinality() {
        return this.getChildren().size();
    }

    @Override
    public boolean hasGotAllChildren() {
        return this.childrenOrderedMap != null;
    }

    @Override
    public void setGotAllChildren() {
        this.initChildrenOrderedMap();
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap() {
        if (this.isPopulateChildrenRequired()) {
            this.populateChildren();
        }
        return this.childrenOrderedMap;
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap(int maxLevelIndex) {
        return this.getChildrenOrderedMap();
    }

    protected IOrderedMap<IMember> createOrderedMap() {
        return new OrderedMap<IMember>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChildrenOrderedMap() {
        if (this.childrenOrderedMap != null) {
            return;
        }
        MemberProxy memberProxy = this;
        synchronized (memberProxy) {
            if (this.childrenOrderedMap == null) {
                this.childrenOrderedMap = this.createOrderedMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateChildren() {
        IOrderedMap<IMember> childrenMembers = this.fetchChildren();
        MemberProxy memberProxy = this;
        synchronized (memberProxy) {
            if (!this.hasGotAllChildren()) {
                this.setChildren(childrenMembers);
            }
        }
    }

    @Override
    public IMember searchChildrenOrderedMap(String childrenKey) {
        if (this.childrenOrderedMap == null) {
            return null;
        }
        return this.childrenOrderedMap.get(childrenKey);
    }

    @Override
    public int getChildrenOrderedMapSize() {
        if (this.childrenOrderedMap == null) {
            return 0;
        }
        return this.childrenOrderedMap.size();
    }

    @Override
    public void addMemberToChildrenOrderedMap(IMember childMember) {
        this.initChildrenOrderedMap();
        this.childrenOrderedMap.put(childMember);
    }

    @Override
    public void removeMember(IMember childMember) {
        this.initChildrenOrderedMap();
        this.childrenOrderedMap.remove(childMember);
    }

    @Override
    public boolean isPopulateChildrenRequired() {
        return !this.hasGotAllChildren();
    }

    public synchronized void setChildren(IOrderedMap<IMember> children) {
        this.childrenOrderedMap = children;
    }

    protected IOrderedMap<IMember> fetchChildren() {
        return null;
    }

    @Override
    public IOrderedMap<IMember> getDescendantsOrderedMap(int depth, int descRangeFlag) {
        return null;
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    @Override
    public IDimension getDimension() {
        return this.memberLevel.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.memberLevel.getHierarchy();
    }

    @Override
    public ILevel getLevel() {
        return this.memberLevel;
    }

    @Override
    public int getNumberOfParents() {
        if (this.parentMember == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public IMember getParent() {
        return MemberOperations.getParentOp(this.parentMember, false);
    }

    @Override
    public IMember getParent(boolean includeFillerMembers) {
        return MemberOperations.getParentOp(this.parentMember, includeFillerMembers);
    }

    @Override
    public String getParentObjectUniqueName() {
        if (this.parentMember != null && this.getParent() != null) {
            return this.getParent().getUniqueName();
        }
        return null;
    }

    @Override
    public String getParentUniqueName() {
        if (this.parentMember != null) {
            return this.getParent().getUniqueName();
        }
        return null;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return AggregateTypeEnum.UNKNOWN;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        return null;
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        return AggregateTypeEnum.UNKNOWN;
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MemberTypeEnum getType() {
        return (MemberTypeEnum)((Object)this.retrievePropValueFromCache("MEMBER_TYPE"));
    }

    @Override
    public String getUniqueName() {
        if (this.memberUniqueName == null) {
            this.memberUniqueName = (String)this.retrievePropValueFromCache("MEMBER_UNIQUE_NAME");
        }
        return this.memberUniqueName;
    }

    @Override
    public String getMUNPropValue() {
        return this.getUniqueName();
    }

    @Override
    public boolean isCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    public boolean isContextMember() {
        return false;
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean isSuppressed() {
        return false;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return null;
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getScreenTip() {
        return null;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public IMetadata getParentObject() {
        return this.getParent();
    }

    @Override
    public String getUniqueID() {
        return null;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return false;
    }

    public void setConnection(MetadataConnection conn) {
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 instanceof IMember) {
            return this.getUniqueName().compareTo(((IMember)arg0).getUniqueName());
        }
        if (this.getDataType().isTextType() && arg0 instanceof TextValue) {
            return this.getName().compareTo(arg0.toString());
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.memberName;
    }

    public void setName(String name) {
        this.memberName = name;
    }

    @Override
    public void copyFrom(IValue value) {
    }

    @Override
    public int fastHash() {
        return 0;
    }

    @Override
    public Object hashKey() {
        IntegerValue intVal = DataValueFactory.createIntegerValue();
        intVal.set(this.getCacheKey().hashCode());
        return intVal;
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void setNull() {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public int sizeOf() {
        return 0;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Member", -1);
        xmlWriter.attribute("Hierarchy", this.getLevel().getHierarchy().getUniqueName());
        xmlWriter.beginElement("UName", -1);
        xmlWriter.data(this.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("Caption", -1);
        xmlWriter.data(this.getCaption());
        xmlWriter.endElement();
        xmlWriter.beginElement("LName", -1);
        xmlWriter.data(this.getLevel().getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("LNum", -1);
        xmlWriter.data(String.valueOf(this.getLevel().getIndex()));
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    @Override
    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return null;
    }

    @Override
    public Set<String> getAvailableProperties() {
        return Collections.emptySet();
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) throws MetadataException {
        return MemberOperations.getSiblingsOp(this, includeSelf);
    }

    @Override
    public int getParentLevelNumber() {
        int parentLevelNumber = 0;
        if (this.parentMember != null) {
            parentLevelNumber = this.getParent().getLevel().getIndex();
        }
        return parentLevelNumber;
    }

    @Override
    public String getV5UniqueName() {
        return this.getUniqueName();
    }

    @Override
    public String getID() {
        return this.getUniqueName();
    }

    @Override
    public IMember getPreviousMember() throws MetadataException {
        return MemberOperations.getPreviousMemberOp(this, false);
    }

    @Override
    public IMember getPreviousMember(boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getPreviousMemberOp(this, includeFillerMembers);
    }

    @Override
    public IMember getNextMember() throws MetadataException {
        return MemberOperations.getNextMemberOp(this, false);
    }

    @Override
    public IMember getNextMember(boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getNextMemberOp(this, includeFillerMembers);
    }

    @Override
    public IMember createChild(String childName) throws MetadataException {
        return null;
    }

    @Override
    public int getIndex() {
        if (this.memberKey instanceof MetadataCacheKey) {
            return ((MetadataCacheKey)this.memberKey).getMetadataChildId();
        }
        return 0;
    }

    @Override
    public long getMemberId() {
        if (this.memberKey instanceof MetadataCacheKey) {
            return ((MetadataCacheKey)this.memberKey).getMetadataChildId();
        }
        return 0L;
    }

    public ICacheKey getCacheKey() {
        return this.memberKey;
    }

    public void setCacheKey(ICacheKey key) {
        if (null == this.memberKey) {
            this.memberKey = key;
        }
    }

    @Override
    public void setMemberId(long i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getDescendantsIds(ILevel l) throws MetadataException {
        return MemberOperations.getDescendantsIdsOp(this, l);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l) throws MetadataException {
        return MemberOperations.getDescendantsOp(this, l, false);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp(this, l, includeFillerMembers);
    }

    @Override
    public ArrayList<IMember> getDescendants(int distance, int descRangeflagEnum) throws MetadataException {
        ArrayList<IMember> results = new ArrayList<IMember>();
        if (descRangeflagEnum == -1) {
            descRangeflagEnum = 0;
        }
        MemberOperations.getDescendantsOp(this, distance, descRangeflagEnum, false, results, null);
        return results;
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, int descRangeflagEnum) throws MetadataException {
        return MemberOperations.getDescendantsOp((IMemberCubics)this, l, descRangeflagEnum, true);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, int descRangeflagEnum, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp((IMemberCubics)this, l, descRangeflagEnum, includeFillerMembers);
    }

    @Override
    public ArrayList<IMember> getDescendants() throws MetadataException {
        ArrayList<IMember> result = new ArrayList<IMember>();
        MemberOperations.getDescendantsOp(this, 0, 4, false, result, null);
        return result;
    }

    @Override
    public IMember cousin(IMember ancestor) {
        return MemberOperations.cousin(this, ancestor);
    }

    @Override
    public int getIndexInParentsChildren() {
        if (this.indexInParentsChildrenList == -1) {
            try {
                if (this.parentMember == null) {
                    this.indexInParentsChildrenList = this.getIndex();
                } else if (((IMemberCubics)this.parentMember).isFillerMember()) {
                    IMember realParent = this.parentMember;
                    while (((IMemberCubics)realParent).isFillerMember()) {
                        realParent = this.parentMember.getParent();
                    }
                    this.indexInParentsChildrenList = ((MemberProxy)realParent).getChildIndex(this);
                } else {
                    this.indexInParentsChildrenList = ((MemberProxy)this.parentMember).getChildIndex(this, true);
                }
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        return this.indexInParentsChildrenList;
    }

    @Override
    public synchronized void resetIndexInParentsChildren() {
        this.indexInParentsChildrenList = -1;
    }

    @Override
    public void setIndexInParentsChildren(int index) {
        this.indexInParentsChildrenList = index;
    }

    @Override
    public int hierarchyCompare(IMember b, boolean postOrder) throws MetadataException {
        return MemberOperations.hierarchyCompare(this, b, postOrder);
    }

    @Override
    public int estimateChildCount() {
        return this.getChildrenOrderedMap().size();
    }

    @Override
    public ArrayList<IMember> getChildFillerMembers() {
        return null;
    }

    @Override
    public boolean isFillerMember() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public synchronized Object getProperty(String propName) {
        return MemberOperations.getPropertyOp(this, propName);
    }

    public String toString() {
        if (this.isDummyMember()) {
            return this.getDimension().getUniqueName() + ".[Dummy Member]";
        }
        return this.getUniqueName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MemberProxy && this.isDummyMember() && ((MemberProxy)other).isDummyMember()) {
            String uniqueName = ((MemberProxy)other).getDimension().getUniqueName();
            return this.getDimension().getUniqueName().equalsIgnoreCase(uniqueName);
        }
        if (other instanceof Member && this.isDummyMember() && ((Member)other).isDummyMember()) {
            String uniqueName = ((Member)other).getDimension().getUniqueName();
            return this.getDimension().getUniqueName().equalsIgnoreCase(uniqueName);
        }
        if (!(other instanceof MemberProxy)) {
            return false;
        }
        if (this.hashCode() != ((MemberProxy)other).hashCode()) {
            return false;
        }
        if (!this.isCached() || !((MemberProxy)other).isCached()) {
            return true;
        }
        if (this.parentMember != ((MemberProxy)other).parentMember) {
            return false;
        }
        return this.getUniqueName().equals(((IMember)other).getUniqueName());
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    private synchronized void calcHashCode() {
        if (this.hashCode == -1) {
            int tempHashCode = this.getIndex();
            tempHashCode *= 61;
            this.hashCode = tempHashCode += this.getHierarchy().getUniqueName().hashCode();
        }
    }

    protected synchronized Object retrievePropValueFromCache(String propName) {
        return null;
    }

    @Override
    public Object getMetadataProperty(String propName) {
        return this.retrievePropValueFromCache(propName);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildMembers(false).length == 0;
    }

    @Override
    public boolean isDummyMember() {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public String getV5MUN() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }

    public boolean isCached() {
        return this.isCached;
    }
}

