/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.mockprovider;

import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyCube;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyLevel;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyMember;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.OrderedMap;

public class NoddyDimension
extends Dimension {
    public NoddyDimension(String n, Cube c) {
        super(n, c);
        this.initialiseLevels();
    }

    private void initialiseLevels() {
        int idx = ((Cube)this.getCube()).getDimensionIndex(this);
        NoddyCube noddyCube = (NoddyCube)this.getCube();
        String[] levelNames = noddyCube.getMockMetadata().getLevelNames(noddyCube, idx);
        int levelCount = levelNames.length;
        for (int i = 0; i < levelCount; ++i) {
            new NoddyLevel(levelNames[i], this);
        }
    }

    protected OrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        OrderedMap<IMember> result = new OrderedMap<IMember>();
        ILevel firstLevel = this.getLevel(0);
        XQEDebugLog.out.println("Create Members for Level " + firstLevel.getName() + " in Dimension " + this.getName());
        int idx = ((Cube)this.getCube()).getDimensionIndex(this);
        NoddyCube noddyCube = (NoddyCube)this.getCube();
        String[] memberNames = noddyCube.getMockMetadata().getRootMemberNames(noddyCube, idx);
        for (int i = 0; i < memberNames.length; ++i) {
            result.put(new NoddyMember(memberNames[i], firstLevel));
        }
        return result;
    }

    @Override
    public boolean getMembersRollup() {
        return true;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isShareable() {
        return false;
    }
}

