/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.mockprovider;

import com.cognos.xqe.runtree.olap.mdx.mockprovider.IMockMetadata;
import com.cognos.xqe.runtree.olap.mdx.mockprovider.NoddyCube;

public class RandomMetadata
implements IMockMetadata {
    private static final int DIM_COUNT = 10;
    private static final int ROOT_MEM_COUNT = 4;
    private static final int LEVEL_LIMIT = 4;

    @Override
    public String getCubeName() {
        return "Noddy Cube";
    }

    @Override
    public int getDimensionCount() {
        return 10;
    }

    @Override
    public String getDimensionName(int dimIndex) {
        if (dimIndex == 0) {
            return "Measures";
        }
        return "Noddy Dim " + dimIndex;
    }

    @Override
    public String getDimensionPrefix(int dimIndex) {
        return "Noddy Member";
    }

    @Override
    public String[] getLevelNames(NoddyCube noddyCube, int dimIndex) {
        String[] levelNames = null;
        if (dimIndex == 0) {
            levelNames = new String[]{"MeasuresLevel"};
        } else {
            int levelCount = 1 + noddyCube.getNextRandom(1, 4);
            levelNames = new String[levelCount];
            for (int i = 0; i < levelCount; ++i) {
                levelNames[i] = noddyCube.getDimension(dimIndex).getName() + " Level " + i;
            }
        }
        return levelNames;
    }

    @Override
    public String[] getRootMemberNames(NoddyCube noddyCube, int dimIndex) {
        String[] rootMemberNames = null;
        if (dimIndex == 0) {
            rootMemberNames = new String[4];
            for (int i = 0; i < 4; ++i) {
                rootMemberNames[i] = "Measure " + i;
            }
        } else {
            rootMemberNames = new String[]{"All " + noddyCube.getDimension(dimIndex).getName()};
        }
        return rootMemberNames;
    }

    @Override
    public int getLevelCardinality(NoddyCube noddyCube, int dimIndex, int levelIndex) {
        int value = levelIndex + 1;
        if (levelIndex == 0) {
            return this.getRootMemberNames(noddyCube, dimIndex).length;
        }
        return (value * 2 ^ value) / 2;
    }
}

