/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.util.primitive.HashSetLong;
import java.util.Iterator;

public class FilterDuplicatesTupleValueIterator
implements Iterator<TupleValue> {
    private Iterator<TupleValue> tvIterator = null;
    private ISet ordinalSet = null;
    private HashSetLong seenOrdinals;
    private TupleValue nextTupleValue;
    private int numDups = 0;

    public FilterDuplicatesTupleValueIterator(Iterator<TupleValue> aTvIterator, ISet ordinalCalcSet, HashSetLong dupOrdinals) {
        this.tvIterator = aTvIterator;
        this.ordinalSet = ordinalCalcSet;
        this.seenOrdinals = dupOrdinals;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTupleValue == null) {
            this.nextTupleValue = this.findNextTupleValue();
        }
        return this.nextTupleValue != null;
    }

    @Override
    public TupleValue next() {
        TupleValue returnValue = null;
        if (this.hasNext()) {
            returnValue = this.nextTupleValue;
            this.nextTupleValue = null;
        }
        return returnValue;
    }

    private TupleValue findNextTupleValue() {
        TupleValue nextValue = null;
        while (this.tvIterator.hasNext() && nextValue == null) {
            TupleValue nextPossibleValue = this.tvIterator.next();
            long[] ordinals = this.ordinalSet.getOrdinals(nextPossibleValue.getTuple());
            boolean isDup = false;
            for (long ordinal : ordinals) {
                if (this.seenOrdinals.add(ordinal)) continue;
                isDup = true;
            }
            if (!isDup) {
                nextValue = nextPossibleValue;
                continue;
            }
            ++this.numDups;
        }
        return nextValue;
    }

    public int getNumDups() {
        return this.numDups;
    }

    @Override
    public void remove() {
        this.tvIterator.remove();
    }
}

