/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import java.util.Iterator;

public class HighSpeedHierarchyReorderTupleValueIterator
implements Iterator<TupleValue> {
    private Iterator<TupleValue> tvIterator = null;
    private IHierarchy[] hierOrder = null;
    private int[] memberIndex = null;
    private IMember[] tupleMembers = null;
    private Cell cell = null;
    private TupleValue tupleValue = null;

    public HighSpeedHierarchyReorderTupleValueIterator(Iterator<TupleValue> aTvIterator, IHierarchy[] aHierOrder) {
        this.tvIterator = aTvIterator;
        this.hierOrder = aHierOrder;
    }

    @Override
    public boolean hasNext() {
        return this.tvIterator.hasNext();
    }

    @Override
    public TupleValue next() {
        TupleValue origTupleValue = this.tvIterator.next();
        if (this.memberIndex == null) {
            this.memberIndex = this.buildIndexArray(origTupleValue);
            this.tupleMembers = new IMember[this.hierOrder.length];
            Tuple tuple = new Tuple(this.tupleMembers, false);
            this.cell = new Cell(origTupleValue.getCell().getObjectValue());
            this.tupleValue = new TupleValue(tuple, this.cell);
        }
        IMember[] origMembers = origTupleValue.getTuple().getMembers();
        for (int i = 0; i < this.tupleMembers.length; ++i) {
            this.tupleMembers[i] = origMembers[this.memberIndex[i]];
        }
        this.cell.setValue(origTupleValue.getCell().getValue());
        return this.tupleValue;
    }

    private int[] buildIndexArray(TupleValue origTupleValue) {
        int[] tupleMemberIndex = new int[this.hierOrder.length];
        IMember[] origMembers = origTupleValue.getTuple().getMembers();
        block0: for (int i = 0; i < this.hierOrder.length; ++i) {
            for (int j = 0; j < origMembers.length; ++j) {
                if (origMembers[j].getHierarchy() != this.hierOrder[i]) continue;
                tupleMemberIndex[i] = j;
                continue block0;
            }
        }
        return tupleMemberIndex;
    }

    @Override
    public void remove() {
        this.tvIterator.remove();
    }
}

