/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.List;

public class QueryExecutionTupleValueIterator
extends ROLAPQueryStrategy.TupleValueIterator {
    private final List<RSAPIResultSet> rsApiResultSetsToRelease;
    private final ROLAPQueryStrategy queryStrategy;
    private final SetSelections setToFetch;
    private RSAPIResultSet myRsApiResultSet = null;
    private boolean haveRunQuery = false;
    private boolean hasDoneClose = false;

    public QueryExecutionTupleValueIterator(HashMapObjectInt<String> hierToIndexMap, ROLAPQuery queryObj, IResultSet resultSet, ROLAPQueryExecuteMetrics metrics, boolean internallyManageNotifyStartAndEnd, List<RSAPIResultSet> theRsApiResultSetsToRelease, ROLAPQueryStrategy theQueryStrategy, SetSelections theSetToFetch) {
        super(hierToIndexMap, queryObj, resultSet, metrics, internallyManageNotifyStartAndEnd);
        this.setToFetch = theSetToFetch;
        this.rsApiResultSetsToRelease = theRsApiResultSetsToRelease;
        this.queryStrategy = theQueryStrategy;
    }

    @Override
    public boolean hasNext() {
        boolean hasNextResponse;
        if (!this.haveRunQuery) {
            this.haveRunQuery = true;
            this.runQuery();
        }
        if (!(hasNextResponse = super.hasNext()) && !this.hasDoneClose) {
            this.close();
            if (this.myRsApiResultSet != null) {
                this.myRsApiResultSet.release();
            }
            this.hasDoneClose = true;
        }
        return hasNextResponse;
    }

    @Override
    public TupleValue next() {
        if (!this.haveRunQuery) {
            this.haveRunQuery = true;
            this.runQuery();
        }
        return super.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery() {
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started executing to datasource");
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPQuery.Performance", "Requested set: " + this.setToFetch.getSet().toString());
            }
        }
        try {
            int origRsApiResultSetCount = this.rsApiResultSetsToRelease.size();
            ROLAPBaseCube cube = (ROLAPBaseCube)this.queryStrategy.getCube();
            V5ProviderQueryResult v5Result = this.queryStrategy.executeIndividualQuery(this.rsApiResultSetsToRelease, this.queryMetrics, cube, this.query);
            try {
                if (this.rsApiResultSetsToRelease.size() > origRsApiResultSetCount) {
                    this.myRsApiResultSet = this.rsApiResultSetsToRelease.get(this.rsApiResultSetsToRelease.size() - 1);
                }
                this.initializeForFetch(v5Result);
                if (!super.hasNext()) {
                    ROLAPQueryStrategy.logMsgNoResultForQuery(this.query, null);
                }
            }
            catch (RuntimeException ex) {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                throw ex;
            }
            catch (Throwable ex) {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
            }
        }
        finally {
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
                ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished delayed execution to datasource for single query.");
            }
        }
    }

    @Override
    protected boolean isQueryExecutePartOfFetch() {
        return true;
    }
}

