/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ROLAPCalculatedMember
extends CalculatedMember
implements IROLAPMember {
    private ROLAPMetaCalculatedMember metaCalculatedMember = null;
    private long ordinal = -1L;

    public ROLAPCalculatedMember(String name, ILevel level, Object calculationStr, String[] identifiers, ROLAPMetaCalculatedMember calcMem) throws MetadataException {
        super(name, level, calculationStr, identifiers);
        this.metaCalculatedMember = calcMem;
    }

    private ROLAPMetaCalculatedMember getMetaCalculatedMember() {
        return this.metaCalculatedMember;
    }

    @Override
    protected void parseCalculationString(String calculationObj) {
        this.setCalculationString(calculationObj);
    }

    public static FormatId getFormatId(String calcName, ILevel level) {
        if (level instanceof IROLAPLevel) {
            return ((IROLAPLevel)level).getCalculatedMeasureFormatId(calcName);
        }
        return null;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        if (this.getMetaCalculatedMember() != null) {
            captions = this.getMetaCalculatedMember().getCaptions();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    @Override
    public String getCaption() {
        String theCaption = null;
        if (this.getMetaCalculatedMember() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            theCaption = this.getMetaCalculatedMember().getCaption(locale);
            if (theCaption == null) {
                theCaption = this.getMetaCalculatedMember().getCaption(this.getMetaCalculatedMember().getDefaultLocale());
            }
        }
        if (theCaption != null) {
            return theCaption;
        }
        if (this.caption != null) {
            return this.caption;
        }
        return this.getName();
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return null;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        if (this.getMetaCalculatedMember() != null) {
            names = this.getMetaCalculatedMember().getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return UniqueNameGenerator.createMemberV5UniqueName(cubeName, this.getLevel(), this.getUniqueName());
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((IROLAPCube)((Object)this.getLevel().getDimension().getCube())).getCalculations(this));
    }

    @Override
    public int getROLAPChildrenCount() {
        return 0;
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getLevel().getDimension();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getLevel().getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public String getDefaultLocale() {
        return this.getROLAPDimension().getROLAPCube().getDefaultLocale();
    }

    @Override
    public int getROLAPOrdinal() {
        return (int)this.getOrdinal();
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    @Override
    public IROLAPMember getROLAPParent() {
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        ROLAPCalculatedMember member = this;
        try {
            ROLAPMemberOperations.getRelationsOf(member, 4, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        if (relationList.isEmpty()) {
            return null;
        }
        return (IROLAPMember)relationList.get(0);
    }

    @Override
    public int getROLAPParentCount() {
        if (this.getROLAPParent() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getROLAPType() {
        return 4;
    }

    @Override
    public void getRelationsOf(int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) throws Exception {
        ROLAPMemberOperations.getRelationsOf(this, treeOp, includeCalcMembers, relationList);
    }

    @Override
    public Pair[] getSourceMembers() {
        return null;
    }

    @Override
    public boolean isPaddingMember() {
        return false;
    }

    @Override
    public boolean isSecurityPaddingMember() {
        return false;
    }

    @Override
    public void setSecurityPaddingMember(boolean paddingMember) {
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPmember.getAllChildren not supported");
    }

    public boolean isRolapCalculatedMemberVisible(ROLAPCube rolapCube, IHierarchy hierarchy) {
        boolean isVisible = true;
        SecurityManagerInterface secManager = rolapCube.getSecurityManager();
        if (secManager != null) {
            IROLAPHierarchy rolapHier = (IROLAPHierarchy)rolapCube.getHierarchy(hierarchy.getName());
            IMember[] arrayInput = new IMember[]{this};
            IMember[] arrayOutput = secManager.applySecurity(arrayInput, rolapHier);
            if (arrayOutput.length <= 0) {
                isVisible = false;
            }
        }
        return isVisible;
    }
}

