/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCubeSoftReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.ConcurrentRefCountingSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapObjectBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ROLAPContext
implements IContextable {
    public static final String NL = System.getProperty("line.separator");
    private static final String NO_RESERVATION = "Expected to see reservation for cube %s in the context";
    private HashSet<ROLAPCube> mCubesUsedInQueryScopeReservations = new HashSet();
    private Set<ROLAPCube> mCubesUsedInContext = Collections.newSetFromMap(new ConcurrentHashMap());
    private HashMap<ROLAPCube, ROLAPCubeSoftReservation> mSoftReservations = new HashMap();
    private ConcurrentHashMap<ROLAPCube, ConcurrentRefCountingSet<ROLAPCubeReservation>> mQueryReservations = new ConcurrentHashMap();
    private int mQueryNestingCount = 0;
    private HashMap<String, WorkloadInfo> mWorkloadInfoMap = new HashMap();
    private HashMapObjectBoolean<String> cubeNameToIsLoggingQueriesMap = new HashMapObjectBoolean();
    private ArrayList<HashSet<String>> mDatasetIDs = new ArrayList();
    private boolean mROLAPUsed = false;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPCubes.Management");
    private long mReportExecutionStartTime = System.currentTimeMillis();
    private boolean mInternalUse = false;
    private boolean mROLAPRelQueryExecuting = false;
    private static final ThreadLocal<String> CUBECONTAINER = new ThreadLocal();

    public static boolean setCurrentCubeName(String cubeName) {
        if (ROLAPContext.getCurrentCubeName() == null) {
            CUBECONTAINER.set(cubeName);
            return true;
        }
        return false;
    }

    public static void removeCurrentCubeName(boolean needToRemoveCubeName) {
        if (needToRemoveCubeName) {
            CUBECONTAINER.remove();
        }
    }

    public static String getCurrentCubeName() {
        return CUBECONTAINER.get();
    }

    public static boolean setCurrentCubeName(IPlanningEnvironment environment) {
        if (ROLAPUtilities.isQueryROLAP(environment)) {
            return ROLAPContext.setCurrentCubeName(ROLAPContext.getCMDataSourceName(environment));
        }
        return false;
    }

    public static String getCMDataSourceName(IPlanningEnvironment environment) {
        IDataSource dataSource;
        if (!ROLAPUtilities.isQueryROLAP(environment)) {
            return null;
        }
        IModelDataSource maDataSource = environment.getMADataSource();
        if (maDataSource != null) {
            return maDataSource.getCMDataSourceName();
        }
        Object executionEnvironment = environment.getExecutionEnvironment();
        if (executionEnvironment != null && (dataSource = executionEnvironment.getDataSource()) != null) {
            return dataSource.getCMDataSourceName();
        }
        Object metadataConnection = environment.getMetadataConnection();
        if (metadataConnection != null && metadataConnection instanceof MetadataConnection) {
            List<IModelDataSource> modelDataSources = ((MetadataConnection)metadataConnection).getModelDataSources();
            String cubeName = environment.getCubeName();
            if (cubeName == null) {
                for (IModelDataSource datasource : modelDataSources) {
                    if (!datasource.isROLAP()) continue;
                    cubeName = datasource.getCube().getName();
                }
            }
            if (cubeName != null) {
                return cubeName;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Too many cubes to choose. Ambiguous cube choice");
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot determine which cube");
    }

    public ROLAPContext(MultiRequestContext mrc) {
    }

    public static boolean isRelQueryExecuting() {
        ROLAPContext ctx = ROLAPContext.get();
        if (ctx != null) {
            return ctx.mROLAPRelQueryExecuting;
        }
        return false;
    }

    public static void setRelQueryExecuting() {
        ROLAPContext ctx = ROLAPContext.get();
        if (ctx != null) {
            ctx.mROLAPRelQueryExecuting = true;
        }
    }

    public void setInternalUse() {
        this.mInternalUse = true;
    }

    public boolean isInternalUse() {
        return this.mInternalUse;
    }

    public void addReservation(ROLAPCubeReservation res, IExecutionEnvironment env) {
        ConcurrentRefCountingSet newResSet;
        ROLAPCube cube = res.getCube();
        ConcurrentRefCountingSet<ROLAPCubeReservation> resSet = this.mQueryReservations.putIfAbsent(cube, newResSet = new ConcurrentRefCountingSet());
        if (resSet == null) {
            resSet = newResSet;
        }
        if (resSet.isEmpty()) {
            ROLAPCubeSoftReservation softRes = this.mSoftReservations.get(cube);
            if (softRes == null) {
                softRes = new ROLAPCubeSoftReservation(res);
            } else {
                softRes.updateROLAPCubeSoftReservation(res);
            }
            this.mSoftReservations.put(cube, softRes);
        }
        cube.registerReservation(res, env);
        resSet.add(res);
        this.mCubesUsedInContext.add(cube);
    }

    public boolean removeReservation(ROLAPCubeReservation res) {
        ConcurrentHashMap<ROLAPCube, ConcurrentRefCountingSet<ROLAPCubeReservation>> cubeReservationsRef = this.mQueryReservations;
        if (cubeReservationsRef != null) {
            ConcurrentRefCountingSet<ROLAPCubeReservation> set = cubeReservationsRef.get(res.getCube());
            if (set == null || set.isEmpty()) {
                throw new IllegalStateException(String.format(NO_RESERVATION, res.getCube().getName()));
            }
            res.getCube().deregisterReservation(res);
            return set.remove(res);
        }
        return false;
    }

    public ROLAPCubeReservation getReservation(ROLAPCube cube) {
        if (this.mQueryReservations == null) {
            return null;
        }
        ConcurrentRefCountingSet<ROLAPCubeReservation> entry = this.mQueryReservations.get(cube);
        if (entry == null) {
            return null;
        }
        Set<ROLAPCubeReservation> resSet = entry.keySet();
        if (resSet == null || resSet.isEmpty()) {
            return null;
        }
        return resSet.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        for (ROLAPCubeSoftReservation res : this.mSoftReservations.values()) {
            res.release();
        }
        this.mSoftReservations.clear();
        Set<String> cubeNames = this.cubeNameToIsLoggingQueriesMap.keySet();
        for (String cubeName : cubeNames) {
            boolean isLoggingQueriesAgainstCube = this.cubeNameToIsLoggingQueriesMap.get(cubeName);
            if (!isLoggingQueriesAgainstCube) continue;
            try {
                WorkloadInfo workloadInfo = this.mWorkloadInfoMap.get(cubeName);
                if (workloadInfo == null) continue;
                workloadInfo.setExecutionTime(System.currentTimeMillis() - this.mReportExecutionStartTime);
                workloadInfo.save();
            }
            catch (Exception e) {
                ROLAPLog.logError("ROLAP.AggregateWorkload", "Error recording workload information", e);
            }
        }
        this.mWorkloadInfoMap.clear();
        this.cubeNameToIsLoggingQueriesMap.clear();
        ROLAPContext rOLAPContext = this;
        synchronized (rOLAPContext) {
            if (this.mQueryReservations != null) {
                block9: while (true) {
                    HashSet<ROLAPCubeReservation> reservationsToClear = new HashSet<ROLAPCubeReservation>();
                    for (ConcurrentRefCountingSet<ROLAPCubeReservation> resSet : this.mQueryReservations.values()) {
                        reservationsToClear.addAll(resSet.keySet());
                    }
                    if (reservationsToClear.isEmpty()) break;
                    for (ConcurrentRefCountingSet<ROLAPCubeReservation> resSet : this.mQueryReservations.values()) {
                        for (ROLAPCubeReservation reservation : resSet.keySet()) {
                            ROLAPCubeReservation[] sourceResList = reservation.getSourceReservations();
                            if (sourceResList == null) continue;
                            for (ROLAPCubeReservation sourceRes : sourceResList) {
                                reservationsToClear.remove(sourceRes);
                            }
                        }
                    }
                    Iterator<ConcurrentRefCountingSet<ROLAPCubeReservation>> iterator = reservationsToClear.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block9;
                        ROLAPCubeReservation reservation = (ROLAPCubeReservation)((Object)iterator.next());
                        String cubeName = null;
                        ROLAPCube cube = null;
                        try {
                            cube = reservation.getCube();
                            cubeName = cube.getName();
                            cube.unreserve(reservation);
                            if (!ROLAPLog.isOn("ROLAPCubes.Management")) continue;
                            ROLAPLog.log("ROLAPCubes.Management", String.format("ROLAPContext.release() is releasing a possibly leaked reservation for cube %s.", cubeName));
                        }
                        catch (Throwable th) {
                            if (!reservation.isInvalid()) {
                                ROLAPLog.logError("ROLAPCubes.Management", String.format("ROLAPContext.release() failed to unreserve cube %s.", cubeName), th);
                            }
                            if (cube == null || this.mQueryReservations.get(cube) == null) continue;
                            this.mQueryReservations.get(cube).clear();
                        }
                    }
                    break;
                }
                this.mQueryReservations = null;
            }
        }
    }

    @Override
    public boolean isSessionScope() {
        return false;
    }

    private void reportQueryNestingCount() {
        if (ROLAPLog.isOn("ROLAPCubes.Reservation", LogLevel.INFO)) {
            ROLAPLog.log("ROLAPCubes.Reservation", "Query nesting count: " + this.mQueryNestingCount);
        }
    }

    private synchronized void queryInit(ROLAPCube cube, IExecutionEnvironment executionEnvironment) {
        this.mROLAPUsed = true;
        if (!this.mCubesUsedInQueryScopeReservations.contains(cube)) {
            if (this.mQueryNestingCount > 0) {
                for (int i = 0; i < this.mQueryNestingCount; ++i) {
                    cube.reserve(executionEnvironment, null);
                }
            }
            this.mCubesUsedInQueryScopeReservations.add(cube);
        }
    }

    private synchronized void queryReserve() {
        ++this.mQueryNestingCount;
        this.reportQueryNestingCount();
        ArrayList<ROLAPCubeReservation> createdReservations = new ArrayList<ROLAPCubeReservation>();
        for (ROLAPCube cube : this.mCubesUsedInQueryScopeReservations) {
            ROLAPCubeReservation res;
            ROLAPCubeSoftReservation softRes = this.mSoftReservations.get(cube);
            if (this.mQueryReservations != null && (this.mQueryReservations.get(cube) == null || this.mQueryReservations.get(cube).isEmpty()) && softRes != null) {
                res = cube.reserve((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), softRes);
                createdReservations.add(res);
                if (softRes.matches(res)) continue;
                for (ROLAPCubeReservation reservation : createdReservations) {
                    reservation.getCube().unreserve(reservation);
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_CacheUpdatedDuringRequest, cube.getName());
            }
            res = cube.reserve((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), null);
            createdReservations.add(res);
        }
    }

    private synchronized void queryUnreserve() {
        if (this.mQueryNestingCount == 0) {
            throw new IllegalStateException("Unmatched transaction unreserve");
        }
        --this.mQueryNestingCount;
        this.reportQueryNestingCount();
        for (ROLAPCube cube : this.mCubesUsedInQueryScopeReservations) {
            ROLAPCubeReservation res = this.getReservation(cube);
            if (res == null) {
                INFO_LOGGER.log(LogLevel.ERROR, (Throwable)new IllegalStateException("Unexpected nonexistent reservation for cube " + cube.getName()));
                continue;
            }
            cube.unreserve(res, this);
        }
    }

    public static void queryEnter(IExecutionEnvironment execEnv, ROLAPCube cube) {
        ROLAPContext context = ROLAPContext.get(execEnv);
        if (context == null) {
            return;
        }
        if (cube != null) {
            context.queryInit(cube, execEnv);
        }
        context.queryReserve();
    }

    public static void queryEnter(IExecutionEnvironment execEnv) {
        ROLAPContext.queryEnter(execEnv, null);
    }

    public static void queryExit(IExecutionEnvironment execEnv) {
        ROLAPContext context = ROLAPContext.get(execEnv);
        if (context == null) {
            return;
        }
        context.queryUnreserve();
    }

    public static void queryInit(String cubeName, ExecutionEnvironment execEnv) {
        ROLAPContext context = ROLAPContext.get(execEnv);
        if (context == null) {
            return;
        }
        context.queryInit(ROLAPCubeManager.getInstance().getCube(cubeName), execEnv);
    }

    public static ROLAPContext get(IExecutionEnvironment execEnv) {
        if (execEnv == null) {
            return null;
        }
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContextNoThrow();
        if (multiRequestContext == null) {
            return null;
        }
        return multiRequestContext.getRolapContext();
    }

    public static ROLAPContext get() {
        return ROLAPContext.get((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
    }

    public boolean isLoggingQueriesAgainstCube(WorkloadLogger workloadLogger) {
        String cubeName = workloadLogger.getCubeName();
        if (!this.cubeNameToIsLoggingQueriesMap.containsKey(cubeName)) {
            boolean isLoggingQueries = workloadLogger.isLoggingInitialized() && workloadLogger.isLoggingEnabledForCube();
            this.cubeNameToIsLoggingQueriesMap.put(cubeName, isLoggingQueries);
        }
        return this.cubeNameToIsLoggingQueriesMap.get(cubeName);
    }

    public WorkloadInfo getWorkloadInfo(WorkloadLogger workloadLogger, RequestEnvironment reqEnv) {
        WorkloadInfo workloadInfo = null;
        if (null != this.mWorkloadInfoMap && null != workloadLogger && this.isLoggingQueriesAgainstCube(workloadLogger)) {
            String cubeName = workloadLogger.getCubeName();
            if (this.mWorkloadInfoMap.containsKey(cubeName)) {
                workloadInfo = this.mWorkloadInfoMap.get(cubeName);
            } else {
                workloadInfo = new WorkloadInfo(workloadLogger, reqEnv);
                this.mWorkloadInfoMap.put(cubeName, workloadInfo);
            }
        }
        return workloadInfo;
    }

    public static void startFirstPage() {
        ROLAPContext context = ROLAPContext.get();
        if (context != null) {
            context.queryReserve();
        }
    }

    public static void updateFirstPage(boolean error, IXQEQueryNode[] datasets) {
        ROLAPContext context = ROLAPContext.get();
        if (context != null) {
            context.updateFirstPageImpl(error, datasets);
        }
    }

    private void updateFirstPageImpl(boolean error, IXQEQueryNode[] datasets) {
        if (error || !this.mROLAPUsed || datasets == null || datasets.length == 0) {
            this.queryUnreserve();
        } else {
            HashSet<String> datasetIDs = new HashSet<String>();
            this.mDatasetIDs.add(datasetIDs);
            for (IXQEQueryNode dataset : datasets) {
                datasetIDs.add(((RSAPIDataset)dataset).getUniqueID());
            }
        }
    }

    public static void endFirstPage(String datasetID) {
        ROLAPContext context = ROLAPContext.get();
        if (context != null) {
            context.endFirstPageImpl(datasetID);
        }
    }

    private void endFirstPageImpl(String datasetID) {
        if (!this.mROLAPUsed) {
            return;
        }
        for (HashSet<String> datasetIDs : this.mDatasetIDs) {
            if (!datasetIDs.contains(datasetID)) continue;
            datasetIDs.remove(datasetID);
            if (!datasetIDs.isEmpty()) break;
            this.mDatasetIDs.remove(datasetIDs);
            this.queryUnreserve();
            break;
        }
    }

    public Set<ROLAPCube> getCubesUsedInContext() {
        return this.mCubesUsedInContext;
    }

    public Set<ROLAPCube> getCubesUsedInQuery() {
        return this.mCubesUsedInQueryScopeReservations;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ROLAPContext:");
        str.append(NL);
        ConcurrentHashMap<ROLAPCube, ConcurrentRefCountingSet<ROLAPCubeReservation>> cubeReservationsRef = this.mQueryReservations;
        if (cubeReservationsRef != null) {
            for (ROLAPCube cube : cubeReservationsRef.keySet()) {
                str.append(" ").append(cube.getName()).append(":").append(cubeReservationsRef.get(cube).size()).append(NL);
            }
        }
        return str.toString();
    }

    public void reserveMissingLeaves(ROLAPCube cube, ArrayList<ROLAPCubeReservation> resList) {
        if (cube.isVirtual()) {
            ROLAPCube[] sourceCubes;
            for (ROLAPCube source : sourceCubes = ((ROLAPVirtualCube)cube).getSourceCubes()) {
                this.reserveMissingLeaves(source, resList);
            }
        } else if (this.getReservation(cube) == null) {
            resList.add(cube.reserve());
        }
    }

    public void unreserveMissingLeaves(ArrayList<ROLAPCubeReservation> resList) {
        for (ROLAPCubeReservation res : resList) {
            res.getCube().unreserve(res);
        }
    }
}

