/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAggregateStrategyDelegator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategyDelegator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import java.io.File;

public class ROLAPProvider
extends Provider {
    public static final String PROP_DATA_CACHE_ROOT_DIR = "DataCacheRootDir";
    public static final String DEFAULT_DATA_CACHE_ROOT_DIR = "cache";
    private static boolean disableResultSetCacheForAllCubes = false;
    private String dataCacheRootDirectory;
    private String tempPath = null;

    public ROLAPProvider() {
        this.initializeEnv();
    }

    @Override
    public void connect() throws ProviderException {
    }

    @Override
    public String[] getCatalogs() throws ProviderException {
        return null;
    }

    @Override
    public String[] getCubeNames(String profileName) throws ProviderException {
        return null;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        return new ROLAPQueryStrategyDelegator();
    }

    @Override
    public QueryStrategy getQueryStrategy(ICube cube) {
        return ((ROLAPCube)cube).getQueryStrategy();
    }

    @Override
    public boolean isResultSetCacheEnabled(ICube cube) {
        ROLAPCube rolapCube = (ROLAPCube)cube;
        return !rolapCube.getConfigIsDisableResultSetCache() && !disableResultSetCacheForAllCubes;
    }

    public static void setDisableResultSetCacheForAllCubes(boolean disable) {
        disableResultSetCacheForAllCubes = disable;
    }

    @Override
    public ICubeResultSetCache getResultSetCache(ICube cube) {
        ROLAPCube rolapCube = (ROLAPCube)cube;
        return rolapCube.getResultSetCache();
    }

    @Override
    public boolean isResultSetCacheable(MDXQuery mdxQuery, XDataContext dataContext, ICubeResultSet executedResultSet, long elapsedQueryTime) {
        ROLAPCubeManager cubeMan = ROLAPCubeManager.getInstance();
        ROLAPConfiguration cfg = cubeMan.getConfig();
        return (long)cfg.getResultSetCacheQueryTimeThreshold() <= elapsedQueryTime;
    }

    @Override
    public Cube retrieveCube(String profileName, String cubeName) throws ProviderException {
        return null;
    }

    public String getDataCacheRootDirectory() {
        return this.dataCacheRootDirectory;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    @Override
    public Cube getCube(String cubeName) {
        ROLAPCubeManager cubeMgr = ROLAPCubeManager.getInstance();
        ROLAPCube cube = cubeMgr.getCube(cubeName);
        return cube;
    }

    private void initializeEnv() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String tempDir = config.getXqeTempDirectory();
        if (!tempDir.endsWith(File.separator)) {
            tempDir = tempDir + File.separator;
        }
        this.dataCacheRootDirectory = System.getProperty(PROP_DATA_CACHE_ROOT_DIR);
        if (this.dataCacheRootDirectory == null) {
            this.dataCacheRootDirectory = tempDir + File.separator + DEFAULT_DATA_CACHE_ROOT_DIR;
        }
        if (!this.dataCacheRootDirectory.endsWith(File.separator)) {
            this.dataCacheRootDirectory = this.dataCacheRootDirectory + File.separator;
        }
        String tmpPath = tempDir;
        tmpPath = tmpPath + "XQE" + File.separator;
        String tmp = "temp";
        this.tempPath = tmpPath = tmpPath + tmp + File.separator + "xqe" + File.separator + tmp + File.separator;
    }

    @Override
    public IExternalAggregateStrategy getExternalAggregateStrategy() {
        return new ROLAPAggregateStrategyDelegator();
    }
}

