/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XQueryStrategy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ROLAPQueryExecuteMetrics {
    private int prevCellCount = 0;
    private int dataCacheHits = 0;
    private int aggrCacheHits = 0;
    private int aggrCubeHits = 0;
    private BigInteger dataCacheRequestSetSize = BigInteger.ZERO;
    private BigInteger dataCacheReturnSetSize = BigInteger.ZERO;
    private BigInteger aggregateCacheRequestSetSize = BigInteger.ZERO;
    private BigInteger aggregateCacheReturnSetSize = BigInteger.ZERO;
    private long dataCacheTotalTime = 0L;
    private final List<SQLQueryMetrics> sqlQueryMetrics = new ArrayList<SQLQueryMetrics>();
    private int fetchCount = 0;
    private int pushdownHits = 0;
    private int resultSetCacheHits = 0;
    private long virutalCubeSourceCubeOperationDuration = 0L;
    private long totalInMemoryAggregateTime = 0L;
    private AggregateCalculationMetrics aggregateCalcMetrics = null;
    private XQueryStrategy qsProfileNode;

    public ROLAPQueryExecuteMetrics(int aPrevCellCount) {
        this.prevCellCount = aPrevCellCount;
    }

    public void setProfileNode(XQueryStrategy profileNode) {
        this.qsProfileNode = profileNode;
    }

    public int notifyCellCount(int newCellCount, PopulationSource source) {
        return this.notifyCellCount(newCellCount, source, false);
    }

    public int notifyCellCount(int newCellCount, PopulationSource source, boolean pushdownMode) {
        int newHits = newCellCount - this.prevCellCount;
        switch (source) {
            case AGGREGATE_CACHE: {
                this.aggrCacheHits += newHits;
                break;
            }
            case AGGREGATE_CUBE: {
                this.aggrCubeHits += newHits;
                break;
            }
            case BASE_CUBE: {
                this.fetchCount += newHits;
                break;
            }
            case DATA_CACHE: {
                this.dataCacheHits += newHits;
                break;
            }
        }
        if (pushdownMode) {
            this.pushdownHits += newHits;
        }
        this.prevCellCount = newCellCount;
        return newHits;
    }

    public final int getPrevCellCount() {
        return this.prevCellCount;
    }

    public final int getAggrCubeHits() {
        return this.aggrCubeHits;
    }

    public final int getFetchCount() {
        return this.fetchCount;
    }

    public final int getPushdownHits() {
        return this.pushdownHits;
    }

    public final long getDataQueryTime() {
        long totalTime = 0L;
        for (SQLQueryMetrics sqlMetric : this.sqlQueryMetrics) {
            totalTime = totalTime + sqlMetric.getSqlExectuteTime() + sqlMetric.getSqlFetchTime();
        }
        return totalTime;
    }

    public final long getDataQueryTimeAsNano() {
        return TimeUnit.NANOSECONDS.convert(this.getDataQueryTime(), TimeUnit.MILLISECONDS);
    }

    public final int getAggrCacheHits() {
        return this.aggrCacheHits;
    }

    public final int getDataCacheHits() {
        return this.dataCacheHits;
    }

    public final int getResultSetCacheHits() {
        return this.resultSetCacheHits;
    }

    public void incrementResultSetCacheHits(int inRSCHits) {
        this.resultSetCacheHits += inRSCHits;
    }

    public final void notifyOperationStart(XQueryStrategy.Operation op) {
        if (this.qsProfileNode != null) {
            this.qsProfileNode.notifyOperationStart(op);
        }
    }

    public final void notifyOperationEnd(XQueryStrategy.Operation op, int newCellCount, boolean pushdownMode) {
        PopulationSource source = this.opToPopulationSource(op);
        int delta = this.notifyCellCount(newCellCount, source, pushdownMode);
        if (this.qsProfileNode != null) {
            this.qsProfileNode.notifyOperationEnd(op, delta);
        }
    }

    public final void notifyOperationEnd(XQueryStrategy.Operation op, int newCellCount) {
        PopulationSource source = this.opToPopulationSource(op);
        int delta = this.notifyCellCount(newCellCount, source);
        if (this.qsProfileNode != null) {
            this.qsProfileNode.notifyOperationEnd(op, delta);
        }
    }

    private PopulationSource opToPopulationSource(XQueryStrategy.Operation op) {
        PopulationSource source = null;
        switch (op) {
            case DATA_CACHE_RETRIEVAL: {
                source = PopulationSource.DATA_CACHE;
                break;
            }
            case AGGREGATE_CACHE_RETRIEVAL: {
                source = PopulationSource.AGGREGATE_CACHE;
                break;
            }
            case AGGREGATE_CUBE_RETRIEVAL: {
                source = PopulationSource.AGGREGATE_CUBE;
                break;
            }
            case CUBE_RETRIEVAL: {
                source = PopulationSource.BASE_CUBE;
                break;
            }
        }
        return source;
    }

    public final long getTotalInMemoryAggregateTime() {
        return this.totalInMemoryAggregateTime;
    }

    public final void setInMemoryAggregateMetrics(long aTotalInMemoryAggregateTime, BigInteger requestSetSize, boolean solvedEntireSet) {
        this.totalInMemoryAggregateTime = aTotalInMemoryAggregateTime;
        this.aggregateCacheRequestSetSize = requestSetSize;
        if (!solvedEntireSet) {
            this.aggregateCacheReturnSetSize = requestSetSize;
        }
    }

    public final AggregateCalculationMetrics getAggregateCalculationMetrics() {
        return this.aggregateCalcMetrics;
    }

    public final void setAggregateCalculationMetrics(AggregateCalculationMetrics metrics) {
        this.aggregateCalcMetrics = metrics;
    }

    public final long getAggregateSubQueryTime() {
        if (this.aggregateCalcMetrics != null) {
            return this.aggregateCalcMetrics.getAggregateFetchTime();
        }
        return 0L;
    }

    public final long getAggregateRollupTime() {
        if (this.aggregateCalcMetrics != null) {
            return this.aggregateCalcMetrics.getAggregateRollupTime();
        }
        return 0L;
    }

    public final long getAggregateQueryCellCount() {
        if (this.aggregateCalcMetrics != null) {
            return this.aggregateCalcMetrics.getCellsInAggregateQuery();
        }
        return 0L;
    }

    public final int getAggregateQueryCellRollupLocations() {
        if (this.aggregateCalcMetrics != null) {
            return this.aggregateCalcMetrics.getCellRollupLocations();
        }
        return 0;
    }

    public final int getNumAggregateQueryTasks() {
        if (this.aggregateCalcMetrics != null) {
            return this.aggregateCalcMetrics.getNumberOfMetrics() - 1;
        }
        return 0;
    }

    public BigInteger getDataCacheRequestSetSize() {
        return this.dataCacheRequestSetSize;
    }

    public void setDataCacheMetrics(BigInteger requestSetSize, BigInteger returnSetSize, long requestTime) {
        this.dataCacheRequestSetSize = requestSetSize;
        this.dataCacheReturnSetSize = returnSetSize;
        this.dataCacheTotalTime = requestTime;
    }

    public boolean hadDataCacheRequest() {
        return this.dataCacheHits != 0 || this.dataCacheRequestSetSize != BigInteger.ZERO;
    }

    public boolean hadAggregateCacheRequest() {
        return this.aggrCacheHits != 0 || this.aggregateCacheRequestSetSize != BigInteger.ZERO;
    }

    public BigInteger getDataCacheReturnSetSize() {
        return this.dataCacheReturnSetSize;
    }

    public BigInteger getAggregateCacheRequestSetSize() {
        return this.aggregateCacheRequestSetSize;
    }

    public BigInteger getAggregateCacheReturnSetSize() {
        return this.aggregateCacheReturnSetSize;
    }

    public long getDataCacheTotalTime() {
        return this.dataCacheTotalTime;
    }

    public List<SQLQueryMetrics> getSqlQueryMetrics() {
        return this.sqlQueryMetrics;
    }

    public long getVirutalCubeSourceCubeOperationDuration() {
        return this.virutalCubeSourceCubeOperationDuration;
    }

    public void incrementVirutalCubeSourceCubeOperationDuration(long duration) {
        this.virutalCubeSourceCubeOperationDuration = duration;
    }

    public static enum PopulationSource {
        DATA_CACHE,
        AGGREGATE_CACHE,
        AGGREGATE_CUBE,
        BASE_CUBE;

    }
}

