/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EventManagementService_PortType;
import com.cognos.developer.schemas.bibus._3.EventManagementService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.MonitorOptionGUID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.CMException;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMUser;
import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEAxisFaultException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.data.cache.DiskBackedCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICachedCubeResultSet;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheVisitor;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IncrementAwareDiskBackedResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MetadataResolver;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPNamespace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPAccessAccountManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCacheUpdater;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMBean;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMessages;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateMachine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryDetailedInfoLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.IROLAPCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCubeSoftReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPResultSetCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSharedDimensionCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaFacts;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewCombinationRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQueryCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.ConcurrentRefCountingMap;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementMetrics;
import com.cognos.xqe.runtree.olap.mdx.util.ConnectionPropertyUtilities;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.concurrent.locks.CannotAcquireLockInExclusiveModeException;
import com.cognos.xqe.util.concurrent.locks.LockManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.cubingservices.DQServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Element;

public abstract class ROLAPCube
extends Cube
implements IReleasable,
ROLAPCubeMBean,
IROLAPCube {
    private static final String COMMA_AND_SPACE = ", ";
    public static final String EXPRESSION_ONE = "1";
    private static final String SEMICOLON = ";";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSED_BRACKET = "]";
    private static final String MBEAN_NAME = "com.cognos.xqe.rolap:type=cubes,name=";
    public static final String LEVEL_MEMBERS_CACHE_KEYS = "LEVEL_MEMBERS_CACHE_KEYS";
    private static final long BYTES_PER_MEGABYTE = 0x100000L;
    public static final String CUBE_NAME = "cubeName";
    protected static final String CUBE_NAME_DESCRIPTION = "Cube name";
    protected static final String CUBE_ID = "id";
    protected static final String CUBE_LIST = "cubeList";
    protected static final String[] CUBE_NAME_FIELDS = new String[]{"id", "cubeName"};
    protected static final CompositeType CUBE_NAME_TYPE;
    protected static final TabularType CUBE_LIST_TYPE;
    private static final String ITEM_PROPERTY = "item";
    private static final String VALUE_PROPERTY = "value";
    protected AtomicInteger reservationCount;
    protected AtomicInteger loadNextIncrementCount = new AtomicInteger(0);
    private final ConcurrentRefCountingMap<ROLAPCubeReservation, IExecutionEnvironment> mReservations = new ConcurrentRefCountingMap();
    private CompositeType reservationsCompositeType;
    private TabularType reservationsTabularType;
    public static final String ROLAPDATASOURCE_TYPE = "cm:rolapDataSource";
    public static final String ROLAPVIRTUALDATASOURCE_TYPE = "cm:rolapVirtualDataSource";
    private static final String CM_ROLAPDATASOURCE_SEARCH_PATH_TEMPLATE = "CAMID(\":\")/rolapDataSource[@name='NAME']";
    private static final String CM_ROLAPVIRTUALDATASOURCE_SEARCH_PATH_TEMPLATE = "CAMID(\":\")/rolapVirtualDataSource[@name='NAME']";
    private static final Pattern PATTERN;
    private static final String MSG_CUBE_STOP_FAILED = "Cube stop failed.";
    public static final QName BI_BUS_HEADER_QNAME;
    protected final ROLAPNamespace namespace;
    protected String defaultLocale = null;
    protected ROLAPCubeConfiguration configuration;
    private String modeSearchPath = null;
    protected final ROLAPCubeStateMachine mStateMachine;
    private volatile boolean isDeleted = false;
    private MetadataResolver metadataResolver = null;
    private ROLAPProvider provider;
    private final ConcurrentHashMap<ROLAPCube, ROLAPCube> mDependentCubes = new ConcurrentHashMap();
    private List<String> mAllDependentCubeNamesMetricValue = new ArrayList<String>();
    private ICubeResultSetCache resultSetCache = null;
    protected ROLAPCacheManager<ROLAPMemberCache> mMemberCacheManager;
    private final LockManager lockManager;
    private final long lockWaitTime;
    private final String newCacheUniqueName;
    private final String currentCacheUniqueName;
    private final String registrationUniqueName;
    private final String startupUniqueName;
    private final Boolean multHierSupport = null;
    protected static final String CURRENT_VERSION_NAME = "currentVersion";
    protected static final String TIMESTAMP_NAME = "timestamp";
    protected static final String RESERVATIONS_NAME = "Reservations";
    protected static final String SOFT_RESERVATIONS_NAME = "softReservations";
    protected static final String RESERVATION_ID_NAME = "reservationID";
    protected static final String MEMBER_CACHE_NAME = "MemberCaches";
    protected static final String MEMBER_CACHE_ID_NAME = "memberCacheID";
    static final String[] MEMBER_CACHE_FIELDS;
    protected static final String DATA_CACHE_NAME = "DataCaches";
    protected static final String DATA_CACHE_ID_NAME = "dataCacheID";
    protected static final String[] DATA_CACHE_FIELDS;
    protected static final String SECURITY_CACHE_NAME = "SecurityCaches";
    protected static final String SECURITY_CACHE_ID_NAME = "securityCacheID";
    protected static final String[] SECURITY_CACHE_FIELDS;
    protected static final String[] RESERVATION_FIELDS;
    protected CompositeType memberCacheCompositeType;
    protected TabularType memberCacheTabularType;
    protected CompositeType dataCacheCompositeType;
    protected TabularType dataCacheTabularType;
    protected CompositeType securityCacheCompositeType;
    protected TabularType securityCacheTabularType;
    protected ROLAPCubeMetrics mCubeMetrics;
    protected ROLAPCubeMessages mMessages = new ROLAPCubeMessages();
    private final AtomicBoolean isForceStopping = new AtomicBoolean(false);
    private final ConcurrentHashMap<Thread, AtomicBoolean> currentThreads = new ConcurrentHashMap();
    protected WorkloadLogger workloadLogger = null;
    protected ROLAPMetaMdSchema schema;
    private IModelDataSource datasource = null;
    private ROLAPCubeInfo mCubeInfo;
    protected ROLAPAccessAccountManager mAccountManager;
    ROLAPCacheUpdater.IROLAPCacheProcessor mDataCacheProcessor = new ROLAPCacheUpdater.IROLAPCacheProcessor(){

        @Override
        public ROLAPCacheBase buildCache(ROLAPCacheUpdater updater) {
            ROLAPDataCache dataCache = (ROLAPDataCache)this.getCacheManager(updater.getCube()).newRevision();
            dataCache.initialize();
            return dataCache;
        }

        @Override
        public void setCurrentCache(ROLAPCacheUpdater updater, ROLAPCacheBase cache) {
            this.getCacheManager(updater.getCube()).setNewRevision((ROLAPDataCache)cache);
        }

        @Override
        public ROLAPCacheManager<?> getCacheManager(ROLAPCube cube) {
            return cube.getMemberCacheManager().getCurrentRevision().getDataCacheManager();
        }

        @Override
        public void postUpdateActions(ROLAPCube cube) {
            TimestampValue t = DataValueFactory.createTimestampValue();
            t.set(System.currentTimeMillis());
            cube.setUpdatedDate(t);
            cube.fireStartupTrigger();
            cube.loadInMemoryAggregatesAsynchronously();
        }

        @Override
        public IMessageKey.Param0 getFailedMessage() {
            return XQEMessageKeys.RLU_DataCacheRefreshFailed;
        }

        @Override
        public IMessageKey.Param0 getStartMessage() {
            return XQEMessageKeys.RLU_DataCacheRefreshExecuting;
        }

        @Override
        public IMessageKey.Param1 getIndirectStartMessage() {
            return XQEMessageKeys.RLU_DataCacheIndirectRefreshExecuting;
        }

        @Override
        public IMessageKey.Param0 getSuccessMessage() {
            return XQEMessageKeys.RLU_DataCacheRefreshSucceeded;
        }

        @Override
        public ROLAPCube getCube() {
            return ROLAPCube.this;
        }
    };
    ROLAPCacheUpdater.IROLAPCacheProcessor mMemberCacheProcessor = new ROLAPCacheUpdater.IROLAPCacheProcessor(){

        @Override
        public ROLAPCacheBase buildCache(ROLAPCacheUpdater updater) {
            ROLAPMemberCache cache = updater.getCube().getMemberCacheManager().newRevision();
            updater.getCube().resetSessionCalculatedMemberIDCounter();
            cache.initialize(updater.getCubeAction(), updater.getCube().getCurrentSecurityManager());
            ROLAPCubeReservation res = new ROLAPCubeReservation(updater.getCube(), cache, cache.getDataCacheManager().getCurrentRevision(), cache.getSecurityCacheManager().getCurrentRevision());
            ROLAPContext.get().addReservation(res, (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            updater.setReservation(res);
            ArrayList<ROLAPCubeReservation> missingRes = new ArrayList<ROLAPCubeReservation>();
            ROLAPContext.get().reserveMissingLeaves(updater.getCube(), missingRes);
            updater.setMissingLeafReservations(missingRes);
            return cache;
        }

        @Override
        public void setCurrentCache(ROLAPCacheUpdater updater, ROLAPCacheBase cache) {
            ROLAPContext.get().unreserveMissingLeaves(updater.getMissingLeafReservations());
            ROLAPContext.get().removeReservation(updater.getReservation());
            updater.getCube().getMemberCacheManager().setNewRevision((ROLAPMemberCache)cache);
        }

        @Override
        public ROLAPCacheManager<?> getCacheManager(ROLAPCube cube) {
            return cube.getMemberCacheManager();
        }

        @Override
        public void postUpdateActions(ROLAPCube cube) {
            ROLAPCubeManager.getInstance().clearPlansForCube(cube);
            TimestampValue t = DataValueFactory.createTimestampValue();
            t.set(System.currentTimeMillis());
            cube.setSchemaUpdatedDate(t);
            cube.setUpdatedDate(t);
            cube.fireStartupTrigger();
            cube.loadInMemoryAggregatesAsynchronously();
        }

        @Override
        public IMessageKey.Param0 getFailedMessage() {
            return XQEMessageKeys.RLU_MemberCacheRefreshFailed;
        }

        @Override
        public IMessageKey.Param0 getStartMessage() {
            return XQEMessageKeys.RLU_MemberCacheRefreshExecuting;
        }

        @Override
        public IMessageKey.Param1 getIndirectStartMessage() {
            return XQEMessageKeys.RLU_MemberCacheIndirectRefreshExecuting;
        }

        @Override
        public IMessageKey.Param0 getSuccessMessage() {
            return XQEMessageKeys.RLU_MemberCacheRefreshSucceeded;
        }

        @Override
        public ROLAPCube getCube() {
            return ROLAPCube.this;
        }
    };
    ROLAPCacheUpdater.IROLAPCacheProcessor mSecurityCacheProcessor = new ROLAPCacheUpdater.IROLAPCacheProcessor(){

        @Override
        public ROLAPCacheBase buildCache(ROLAPCacheUpdater updater) {
            ROLAPSecurityCache securityCache = (ROLAPSecurityCache)this.getCacheManager(updater.getCube()).newRevision();
            securityCache.initialize(updater.getCubeAction(), updater.getCube().getCurrentSecurityManager());
            ROLAPCubeReservation res = new ROLAPCubeReservation(updater.getCube(), updater.getCube().getMemberCacheManager().getCurrentRevision(), updater.getCube().getMemberCacheManager().getCurrentRevision().getDataCacheManager().getCurrentRevision(), securityCache);
            ROLAPContext.get().addReservation(res, (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            updater.setReservation(res);
            ArrayList<ROLAPCubeReservation> missingRes = new ArrayList<ROLAPCubeReservation>();
            ROLAPContext.get().reserveMissingLeaves(updater.getCube(), missingRes);
            updater.setMissingLeafReservations(missingRes);
            return securityCache;
        }

        @Override
        public void setCurrentCache(ROLAPCacheUpdater updater, ROLAPCacheBase cache) {
            ROLAPContext.get().unreserveMissingLeaves(updater.getMissingLeafReservations());
            ROLAPContext.get().removeReservation(updater.getReservation());
            this.getCacheManager(updater.getCube()).setNewRevision((ROLAPSecurityCache)cache);
        }

        @Override
        public ROLAPCacheManager<?> getCacheManager(ROLAPCube cube) {
            return cube.getMemberCacheManager().getCurrentRevision().getSecurityCacheManager();
        }

        @Override
        public void postUpdateActions(ROLAPCube cube) {
            ROLAPCubeManager.getInstance().clearPlansForCube(cube);
            TimestampValue t = DataValueFactory.createTimestampValue();
            t.set(System.currentTimeMillis());
            cube.setSchemaUpdatedDate(t);
        }

        @Override
        public IMessageKey.Param0 getFailedMessage() {
            return XQEMessageKeys.RLU_SecurityRefreshFailed;
        }

        @Override
        public IMessageKey.Param0 getStartMessage() {
            return XQEMessageKeys.RLU_SecurityRefreshExecuting;
        }

        @Override
        public IMessageKey.Param1 getIndirectStartMessage() {
            return XQEMessageKeys.RLU_SecurityIndirectRefreshExecuting;
        }

        @Override
        public IMessageKey.Param0 getSuccessMessage() {
            return XQEMessageKeys.RLU_SecurityRefreshSucceeded;
        }

        @Override
        public ROLAPCube getCube() {
            return ROLAPCube.this;
        }
    };
    private ROLAPFolder rootMeasureFolder;
    private static final String USERNAME = "account.personalInfo.userName";

    public abstract boolean isVirtual();

    public abstract boolean isValidateCube();

    public abstract boolean isCubingServicesCompatible();

    protected ROLAPCube(String n, ROLAPCubeInfo cubeInfo) {
        super(n, "ROLAP Catalog", System.currentTimeMillis());
        this.mCubeInfo = cubeInfo;
        this.reservationCount = new AtomicInteger();
        ROLAPCubeConfiguration cubeConfiguration = this.getLatestConfiguration();
        this.setConfiguration(cubeConfiguration);
        ROLAPCubeStateEnum initialState = cubeConfiguration.getInitialState();
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        this.lockManager = cubeManager.getLockManager();
        this.lockWaitTime = cubeManager.getLockWaitTime();
        this.mStateMachine = new ROLAPCubeStateMachine(initialState, new ROLAPCubeStateContext(this), this.lockManager, this.lockWaitTime);
        this.newCacheUniqueName = UniqueNameGenerator.createUniqueName(n, "newCache");
        this.currentCacheUniqueName = UniqueNameGenerator.createUniqueName(n, "currentCache");
        this.registrationUniqueName = UniqueNameGenerator.createUniqueName(n, "registration");
        this.startupUniqueName = UniqueNameGenerator.createUniqueName(n, "startup");
        this.lockManager.createLocks(this.newCacheUniqueName, this.currentCacheUniqueName, this.registrationUniqueName, this.startupUniqueName);
        TimestampValue t = DataValueFactory.createTimestampValue();
        t.set(System.currentTimeMillis());
        this.setCreatedDate(t);
        this.setSchemaUpdatedDate(t);
        this.setUpdatedDate(t);
        this.modeSearchPath = this.constructDatasourceBasePath() + "/model";
        this.namespace = new ROLAPNamespace(this.name, this);
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME + this.getName());
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(this, name);
            }
            this.reservationsCompositeType = new CompositeType(RESERVATIONS_NAME, RESERVATIONS_NAME, RESERVATION_FIELDS, RESERVATION_FIELDS, new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.DATE});
            this.reservationsTabularType = new TabularType(RESERVATIONS_NAME, RESERVATIONS_NAME, this.reservationsCompositeType, new String[]{RESERVATION_ID_NAME});
            this.schema = this.loadSchema();
            this.defaultLocale = this.schema.getDefaultLocale();
        }
        catch (Throwable th) {
            this.release();
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, th, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
        this.workloadLogger = this.createWorkloadLogger();
        this.mCubeMetrics = new ROLAPCubeMetrics(this);
    }

    protected WorkloadLogger createWorkloadLogger() {
        WorkloadLogger workloadLoggerInstance = null;
        workloadLoggerInstance = this.getConfigAutoAggrOptimizationEnum() == ROLAPCubeConfiguration.AutoAggrOptimization.On ? new QuerySummaryInfoLogger(this) : new QueryDetailedInfoLogger(this);
        return workloadLoggerInstance;
    }

    public ROLAPMetaMdSchema getSchema() {
        return this.schema;
    }

    public ROLAPCubeMetrics getMetrics() {
        return this.mCubeMetrics;
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public ROLAPCubeMessages getMessages() {
        return this.mMessages;
    }

    public abstract void init(ROLAPProvider var1);

    public void addDependentCube(ROLAPCube dependent) {
        this.mDependentCubes.put(dependent, dependent);
        this.updateDependentMetric();
    }

    public void updateDependentMetric() {
        ArrayList<String> allDependents = new ArrayList<String>();
        this.getAllDependents(this, allDependents);
        this.mAllDependentCubeNamesMetricValue = Collections.unmodifiableList(allDependents);
    }

    public void removeDependentCube(ROLAPCube dependent) {
        this.mDependentCubes.remove(dependent);
        this.updateDependentMetric();
    }

    public Set<ROLAPCube> getDependentCubes() {
        return this.mDependentCubes.keySet();
    }

    protected ROLAPCubeConfiguration getLatestConfiguration() {
        String cubeName = this.getName();
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        ROLAPCubeConfiguration cubeConfiguration = cubeManager.getCubeConfiguration(cubeName);
        if (cubeConfiguration == null) {
            cubeConfiguration = cubeManager.createCubeConfiguration(cubeName, this.isVirtual());
        }
        return cubeConfiguration;
    }

    protected void setConfiguration(ROLAPCubeConfiguration cubeConfiguration) {
        this.configuration = cubeConfiguration;
        this.configuration.reportUnsupportedProperties(this.getMessages());
    }

    protected void buildJMXCacheDiagnosticInfo() {
        try {
            this.dataCacheCompositeType = new CompositeType(DATA_CACHE_NAME, DATA_CACHE_NAME, DATA_CACHE_FIELDS, DATA_CACHE_FIELDS, new OpenType[]{SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE});
            this.dataCacheTabularType = new TabularType(DATA_CACHE_NAME, DATA_CACHE_NAME, this.dataCacheCompositeType, new String[]{DATA_CACHE_ID_NAME});
            this.securityCacheCompositeType = new CompositeType(SECURITY_CACHE_NAME, SECURITY_CACHE_NAME, SECURITY_CACHE_FIELDS, SECURITY_CACHE_FIELDS, new OpenType[]{SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.DATE, SimpleType.INTEGER, SimpleType.INTEGER});
            this.securityCacheTabularType = new TabularType(SECURITY_CACHE_NAME, SECURITY_CACHE_NAME, this.securityCacheCompositeType, new String[]{SECURITY_CACHE_ID_NAME});
            this.memberCacheCompositeType = new CompositeType(MEMBER_CACHE_NAME, MEMBER_CACHE_NAME, MEMBER_CACHE_FIELDS, MEMBER_CACHE_FIELDS, new OpenType[]{SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, this.dataCacheTabularType, this.securityCacheTabularType, SimpleType.DATE});
            this.memberCacheTabularType = new TabularType(MEMBER_CACHE_NAME, MEMBER_CACHE_NAME, this.memberCacheCompositeType, new String[]{MEMBER_CACHE_ID_NAME});
        }
        catch (Throwable t) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, t, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
    }

    @Override
    public INamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public int getReservationCount() {
        return this.reservationCount.get();
    }

    @Override
    public void setReservationCount(int count) {
        this.changeReservationCount(this.getReservationCount(), count);
    }

    public boolean changeReservationCount(int from, int to) {
        if (this.reservationCount.compareAndSet(from, to)) {
            if (ROLAPLog.isOn("ROLAPCubes.Reservation", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Reservation", "Changed reservation count from " + from + " to " + to);
            }
            ROLAPCubeManager.adminNotify(this.reservationCount);
            return true;
        }
        return false;
    }

    public boolean isUp() {
        return this.isRunning() || this.isPaused();
    }

    public boolean isRunning() {
        return ((ROLAPCubeStateEnum)((Object)this.mStateMachine.getState())).isRunning();
    }

    public boolean isPaused() {
        return ((ROLAPCubeStateEnum)((Object)this.mStateMachine.getState())).isPaused();
    }

    public boolean isStopped() {
        return ((ROLAPCubeStateEnum)((Object)this.mStateMachine.getState())).isStopped();
    }

    public boolean isEnabled() {
        return this.mStateMachine.getState() != ROLAPCubeStateEnum.DISABLED;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ROLAPCubeReservation reserveImpl(ROLAPCubeSoftReservation softRes, ROLAPCubeReservation[] sourceReservations) {
        this.acquireLock(this.currentCacheUniqueName, false);
        try {
            ROLAPMemberCache memberCache = null;
            ROLAPDataCache dataCache = null;
            ROLAPSecurityCache securityCache = null;
            if (softRes != null) {
                memberCache = softRes.getMemberCache();
                dataCache = softRes.getDataCache();
                securityCache = softRes.getSecurityCache();
            }
            memberCache = this.mMemberCacheManager.reserve(memberCache);
            dataCache = memberCache.getDataCacheManager().reserve(dataCache);
            securityCache = memberCache.getSecurityCacheManager().reserve(securityCache);
            ROLAPCubeReservation rOLAPCubeReservation = new ROLAPCubeReservation(this, memberCache, dataCache, securityCache, sourceReservations);
            return rOLAPCubeReservation;
        }
        finally {
            this.releaseLock(this.currentCacheUniqueName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unreserveImpl(ROLAPCubeReservation reservation, ROLAPContext ctx) {
        this.acquireLock(this.currentCacheUniqueName, false);
        try {
            ROLAPMemberCache memberCache = reservation.getMemberCache();
            memberCache.getSecurityCacheManager().unreserve(reservation.getSecurityCache());
            memberCache.getDataCacheManager().unreserve(reservation.getDataCache());
            this.mMemberCacheManager.unreserve(memberCache);
        }
        finally {
            this.releaseLock(this.currentCacheUniqueName, false);
        }
        ROLAPCubeManager.adminNotify(this.mMemberCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROLAPCubeReservation reserve(final IExecutionEnvironment execEnv, final ROLAPCubeSoftReservation softRes) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            final AtomicReference resHolder = new AtomicReference();
            final ROLAPCube cubeToReserve = this;
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    int count;
                    ROLAPContext context = ROLAPContext.get(execEnv);
                    if (ROLAPCube.this.isPaused()) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_CubePaused, new ROLAPCubeNameWrapper(ROLAPCube.this.getName()));
                    }
                    ROLAPCubeReservation res = context.getReservation(cubeToReserve);
                    if (res == null && (ROLAPCube.this.mStateMachine.getState() == ROLAPCubeStateEnum.STARTING || ROLAPCube.this.mStateMachine.getState() == ROLAPCubeStateEnum.STOPPING)) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(ROLAPCube.this.getName()));
                    }
                    while (!ROLAPCube.this.changeReservationCount(count = ROLAPCube.this.reservationCount.get(), count + 1)) {
                    }
                    if (res == null) {
                        res = ROLAPCube.this.reserveImpl(softRes, null);
                    }
                    context.addReservation(res, execEnv);
                    resHolder.set(res);
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.STARTING);
            set.add(ROLAPCubeStateEnum.STOPPING);
            set.add(ROLAPCubeStateEnum.PAUSED);
            if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
            }
            ROLAPCubeReservation rOLAPCubeReservation = (ROLAPCubeReservation)resHolder.get();
            return rOLAPCubeReservation;
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    public ROLAPCubeReservation reserve() {
        return this.reserve((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment(), null);
    }

    public void unreserve(ROLAPCubeReservation reservation) {
        this.unreserve(reservation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreserve(final ROLAPCubeReservation reservation, final ROLAPContext ctx) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            ROLAPCube cubeToUnreserve = this;
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    ROLAPContext context = ctx != null ? ctx : ROLAPContext.get();
                    try {
                        if (context.removeReservation(reservation)) {
                            ROLAPCube.this.unreserveImpl(reservation, context);
                        }
                    }
                    finally {
                        int count;
                        do {
                            if ((count = ROLAPCube.this.reservationCount.get()) > 0) continue;
                            throw new IllegalStateException("Reservation count was in an unexpected range (<= 0).");
                        } while (!ROLAPCube.this.changeReservationCount(count, count - 1));
                    }
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.STARTING);
            set.add(ROLAPCubeStateEnum.STOPPING);
            set.add(ROLAPCubeStateEnum.PAUSED);
            set.add(ROLAPCubeStateEnum.PAUSING);
            if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
            }
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    @Override
    public ICacheEngine getMetadataStorage() {
        return this.getMemberCacheInContext().getMetadataStorage();
    }

    @Override
    public void setMetadataStorage(ICacheEngine cacheEngine) {
        this.getMemberCacheInContext().setMetadataStorage(cacheEngine);
    }

    @Override
    public CacheMetricsTracker getTupleStorageMetrics() {
        CacheMetricsTracker metricsTracker = null;
        ROLAPDataCache dataCache = this.getDataCacheInContext();
        if (dataCache != null) {
            metricsTracker = dataCache.getTupleStorageMetrics();
        }
        return metricsTracker;
    }

    @Override
    public void createCubeDirectory() throws ProviderException {
    }

    @Override
    public IBlockTupleStorage getBlockTupleStorage() {
        return this.getDataCacheInContext().getBlockTupleStorage();
    }

    public IBlockTupleStorage getAggregateCache() {
        return this.getDataCacheInContext().getAggregateStorage();
    }

    public Provider getProvider() {
        return this.provider;
    }

    protected void setProvider(ROLAPProvider aProvider) {
        this.provider = aProvider;
    }

    public ROLAPCubeConfiguration getCubeConfiguration() {
        return this.configuration;
    }

    public ICubeResultSetCache getResultSetCache() {
        return this.resultSetCache;
    }

    @Override
    public IMember getMeasure(String measureName) throws MetadataException {
        String unqualifiedMeasureName;
        if (measureName == null) {
            return null;
        }
        try {
            unqualifiedMeasureName = UniqueNameParser.parseLastIdentifier(measureName);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        if (unqualifiedMeasureName != null) {
            IMember[] allMeasures;
            for (IMember m : allMeasures = this.getMeasures(true)) {
                if (!unqualifiedMeasureName.equals(m.getName())) continue;
                return m;
            }
        }
        return null;
    }

    public IMember[] getMeasures(boolean includeInVisibleMeasures) {
        IMember[] result = new IMember[]{};
        Level measuresLevel = (Level)this.getMeasuresDimension().getLevel(0);
        result = measuresLevel.getMembers(false, includeInVisibleMeasures).toArray(new IMember[0]);
        SecurityManagerInterface securityManager = this.getSecurityManager(this.getProvider());
        if (securityManager != null && result.length > 0) {
            result = securityManager.applySecurity(result, result[0].getHierarchy());
        }
        return result;
    }

    @Override
    public IMember[] getMeasures() {
        return this.getMeasures(false);
    }

    @Override
    protected IDimension getMeasuresDimension() {
        List<IDimension> dimList = this.getDimensions();
        for (int i = 0; i < dimList.size(); ++i) {
            IDimension dim = dimList.get(i);
            if (dim.getType() != DimensionTypeEnum.MEASURE) continue;
            return dim;
        }
        return null;
    }

    public IMember findROLAPMember(String memberName) {
        IMember member = this.findMember(memberName);
        if (member == null) {
            try {
                member = this.getMetadataResolver().resolveMember(memberName);
            }
            catch (InterpreterException ie) {
                ROLAPLog.logError("ROLAPCubes.Management", "", ie);
                return null;
            }
        }
        if (member != null) {
            SecurityManagerInterface securityManager = this.getSecurityManager(this.getProvider());
            if (securityManager != null) {
                IMember[] members = new IMember[]{member};
                if ((members = securityManager.applySecurity(members, member.getHierarchy())).length == 0) {
                    member = null;
                }
            }
            return member;
        }
        return null;
    }

    public IHierarchy findROLAPHierarchy(String hierName) {
        IHierarchy hierarchy = this.getHierarchy(hierName);
        if (hierarchy == null) {
            try {
                hierarchy = this.getMetadataResolver().resolveHierarchy(hierName);
            }
            catch (InterpreterException ie) {
                ROLAPLog.logError("ROLAPCubes.Management", "", ie);
            }
        }
        return hierarchy;
    }

    private MetadataResolver getMetadataResolver() {
        if (this.metadataResolver == null) {
            this.metadataResolver = new MetadataResolver(this.provider, this);
        }
        return this.metadataResolver;
    }

    public void setMetadataResolver(MetadataResolver mr) {
        this.metadataResolver = mr;
    }

    @Override
    public String getStateStr() {
        return ((ROLAPCubeStateEnum)((Object)this.mStateMachine.getState())).name();
    }

    public ROLAPCubeStateEnum getState() {
        return (ROLAPCubeStateEnum)((Object)this.mStateMachine.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        try {
            this.lockManager.removeLocks(this.newCacheUniqueName, this.currentCacheUniqueName, this.registrationUniqueName, this.startupUniqueName);
            this.mStateMachine.removeLocks();
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME + this.getName());
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
                ROLAPLog.log("ROLAPCubes.Management", "Cube released succeeded.");
            }
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Cube released failed.", t);
        }
        finally {
            traceContext.exit();
        }
    }

    public abstract ROLAPMetaCube getModelCube();

    @Override
    protected IBlockTupleStorage createBlockTupleStorage() throws ProviderException {
        return null;
    }

    @Override
    public boolean getConfigIsDisabled() {
        return this.configuration.isDisabled();
    }

    @Override
    public boolean getConfigIsEnableDynamicMemberCaching() {
        return this.configuration.isEnableDynamicMemberCaching();
    }

    @Override
    public int getConfigMemberCacheLimit() {
        return this.configuration.getMemberCacheLimit();
    }

    @Override
    public String getConfigStartupTriggerName() {
        return this.configuration.getStartupTriggerName();
    }

    @Override
    public boolean getConfigIsDisableResultSetCache() {
        return this.configuration.isDisableResultSetCache();
    }

    @Override
    public int getConfigResultSetCacheSizeLimit() {
        return this.configuration.getResultSetCacheSizeLimit();
    }

    @Override
    public int getConfigPredicateThreshold() {
        return this.configuration.getPredicateThreshold();
    }

    @Override
    public boolean getConfigIsDisableExternalAggregates() {
        return this.configuration.isDisableExternalAggregates();
    }

    @Override
    public boolean getConfigIsAggregateLoggingEnabled() {
        return this.configuration.isAggregateLoggingEnabled();
    }

    @Override
    public int getConfigMultiDimensionalQuerySizeLimit() {
        return this.configuration.getMultiDimensionalQuerySizeLimit();
    }

    @Override
    public int getConfigMaxDataCacheSize() {
        return this.configuration.getMaxDataCacheSize();
    }

    @Override
    public int getConfigMaxAggregateCacheSize() {
        return this.configuration.getMaxAggregateCacheSize();
    }

    @Override
    public void setConfigIsDisabled(boolean disable) {
        this.configuration.setDisabled(disable);
    }

    @Override
    public void setConfigIsEnableDynamicMemberCaching(boolean enableCaching) {
        this.configuration.setEnableDynamicMemberCaching(enableCaching);
    }

    @Override
    public void setConfigMemberCacheLimit(int limit) {
        this.configuration.setMemberCacheLimit(limit);
    }

    @Override
    public void setConfigStartupTriggerName(String triggerName) {
        this.configuration.setStartupTriggerName(triggerName);
    }

    @Override
    public void setConfigIsDisableResultSetCache(boolean disableCache) {
        this.configuration.setDisableResultSetCache(disableCache);
        if (!disableCache && this.isRunning() && null == this.resultSetCache) {
            try {
                this.initializeResultSetCache();
            }
            catch (IOException e) {
                ROLAPLog.logError("ROLAPCubes.Management", "Failed to initialize Result Set Cache.", e);
                ROLAPCubeManager.handleExceptionInJMX(e);
            }
        }
    }

    @Override
    public void setConfigResultSetCacheSizeLimit(int size) {
        this.configuration.setResultSetCacheSizeLimit(size);
        ICubeResultSetCache currentResultSetCache = this.resultSetCache;
        if (null != currentResultSetCache) {
            currentResultSetCache.setMaxCacheSize(0x100000L * (long)size);
            currentResultSetCache.runMaintenance();
        }
    }

    @Override
    public void setConfigPredicateThreshold(int threshold) {
        this.configuration.setPredicateThreshold(threshold);
    }

    @Override
    public void setConfigIsDisableExternalAggregates(boolean disableAggregates) {
        this.configuration.setDisableExternalAggregates(disableAggregates);
    }

    @Override
    public void setConfigIsAggregateLoggingEnabled(boolean loggingEnabled) {
        this.configuration.setAggregateLoggingEnabled(loggingEnabled);
    }

    @Override
    public void setConfigMultiDimensionalQuerySizeLimit(int size) {
        this.configuration.setMultiDimensionalQuerySizeLimit(size);
    }

    @Override
    public void setConfigMaxDataCacheSize(int size) {
        this.configuration.setMaxDataCacheSize(size);
    }

    @Override
    public void setConfigMaxAggregateCacheSize(int size) {
        this.configuration.setMaxAggregateCacheSize(size);
    }

    @Override
    public String getConfigPostInMemoryTriggerName() {
        return this.configuration.getPostInMemoryTriggerName();
    }

    @Override
    public void setConfigPostInMemoryTriggerName(String triggerName) {
        this.configuration.setPostInMemoryTriggerName(triggerName);
    }

    @Override
    public int getConfigMaxHierarchyLoadThreads() {
        return this.configuration.getMaxHierarchyLoadThreads();
    }

    @Override
    public void setConfigMaxHierarchyLoadThreads(int threads) {
        this.configuration.setMaxHierarchyLoadThreads(threads);
    }

    @Override
    public int getConfigMaxAggregateLoadThreads() {
        return this.configuration.getMaxAggregateLoadThreads();
    }

    @Override
    public void setConfigMaxAggregateLoadThreads(int threads) {
        this.configuration.setMaxAggregateLoadThreads(threads);
    }

    @Override
    public int getConfigMeasuresThreshold() {
        return this.configuration.getMeasuresThreshold();
    }

    @Override
    public void setConfigMeasuresThreshold(int threshold) {
        this.configuration.setMeasuresThreshold(threshold);
    }

    @Override
    public String getConfigAutoAggrOptimization() {
        return this.getConfigAutoAggrOptimizationEnum().getValue();
    }

    public ROLAPCubeConfiguration.AutoAggrOptimization getConfigAutoAggrOptimizationEnum() {
        return this.configuration.getAutoAggrOptimization();
    }

    @Override
    public void setConfigAutoAggrOptimization(String optimization) {
        this.configuration.setAutoAggrOptimization(optimization);
    }

    public boolean isAutonomicAggregateOptimizationEnabled() {
        return this.getConfigAutoAggrOptimizationEnum() == ROLAPCubeConfiguration.AutoAggrOptimization.On;
    }

    protected void startCubeImpl(boolean forceStart) {
        try {
            if (!this.getConfigIsDisableResultSetCache()) {
                this.initializeResultSetCache();
            }
            if (this.schema == null) {
                this.schema = this.loadSchema();
                this.defaultLocale = this.schema.getDefaultLocale();
            }
            this.mCubeInfo = ROLAPCube.loadCubeInfo(this.getName());
            ROLAPCubeManager.getInstance().updateCubeInfo(this.getName(), this, this.mCubeInfo);
        }
        catch (Throwable t) {
            throw XQERuntimeException.wrap(t);
        }
    }

    protected void stopCubeImpl() {
        try {
            this.mReservations.clear();
            this.reservationCount.set(0);
            this.setMetadataResolver(null);
            ROLAPSharedDimensionCache.getInstance().removeSharedDimensions(this);
            if (null != this.resultSetCache) {
                this.resultSetCache.release();
                this.resultSetCache = null;
            }
            this.schema = null;
            ROLAPCubeManager.getInstance().clearPlansForCube(this);
            super.close(false);
        }
        catch (Throwable t) {
            throw XQERuntimeException.wrap(t);
        }
    }

    void acquireNewCacheLock(AtomicLong waitTime) {
        this.acquireLock(this.newCacheUniqueName, true, waitTime);
    }

    void releaseNewCacheLock() {
        this.releaseLock(this.newCacheUniqueName, true);
    }

    void acquireCurrentCacheLock(AtomicLong waitTime) {
        this.acquireLock(this.currentCacheUniqueName, true, waitTime);
    }

    void releaseCurrentCacheLock() {
        this.releaseLock(this.currentCacheUniqueName, true);
    }

    public ROLAPCacheManager<ROLAPMemberCache> getMemberCacheManager() {
        return this.mMemberCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildMemberCache() {
        this.acquireLock(this.newCacheUniqueName, true);
        try {
            this.waitUntilNewCacheCanBeCreated(this.mMemberCacheProcessor.getCacheManager(this), new AtomicLong(ROLAPCubeManager.setUpAdminWait()));
            ROLAPCacheUpdater updater = new ROLAPCacheUpdater(this, this.mMemberCacheProcessor, ROLAPCubeAction.START);
            ROLAPMemberCache cache = (ROLAPMemberCache)this.mMemberCacheProcessor.buildCache(updater);
            this.acquireLock(this.currentCacheUniqueName, true);
            try {
                this.mMemberCacheProcessor.setCurrentCache(updater, cache);
            }
            finally {
                this.releaseLock(this.currentCacheUniqueName, true);
            }
        }
        finally {
            this.releaseLock(this.newCacheUniqueName, true);
        }
        ROLAPCubeManager.getInstance().clearPlansForCube(this);
        TimestampValue t = DataValueFactory.createTimestampValue();
        t.set(System.currentTimeMillis());
        this.setSchemaUpdatedDate(t);
        this.setUpdatedDate(t);
    }

    private void clearWorkloadLogImpl() {
        this.workloadLogger.clearLogs();
    }

    private SecurityManagerInterface getCurrentSecurityManager() {
        ROLAPCacheManager<ROLAPSecurityCache> securityCacheManager;
        ROLAPSecurityCache currentSecurityCache;
        SecurityManagerInterface currentSecurityManager = null;
        if (this.mMemberCacheManager == null) {
            return null;
        }
        ROLAPMemberCache currentMemberCache = this.mMemberCacheManager.getCurrentRevision();
        if (currentMemberCache != null && (currentSecurityCache = (securityCacheManager = currentMemberCache.getSecurityCacheManager()).getCurrentRevision()) != null) {
            currentSecurityManager = currentSecurityCache.getSecurityManager();
        }
        return currentSecurityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilNewCacheCanBeCreated(ROLAPCacheManager<?> cacheManager, AtomicLong waitTime) {
        long timeLeft = waitTime.get();
        long startTime = System.nanoTime();
        try {
            if (cacheManager.createAllowed()) {
                return;
            }
            while (true) {
                if (cacheManager != this.mMemberCacheManager) {
                    if (!this.mMemberCacheManager.compress()) {
                        cacheManager.compress();
                    }
                } else {
                    cacheManager.compress();
                }
                if (cacheManager.createAllowed()) {
                    break;
                }
                if (timeLeft <= 0L) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_CacheRefreshError, new ROLAPCubeNameWrapper(this.getName()));
                }
                this.throwExceptionIfCurrentThreadIsInterrupted();
                timeLeft = ROLAPCubeManager.adminWait(timeLeft, this.mMemberCacheManager);
            }
        }
        finally {
            ROLAPCubeManager.updateRemainingWaitTime(waitTime, startTime);
        }
    }

    private void fireStartupTrigger() {
        this.fireTrigger(this.getConfigStartupTriggerName(), XQEMessageKeys.RLU_FireStartupTriggerFailed, XQEMessageKeys.ROL_StartupTriggerCouldNotBeFired);
    }

    protected void firePostInMemoryAggrTrigger() {
        this.fireTrigger(this.getConfigPostInMemoryTriggerName(), XQEMessageKeys.RLU_FirePostInMemoryTriggerFailed, XQEMessageKeys.ROL_PostInMemoryTriggerCouldNotBeFired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTrigger(final String triggerName, IMessageKey.Param1 failedMsg, final IMessageKey.Param2 failedError) {
        if (triggerName != null && triggerName.length() > 0) {
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.getName());
            boolean registered = false;
            try {
                registered = this.registerCurrentThread(false);
                ROLAPLog.log("ROLAPCubes.Management", String.format("Firing of trigger \"%s\" began.", triggerName));
                Runnable work = new Runnable(){

                    @Override
                    public void run() {
                        ROLAPCube.this.fireTriggerImpl(triggerName, failedError);
                    }
                };
                HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
                set.add(ROLAPCubeStateEnum.RUNNING);
                set.add(ROLAPCubeStateEnum.PAUSED);
                if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
                }
                ROLAPLog.log("ROLAPCubes.Management", String.format("Firing of \"%s\" succeeded.", triggerName));
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause == null) {
                    cause = t;
                }
                this.getMessages().addMessage(failedMsg, triggerName, cause);
                ROLAPCubeManager.handleExceptionInJMX(t);
            }
            finally {
                this.deregisterCurrentThread(false, registered);
                traceContext.exit();
            }
        }
    }

    private void fireTriggerImpl(final String triggerName, IMessageKey.Param2 failedError) {
        try {
            ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
            String internalDispatcherURI = cubeManager.getInternalDispatcherURI();
            String internalDispatcherGuid = cubeManager.getInternalDispatcherGuid();
            MonitorOptionGUID monitorOptionGUID = new MonitorOptionGUID();
            Guid guid = new Guid();
            guid.set_value(internalDispatcherGuid);
            monitorOptionGUID.setName(MonitorOptionEnum.dispatcherID);
            monitorOptionGUID.setValue(guid);
            final Option[] triggerOptions = new Option[]{monitorOptionGUID};
            ROLAPLog.log("ROLAPCubes.Management", String.format("Trigger \"%s\" is targeting execution of the job on the dispatcher with URI \"%s\" and guid \"%s\"", triggerName, internalDispatcherURI, internalDispatcherGuid));
            final EventManagementService_PortType eventManagementService = new EventManagementService_ServiceLocator().geteventManagementService(new URL(internalDispatcherURI));
            final AtomicInteger activatedScheduleCount = new AtomicInteger();
            this.mAccountManager.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BiBusHeader biBusHeader = ContentManager.buildBiBusHeaderFrom(ROLAPCube.this.mAccountManager.getEnvelope());
                        ((Stub)eventManagementService).setHeader(BI_BUS_HEADER_QNAME.getNamespaceURI(), BI_BUS_HEADER_QNAME.getLocalPart(), (Object)biBusHeader);
                        activatedScheduleCount.set(eventManagementService.triggerWithOptions(triggerName, triggerOptions));
                    }
                    catch (RemoteException e) {
                        throw new XQERuntimeException(e);
                    }
                }
            });
            if (activatedScheduleCount.get() <= 0) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_StartupTriggerRequestActivatedNoSchedules, triggerName);
            }
            ROLAPLog.log("ROLAPCubes.Management", String.format("The Event Management Service activated %d schedule(s) with the trigger \"%s\".", activatedScheduleCount.get(), triggerName));
        }
        catch (Throwable t) {
            Throwable cause = t;
            if (t instanceof AxisFault) {
                cause = new XQEAxisFaultException((AxisFault)t);
            }
            throw new XQERuntimeException(failedError, cause, (Object)triggerName, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
    }

    @Override
    public void start() {
        this.start(true, false, true, false);
    }

    @Override
    public void forceStart() {
        this.forceStart(false);
    }

    public void forceStart(boolean onStartup) {
        this.start(true, true, true, onStartup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void start(boolean fireStartupTrigger, boolean forceStart, boolean loadInMemoryAggregates, boolean onStartup) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        try {
            try {
                this.checkOperationAllowed(true);
            }
            catch (Throwable t) {
                this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartFailed, t);
                ROLAPCubeManager.handleExceptionInJMX(t);
            }
            try {
                this.acquireLock(this.startupUniqueName, true);
            }
            catch (CannotAcquireLockInExclusiveModeException e) {
                ROLAPLog.log("ROLAPCubes.Management", "Cube start attempted, but is already in progress");
                traceContext.exit();
                return;
            }
            try {
                if (this.isPaused()) {
                    this.unpause();
                    return;
                }
                boolean registered = false;
                try {
                    registered = this.registerCurrentThread(false);
                    ROLAPCubeStateContext cubeStateContext = new ROLAPCubeStateContext(this);
                    if (!this.mStateMachine.transitionToStartingState(cubeStateContext)) {
                        return;
                    }
                    if (onStartup) {
                        this.delayCubeStartOnCrash();
                    }
                    this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartExecuting);
                    try {
                        this.startCubeImpl(forceStart);
                        this.mStateMachine.extendedTransition(ROLAPCubeStateEnum.RUNNING, cubeStateContext);
                    }
                    catch (Throwable t) {
                        try {
                            this.mStateMachine.setState(ROLAPCubeStateEnum.STOPPING);
                            this.stopCubeImpl();
                            this.mStateMachine.setState(this.configuration.getInitialState());
                            throw t;
                        }
                        catch (Throwable stopException) {
                            ROLAPLog.logError("ROLAPCubes.Management", MSG_CUBE_STOP_FAILED, stopException);
                        }
                        throw t;
                    }
                    TimestampValue t = DataValueFactory.createTimestampValue();
                    t.set(System.currentTimeMillis());
                    this.setUpdatedDate(t);
                    this.setSchemaUpdatedDate(t);
                    try {
                        if (!this.isValidateCube()) {
                            this.validateNamedSets();
                            this.validateCalculatedMembers();
                            this.validateAggregateCubes();
                        }
                    }
                    catch (Throwable e) {
                        this.getMessages().addMessage(XQEMessageKeys.RLU_ErrorValidatingCube, e);
                    }
                    this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartSucceeded);
                    this.getMetrics().recordCubeStartTime(System.currentTimeMillis());
                }
                catch (Throwable t) {
                    this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartFailed, t);
                    ROLAPCubeManager.handleExceptionInJMX(t);
                }
                finally {
                    this.deregisterCurrentThread(false, registered);
                }
                if (fireStartupTrigger) {
                    this.fireStartupTrigger();
                }
                if (!loadInMemoryAggregates) return;
                this.loadInMemoryAggregatesAsynchronously();
                return;
            }
            finally {
                this.releaseLock(this.startupUniqueName, true);
            }
        }
        finally {
            traceContext.exit();
        }
    }

    private void delayCubeStartOnCrash() {
        if (DQServer.isRecoveringFromCrash()) {
            long delayInSeconds = ROLAPCubeManager.getInstance().getConfig().getCubeStartDelayOnRecovery();
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartDelayed, Long.toString(delayInSeconds));
            long timeLeft = TimeUnit.SECONDS.toMillis(delayInSeconds);
            while (timeLeft > 0L) {
                timeLeft = ROLAPCubeManager.adminWait(timeLeft, this);
            }
        }
    }

    private void unpause() {
        try {
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartExecuting);
            this.unpauseImpl();
            ROLAPCubeStateContext cubeStateContext = new ROLAPCubeStateContext(this);
            this.mStateMachine.extendedTransition(ROLAPCubeStateEnum.RUNNING, cubeStateContext);
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartSucceeded);
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStartFailed, t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
    }

    protected void unpauseImpl() {
    }

    protected void validateCalculatedDefaultMember() {
        List<IHierarchy> hiersWithCalcDefaultMember = this.hierarchiesWithCalculatedDefaultMember();
        if (hiersWithCalcDefaultMember.size() > 0) {
            ArrayList<IHierarchy> maskHiers = new ArrayList<IHierarchy>();
            HashMap<String, Object> queryProperties = null;
            StringBuilder planningException = null;
            StringBuilder lastException = null;
            for (int i = 0; i <= hiersWithCalcDefaultMember.size(); ++i) {
                if (i > 0) {
                    queryProperties = new HashMap<String, Object>();
                    queryProperties.put("calculatedDefaultMembersMaskList", maskHiers);
                }
                planningException = new StringBuilder();
                try {
                    V5ExpressionUtils.validateSimpleExpression(this, EXPRESSION_ONE, planningException, queryProperties, false);
                }
                catch (OperationCanceledException cancelException) {
                    throw cancelException;
                }
                catch (Exception cancelException) {
                    // empty catch block
                }
                if (planningException.length() <= 0) break;
                if (i < hiersWithCalcDefaultMember.size()) {
                    maskHiers.add(hiersWithCalcDefaultMember.get(i));
                }
                lastException = planningException;
            }
            if (maskHiers.size() > 0 && (maskHiers.size() != hiersWithCalcDefaultMember.size() || planningException.length() <= 0)) {
                StringBuilder hiers = new StringBuilder();
                for (IHierarchy h : maskHiers) {
                    ((ROLAPHierarchy)h).setDefaultMember(null);
                    hiers.append(h.getUniqueName());
                    hiers.append(COMMA_AND_SPACE);
                }
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedDefaultMember_INTERNAL, XQEMessages.getCurrProductLocale(), hiers.toString(), lastException.toString());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL));
            }
        }
    }

    protected List<IHierarchy> hierarchiesWithCalculatedDefaultMember() {
        ArrayList<IHierarchy> result = new ArrayList<IHierarchy>();
        List<IHierarchy> hierarchies = this.getHierarchies();
        for (IHierarchy h : hierarchies) {
            IMember m = h.getDefaultMember();
            if (!m.isCalculatedMember()) continue;
            result.add(h);
        }
        return result;
    }

    protected abstract void validateCalculatedMembers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateNamedSets() {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        try {
            ROLAPCubeReservation reservation = this.reserve();
            boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName(this.getName());
            try {
                ROLAPMemberCache currMemberCache = this.getMemberCacheInContext();
                SequencedHashMap namedSetMap = currMemberCache.getNamedSets();
                if (namedSetMap == null) {
                    return;
                }
                ArrayList<IROLAPNamedSet> invalidNamedSets = new ArrayList<IROLAPNamedSet>();
                for (IROLAPNamedSet namedSet : namedSetMap.values()) {
                    try {
                        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Validating named set: " + namedSet.getName());
                        String v5Expression = namedSet.getExpression();
                        if (!v5Expression.contains("#") && !v5Expression.contains("?")) {
                            HashSet<IMember> hierarchyMembers = V5ExpressionUtils.executeAndFetchMembers(null, this, v5Expression);
                            if (!hierarchyMembers.iterator().hasNext()) continue;
                            namedSet.setFirstMember(hierarchyMembers.iterator().next());
                            continue;
                        }
                        V5ExpressionUtils.checkV5ExpressionSyntax(v5Expression);
                    }
                    catch (OperationCanceledException cancelException) {
                        throw cancelException;
                    }
                    catch (XQERuntimeException e) {
                        String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidNamedSetDefinition, XQEMessages.getCurrProductLocale(), namedSet.getName(), this.getName());
                        ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                        invalidNamedSets.add(namedSet);
                    }
                    finally {
                        ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished validating named set: " + namedSet.getName());
                    }
                }
                currMemberCache.removeNamedSets(invalidNamedSets);
                if (invalidNamedSets.size() > 0) {
                    TimestampValue t = DataValueFactory.createTimestampValue();
                    t.set(System.currentTimeMillis());
                    this.setSchemaUpdatedDate(t);
                }
            }
            finally {
                this.unreserve(reservation);
                ROLAPContext.removeCurrentCubeName(needToRemoveCurrentCubeName);
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    @Override
    public void addInvalidCalculatedMember(IHierarchy hierarchy, String calculatedMemberName) {
        this.getMemberCacheInContext().addInvalidCalculatedMember(hierarchy, String.format("[%s]", calculatedMemberName));
    }

    private Set<String> getInvalidCalculatedMembers(IHierarchy hierarchy) {
        return this.getMemberCacheInContext().getInvalidCalculatedMembers(hierarchy);
    }

    protected void addMessageInvalidCalculatedMembersWereRemoved(IHierarchy hierarchy) {
        Set<String> invalidCalculatedMembers = this.getInvalidCalculatedMembers(hierarchy);
        if (invalidCalculatedMembers != null && !invalidCalculatedMembers.isEmpty()) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_InvalidCalculatedMembersWereRemoved, invalidCalculatedMembers.toString(), hierarchy.getUniqueName());
        }
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void forceStop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean forceStop) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            ROLAPCubeStateContext cubeStateContext;
            registered = this.registerCurrentThread(forceStop);
            this.checkOperationAllowed(true);
            if (forceStop) {
                if (!registered) {
                    return;
                }
                this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStopExecuting);
                this.cancelAndWaitForCurrentThreads();
            }
            if (!this.mStateMachine.extendedTransition(ROLAPCubeStateEnum.STOPPING, cubeStateContext = new ROLAPCubeStateContext(this, forceStop))) {
                if (forceStop) {
                    this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStopSucceeded);
                }
                return;
            }
            try {
                if (!forceStop) {
                    this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStopExecuting);
                    long timeLeft = ROLAPCubeManager.setUpAdminWait();
                    while (this.getReservationCount() != 0) {
                        if (timeLeft <= 0L) {
                            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeLocked, new ROLAPCubeNameWrapper(this.getName()));
                        }
                        this.throwExceptionIfCurrentThreadIsInterrupted();
                        timeLeft = ROLAPCubeManager.adminWait(timeLeft, this.reservationCount);
                    }
                }
            }
            catch (Throwable t) {
                this.mStateMachine.setState(ROLAPCubeStateEnum.RUNNING);
                throw t;
            }
            try {
                this.stopCubeImpl();
            }
            finally {
                this.mStateMachine.setState(this.configuration.getInitialState());
            }
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStopSucceeded);
            this.getMetrics().recordCubeStartTime(0L);
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeStopFailed, t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(forceStop, registered);
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDataCache() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            try {
                this.checkOperationAllowed(false);
            }
            catch (Throwable t) {
                this.getMessages().addMessage(XQEMessageKeys.RLU_DataCacheRefreshFailed, t);
                throw t;
            }
            ROLAPCacheUpdater.synchronizeUpdate(this, this.mDataCacheProcessor, ROLAPCubeAction.REFRESH_DATA_CACHE);
        }
        catch (Throwable t) {
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshMemberCache() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            try {
                this.checkOperationAllowed(false);
            }
            catch (Throwable t) {
                this.getMessages().addMessage(XQEMessageKeys.RLU_MemberCacheRefreshFailed, t);
                throw t;
            }
            ROLAPCacheUpdater.synchronizeUpdate(this, this.mMemberCacheProcessor, ROLAPCubeAction.REFRESH_MEMBER_CACHE);
            ROLAPMemberCache cache = this.mMemberCacheManager.getCurrentRevision();
            List<IDimension> dims = cache.getDimensions();
            ArrayList<String> list = new ArrayList<String>();
            for (IDimension dim : dims) {
                if (!dim.isShareable()) continue;
                list.add(dim.getName());
            }
            if (!list.isEmpty()) {
                this.getMessages().addMessage(XQEMessageKeys.RLU_SharedDimensionsNotRefreshed, list.toString());
            }
        }
        catch (Throwable t) {
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    @Override
    public void delete() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        try {
            ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteBegan, XQEMessages.getCurrProductLocale()));
            ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteBegan, XQEMessages.getCurrProductLocale()));
            this.isDeleted = true;
            if (this.isEnabled()) {
                this.forceStop();
            }
            ROLAPCubeManager.getInstance().removeCube(this);
            ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteSucceeded, XQEMessages.getCurrProductLocale()));
            ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteSucceeded, XQEMessages.getCurrProductLocale()));
            this.release();
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteFailed, XQEMessages.getCurrProductLocale()), t);
            ROLAPLog.logError("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_CubeDeleteFailed, XQEMessages.getCurrProductLocale()), t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshSecurity() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            try {
                this.checkOperationAllowed(false);
            }
            catch (Throwable t) {
                this.getMessages().addMessage(XQEMessageKeys.RLU_SecurityRefreshFailed, t);
                throw t;
            }
            ROLAPCacheUpdater.synchronizeUpdate(this, this.mSecurityCacheProcessor, ROLAPCubeAction.REFRESH_SECURITY);
        }
        catch (Throwable t) {
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWorkloadLog() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            this.checkOperationAllowed(false);
            this.getMessages().addMessage(XQEMessageKeys.RLU_ClearWorkloadLogExecuting);
            ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_ClearWorkloadLogExecuting, XQEMessages.getCurrProductLocale()));
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    ROLAPCube.this.clearWorkloadLogImpl();
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.DISABLED);
            set.add(ROLAPCubeStateEnum.STOPPED);
            set.add(ROLAPCubeStateEnum.PAUSED);
            if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotUseStoppingCube, new ROLAPCubeNameWrapper(this.getName()));
            }
            this.getMessages().addMessage(XQEMessageKeys.RLU_ClearWorkloadLogSucceeded);
            ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_ClearWorkloadLogSucceeded, XQEMessages.getCurrProductLocale()));
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_ClearWorkloadLogFailed, t);
            ROLAPLog.logError("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_ClearWorkloadLogFailed, XQEMessages.getCurrProductLocale()), t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeRestartExecuting);
            this.stop();
            this.start(false, false, false, false);
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeRestartSucceeded);
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubeRestartFailed, t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
        this.fireStartupTrigger();
        this.loadInMemoryAggregatesAsynchronously();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            this.checkOperationAllowed(true);
            if (this.isPaused()) {
                return;
            }
            if (!this.isRunning()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, this.getName());
            }
            registered = this.registerCurrentThread(false);
            if (!registered) {
                return;
            }
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubePauseExecuting);
            ROLAPCubeStateContext cubeStateContext = new ROLAPCubeStateContext(this);
            try {
                if (!this.mStateMachine.extendedTransition(ROLAPCubeStateEnum.PAUSING, cubeStateContext)) {
                    return;
                }
            }
            catch (CannotAcquireLockInExclusiveModeException e) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeBusyCannotBePaused, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.getName()));
            }
            try {
                this.cancelQueries();
                long timeLeft = ROLAPCubeManager.setUpAdminWait();
                while (this.getReservationCount() != 0) {
                    if (timeLeft <= 0L) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_CubeLocked, new ROLAPCubeNameWrapper(this.getName()));
                    }
                    this.throwExceptionIfCurrentThreadIsInterrupted();
                    timeLeft = ROLAPCubeManager.adminWait(timeLeft, this.reservationCount);
                }
            }
            catch (Throwable t) {
                this.mStateMachine.setState(ROLAPCubeStateEnum.RUNNING);
                throw t;
            }
            this.pauseImpl();
            this.mStateMachine.extendedTransition(ROLAPCubeStateEnum.PAUSED, cubeStateContext);
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubePauseSucceeded);
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_CubePauseFailed, t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    protected void pauseImpl() {
    }

    public void waitForStart(boolean indefinitely) {
        try {
            if (!this.mStateMachine.waitForTransition(ROLAPCubeStateEnum.STARTING, ROLAPCubeStateEnum.RUNNING, new ROLAPCubeStateContext(this), indefinitely)) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, new ROLAPCubeNameWrapper(this.getName()));
            }
        }
        catch (IllegalStateException e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
    }

    protected String constructDatasourceBasePath() {
        if (this.isVirtual()) {
            return ROLAPCube.constructVirtualDatasourceBasePath(this.getName());
        }
        return PATTERN.matcher(CM_ROLAPDATASOURCE_SEARCH_PATH_TEMPLATE).replaceAll(this.getName());
    }

    private static String constructVirtualDatasourceBasePath(String name) {
        return PATTERN.matcher(CM_ROLAPVIRTUALDATASOURCE_SEARCH_PATH_TEMPLATE).replaceAll(name);
    }

    public String getModelSearchPath() {
        return this.modeSearchPath;
    }

    public static ROLAPCubeInfo loadCubeInfo(String cubeName) {
        ROLAPCubeInfo cubeInfo = null;
        try {
            String dataSourceBasePath = PATTERN.matcher(CM_ROLAPDATASOURCE_SEARCH_PATH_TEMPLATE).replaceAll(cubeName) + " | " + PATTERN.matcher(CM_ROLAPVIRTUALDATASOURCE_SEARCH_PATH_TEMPLATE).replaceAll(cubeName);
            List<CMClass> resultList = ContentManager.getProperties(dataSourceBasePath, PropEnum.defaultName.getValue(), PropEnum.name.getValue());
            Iterator<CMClass> it = resultList.iterator();
            if (!it.hasNext()) {
                return null;
            }
            CMClass cls = it.next();
            cubeInfo = new ROLAPCubeInfo(cls.getCMClassName().equals(ROLAPVIRTUALDATASOURCE_TYPE));
            Element elt = cls.getPropertyAsElement(PropEnum.defaultName.getValue());
            if (elt != null) {
                cubeInfo.setDefaultName(elt.element(VALUE_PROPERTY).getText());
            }
            if ((elt = cls.getPropertyAsElement(PropEnum.name.getValue())) != null && (elt = elt.element(VALUE_PROPERTY)) != null) {
                List<Element> items = CollectionCast.uncheckedCast(elt.elements(ITEM_PROPERTY));
                for (Element anItem : items) {
                    cubeInfo.setName(anItem.element("locale").getText(), anItem.element(VALUE_PROPERTY).getText());
                }
            }
        }
        catch (CMException e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeInitFailed, e.getCause(), (Object)new ROLAPCubeNameWrapper(cubeName));
        }
        ROLAPLog.log("ROLAPCubes.Info", "Cube information loaded: " + cubeInfo.toString());
        return cubeInfo;
    }

    public ROLAPMemberCache getMemberCacheInContext() {
        ROLAPContext context = ROLAPContext.get();
        ROLAPCubeReservation res = context.getReservation(this);
        if (res == null) {
            throw new IllegalStateException(String.format("Cannot retrieve member cache reference, ROLAP cube \"%s\" has not been reserved.", this.getName()));
        }
        return res.getMemberCache();
    }

    public ROLAPDataCache getDataCacheInContext() {
        ROLAPContext context = ROLAPContext.get();
        ROLAPCubeReservation res = context.getReservation(this);
        if (res == null) {
            throw new IllegalStateException(String.format("Cannot retrieve data cache reference, ROLAP cube \"%s\" has not been reserved.", this.getName()));
        }
        return res.getDataCache();
    }

    public IncrementManager getIncrementManagerInContext() {
        ROLAPDataCache dc = this.getDataCacheInContext();
        if (dc == null) {
            return null;
        }
        return dc.getIncrementManager();
    }

    public void registerReservation(ROLAPCubeReservation res, IExecutionEnvironment env) {
        this.acquireLock(this.registrationUniqueName, false);
        try {
            if (this.isForceStopping.get()) {
                throw new OperationCanceledException();
            }
            this.mReservations.put(res, env);
        }
        finally {
            this.releaseLock(this.registrationUniqueName, false);
        }
    }

    public void deregisterReservation(ROLAPCubeReservation res) {
        this.mReservations.remove(res);
    }

    @Override
    public TabularData getReservationInfo() {
        try {
            TabularDataSupport tds = new TabularDataSupport(this.reservationsTabularType);
            for (ROLAPCubeReservation res : this.mReservations.keySet()) {
                int dataCacheID = -1;
                if (res.getDataCache() != null) {
                    dataCacheID = res.getDataCache().getID();
                }
                int securityCacheID = -1;
                if (res.getSecurityCache() != null) {
                    securityCacheID = res.getSecurityCache().getID();
                }
                CompositeDataSupport cds = new CompositeDataSupport(this.reservationsCompositeType, RESERVATION_FIELDS, new Object[]{res.getID(), res.getMemberCache().getID(), dataCacheID, securityCacheID, new Date(res.getTimestamp())});
                tds.put(cds);
            }
            return tds;
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
    }

    public void onMemberCacheReleased(int memberCacheRevision) {
        if (null != this.resultSetCache) {
            ResultSetCacheExpiringVisitor visitor = new ResultSetCacheExpiringVisitor(memberCacheRevision, null);
            this.resultSetCache.visit(visitor);
            this.resultSetCache.runMaintenance();
        }
    }

    public void onDataCacheReleased(int memberCacheRevision, int dataCacheRevision) {
        if (null != this.resultSetCache) {
            ResultSetCacheExpiringVisitor visitor = new ResultSetCacheExpiringVisitor(memberCacheRevision, dataCacheRevision);
            this.resultSetCache.visit(visitor);
            this.resultSetCache.runMaintenance();
        }
    }

    private void initializeResultSetCache() throws IOException {
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        StringBuilder pathBuilder = new StringBuilder(cubeManager.getConfigResultSetCacheFolder());
        pathBuilder.append(File.separatorChar).append(TraceLogManager.escapeName(this.getName()));
        this.resultSetCache = new IncrementAwareDiskBackedResultSetCache(this, new ROLAPResultSetCacheKeyMaker(), new File(pathBuilder.toString()), cubeManager.getConfigResultSetCacheEncrypted(), cubeManager.getBufferPool());
        ((DiskBackedCubeResultSetCache)this.resultSetCache).registerListener(this.getMetrics().getResultSetCacheListener());
        this.resultSetCache.setMaxCacheSize(0x100000L * (long)this.configuration.getResultSetCacheSizeLimit());
    }

    @Override
    public boolean multipleHierarchySupport() {
        return true;
    }

    @Override
    public SecurityManagerInterface getSecurityManager() {
        ROLAPContext context = ROLAPContext.get();
        ROLAPCubeReservation res = context.getReservation(this);
        if (res == null) {
            throw new IllegalStateException(String.format("Cannot retrieve security manager because ROLAP cube \"%s\" has not been reserved.", this.getName()));
        }
        ROLAPSecurityCache securityCache = res.getSecurityCache();
        if (securityCache == null) {
            return null;
        }
        return securityCache.getSecurityManager();
    }

    public abstract ROLAPMemberCache createMemberCache();

    public abstract ROLAPDataCache createDataCache(ROLAPCacheBase var1);

    @Override
    public SecurityManagerInterface getSecurityManager(Provider p) {
        return this.getSecurityManager();
    }

    @Override
    public IDimension getDimension(String dimName) {
        return this.getMemberCacheInContext().getDimension(dimName);
    }

    @Override
    public IDimension getDimension(int index) {
        return this.getMemberCacheInContext().getDimension(index);
    }

    @Override
    public List<IDimension> getDimensions() {
        return this.getMemberCacheInContext().getDimensions();
    }

    @Override
    public Object[] getDimensionsToArray(Object[] o) {
        return this.getMemberCacheInContext().getDimensionsToArray(o);
    }

    @Override
    public int getDimensionIndex(IDimension d) {
        return this.getMemberCacheInContext().getDimensionIndex(d);
    }

    @Override
    public int getDimensionCount() {
        return this.getMemberCacheInContext().getDimensionCount();
    }

    @Override
    public void addDimension(IDimension dim) {
        this.getMemberCacheInContext().addDimension(dim);
    }

    @Override
    public TabularData getCacheInfo() {
        try {
            TabularDataSupport tds = new TabularDataSupport(this.memberCacheTabularType);
            if (this.mMemberCacheManager != null) {
                List<ROLAPMemberCache> memberCacheList = this.mMemberCacheManager.getCacheRevisions();
                boolean bCurrentMemberCache = true;
                for (ROLAPMemberCache memberCache : memberCacheList) {
                    TabularDataSupport dataCacheTds = new TabularDataSupport(this.dataCacheTabularType);
                    List<ROLAPDataCache> dataCacheList = memberCache.getDataCacheManager().getCacheRevisions();
                    boolean bCurrentDataCache = true;
                    for (ROLAPDataCache dataCache : dataCacheList) {
                        CompositeDataSupport dataCacheCds = new CompositeDataSupport(this.dataCacheCompositeType, DATA_CACHE_FIELDS, new Object[]{bCurrentDataCache, dataCache.getID(), dataCache.getReservationCount(), dataCache.getSoftReservationCount(), dataCache.getTupleStorageMetrics().getMisses(), new Date(dataCache.getTimestamp())});
                        dataCacheTds.put(dataCacheCds);
                        bCurrentDataCache = false;
                    }
                    TabularDataSupport securityCacheTds = new TabularDataSupport(this.securityCacheTabularType);
                    List<ROLAPSecurityCache> securityCacheList = memberCache.getSecurityCacheManager().getCacheRevisions();
                    boolean bCurrentSecurityCache = true;
                    for (ROLAPSecurityCache securityCache : securityCacheList) {
                        SecManager secManager = (SecManager)securityCache.getSecurityManager();
                        SecurityLookupQueryCache lookupCache = secManager.getLookupQueryCache();
                        CompositeDataSupport securityCacheCds = new CompositeDataSupport(this.securityCacheCompositeType, SECURITY_CACHE_FIELDS, new Object[]{bCurrentSecurityCache, securityCache.getID(), securityCache.getReservationCount(), securityCache.getSoftReservationCount(), new Date(securityCache.getTimestamp()), lookupCache.getQueryCacheSize(), lookupCache.getTotalCachedMemberCount()});
                        securityCacheTds.put(securityCacheCds);
                        bCurrentSecurityCache = false;
                    }
                    CompositeDataSupport cds = new CompositeDataSupport(this.memberCacheCompositeType, MEMBER_CACHE_FIELDS, new Object[]{bCurrentMemberCache, memberCache.getID(), memberCache.getReservationCount(), memberCache.getSoftReservationCount(), memberCache.getCachedMemberCount(), dataCacheTds, securityCacheTds, new Date(memberCache.getTimestamp())});
                    tds.put(cds);
                    bCurrentMemberCache = false;
                }
            }
            return tds;
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public void addMeasuresDimension() throws ProviderException {
    }

    @Override
    public String[] getAdminMessages() {
        return this.getMessages().getRenderedMessages();
    }

    public void addCalculatedMember(CalculatedMember cm) {
        this.getMemberCacheInContext().addCalculatedMember(cm);
    }

    @Override
    public void removeCalculatedMembers(List<ROLAPCalculatedMember> calcsToRemove) {
        this.getMemberCacheInContext().removeCalculatedMembers(calcsToRemove);
    }

    @Override
    public Map getCalculatedMembers() {
        return this.getMemberCacheInContext().getCalculatedMembers();
    }

    @Override
    public CalculatedMember getCalculatedMember(String memberUniqueName) {
        return this.getMemberCacheInContext().getCalculatedMember(memberUniqueName);
    }

    @Override
    public ArrayList<CalculatedMember> getCalculations(IDimension d) {
        return this.getMemberCacheInContext().getCalculations(d);
    }

    @Override
    public ArrayList<CalculatedMember> getCalculations(ILevel l) {
        return this.getMemberCacheInContext().getCalculations(l);
    }

    @Override
    public ArrayList<CalculatedMember> getCalculations(IMember parentMember) {
        return this.getMemberCacheInContext().getCalculations(parentMember);
    }

    @Override
    public void addNamedSet(INamedSet ns) {
    }

    public Map getNamedSets() {
        return this.getMemberCacheInContext().getNamedSets();
    }

    public int getTotalDataCacheNo() {
        int count = 0;
        if (this.mMemberCacheManager != null) {
            List<ROLAPMemberCache> revisions = this.mMemberCacheManager.getCacheRevisions();
            for (ROLAPMemberCache cache : revisions) {
                count += cache.getDataCacheNo();
            }
        }
        return count;
    }

    public int getTotalSecurityCacheNo() {
        int count = 0;
        if (this.mMemberCacheManager != null) {
            List<ROLAPMemberCache> revisions = this.mMemberCacheManager.getCacheRevisions();
            for (ROLAPMemberCache cache : revisions) {
                count += cache.getSecurityCacheNo();
            }
        }
        return count;
    }

    public static ROLAPMetaFacts getModelCubeFacts(ROLAPMetaCube cube) {
        ROLAPMetaObject parent;
        ROLAPMetaFacts metaFacts = null;
        if (cube != null && ROLAPMetaCubeModel.class.isInstance(parent = cube.getParent())) {
            metaFacts = ((ROLAPMetaCubeModel)parent).getFacts();
        }
        return metaFacts;
    }

    public boolean registerCurrentThread(boolean isForceStop) {
        if (isForceStop) {
            return this.registerCurrentThreadAsForceStopOperation();
        }
        return this.registerCurrentThreadAsNonForceStopOperation();
    }

    private boolean registerCurrentThreadAsForceStopOperation() {
        this.acquireLock(this.registrationUniqueName, true);
        try {
            boolean bl = this.isForceStopping.compareAndSet(false, true);
            return bl;
        }
        finally {
            this.releaseLock(this.registrationUniqueName, true);
        }
    }

    private boolean registerCurrentThreadAsNonForceStopOperation() {
        this.acquireLock(this.registrationUniqueName, false);
        try {
            boolean alreadyRegistered = this.currentThreads.containsKey(Thread.currentThread());
            if (this.isForceStopping.get()) {
                if (alreadyRegistered) {
                    throw new OperationCanceledException();
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotUseStoppingCube, new ROLAPCubeNameWrapper(this.getName()));
            }
            if (!alreadyRegistered) {
                this.currentThreads.put(Thread.currentThread(), new AtomicBoolean(false));
            }
            boolean bl = !alreadyRegistered;
            return bl;
        }
        finally {
            this.releaseLock(this.registrationUniqueName, false);
        }
    }

    public void deregisterCurrentThread(boolean isForceStop, boolean registered) {
        if (isForceStop) {
            this.deregisterCurrentThreadAsForceStopOperation(registered);
        } else {
            this.deregisterCurrentThreadAsNonForceStopOperation(registered);
        }
    }

    private void deregisterCurrentThreadAsForceStopOperation(boolean registered) {
        if (registered) {
            this.isForceStopping.set(false);
        }
    }

    private void deregisterCurrentThreadAsNonForceStopOperation(boolean registered) {
        if (registered) {
            this.currentThreads.remove(Thread.currentThread());
            ROLAPCubeManager.adminNotify(this.currentThreads);
        }
    }

    private void cancelAndWaitForCurrentThreads() {
        this.cancelReservations();
        this.cancelCurrentThreads();
        this.interruptCurrentThreads();
        this.waitUntilCurrentThreadsExitCriticalSections();
    }

    private void cancelQueries() {
        try {
            ROLAPLog.log("ROLAPCubes.Management", "Cancellation of queries began.");
            for (ROLAPCubeReservation res : this.mReservations.keySet()) {
                Set<IExecutionEnvironment> envSet = this.mReservations.get(res);
                if (envSet == null) continue;
                for (IExecutionEnvironment env : envSet) {
                    try {
                        env.getCancelManager().cancel();
                    }
                    catch (Throwable t) {
                        ROLAPLog.logError("ROLAPCubes.Management", "Query cancel failed ", t);
                        XQEDebugLog.err.printStackTrace(t);
                    }
                }
            }
            ROLAPLog.log("ROLAPCubes.Management", "Cancellation of queries succeeded.");
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Cancellation of queries failed.", t);
            throw XQERuntimeException.wrap(t);
        }
    }

    private void cancelReservations() {
        try {
            ROLAPLog.log("ROLAPCubes.Management", "Cancelation of reservations began.");
            for (ROLAPCubeReservation res : this.mReservations.keySet()) {
                Set<IExecutionEnvironment> envSet = this.mReservations.get(res);
                if (envSet == null) continue;
                for (IExecutionEnvironment env : envSet) {
                    try {
                        env.getCancelManager().cancel();
                    }
                    catch (Throwable t) {
                        ROLAPLog.logError("ROLAPCubes.Management", "Query cancel failed", t);
                        XQEDebugLog.err.printStackTrace(t);
                    }
                }
                int reservationID = res.getID();
                int memberCacheID = -1;
                int dataCacheID = -1;
                int securityCacheID = -1;
                if (!res.isInvalid()) {
                    ROLAPSecurityCache securityCache;
                    ROLAPDataCache dataCache;
                    ROLAPMemberCache memberCache = res.getMemberCache();
                    if (memberCache != null) {
                        memberCacheID = memberCache.getID();
                    }
                    if ((dataCache = res.getDataCache()) != null) {
                        dataCacheID = dataCache.getID();
                    }
                    if ((securityCache = res.getSecurityCache()) != null) {
                        securityCacheID = securityCache.getID();
                    }
                }
                res.invalidate();
                ROLAPLog.log("ROLAPCubes.Management", String.format("Reservation %d (memberCache=%d, dataCache=%d, securityCache=%d) was invalidated.", reservationID, memberCacheID, dataCacheID, securityCacheID));
            }
            ROLAPLog.log("ROLAPCubes.Management", "Cancelation of reservations succeeded.");
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Cancelation of reservations failed.", t);
            throw XQERuntimeException.wrap(t);
        }
    }

    private void cancelCurrentThreads() {
        try {
            ROLAPLog.log("ROLAPCubes.Management", "Cancelation of threads began.");
            Set threads = this.currentThreads.keySet();
            for (Thread thread : threads) {
                AtomicBoolean interrupted = this.currentThreads.get(thread);
                if (interrupted == null) continue;
                interrupted.set(true);
                ROLAPLog.log("ROLAPCubes.Management", String.format("The interrupted status of thread %d was set.", thread.getId()));
            }
            ROLAPLog.log("ROLAPCubes.Management", "Cancelation of threads succeeded.");
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Cancelation of threads failed.", t);
            throw XQERuntimeException.wrap(t);
        }
    }

    private void interruptCurrentThreads() {
        try {
            ROLAPLog.log("ROLAPCubes.Management", "Interruption of threads began.");
            Set threads = this.currentThreads.keySet();
            for (Thread thread : threads) {
                AtomicBoolean interrupted = this.currentThreads.get(thread);
                if (interrupted == null) continue;
                try {
                    thread.interrupt();
                    ROLAPLog.log("ROLAPCubes.Management", String.format("Thread %d was interrupted.", thread.getId()));
                }
                catch (Throwable t) {
                    ROLAPLog.logError("ROLAPCubes.Management", String.format("Thread %d was not interrupted.", thread.getId()), t);
                }
            }
            ROLAPLog.log("ROLAPCubes.Management", "Interruption of threads succeeded.");
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Interruption of threads failed.", t);
            throw XQERuntimeException.wrap(t);
        }
    }

    private void waitUntilCurrentThreadsExitCriticalSections() {
        while (!this.currentThreads.isEmpty()) {
            if (ROLAPLog.isOn("ROLAPCubes.Management", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Management", String.format("Waiting for interrupted threads %s to exit critical sections", this.getCurrentThreadIds()));
            }
            ROLAPCubeManager.adminWait(5000L, this.currentThreads);
            if (!ROLAPCubeManager.getInstance().isShuttingDown()) continue;
            if (!ROLAPLog.isOn("ROLAPCubes.Management", LogLevel.ERROR)) break;
            ROLAPLog.log("ROLAPCubes.Management", String.format("Ignoring threads %s that are still executing admin operations", this.getCurrentThreadIds()));
            break;
        }
    }

    private String getCurrentThreadIds() {
        StringBuilder sb = new StringBuilder(OPEN_BRACKET);
        Enumeration<Thread> threads = this.currentThreads.keys();
        while (threads.hasMoreElements()) {
            Thread thread = threads.nextElement();
            sb.append(thread.getId());
            if (!threads.hasMoreElements()) continue;
            sb.append(COMMA_AND_SPACE);
        }
        sb.append(CLOSED_BRACKET);
        return sb.toString();
    }

    public void throwExceptionIfCurrentThreadIsInterrupted() {
        AtomicBoolean interrupted = this.currentThreads.get(Thread.currentThread());
        if (interrupted != null && interrupted.get()) {
            throw new OperationCanceledException();
        }
    }

    public ILocalizedString getLocalizedCaption() {
        return null;
    }

    public ILocalizedString getNames() {
        return null;
    }

    public ILocalizedString getDescriptions() {
        return null;
    }

    private void acquireLock(String resource, boolean exclusive) {
        this.acquireLockImpl(resource, exclusive, this.lockWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(String resource, boolean exclusive, AtomicLong waitTime) {
        long startTime = System.nanoTime();
        try {
            this.acquireLockImpl(resource, exclusive, waitTime.get());
        }
        finally {
            ROLAPCubeManager.updateRemainingWaitTime(waitTime, startTime);
        }
    }

    private void acquireLockImpl(String resource, boolean exclusive, long waitTime) {
        this.throwExceptionIfCurrentThreadIsInterrupted();
        if (exclusive) {
            this.lockManager.acquireLockInExclusiveMode(resource, waitTime);
        } else {
            this.lockManager.acquireLockInSharedMode(resource, waitTime);
        }
    }

    private void releaseLock(String resource, boolean exclusive) {
        if (exclusive) {
            this.lockManager.releaseLockInExclusiveMode(resource);
        } else {
            this.lockManager.releaseLockInSharedMode(resource);
        }
    }

    public WorkloadLogger getWorkloadLogger() {
        return this.workloadLogger;
    }

    public void setWorkloadLogger(WorkloadLogger logger) {
        this.workloadLogger = logger;
    }

    public static String getRelativeWorkloadLogFolder(String cubeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(File.separatorChar).append("ROLAPCubes").append(File.separatorChar).append(cubeName);
        return sb.toString();
    }

    protected void validateAggregateCubes() {
    }

    public ROLAPMetaMdSchema loadSchema() throws Exception {
        ROLAPMetaMdSchema loadedSchema;
        String schemaFile = null;
        try {
            schemaFile = ConnectionPropertyUtilities.getPropertyValue(this.getName(), "schema");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (schemaFile != null) {
            String dataSourceDriver = ConnectionPropertyUtilities.getPropertyValue(this.getName(), "driver");
            if (dataSourceDriver != null && dataSourceDriver.length() > 0) {
                Class.forName(dataSourceDriver);
            }
            loadedSchema = ROLAPCube.getSchema(this.getName());
        } else {
            loadedSchema = this.getSchemaFromCM();
        }
        return loadedSchema;
    }

    public static ROLAPMetaMdSchema getSchema(String cubeName) throws Exception {
        StringBuilder buffer;
        BufferedReader reader;
        ROLAPMetaMdSchema loadedSchema = null;
        String schemaFile = ConnectionPropertyUtilities.getPropertyValue(cubeName, "schema");
        String schemaString = null;
        if (schemaFile != null) {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(schemaFile)), "UTF-8"));
            buffer = new StringBuilder();
            String lineSeparator = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append(lineSeparator);
            }
        } else {
            throw new Exception("No entry found in the connection properties file for cube: " + cubeName);
        }
        reader.close();
        schemaString = buffer.toString();
        if (schemaString != null) {
            loadedSchema = ROLAPMetaObject.parse(schemaString);
        }
        return loadedSchema;
    }

    private ROLAPMetaMdSchema getSchemaFromCM() throws Exception {
        String escapedCubeModelXML = null;
        ROLAPMetaMdSchema loadedSchema = null;
        Element biBusHeader = new BIBusEnvelope().getBIBusHeader().createCopy();
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setRequestHeader((Element)biBusHeader.clone());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        ExecutionEnvironment execEnv = envHelper.getExecutionEnvironment();
        try {
            MetadataConnection metadataConnection = MetadataService.getInstance().getConnectionForceCMTrusted("MFW4J", this.getModelSearchPath(), execEnv, true);
            this.setConnection(metadataConnection);
            this.datasource = null;
            MFWGateway mfwGateway = metadataConnection.getGateway().getGatewayImpl();
            MFWNodeHandle[] mfwHandleRootNSs = mfwGateway.query(MFWQuerySpec.create((String)"/project/namespace[0]"));
            if (mfwHandleRootNSs != null && mfwHandleRootNSs.length > 0) {
                MFWModelRes mfwModelRes = MFWModelRes.getInstance();
                MFWNodeHandle[] mfwHandleRolapSourceProperties = mfwGateway.findChildObjects(mfwHandleRootNSs[0], mfwModelRes.RID_property, mfwModelRes.RID_name, "ROLAPSource");
                escapedCubeModelXML = mfwGateway.getObjectPropertyValue(mfwHandleRolapSourceProperties[0], mfwModelRes.RID__Value);
            }
        }
        catch (Throwable th) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_FailedToRetrieveCubeModel, th, (Object)new ROLAPCubeNameWrapper(this.getName()));
        }
        finally {
            envHelper.tearDownEnvironment();
        }
        if (escapedCubeModelXML != null) {
            try {
                String cubeModelXML = escapedCubeModelXML;
                if (escapedCubeModelXML.contains("&lt;olap:metadata")) {
                    cubeModelXML = StringEscapeUtils.unescapeXml((String)escapedCubeModelXML);
                }
                loadedSchema = ROLAPMetaObject.parse(cubeModelXML);
            }
            catch (Throwable t) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_FailedToParseCubeModel, t, (Object)new ROLAPCubeNameWrapper(this.getName()));
            }
        }
        return loadedSchema;
    }

    public void loadInMemoryAggregatesAsynchronously() {
    }

    public ROLAPDataCache getCurrentDataCache() {
        ROLAPCacheManager<ROLAPDataCache> dataCacheManager;
        ROLAPMemberCache currentMemberCache;
        ROLAPCacheManager<ROLAPMemberCache> memberCacheManager = this.mMemberCacheManager;
        if (memberCacheManager != null && (currentMemberCache = memberCacheManager.getCurrentRevision()) != null && (dataCacheManager = currentMemberCache.getDataCacheManager()) != null) {
            return dataCacheManager.getCurrentRevision();
        }
        return null;
    }

    public static TabularType getCubeListType() {
        return CUBE_LIST_TYPE;
    }

    public TabularData getDependentCubesMetricValues() {
        TabularDataSupport tds = new TabularDataSupport(CUBE_LIST_TYPE);
        int i = 0;
        for (ROLAPCube cube : this.mDependentCubes.keySet()) {
            CompositeDataSupport cds;
            if (cube == null) continue;
            try {
                cds = new CompositeDataSupport(CUBE_NAME_TYPE, CUBE_NAME_FIELDS, new Object[]{new Integer(i), cube.getName()});
            }
            catch (OpenDataException oe) {
                throw new XQERuntimeException(oe);
            }
            tds.put(cds);
            ++i;
        }
        return tds;
    }

    public TabularData getSourceCubesMetricValues() {
        return new TabularDataSupport(CUBE_LIST_TYPE);
    }

    public TabularData getStoppedSourceCubesMetricValues() {
        return new TabularDataSupport(CUBE_LIST_TYPE);
    }

    public TabularData getRunningDependentCubesMetricValues() {
        TabularDataSupport tds = new TabularDataSupport(CUBE_LIST_TYPE);
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        HashSet<String> usedNames = new HashSet<String>();
        int i = 0;
        for (String cubeName : this.mAllDependentCubeNamesMetricValue) {
            CompositeDataSupport cds;
            ROLAPCube cube;
            if (cubeName == null || (cube = cubeManager.getCube(cubeName)).getState() != ROLAPCubeStateEnum.STARTING && cube.getState() != ROLAPCubeStateEnum.RUNNING || usedNames.contains(cubeName)) continue;
            usedNames.add(cubeName);
            try {
                cds = new CompositeDataSupport(CUBE_NAME_TYPE, CUBE_NAME_FIELDS, new Object[]{new Integer(i), cube.getName()});
            }
            catch (OpenDataException oe) {
                throw new XQERuntimeException(oe);
            }
            tds.put(cds);
            ++i;
        }
        return tds;
    }

    @Override
    public String getName(String locale) {
        return null;
    }

    private void getAllDependents(ROLAPCube cube, ArrayList<String> dependents) {
        for (ROLAPCube dependent : cube.getDependentCubes()) {
            if (dependent == null) continue;
            this.getAllDependents(dependent, dependents);
            dependents.add(dependent.getName());
        }
    }

    public void acquireStateLock() {
        this.mStateMachine.acquireStateLock(new ROLAPCubeStateContext(this));
    }

    public void releaseStateLock() {
        this.mStateMachine.releaseStateLock();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public IModelDataSource getModelDataSource() {
        if (this.datasource != null) {
            return this.datasource;
        }
        if (super.getModelDataSource() != null) {
            this.datasource = super.getModelDataSource();
        } else if (this.getConnection() != null) {
            this.datasource = this.getConnection().getModelDataSources().get(0);
        }
        return this.datasource;
    }

    public QueryEnvironmentHelper setUpExecutionEnvironment(boolean internalUse, boolean monitorResources) {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.getAccountManager());
        envHelper.setInternalUse(internalUse);
        envHelper.setUpEnvironment(true, monitorResources);
        return envHelper;
    }

    public void updateConfiguration() {
        ROLAPCubeConfiguration conf = this.getLatestConfiguration();
        this.updateConfigurationDisabled(conf);
        this.updateConfigurationAggregateLoggingEnabled(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurationDisabled(ROLAPCubeConfiguration conf) {
        final boolean newStateDisabled = conf.isDisabled();
        this.configuration.setDisabled(newStateDisabled);
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        try {
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    if (newStateDisabled) {
                        if (ROLAPCube.this.mStateMachine.getState() == ROLAPCubeStateEnum.STOPPED) {
                            ROLAPCube.this.mStateMachine.setState(ROLAPCubeStateEnum.DISABLED);
                            ROLAPLog.log("ROLAPCubes.Info", "Cube disabled");
                        }
                    } else if (ROLAPCube.this.mStateMachine.getState() == ROLAPCubeStateEnum.DISABLED) {
                        ROLAPCube.this.mStateMachine.setState(ROLAPCubeStateEnum.STOPPED);
                        ROLAPLog.log("ROLAPCubes.Info", "Cube enabled");
                    }
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.DISABLED);
            set.add(ROLAPCubeStateEnum.STOPPED);
            this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this), true);
        }
        finally {
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurationAggregateLoggingEnabled(final ROLAPCubeConfiguration latestConfiguration) {
        if (this.getConfigAutoAggrOptimizationEnum() == ROLAPCubeConfiguration.AutoAggrOptimization.On) {
            return;
        }
        boolean wasAggregateLoggingEnabled = this.configuration.isAggregateLoggingEnabled();
        boolean isAggregateLoggingEnabled = latestConfiguration.isAggregateLoggingEnabled();
        if (!wasAggregateLoggingEnabled && !isAggregateLoggingEnabled || wasAggregateLoggingEnabled && isAggregateLoggingEnabled) {
            return;
        }
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        try {
            ROLAPCubeStateEnum currentCubeState;
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    boolean isAggregateLoggingEnabled = latestConfiguration.isAggregateLoggingEnabled();
                    ROLAPCube.this.configuration.setAggregateLoggingEnabled(isAggregateLoggingEnabled);
                    if (isAggregateLoggingEnabled) {
                        ROLAPCube.this.getWorkloadLogger().startLogging();
                        ROLAPLog.log("ROLAPCubes.Info", "Workload logging was enabled.");
                    } else {
                        ROLAPCube.this.getWorkloadLogger().stopLogging();
                        ROLAPLog.log("ROLAPCubes.Info", "Workload logging was disabled.");
                    }
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.PAUSED);
            if (!(this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this)) || (currentCubeState = this.getState()) != ROLAPCubeStateEnum.STARTING && currentCubeState != ROLAPCubeStateEnum.PAUSING && currentCubeState != ROLAPCubeStateEnum.STOPPING)) {
                ROLAPLog.logWarn("ROLAPCubes.Info", String.format("Workload logging cannot be changed while the cube is in the transitional state: %s.", new Object[]{currentCubeState}));
            }
        }
        finally {
            traceContext.exit();
        }
    }

    protected void checkOperationAllowed(boolean allowedForVCs) {
        if (this.getState() == ROLAPCubeStateEnum.DISABLED) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CubeDisabled, new ROLAPCubeNameWrapper(this.getName()));
        }
        if (this.isVirtual() && !allowedForVCs) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_OperationDoesNotApplyToVirtualCubes);
        }
    }

    void setParameters(RequestEnvironment reqEnv, String[][] parameterMap) {
        if (parameterMap != null) {
            ParameterMapCM parMap = new ParameterMapCM(reqEnv);
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (String[] val : parameterMap) {
                ArrayList<String> value = new ArrayList<String>();
                for (int i = 0; i < val.length; ++i) {
                    if (i == 0) continue;
                    value.add(val[i]);
                }
                if (val.length == 0 || val[0] == null) continue;
                map.put(val[0], value);
            }
            if (map.size() != 0) {
                parMap.setParameterMap(map);
                ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContext().setCMMap(parMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String incrementallyLoad(final String strTID) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        String returnMsg = null;
        boolean registered = false;
        try {
            int numCurrentlyExecutingRequests = this.loadNextIncrementCount.incrementAndGet();
            if (numCurrentlyExecutingRequests <= 2) {
                registered = this.registerCurrentThread(false);
                this.checkOperationAllowed(false);
                this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementExecuting);
                ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementExecuting, XQEMessages.getCurrProductLocale()));
                Runnable work = new Runnable(){

                    @Override
                    public void run() {
                        ROLAPCube.this.incrementallyLoadImpl(strTID);
                    }
                };
                HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
                set.add(ROLAPCubeStateEnum.RUNNING);
                set.add(ROLAPCubeStateEnum.PAUSED);
                if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
                }
                IncrementMetrics im = this.getLastestIncrementMetrics();
                if (im != null) {
                    if (im.didIncrementHaveNewData()) {
                        returnMsg = XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNewValues, XQEMessages.getCurrProductLocale(), im.getTID());
                        this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNewValues, im.getTID());
                    } else if (strTID != null) {
                        returnMsg = XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNoNewValues_CallerSpecifiedTID, XQEMessages.getCurrProductLocale(), im.getTID(), im.getPreviousTid());
                        this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNoNewValues_CallerSpecifiedTID, im.getTID(), im.getPreviousTid());
                    } else {
                        returnMsg = XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNoNewValues_SystemSpecifiedTID, XQEMessages.getCurrProductLocale(), im.getPreviousTid());
                        this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementHadNoNewValues_SystemSpecifiedTID, im.getPreviousTid());
                    }
                } else {
                    returnMsg = XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementSucceeded, XQEMessages.getCurrProductLocale());
                    this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementSucceeded);
                }
            } else {
                returnMsg = XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementCancelled, XQEMessages.getCurrProductLocale());
                this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementCancelled);
            }
            ROLAPLog.logWarn("ROLAPCubes.Audit", returnMsg);
        }
        catch (Throwable t) {
            this.getMessages().addMessage(XQEMessageKeys.RLU_LoadNextIncrementFailed, t);
            ROLAPLog.logError("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_LoadNextIncrementFailed, XQEMessages.getCurrProductLocale()), t);
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.loadNextIncrementCount.decrementAndGet();
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
        return returnMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementallyLoadImpl(String strTID) {
        try {
            ROLAPCubeReservation res = null;
            QueryEnvironmentHelper envHelper = this.setUpExecutionEnvironment(false, false);
            try {
                IncrementManager im;
                res = this.reserve();
                ROLAPDataCache dataCache = res.getDataCache();
                if (dataCache != null && (im = dataCache.getIncrementManager()) != null) {
                    im.loadNextIncrement(dataCache, strTID);
                }
            }
            finally {
                if (res != null) {
                    this.unreserve(res);
                }
                envHelper.tearDownEnvironment();
            }
        }
        catch (InterpreterException e) {
            throw new XQERuntimeException(e);
        }
    }

    public IncrementMetrics getLastestIncrementMetrics() {
        IncrementManager im;
        IncrementMetrics metrics = null;
        ROLAPDataCache currentDataCache = this.getCurrentDataCache();
        if (currentDataCache != null && (im = currentDataCache.getIncrementManager()) != null) {
            metrics = im.getLastMetrics();
        }
        return metrics;
    }

    public int getOldestPossibleIncrementId() {
        int oldestUsedIncrementId;
        IncrementManager im;
        int oldestIncrementId = Integer.MAX_VALUE;
        ROLAPDataCache currentDataCache = this.getCurrentDataCache();
        if (currentDataCache != null && (im = currentDataCache.getIncrementManager()) != null) {
            oldestIncrementId = im.getCurrentIncrementID();
        }
        if ((oldestUsedIncrementId = this.getOldestActiveIncrementId()) >= 0) {
            oldestIncrementId = Math.min(oldestIncrementId, oldestUsedIncrementId);
        }
        if (oldestIncrementId == Integer.MAX_VALUE) {
            oldestIncrementId = 0;
        }
        return oldestIncrementId;
    }

    public int getOldestActiveIncrementId() {
        int oldestIncrementId = Integer.MAX_VALUE;
        for (ROLAPCubeReservation reservation : this.mReservations.keySet()) {
            if (reservation.isInvalid()) continue;
            oldestIncrementId = Math.min(oldestIncrementId, reservation.getIncrementID());
        }
        if (oldestIncrementId == Integer.MAX_VALUE) {
            oldestIncrementId = -1;
        }
        return oldestIncrementId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditUserSecurity(String userName) {
        if (!ROLAPLog.isOn("ROLAPCubes.SecurityAudit", LogLevel.INFO)) {
            return;
        }
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            QueryEnvironmentHelper envHelper = this.setUpExecutionEnvironment(false, false);
            try {
                RequestEnvironment reqEnv = envHelper.getRequestEnvironment();
                reqEnv.resetRequestPAC();
                ICMUser user = ContentManager.getUser(reqEnv);
                user.setName(userName);
                String[][] parameterMap = new String[][]{{USERNAME, userName}};
                user.getParameterMap().clear();
                ArrayList<String> values = new ArrayList<String>();
                values.add(parameterMap[0][1]);
                user.getParameterMap().put(parameterMap[0][0], values);
                this.setParameters(reqEnv, parameterMap);
                ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(reqEnv.getExecutionEnvironment());
                try {
                    SecManager secManager = (SecManager)this.getCurrentSecurityManager();
                    secManager.setIsSecurityAudit(true);
                    ROLAPCubeReservation res = this.reserve();
                    try {
                        SecViewCombinationRestriction viewCombinationRestriction = secManager.getViewCombinationRestriction();
                        String auditString = "Security audit for user: " + userName + "\n";
                        auditString = viewCombinationRestriction != null ? auditString + viewCombinationRestriction.getAuditString() : auditString + "No restrictions found.\n";
                        ROLAPLog.log("ROLAPCubes.SecurityAudit", auditString);
                    }
                    finally {
                        this.unreserve(res);
                    }
                }
                finally {
                    executionEnvironmentContext.exit();
                }
            }
            finally {
                envHelper.tearDownEnvironment();
            }
        }
        catch (Throwable t) {
            ROLAPCubeManager.handleExceptionInJMX(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    public void maintain() {
        ROLAPDataCache dataCache = this.getCurrentDataCache();
        if (dataCache != null) {
            IncrementManager im;
            AggregateCubeletStorage aggregateStorage;
            IBlockTupleStorage cubeletStorage = dataCache.getBlockTupleStorage();
            if (cubeletStorage != null) {
                cubeletStorage.maintain(0.0);
            }
            if ((aggregateStorage = dataCache.getAggregateStorage()) != null) {
                aggregateStorage.maintain(0.0);
            }
            if ((im = dataCache.getIncrementManager()) != null && !im.isIncrementLoadInProgress()) {
                im.maintainIncrementHistory(dataCache);
            }
        }
        if (this.mMemberCacheManager != null) {
            ROLAPCacheManager<ROLAPDataCache> dataCacheManager;
            this.mMemberCacheManager.maintain();
            ROLAPMemberCache currentMemberCache = this.mMemberCacheManager.getCurrentRevision();
            if (currentMemberCache != null && (dataCacheManager = currentMemberCache.getDataCacheManager()) != null) {
                dataCacheManager.maintain();
            }
        }
    }

    public void setRootMeasureFolder(ROLAPFolder measureFolder) {
        this.rootMeasureFolder = measureFolder;
    }

    public ROLAPFolder getRootMeasureFolder() {
        return this.rootMeasureFolder;
    }

    public ROLAPAccessAccountManager getAccountManager() {
        return this.mAccountManager;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.ROLAP;
    }

    static {
        try {
            CUBE_NAME_TYPE = new CompositeType(CUBE_NAME, CUBE_NAME_DESCRIPTION, CUBE_NAME_FIELDS, new String[]{"Cube list entry ordinal number", CUBE_NAME_DESCRIPTION}, new OpenType[]{SimpleType.INTEGER, SimpleType.STRING});
            CUBE_LIST_TYPE = new TabularType(CUBE_LIST, "List of cube names", CUBE_NAME_TYPE, new String[]{CUBE_ID});
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
        PATTERN = Pattern.compile("NAME");
        BI_BUS_HEADER_QNAME = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        MEMBER_CACHE_FIELDS = new String[]{CURRENT_VERSION_NAME, MEMBER_CACHE_ID_NAME, RESERVATIONS_NAME, SOFT_RESERVATIONS_NAME, "memberCount", "dataCaches", "securityCaches", TIMESTAMP_NAME};
        DATA_CACHE_FIELDS = new String[]{CURRENT_VERSION_NAME, DATA_CACHE_ID_NAME, RESERVATIONS_NAME, SOFT_RESERVATIONS_NAME, "cacheMisses", TIMESTAMP_NAME};
        SECURITY_CACHE_FIELDS = new String[]{CURRENT_VERSION_NAME, SECURITY_CACHE_ID_NAME, RESERVATIONS_NAME, SOFT_RESERVATIONS_NAME, TIMESTAMP_NAME, "queryCacheSize", "totalCachedMemberCount"};
        RESERVATION_FIELDS = new String[]{RESERVATION_ID_NAME, MEMBER_CACHE_ID_NAME, DATA_CACHE_ID_NAME, SECURITY_CACHE_ID_NAME, TIMESTAMP_NAME};
    }

    public final class MemberCacheFactory
    implements IROLAPCacheFactory<ROLAPMemberCache> {
        private static final int MAX_MEMBER_CACHE_VERSIONS = 2;
        private final ROLAPCube mCube;

        public MemberCacheFactory(ROLAPCube cube) {
            this.mCube = cube;
        }

        @Override
        public ROLAPMemberCache create(ROLAPCacheBase parent) {
            return this.mCube.createMemberCache();
        }

        @Override
        public boolean createAllowed() {
            return ROLAPCube.this.mMemberCacheManager.getCacheNo() < 2 && ROLAPDataCacheFactory.newCacheAllowed(this.mCube) && ROLAPSecurityCacheFactory.newCacheAllowed(this.mCube);
        }
    }

    private static final class ResultSetCacheExpiringVisitor
    implements IResultSetCacheVisitor {
        private final Integer mMemberCacheRevision;
        private final Integer mDataCacheRevision;

        ResultSetCacheExpiringVisitor(Integer memberCacheRevision, Integer dataCacheRevision) {
            this.mMemberCacheRevision = memberCacheRevision;
            this.mDataCacheRevision = dataCacheRevision;
        }

        @Override
        public IResultSetCacheVisitor.VisitorAction visit(Object cacheKey, ICachedCubeResultSet cachedResultSet, long creationTimestamp, long lastAccessTimestamp, int currentRefCount) {
            ROLAPResultSetCacheKey rsCacheKey = (ROLAPResultSetCacheKey)cacheKey;
            if (null != this.mMemberCacheRevision && this.mMemberCacheRevision.intValue() == rsCacheKey.getMemberCacheRevision()) {
                if (null != this.mDataCacheRevision) {
                    if (this.mDataCacheRevision.intValue() == rsCacheKey.getDataCacheRevision()) {
                        return IResultSetCacheVisitor.VisitorAction.EXPIRE_AND_CONTINUE;
                    }
                } else {
                    return IResultSetCacheVisitor.VisitorAction.EXPIRE_AND_CONTINUE;
                }
            }
            return IResultSetCacheVisitor.VisitorAction.CONTINUE;
        }
    }

    public static class ROLAPCubeInfo {
        private final boolean virtual;
        private final Map<String, String> nameMap = new HashMap<String, String>();
        private String defaultName;

        ROLAPCubeInfo(boolean virt) {
            this.virtual = virt;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public void setDefaultName(String name) {
            this.defaultName = name;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public void setName(String locale, String name) {
            this.nameMap.put(locale, name);
        }

        public Map<String, String> getNameMap() {
            return this.nameMap;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(ROLAPCube.OPEN_BRACKET);
            buf.append("virtual:").append(this.isVirtual()).append(ROLAPCube.SEMICOLON);
            buf.append("defaultName:").append(this.getDefaultName()).append(ROLAPCube.SEMICOLON);
            buf.append("names:");
            boolean firstSeen = false;
            for (String locale : this.nameMap.keySet()) {
                if (firstSeen) {
                    buf.append(",");
                }
                buf.append(locale).append("=").append(this.nameMap.get(locale));
                firstSeen = true;
            }
            buf.append(ROLAPCube.CLOSED_BRACKET);
            return buf.toString();
        }
    }
}

