/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManagerMBean;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetricResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSharedDimensionCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityManagerFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMaintenanceService;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.WeakHashSet;
import com.cognos.xqe.util.concurrent.locks.LockManager;
import com.cognos.xqe.util.pool.DirectByteBufferPool;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.commons.configuration.ConversionException;
import org.dom4j.Element;

public final class ROLAPCubeManager
implements ROLAPCubeManagerMBean,
XQEConfigurationListener {
    public static final String LOCALHOST = "localhost";
    private static final String MBEAN_NAME = "com.cognos.xqe.rolap:name=Cube Manager";
    private static final String CM_PROPERTY_DISPATCHER_ID = "dispatcherID";
    private static final String CM_PROPERTY_DISPATCHER_PATH = "dispatcherPath";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COLON = ":";
    private static final String PROTOCOL_HOST_SEPARATOR = "://";
    private static final String ELEMENT_NAME_VALUE = "value";
    private XQEConfiguration.ConfigurationChangeListener registeredConfigListener = null;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPCubes.Management");
    public static final String INITIAL_CUBES_PROPERTY = "initialCubes";
    public static final int WAIT_TIME = 5000;
    private volatile ROLAPConfiguration configuration = null;
    private final AtomicBoolean startedEnabledCubes = new AtomicBoolean(false);
    private final ConcurrentMap<ROLAPCube, WeakHashSet<PlannedV5QuerySet>> cubePlans = new ConcurrentHashMap<ROLAPCube, WeakHashSet<PlannedV5QuerySet>>();
    private DirectByteBufferPool mBufferPool = null;
    private static ROLAPCubeMap knownCubes = null;
    private final Lock mCubeCreationLock = new ReentrantLock();
    public static final String ROLAP_CATALOG = "ROLAP Catalog";
    private static final int MAX_CONCURRENT_ADMIN_TASKS = 5;
    private ExecutorService mAdminTaskService = Executors.newFixedThreadPool(5);
    private static final String TASK_SUBMITTED = "ROLAP cube manager submitted %s task, cubes=%s";
    private SecurityManagerFactory securityManagerFactory = new SecurityManagerFactory();
    private String internalDispatcherURI;
    private String internalDispatcherGuid;
    private final LockManager lockManager = new LockManager();
    private long lockWaitTime;
    boolean cmAvailable = false;
    private boolean mShuttingDown = false;
    private static final double ONE_HUNDRED = 100.0;
    private static final double DEFAULT_PCT_TO_FREE = 0.8;
    private int numTotalCriticalNotifications = 0;
    private long timeLastCriticalNotification = 0L;
    private static SingletonHelper<ROLAPCubeManager> singletonHelper = new SingletonHelper<ROLAPCubeManager>(){

        @Override
        protected ROLAPCubeManager newInstance() {
            return new ROLAPCubeManager();
        }

        @Override
        protected void initializeImpl(ROLAPCubeManager theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(ROLAPCubeManager theInstance) {
            theInstance.release();
        }
    };
    private final IAdminAction mCubeStartAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "cube start";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.start();
        }
    };
    private final IAdminAction mCubeForceStartAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "cube start with source cubes";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.forceStart((Boolean)params[0]);
        }
    };
    private final IAdminAction mCubeStopAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "cube stop";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.stop();
        }
    };
    private final IAdminAction mCubeForceStopAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "immediate cube stop";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.forceStop();
        }
    };
    private final IAdminAction mCubeRestartAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "cube restart";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.restart();
        }
    };
    private final IAdminAction mDataCacheClearAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "data cache clear";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.clearDataCache();
        }
    };
    private final IAdminAction mMemberCacheRefreshAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "member cache refresh";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.refreshMemberCache();
        }
    };
    private final IAdminAction mSecurityRefreshAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "security refresh";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.refreshSecurity();
        }
    };
    private final IAdminAction mCubeClearWorkloadLogAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "clear workload log";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.clearWorkloadLog();
        }
    };
    private final IAdminAction mCubePauseAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "cube pause";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            cube.pause();
        }
    };
    private final IAdminAction mCubeIncrementalLoadAction = new IAdminAction(){

        @Override
        public String getDescription() {
            return "incremental cube load";
        }

        @Override
        public void process(ROLAPCube cube, Object ... params) {
            if (params.length > 0) {
                cube.incrementallyLoad((String)params[0]);
            } else {
                cube.incrementallyLoad(null);
            }
        }
    };

    public ROLAPCube getCube(String cubeName) {
        return knownCubes.get(cubeName);
    }

    public ROLAPCubeStateEnum getCubeState(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        return cube.getState();
    }

    public List<ROLAPCube> getRunningCubes() {
        LinkedList<ROLAPCube> cubes = new LinkedList<ROLAPCube>();
        for (ROLAPCube cube : knownCubes.cubeInstances()) {
            if (!cube.isRunning()) continue;
            cubes.add(cube);
        }
        return cubes;
    }

    public String[] getNamesOfRunningCubes() {
        LinkedList<String> cubes = new LinkedList<String>();
        for (ROLAPCube cube : knownCubes.cubeInstances()) {
            if (!cube.isRunning()) continue;
            cubes.add(cube.getName());
        }
        ROLAPLog.logCubeNames("ROLAPCubes.Management", "Get names of running cubes.", cubes);
        return cubes.toArray(new String[cubes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCube(String cubeName) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", cubeName);
        try {
            ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeBeganExecution, XQEMessages.getCurrProductLocale()));
            ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeBeganExecution, XQEMessages.getCurrProductLocale()));
            ROLAPCube cube = knownCubes.get(cubeName);
            if (cube != null) {
                ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailedCubeExists, XQEMessages.getCurrProductLocale()));
                ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailedCubeExists, XQEMessages.getCurrProductLocale()));
                return;
            }
            this.mCubeCreationLock.lock();
            try {
                cube = knownCubes.get(cubeName);
                if (cube != null) {
                    ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailedCubeExists, XQEMessages.getCurrProductLocale()));
                    ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailedCubeExists, XQEMessages.getCurrProductLocale()));
                    return;
                }
                ROLAPCubeConfiguration cubeConfig = this.getCubeConfiguration(cubeName);
                ROLAPCube.ROLAPCubeInfo cubeInfo = ROLAPCube.loadCubeInfo(cubeName);
                boolean isVirtual = false;
                if (cubeInfo != null) {
                    isVirtual = cubeInfo.isVirtual();
                } else if (cubeConfig != null) {
                    isVirtual = cubeConfig.isVirtual();
                } else {
                    ROLAPMetaVirtualCube[] cubes;
                    ROLAPMetaMdSchema schema = null;
                    schema = ROLAPCube.getSchema(cubeName);
                    if (schema != null && (cubes = schema.getVirtualCubes()) != null) {
                        for (int i = 0; i < cubes.length; ++i) {
                            if (!cubes[i].getName().equalsIgnoreCase(cubeName)) continue;
                            isVirtual = true;
                            break;
                        }
                    }
                }
                cube = isVirtual ? new ROLAPVirtualCube(cubeName, cubeInfo) : new ROLAPBaseCube(cubeName, cubeInfo);
                for (ROLAPCube theCube : knownCubes.cubeInstances()) {
                    if (!theCube.isVirtual()) continue;
                    ((ROLAPVirtualCube)theCube).addSourceCube(cube);
                }
                for (ROLAPCube theCube : knownCubes.cubeInstances()) {
                    if (!theCube.isVirtual()) continue;
                    ((ROLAPVirtualCube)theCube).updateAllSourceCubeMetric();
                }
                knownCubes.put(cubeName, cube, cubeInfo);
                if (this.configuration.getCubeConfiguration(cubeName) == null) {
                    this.configuration.addCubeConfiguration(cube.getCubeConfiguration());
                }
                ROLAPLog.log("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeSucceeded, XQEMessages.getCurrProductLocale()));
                ROLAPLog.logWarn("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeSucceeded, XQEMessages.getCurrProductLocale()));
            }
            catch (Exception e) {
                ROLAPLog.logError("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailed, XQEMessages.getCurrProductLocale()), e);
                ROLAPLog.logError("ROLAPCubes.Audit", XQEMessages.getMessage(XQEMessageKeys.RLU_AddCubeFailed, XQEMessages.getCurrProductLocale()), e);
                ROLAPCubeManager.handleExceptionInJMX(e);
            }
            finally {
                this.mCubeCreationLock.unlock();
            }
        }
        finally {
            traceContext.exit();
        }
    }

    public void deleteCube(String cubeName) {
        try {
            ROLAPCube cube = this.getAndUpdateCube(cubeName);
            cube.delete();
            for (ROLAPCube theCube : knownCubes.cubeInstances()) {
                theCube.removeDependentCube(cube);
            }
        }
        catch (Exception e) {
            ROLAPCubeManager.handleExceptionInJMX(e);
        }
    }

    public void removeCube(ROLAPCube cube) {
        this.configuration.removeCubeConfiguration(cube.getName());
        knownCubes.remove(cube);
    }

    public void initCube(ROLAPCube cube) throws Exception {
        ROLAPProvider provider = (ROLAPProvider)Provider.getProvider(ROLAPProvider.class.getName());
        cube.init(provider);
    }

    public static ROLAPCubeManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private void startEnabledCubes() {
        if (this.startedEnabledCubes.compareAndSet(false, true)) {
            Collection<ROLAPCubeConfiguration> cubeConfigs = this.configuration.getCubeConfigurations();
            for (ROLAPCubeConfiguration conf : cubeConfigs) {
                String cubeName = conf.getName();
                try {
                    if (this.getCube(cubeName) != null) continue;
                    this.addCube(cubeName);
                }
                catch (Exception exception) {}
            }
            if (!this.configuration.isManualCubeStart()) {
                LinkedList<String> enabledCubes = new LinkedList<String>();
                for (ROLAPCube cube : knownCubes.cubeInstances()) {
                    if (!cube.isEnabled()) continue;
                    Set<ROLAPCube> dependents = cube.getDependentCubes();
                    for (ROLAPCube dep : dependents) {
                        if (!dep.isEnabled()) continue;
                    }
                    enabledCubes.add(cube.getName());
                }
                if (enabledCubes.size() > 0) {
                    this.forceStartCubes(enabledCubes, true);
                }
            }
        }
    }

    private void refreshConfiguredCubes() {
        if (this.configuration == null) {
            return;
        }
        Collection<ROLAPCubeConfiguration> cubeConfigs = this.configuration.getCubeConfigurations();
        for (ROLAPCubeConfiguration conf : cubeConfigs) {
            ROLAPCube cube = knownCubes.get(conf.getName());
            if (cube == null) {
                try {
                    this.addCube(conf.getName());
                    INFO_LOGGER.log("[Cube Added:" + conf.getName() + "] \n");
                }
                catch (Exception exception) {}
                continue;
            }
            cube.updateConfiguration();
        }
        for (ROLAPCube cube : knownCubes.cubeInstances()) {
            ROLAPCubeConfiguration config = this.configuration.getCubeConfiguration(cube.getName());
            if (config != null) continue;
            this.deleteCube(cube.getName());
            INFO_LOGGER.log("[Cube Deleted:" + cube.getName() + "]\n");
        }
    }

    private void initialize() {
        String resultSetCacheDir;
        String memberCacheDir;
        File f;
        knownCubes = new ROLAPCubeMap();
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.lockWaitTime = xqeConfiguration.getLongProperty("general.lockWaitTimeInMs[@value]", 1000L);
        INFO_LOGGER.log(String.format("Lock wait time = %d ms", this.lockWaitTime));
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME);
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(this, name);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(XQEDebugLog.err);
            INFO_LOGGER.log(LogLevel.ERROR, ex);
        }
        ROLAPConfiguration config = ROLAPConfiguration.loadLocalConfig();
        if (config != null) {
            this.configuration = config;
            INFO_LOGGER.log("Loaded xqe.rolap.dev.config.xml configuration file.");
        } else {
            this.configuration = new ROLAPConfiguration();
        }
        INFO_LOGGER.log("Initial ROLAP configuration: " + this.configuration.dump());
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (this.registeredConfigListener == null) {
            this.registeredConfigListener = xqeConfig.registerConfigurationListener(this);
        }
        if (!(f = new File(memberCacheDir = this.configuration.getMemberCacheFolder())).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(resultSetCacheDir = this.configuration.getResultSetCacheFolder())).exists()) {
            f.mkdirs();
        }
        this.mBufferPool = new DirectByteBufferPool(ByteOrder.nativeOrder(), this.configuration.getIOBufferSize());
        try {
            ROLAPMetaDimension.parseSharableDimUUIDs();
        }
        catch (Exception e) {
            INFO_LOGGER.log(e);
        }
    }

    public ROLAPConfiguration getConfig() {
        return this.configuration;
    }

    public boolean isShuttingDown() {
        return this.mShuttingDown;
    }

    private void release() {
        this.mShuttingDown = true;
        if (this.registeredConfigListener != null) {
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            xqeConfig.unregisterConfigurationListener(this.registeredConfigListener);
        }
        ArrayList<ROLAPCube> cubes = new ArrayList<ROLAPCube>(knownCubes.cubeInstances());
        for (ROLAPCube cube : cubes) {
            cube.delete();
        }
        if (this.mAdminTaskService != null) {
            this.mAdminTaskService.shutdownNow();
            this.mAdminTaskService = null;
        }
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME);
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(XQEDebugLog.err);
            INFO_LOGGER.log(LogLevel.ERROR, ex);
        }
        ROLAPMetaDimension.clearTempUUIDMap();
        ROLAPSharedDimensionCache.releaseInstance();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nRunning Cubes: ");
        str.append(Arrays.asList(this.getNamesOfRunningCubes()));
        return str.toString();
    }

    public static void handleExceptionInJMX(Throwable e) {
        if (!ROLAPCubeManager.runningUnderJMX()) {
            throw XQERuntimeException.wrap(e);
        }
        INFO_LOGGER.log(LogLevel.ERROR, e);
        XQEDebugLog.err.printStackTrace(e);
        throw new RuntimeException(ROLAPCubeManager.getMessage(e));
    }

    private static String getMessage(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        e.printStackTrace(w);
        w.close();
        return sw.toString();
    }

    public static boolean runningUnderJMX() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            if (!st[i].getClassName().endsWith("RMIConnectionImpl")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getConfigAdditionalJVMArgs() {
        return this.configuration.getAdditionalJVMArgs();
    }

    @Override
    public int getConfigAdminCommandTimeout() {
        return this.configuration.getAdminCommandTimeout();
    }

    @Override
    public void setConfigAdminCommandTimeout(int value) {
        this.configuration.setAdminCommandTimeout(value);
    }

    public int getConfigActualAdminCommandTimeout() {
        return this.configuration.getActualAdminCommandTimeout();
    }

    @Override
    public int getConfigInitialJVMHeapSize() {
        return this.configuration.getInitialJVMHeapSize();
    }

    @Override
    public boolean getConfigIsManualCubeStart() {
        return this.configuration.isManualCubeStart();
    }

    @Override
    public int getConfigMultiDimensionalQuerySizeLimit() {
        return this.configuration.getMultiDimensionalQuerySizeLimit();
    }

    @Override
    public int getConfigMaxJVMHeapSize() {
        return this.configuration.getMaxJVMHeapSize();
    }

    @Override
    public String getConfigMemberCacheFolder() {
        return this.configuration.getMemberCacheFolder();
    }

    @Override
    public String getConfigResultSetCacheFolder() {
        return this.configuration.getResultSetCacheFolder();
    }

    @Override
    public boolean getConfigResultSetCacheEncrypted() {
        return this.configuration.isResultSetCacheEncrypted();
    }

    @Override
    public void setConfigResultSetCacheEncrypted(boolean value) {
        this.configuration.setResultSetCacheEncrypted(value);
    }

    @Override
    public int getConfigResultSetCacheQueryTimeThreshold() {
        return this.configuration.getResultSetCacheQueryTimeThreshold();
    }

    @Override
    public void setConfigResultSetCacheQueryTimeThreshold(int value) {
        this.configuration.setResultSetCacheQueryTimeThreshold(value);
    }

    public ROLAPCubeConfiguration getCubeConfiguration(String name) {
        return this.configuration.getCubeConfiguration(name);
    }

    public ROLAPCubeConfiguration createCubeConfiguration(String cubeName, boolean isVirtual) {
        return this.configuration.createCubeConfiguration(cubeName, isVirtual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associatePlanToCube(PlannedV5QuerySet plannedQuerySet, ROLAPCube cube) {
        WeakHashSet<PlannedV5QuerySet> planSet;
        if (null == cube) {
            throw new IllegalArgumentException("cube was null.");
        }
        if (null == plannedQuerySet) {
            throw new IllegalArgumentException("plannedQuerySet was null.");
        }
        WeakHashSet<PlannedV5QuerySet> weakHashSet = planSet = this.getOrCreatePlanSetForCube(cube);
        synchronized (weakHashSet) {
            planSet.add(plannedQuerySet);
        }
    }

    private WeakHashSet<PlannedV5QuerySet> getOrCreatePlanSetForCube(ROLAPCube cube) {
        WeakHashSet tmp;
        WeakHashSet planSet = (WeakHashSet)this.cubePlans.get(cube);
        if (null == planSet && null != (tmp = this.cubePlans.putIfAbsent(cube, planSet = new WeakHashSet()))) {
            planSet = tmp;
        }
        return planSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlansForCube(ROLAPCube cube) {
        block6: {
            try {
                WeakHashSet planSet = (WeakHashSet)this.cubePlans.get(cube);
                if (null == planSet) break block6;
                QueryEngine queryEngine = QueryEngine.getInstance();
                WeakHashSet weakHashSet = planSet;
                synchronized (weakHashSet) {
                    for (PlannedV5QuerySet plannedQuerySet : planSet) {
                        if (null == plannedQuerySet) continue;
                        plannedQuerySet.setCacheable(false);
                        queryEngine.removePlanTree(plannedQuerySet);
                    }
                    planSet.clear();
                }
            }
            catch (Throwable e) {
                INFO_LOGGER.log(LogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void configurationChanged(XQEConfigurationEvent e) {
        block29: {
            if (e.isBeforeUpdate() || e.getPropertyName().indexOf("rolap.") == -1 || e.getPropertyValue() == null) {
                return;
            }
            String propertyName = e.getPropertyName();
            String propertyValue = (String)e.getPropertyValue();
            String parameterName = null;
            if (propertyName.equals("jvm.qsInitialJVMHeapSize")) {
                parameterName = ROLAPConfiguration.JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart();
            } else if (propertyName.equals("jvm.qsJVMHeapSizeLimit")) {
                parameterName = ROLAPConfiguration.JVM_MAX_HEAP_SIZE_QNAME.getLocalPart();
            } else if (propertyName.equals("jvm.qsAdditionalJVMArguments")) {
                parameterName = ROLAPConfiguration.JVM_ADDITIONAL_ARGS_QNAME.getLocalPart();
            } else if (propertyName.equals("rolap.qsManualCubeStart")) {
                parameterName = ROLAPConfiguration.MANUAL_CUBE_START_QNAME.getLocalPart();
            } else if (propertyName.equals("rolap.qsMultiDimensionalQuerySizeLimit")) {
                parameterName = ROLAPConfiguration.QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart();
            } else if (propertyName.equals("rolap.qsROLAPMemberCacheAliasRoot")) {
                parameterName = ROLAPConfiguration.MEMBER_CACHE_FOLDER_QNAME.getLocalPart();
            } else if (propertyName.equals("rolap.qsROLAPCubeAdministrationCommandTimeout")) {
                parameterName = ROLAPConfiguration.ADMIN_COMMAND_TIMEOUT_QNAME.getLocalPart();
            } else if (propertyName.equals("rolap.qsResultSetCacheQueryTimeThreshold")) {
                parameterName = ROLAPConfiguration.RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.getLocalPart();
            }
            boolean isParameterSpecifiedInLocalConfigFile = this.configuration.isParameterSpecifiedInLocalConfigFile(parameterName);
            if (isParameterSpecifiedInLocalConfigFile) {
                INFO_LOGGER.log(String.format("The request to set the parameter \"%s\" to the value \"%s\" is being ignored because the parameter is specified in xqe.rolap.dev.config.xml.", parameterName, propertyValue));
                return;
            }
            INFO_LOGGER.log(LogLevel.INFO, "[Updating a ROLAP configuration parameter: " + propertyName + "=" + propertyValue + "] ");
            INFO_LOGGER.log("[Before: ROLAP configuration: " + this.configuration.dump() + "]  ");
            try {
                if (propertyName.equals("jvm.qsInitialJVMHeapSize")) {
                    this.configuration.setInitialJVMHeapSize(Integer.parseInt(propertyValue));
                    break block29;
                }
                if (propertyName.equals("jvm.qsJVMHeapSizeLimit")) {
                    this.configuration.setMaxJVMHeapSize(Integer.parseInt(propertyValue));
                    break block29;
                }
                if (propertyName.equals("jvm.qsAdditionalJVMArguments")) {
                    this.configuration.setAdditionalJVMArgs(propertyValue);
                    break block29;
                }
                if (propertyName.equals("rolap.qsManualCubeStart")) {
                    this.configuration.setManualCubeStart(Boolean.parseBoolean(propertyValue));
                    break block29;
                }
                if (propertyName.equals("rolap.qsMultiDimensionalQuerySizeLimit")) {
                    this.configuration.setMultiDimensionalQuerySizeLimit(Integer.parseInt(propertyValue));
                    break block29;
                }
                if (propertyName.equals("rolap.qsROLAPMemberCacheAliasRoot")) {
                    this.configuration.setMemberCacheFolder(propertyValue);
                    break block29;
                }
                if (propertyName.equals("rolap.qsROLAPCubeAdministrationCommandTimeout")) {
                    this.configuration.setAdminCommandTimeout(Integer.parseInt(propertyValue));
                    break block29;
                }
                if (propertyName.equals("rolap.qsResultSetCacheQueryTimeThreshold")) {
                    this.configuration.setResultSetCacheQueryTimeThreshold(Integer.parseInt(propertyValue));
                    break block29;
                }
                if (!propertyName.equals("rolap.cubeconfigurations") || !this.isCMRunning()) break block29;
                try {
                    this.configuration.updateCubeConfigurations(propertyValue);
                    this.refreshConfiguredCubes();
                }
                catch (Exception cubeEx) {
                    INFO_LOGGER.log(LogLevel.ERROR, "[Exception occured when processing cube configurations (Exception :" + cubeEx.getMessage() + ")] ");
                }
                this.startEnabledCubes();
            }
            catch (Exception ex) {
                INFO_LOGGER.log(LogLevel.ERROR, "[Exception occurs when processing '" + propertyName + "' with value '" + propertyValue + "' (Exception :" + ex.getMessage() + ")]");
            }
        }
        INFO_LOGGER.log("[After: ROLAP configuration: " + this.configuration.dump() + "]   ");
    }

    private boolean isCMRunning() {
        if (!this.cmAvailable) {
            XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String lastConfigureRequestType = xqeConfiguration.getStringProperty("lastConfigureRequestType", "configure");
            boolean isReconfigureRequest = "reconfigure".equals(lastConfigureRequestType);
            if (isReconfigureRequest) {
                return true;
            }
            this.cmAvailable = ContentManager.isRunning();
        }
        return this.cmAvailable;
    }

    public AdminCommandManagerTask startCubes(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeStartAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeStartAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask forceStartCubes(List<String> cubeNames, boolean startingOnStartup) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeForceStartAction, startingOnStartup);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeForceStartAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask stopCubes(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeStopAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeStopAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask forceStopCubes(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeForceStopAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeForceStopAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask restartCubes(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeRestartAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeRestartAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask refreshCubeMemberCache(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mMemberCacheRefreshAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mMemberCacheRefreshAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask refreshCubeDataCache(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mDataCacheClearAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mDataCacheClearAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask refreshCubeSecurity(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mSecurityRefreshAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mSecurityRefreshAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask clearCubeWorkloadLog(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeClearWorkloadLogAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeClearWorkloadLogAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask pauseCubes(List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubePauseAction);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubePauseAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public AdminCommandManagerTask incrementallyLoadCubes(List<String> cubeNames, String tid) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        if (cubes.size() == 0) {
            return null;
        }
        AdminCommandManagerTask cubeManagerTask = new AdminCommandManagerTask(cubes, this.mCubeIncrementalLoadAction, tid);
        try {
            this.mAdminTaskService.submit(cubeManagerTask);
            INFO_LOGGER.log(String.format(TASK_SUBMITTED, this.mCubeIncrementalLoadAction.getDescription(), cubes.toString()));
        }
        catch (Exception ex) {
            INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        }
        return cubeManagerTask;
    }

    public void disableResultSetCache(List<String> cubeNames, boolean disable) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        for (ROLAPCube cube : cubes) {
            cube.setConfigIsDisableResultSetCache(disable);
        }
    }

    public void addCubes(List<String> cubeNames) {
        if (cubeNames != null && !cubeNames.isEmpty()) {
            for (String cubeName : cubeNames) {
                this.addCube(cubeName);
            }
        }
    }

    public void deleteCubes(List<String> cubeNames) {
        if (cubeNames == null || cubeNames.isEmpty()) {
            cubeNames = new ArrayList<String>();
            Collection<ROLAPCube> cubes = knownCubes.cubeInstances();
            for (ROLAPCube cube : cubes) {
                cubeNames.add(cube.getName());
            }
        }
        for (String cubeName : cubeNames) {
            this.deleteCube(cubeName);
        }
    }

    public void setCubeProperty(String propertyName, String propertyValue, List<String> cubeNames) {
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        for (ROLAPCube cube : cubes) {
            if (propertyName.equals(ROLAPConfiguration.DISABLED_QNAME.getLocalPart())) {
                cube.setConfigIsDisabled("true".equalsIgnoreCase(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.ENABLE_DYNAMIC_MEMBER_CACHING_QNAME.getLocalPart())) {
                cube.setConfigIsEnableDynamicMemberCaching("true".equalsIgnoreCase(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.DISABLE_RESULT_SET_CACHE_QNAME.getLocalPart())) {
                cube.setConfigIsDisableResultSetCache("true".equalsIgnoreCase(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.DISABLE_EXTERNAL_AGGREGATES_QNAME.getLocalPart())) {
                cube.setConfigIsDisableExternalAggregates("true".equalsIgnoreCase(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.AGGREGATE_LOGGING_ENABLED_QNAME.getLocalPart())) {
                cube.setConfigIsAggregateLoggingEnabled("true".equalsIgnoreCase(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart())) {
                cube.setConfigMultiDimensionalQuerySizeLimit(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.MEMBER_CACHE_LIMIT_QNAME.getLocalPart())) {
                cube.setConfigMemberCacheLimit(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getLocalPart())) {
                cube.setConfigPredicateThreshold(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.DATA_CACHE_SIZE_LIMIT_QNAME.getLocalPart())) {
                cube.setConfigMaxDataCacheSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getLocalPart())) {
                cube.setConfigMaxAggregateCacheSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getLocalPart())) {
                cube.setConfigResultSetCacheSizeLimit(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.STARTUP_TRIGGER_NAME_QNAME.getLocalPart())) {
                cube.setConfigStartupTriggerName(propertyValue);
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.MAX_HIERARCHY_LOAD_THREADS_QNAME.getLocalPart())) {
                cube.setConfigMaxHierarchyLoadThreads(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.MAX_AGGREGATE_LOAD_THREADS_QNAME.getLocalPart())) {
                cube.setConfigMaxAggregateLoadThreads(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.MEASURES_THRESHOLD_QNAME.getLocalPart())) {
                cube.setConfigMeasuresThreshold(Integer.parseInt(propertyValue));
                continue;
            }
            if (propertyName.equals(ROLAPConfiguration.AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getLocalPart())) {
                cube.setConfigAutoAggrOptimization(propertyValue);
                continue;
            }
            if (!propertyName.equals(ROLAPConfiguration.POST_IN_MEMORY_TRIGGER_NAME_QNAME.getLocalPart())) continue;
            cube.setConfigPostInMemoryTriggerName(propertyValue);
        }
    }

    public ROLAPCubeStateResult getCubeState(List<String> cubeNames) {
        ROLAPCubeStateResult states = new ROLAPCubeStateResult();
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        for (ROLAPCube cube : cubes) {
            states.setState(cube.getName(), cube.getState().toString());
        }
        ROLAPLog.logCubeStates("ROLAPCubes.Management", cubes);
        return states;
    }

    public ROLAPCubeMetricResult getCubeMetrics(List<String> cubeNames) {
        ROLAPCubeMetricResult metrics = new ROLAPCubeMetricResult();
        List<ROLAPCube> cubes = this.processCubeList(cubeNames);
        for (ROLAPCube cube : cubes) {
            cube.getMetrics().getBusMetrics(metrics);
        }
        return metrics;
    }

    private List<ROLAPCube> processCubeList(List<String> cubeNames) {
        LinkedList<ROLAPCube> cubes = new LinkedList<ROLAPCube>();
        if (cubeNames == null || cubeNames.size() == 0) {
            for (ROLAPCube cube : knownCubes.cubeInstances()) {
                cubes.add(cube);
            }
        } else {
            for (String cubeName : cubeNames) {
                ROLAPCube cube = this.getAndUpdateCube(cubeName);
                cubes.add(cube);
            }
        }
        return cubes;
    }

    public void addAndStartCube(String cubeName) {
        this.addCube(cubeName);
        ROLAPCube cube = this.getCube(cubeName);
        cube.start();
        cube.waitForStart(false);
    }

    public void startCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.start();
    }

    public void forceStartCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.forceStart();
    }

    public void stopCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.stop();
    }

    private ROLAPCube getAndUpdateCube(String cubeName) {
        Exception savedEx = null;
        ROLAPCube cube = this.getCube(cubeName);
        if (cube != null) {
            return cube;
        }
        ROLAPLog.log("ROLAPCubes.Info", "Could not find cube '" + cubeName + "', reloading cube names from CM to see if a new name was added");
        ROLAPCube.ROLAPCubeInfo cubeInfo = null;
        try {
            cubeInfo = ROLAPCube.loadCubeInfo(cubeName);
        }
        catch (Exception e) {
            savedEx = e;
        }
        if (cubeInfo != null && (cube = this.getCube(cubeInfo.getDefaultName())) != null) {
            this.updateCubeInfo(cube.getName(), cube, cubeInfo);
            return cube;
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindCube, (Throwable)savedEx, (Object)new ROLAPCubeNameWrapper(cubeName));
    }

    public void forceStopCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.forceStop();
    }

    public void refreshCubeMemberCache(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.refreshMemberCache();
    }

    public void clearCubeDataCache(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.clearDataCache();
    }

    public void refreshCubeSecurity(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.refreshSecurity();
    }

    public void clearWorkloadLog(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.clearWorkloadLog();
    }

    public void pauseCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.pause();
    }

    public void incrementallyLoadCube(String cubeName, String tid) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        cube.incrementallyLoad(tid);
    }

    public ROLAPCubeReservation reserveCube(String cubeName) {
        ROLAPCube cube = this.getAndUpdateCube(cubeName);
        return cube.reserve();
    }

    public void unreserveCube(ROLAPCubeReservation reservation) {
        reservation.getCube().unreserve(reservation);
    }

    @Override
    public ROLAPCubeStateResult getCubeStates() {
        return this.getCubeState((List<String>)null);
    }

    public Collection<ROLAPCube> getCubes() {
        return knownCubes.cubeInstances();
    }

    public DirectByteBufferPool getBufferPool() {
        return this.mBufferPool;
    }

    public static long setUpAdminWait() {
        return TimeUnit.SECONDS.toMillis(ROLAPCubeManager.getInstance().getConfigActualAdminCommandTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long adminWait(long remaining, Object waitObj) {
        long waitTime = remaining;
        if (waitTime > 5000L) {
            waitTime = 5000L;
        }
        long start = System.nanoTime();
        Object object = waitObj;
        synchronized (object) {
            try {
                waitObj.wait(waitTime);
            }
            catch (InterruptedException ex) {
                throw new OperationCanceledException();
            }
        }
        return remaining - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    public static void updateRemainingWaitTime(AtomicLong waitTime, long startTime) {
        long remainingTime = waitTime.get() - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        if (remainingTime < 0L) {
            waitTime.set(0L);
        } else {
            waitTime.set(remainingTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adminNotify(Object waitObj) {
        Object object = waitObj;
        synchronized (object) {
            waitObj.notifyAll();
        }
    }

    public SecurityManagerFactory getSecurityManagerFactory() {
        return this.securityManagerFactory;
    }

    public void setSecurityManagerFactory(SecurityManagerFactory newSecurityManagerFactory) {
        this.securityManagerFactory = newSecurityManagerFactory;
    }

    public String getInternalDispatcherURI() throws CCLConfigurationException {
        if (this.internalDispatcherURI == null) {
            ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
            this.internalDispatcherURI = cclConfig.getValue("internalDispatcher", false);
        }
        return this.internalDispatcherURI;
    }

    public String getInternalDispatcherGuid() throws Exception {
        if (this.internalDispatcherGuid == null) {
            this.internalDispatcherGuid = this.getInternalDispatcherGuidFromCM();
        }
        return this.internalDispatcherGuid;
    }

    private String getInternalDispatcherGuidFromCM() throws Exception {
        String dispatcherURI = this.getInternalDispatcherURI();
        INFO_LOGGER.log(LogLevel.TRACE, "Getting guid of internal dispatcher \"" + dispatcherURI + "\" from CM.");
        NodeID dispatcherNodeID = NodeID.getNodeID((String)dispatcherURI);
        InetAddress dispatcherInetAddress = null;
        String dispatcherHostFromNodeID = dispatcherNodeID.getHost();
        dispatcherInetAddress = LOCALHOST.equalsIgnoreCase(dispatcherHostFromNodeID) ? InetAddress.getLocalHost() : dispatcherNodeID.getHostInetAddress();
        String dispatcherHostName = dispatcherInetAddress.getHostName();
        String dispatcherCanonicalHostName = dispatcherInetAddress.getCanonicalHostName();
        String dispatcherHostAddress = dispatcherInetAddress.getHostAddress();
        int dispatcherPort = dispatcherNodeID.getPort();
        String dispatcherContext = dispatcherNodeID.getContext();
        String dispatcherHostNamePortContext = dispatcherHostName + COLON + dispatcherPort + dispatcherContext;
        String dispatcherCanonicalHostNamePortContext = dispatcherCanonicalHostName + COLON + dispatcherPort + dispatcherContext;
        String dispatcherHostAddressPortContext = dispatcherHostAddress + COLON + dispatcherPort + dispatcherContext;
        if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
            String orString = "\" or \"";
            INFO_LOGGER.log(LogLevel.TRACE, "Searching for dispatcherPath containing \"" + dispatcherHostNamePortContext + orString + dispatcherCanonicalHostNamePortContext + orString + dispatcherHostAddressPortContext + DOUBLE_QUOTE);
        }
        String dispatcherGuid = null;
        Exception innerException = null;
        try {
            List<CMClass> cmClassList = ContentManager.getProperties("/configuration/descendant::dispatcher", CM_PROPERTY_DISPATCHER_PATH, CM_PROPERTY_DISPATCHER_ID);
            for (CMClass cmClass : cmClassList) {
                if (!cmClass.getCMClassName().equals("cm:dispatcher")) continue;
                Element itemElement = cmClass.getItemElement();
                Element currentDispatcherPathElement = itemElement.element(CM_PROPERTY_DISPATCHER_PATH);
                Element currentDispatcherPathValueElement = currentDispatcherPathElement.element(ELEMENT_NAME_VALUE);
                String currentDispatcherPath = currentDispatcherPathValueElement.getText();
                INFO_LOGGER.log(LogLevel.TRACE, "Processing dispatcher \"" + currentDispatcherPath + DOUBLE_QUOTE);
                int indexOfHostPortContext = currentDispatcherPath.indexOf(PROTOCOL_HOST_SEPARATOR) + PROTOCOL_HOST_SEPARATOR.length();
                String currentDispatcherHostPortContext = currentDispatcherPath.substring(indexOfHostPortContext);
                if (!currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherHostNamePortContext) && !currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherCanonicalHostNamePortContext) && !currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherHostAddressPortContext)) continue;
                Element currentDispatcherIDElement = itemElement.element(CM_PROPERTY_DISPATCHER_ID);
                Element currentDispatcherIDValueElement = currentDispatcherIDElement.element(ELEMENT_NAME_VALUE);
                dispatcherGuid = currentDispatcherIDValueElement.getText();
                break;
            }
        }
        catch (Exception e) {
            innerException = e;
        }
        if (dispatcherGuid == null) {
            String andString = "\" and \"";
            INFO_LOGGER.log(LogLevel.ERROR, "Failed to retrieve guid of dispatcher with URI \"" + dispatcherURI + "\" from CM using search string \"" + dispatcherHostNamePortContext + andString + dispatcherCanonicalHostNamePortContext + andString + dispatcherHostAddressPortContext + DOUBLE_QUOTE, (Throwable)innerException);
            throw new XQERuntimeException(XQEMessageKeys.ROL_DispatcherGuidCouldNotBeRetrieved, (Throwable)innerException, dispatcherURI);
        }
        return dispatcherGuid;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    public ExecutorService createHierarchyLoadExecutorService(int loadTaskCount, int maxLoadThreads) {
        return this.createExecutorService(loadTaskCount, maxLoadThreads);
    }

    public ExecutorService createAggregateLoadExecutorService(int loadTaskCount, int maxLoadThreads) {
        return this.createExecutorService(loadTaskCount, maxLoadThreads);
    }

    private ExecutorService createExecutorService(int loadTaskCount, int maxTasks) {
        int concurrencyLevel = Math.min(loadTaskCount, maxTasks);
        concurrencyLevel = Math.max(concurrencyLevel, 1);
        ExecutorService executorService = Executors.newFixedThreadPool(concurrencyLevel);
        return executorService;
    }

    public void maintain() {
        for (ROLAPCube cube : knownCubes.cubeInstances()) {
            cube.maintain();
        }
    }

    public void updateCubeInfo(String name, ROLAPCube cube, ROLAPCube.ROLAPCubeInfo cubeInfo) {
        knownCubes.put(name, cube, cubeInfo);
    }

    private static double getCubeletFreePercentage() {
        double pctToFree = 0.8;
        try {
            double calcPctToFree;
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            Integer freePct = xqeConfig.getIntegerProperty("general.memoryMonitor.dcLowMemoryFreeDataCachePct", null);
            if (freePct != null && (calcPctToFree = (double)freePct.intValue() / 100.0) >= 0.0 && calcPctToFree <= 1.0) {
                pctToFree = calcPctToFree;
            }
        }
        catch (ConversionException e) {
            pctToFree = 0.8;
        }
        return pctToFree;
    }

    public void clearCaches() {
        double freeCubeletPct = ROLAPCubeManager.getCubeletFreePercentage();
        int numCubesThatHadDataCacheFreed = 0;
        if (freeCubeletPct > 0.0) {
            for (ROLAPCube cube : this.getRunningCubes()) {
                IBlockTupleStorage dataCache;
                ROLAPDataCache dataCacheContainer = cube.getCurrentDataCache();
                if (dataCacheContainer == null || (dataCache = dataCacheContainer.getBlockTupleStorage()) == null) continue;
                CubeletMaintenanceService.getInstance().maintain((CubeletStorage)dataCache, freeCubeletPct);
                ++numCubesThatHadDataCacheFreed;
            }
        }
        String logMsg = "Requested that " + freeCubeletPct * 100.0 + "% of data cache cubelets in " + numCubesThatHadDataCacheFreed + " cubes be released due to a critical low memory situation.";
        if (this.numTotalCriticalNotifications > 0) {
            Date d = new Date(this.timeLastCriticalNotification);
            DateFormat df = DateFormat.getDateTimeInstance();
            logMsg = logMsg + "  There have been " + this.numTotalCriticalNotifications + " previous notifications, with the last one being at " + df.format(d);
        }
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPCubes.Info", LogLevel.WARN);
        logger.log(LogLevel.WARN, logMsg);
        ++this.numTotalCriticalNotifications;
        this.timeLastCriticalNotification = System.currentTimeMillis();
    }

    private static interface IAdminAction {
        public String getDescription();

        public void process(ROLAPCube var1, Object ... var2);
    }

    private static final class CubeAdminTask
    implements Callable<Object> {
        private final ROLAPCube cube;
        private final IAdminAction action;
        private final Object[] params;

        CubeAdminTask(ROLAPCube c, IAdminAction a, Object ... par) {
            this.cube = c;
            this.action = a;
            this.params = par;
        }

        @Override
        public Object call() throws Exception {
            INFO_LOGGER.log(String.format("Started %s task, cube=%s", this.action.getDescription(), this.cube.getName()));
            this.action.process(this.cube, this.params);
            INFO_LOGGER.log(String.format("Finished %s task, cube=%s", this.action.getDescription(), this.cube.getName()));
            return null;
        }
    }

    public static final class AdminCommandManagerTask
    implements Callable<Object> {
        private final List<ROLAPCube> cubes;
        private final IAdminAction action;
        private final Object[] params;
        private boolean done;
        private final ROLAPCubeCommandResult cubeResult = new ROLAPCubeCommandResult();

        public AdminCommandManagerTask(List<ROLAPCube> cubeList, IAdminAction cubeAction) {
            this(cubeList, cubeAction, new Object[0]);
        }

        public AdminCommandManagerTask(List<ROLAPCube> cubeList, IAdminAction cubeAction, Object ... par) {
            this.cubes = cubeList;
            this.action = cubeAction;
            this.params = par;
        }

        public boolean isDone() {
            return this.done;
        }

        public ROLAPCubeCommandResult getResult() {
            return this.cubeResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            INFO_LOGGER.log(String.format("Started %s manager task, cubes=%s", this.action.getDescription(), this.cubes.toString()));
            if (this.cubes.size() > 0) {
                ExecutorService executorService = Executors.newFixedThreadPool(this.cubes.size());
                try {
                    Future cubeFuture;
                    LinkedList<Future> cubeFutures = new LinkedList<Future>();
                    for (ROLAPCube cube : this.cubes) {
                        CubeAdminTask cubeTask = new CubeAdminTask(cube, this.action, this.params);
                        cubeFuture = executorService.submit(cubeTask);
                        cubeFutures.add(cubeFuture);
                        INFO_LOGGER.log(String.format("Manager task submitted %s task for cube %s", this.action.getDescription(), cube.getName()));
                    }
                    int cubeCount = this.cubes.size();
                    for (int cubeIndex = 0; cubeIndex < cubeCount; ++cubeIndex) {
                        ROLAPCube cube = this.cubes.get(cubeIndex);
                        cubeFuture = (Future)cubeFutures.get(cubeIndex);
                        String cubeName = cube.getName();
                        String statusMessage = String.format("Manager task retrieved the status of the %s task for cube %s.", this.action.getDescription(), cubeName);
                        try {
                            INFO_LOGGER.log(String.format("Manager task is retrieving the status of the %s task for cube %s", this.action.getDescription(), cubeName));
                            cubeFuture.get();
                            this.cubeResult.setCommandResult(cubeName, true, XQEMessages.getMessage(XQEMessageKeys.ROL_CubeAdminCommandSucceeded, XQEMessages.getCurrProductLocale(), this.action.getDescription(), cubeName));
                            INFO_LOGGER.log(statusMessage + String.format("  The %s task was successful.", this.action.getDescription()));
                            continue;
                        }
                        catch (InterruptedException ex) {
                            for (int cancelIndex = cubeIndex; cancelIndex < cubeCount; ++cancelIndex) {
                                Future futureToCancel = (Future)cubeFutures.get(cancelIndex);
                                if (futureToCancel.isDone()) continue;
                                futureToCancel.cancel(true);
                            }
                            throw new OperationCanceledException();
                        }
                        catch (CancellationException ex) {
                            INFO_LOGGER.log(statusMessage + String.format("  The %s task was canceled.", this.action.getDescription()));
                            this.cubeResult.setCommandResult(cubeName, false, XQEMessages.getMessage(XQEMessageKeys.ROL_CubeAdminCommandWasCanceled, XQEMessages.getCurrProductLocale(), this.action.getDescription(), cubeName));
                            continue;
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            INFO_LOGGER.log(statusMessage + String.format("  The %s task failed with the exception: ", this.action.getDescription()), cause);
                            this.cubeResult.setCommandResult(cubeName, false, cause.getMessage());
                        }
                    }
                }
                finally {
                    executorService.shutdownNow();
                    this.done = true;
                    ROLAPCubeManager.adminNotify(this);
                }
            }
            INFO_LOGGER.log(String.format("Finished %s manager task, cubes=%s", this.action.getDescription(), this.cubes.toString()));
            return null;
        }
    }

    public static enum AdminCommandResult {
        SUCCEEDED,
        CANCELED,
        FAILED;

    }

    public final class ROLAPCubeMap {
        private final Map<String, ROLAPCube> cubes = new HashMap<String, ROLAPCube>();
        private final ReentrantReadWriteLock mCubeListLock = new ReentrantReadWriteLock();

        public ROLAPCube get(String cubeName) {
            this.mCubeListLock.readLock().lock();
            try {
                ROLAPCube rOLAPCube = this.cubes.get(cubeName.toLowerCase());
                return rOLAPCube;
            }
            finally {
                this.mCubeListLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String cubeName, ROLAPCube cube, ROLAPCube.ROLAPCubeInfo cubeInfo) {
            this.mCubeListLock.writeLock().lock();
            try {
                this.removeImpl(cube);
                this.cubes.put(cubeName.toLowerCase(), cube);
                if (cubeInfo != null) {
                    Map<String, String> nameMap = cubeInfo.getNameMap();
                    for (String name : nameMap.values()) {
                        this.cubes.put(name.toLowerCase(), cube);
                    }
                }
            }
            finally {
                this.mCubeListLock.writeLock().unlock();
            }
        }

        private void removeImpl(ROLAPCube cube) {
            Iterator<Map.Entry<String, ROLAPCube>> it = this.cubes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ROLAPCube> entry = it.next();
                if (entry.getValue() != cube) continue;
                it.remove();
            }
        }

        public void remove(ROLAPCube cube) {
            this.mCubeListLock.writeLock().lock();
            try {
                this.removeImpl(cube);
            }
            finally {
                this.mCubeListLock.writeLock().unlock();
            }
        }

        public Collection<ROLAPCube> cubeInstances() {
            this.mCubeListLock.readLock().lock();
            try {
                HashSet<ROLAPCube> hashSet = new HashSet<ROLAPCube>(this.cubes.values());
                return hashSet;
            }
            finally {
                this.mCubeListLock.readLock().unlock();
            }
        }
    }
}

