/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.cache.ICacheListener;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetricResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementMetrics;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.lang.time.DurationFormatUtils;

public class ROLAPCubeMetrics {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPCubes.Info", LogLevel.ERROR);
    private static final String METRICS_ERROR = "Error retrieving metrics value: ";
    private static final Set<Metric> BASE_CUBE_METRICS = new HashSet<Metric>(Arrays.asList(Metric.AvgTimePerSuccessfulRequest, Metric.AvgTimePerSuccessfulRequestInLastHour, Metric.AvgPercentageOfTimeSpentRetrievingData, Metric.AvgPercentageOfTimeSpentRetrievingDataInLastHour, Metric.AvgPercentageOfDataCacheHits, Metric.AvgPercentageOfDataCacheHitsInLastHour, Metric.AvgPercentageOfResultSetCacheHits, Metric.AvgPercentageOfResultSetCacheHitsInLastHour, Metric.AvgPercentageOfAggrTableHits, Metric.AvgPercentageOfAggrTableHitsInLastHour, Metric.LastResponseTime, Metric.NumberOfProcessedRequests, Metric.ServiceTime, Metric.TimeToLoadMetadata, Metric.NumbersOfInMemoryAggregates, Metric.TimeToLoadInMemoryAggregates, Metric.AvgPercentageOfInMemoryAggregateCacheHits, Metric.AvgPercentageOfInMemoryAggregateCacheHitsInLastHour, Metric.DataCacheUsage, Metric.InMemoryAggregateCacheUsage, Metric.ResultSetCacheUsage, Metric.MembersInMemberCache, Metric.TIDValueOfLatestIncrement, Metric.TimeLatestIncrementAvailable, Metric.DurationToBuildLatestIncrement));
    private static final Set<Metric> VIRTUAL_CUBE_METRICS = new HashSet<Metric>(Arrays.asList(Metric.AvgTimePerSuccessfulRequest, Metric.AvgTimePerSuccessfulRequestInLastHour, Metric.AvgPercentageOfTimeSpentRetrievingData, Metric.AvgPercentageOfTimeSpentRetrievingDataInLastHour, Metric.AvgPercentageOfDataCacheHits, Metric.AvgPercentageOfDataCacheHitsInLastHour, Metric.AvgPercentageOfResultSetCacheHits, Metric.AvgPercentageOfResultSetCacheHitsInLastHour, Metric.LastResponseTime, Metric.NumberOfProcessedRequests, Metric.ServiceTime, Metric.TimeToLoadMetadata));
    private static final long SEGMENT_DURATION = TimeUnit.MINUTES.toNanos(1L);
    private static final long HOUR = TimeUnit.HOURS.toNanos(1L);
    private static final long MEGABYTE = 0x100000L;
    private static final double CACHE_SIZE_FRACTIONAL_FORMAT_LOWER_LIMIT = 0.1;
    private static final double CACHE_SIZE_FRACTIONAL_FORMAT_UPPER_LIMIT = 100.0;
    private ROLAPCube cube;
    private Average mSuccessfulRequestMetric = new Average();
    private Average mDataRetrievalMetric = new Average();
    private Average mDataCacheMetric = new Average();
    private Average mResultSetCacheMetric = new Average();
    private Average mAggrTableMetric = new Average();
    private AtomicLong mLastResponseTime = new AtomicLong(0L);
    private AtomicLong mCubeStartTime = new AtomicLong(0L);
    private AtomicLong mMetadataLoadTime = new AtomicLong(0L);
    private AtomicLong mRequests = new AtomicLong(0L);
    private SlidingWindowValue mSuccessfulRequestTimeLastHour = new SlidingWindowValue();
    private SlidingWindowValue mDataRetrievalRatioLastHour = new SlidingWindowValue();
    private SlidingWindowValue mDataCacheHitRatioLastHour = new SlidingWindowValue();
    private SlidingWindowValue mResultSetCacheHitRatioLastHour = new SlidingWindowValue();
    private SlidingWindowValue mAggrTableHitRatioLastHour = new SlidingWindowValue();
    private AtomicLong mMemberSizingMemberNo = new AtomicLong(0L);
    private AtomicLong mMemberSizingMemberSize = new AtomicLong(0L);
    private AtomicLong mMemberSizingStringSize = new AtomicLong(0L);
    private AtomicLong mMemberSizingChildSize = new AtomicLong(0L);
    private ICacheListener mListener = null;

    public ROLAPCubeMetrics(ROLAPCube theCube) {
        this.cube = theCube;
        this.mListener = new ICacheListener(){

            @Override
            public void incrementMisses() {
                ROLAPCubeMetrics.this.recordResultSetCacheAccess(0L, 1L);
            }

            @Override
            public void incrementMisses(long misses) {
                ROLAPCubeMetrics.this.recordResultSetCacheAccess(0L, misses);
            }

            @Override
            public void incrementHits(long hits) {
                ROLAPCubeMetrics.this.recordResultSetCacheAccess(hits, hits);
            }

            @Override
            public void incrementHits() {
                ROLAPCubeMetrics.this.recordResultSetCacheAccess(1L, 1L);
            }
        };
    }

    public static List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Metric m : Metric.values()) {
            list.add(m.name());
        }
        return list;
    }

    public static List<String> getDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (Metric m : Metric.values()) {
            list.add(m.getDescription());
        }
        return list;
    }

    public static List<OpenType<?>> getTypes() {
        ArrayList list = new ArrayList();
        for (Metric m : Metric.values()) {
            list.add(m.getType());
        }
        return list;
    }

    public List<Object> getValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        this.renderValues(new JMXMetricRenderer(list));
        return list;
    }

    public void getBusMetrics(ROLAPCubeMetricResult res) {
        this.renderValues(new BiBusMetricRenderer(res));
        res.addMetric(this.cube.getName(), "cubeState", this.cube.getState().toString());
    }

    public void renderValues(IMetricContainerRenderer renderer) {
        block32: for (Metric m : Metric.values()) {
            switch (m) {
                case AvgTimePerSuccessfulRequest: {
                    renderer.render(m, this.getAvgTimePerSuccessfulRequest());
                    continue block32;
                }
                case AvgTimePerSuccessfulRequestInLastHour: {
                    renderer.render(m, this.getAvgTimePerSuccessfulRequestInLastHour());
                    continue block32;
                }
                case AvgPercentageOfTimeSpentRetrievingData: {
                    renderer.render(m, this.getAvgPercentageOfTimeSpentRetrievingData());
                    continue block32;
                }
                case AvgPercentageOfTimeSpentRetrievingDataInLastHour: {
                    renderer.render(m, this.getAvgPercentageOfTimeSpentRetrievingDataInLastHour());
                    continue block32;
                }
                case AvgPercentageOfDataCacheHits: {
                    renderer.render(m, this.getAvgPercentageOfDataCacheHits());
                    continue block32;
                }
                case AvgPercentageOfDataCacheHitsInLastHour: {
                    renderer.render(m, this.getAvgPercentageOfDataCacheHitsInLastHour());
                    continue block32;
                }
                case AvgPercentageOfResultSetCacheHits: {
                    renderer.render(m, this.getAvgPercentageOfResultSetCacheHits());
                    continue block32;
                }
                case AvgPercentageOfResultSetCacheHitsInLastHour: {
                    renderer.render(m, this.getAvgPercentageOfResultSetCacheHitsInLastHour());
                    continue block32;
                }
                case AvgPercentageOfAggrTableHits: {
                    renderer.render(m, this.getAvgPercentageOfAggrTableHits());
                    continue block32;
                }
                case AvgPercentageOfAggrTableHitsInLastHour: {
                    renderer.render(m, this.getAvgPercentageOfAggrTableHitsInLastHour());
                    continue block32;
                }
                case LastResponseTime: {
                    renderer.render(m, this.getLastResponseTime());
                    continue block32;
                }
                case NumberOfProcessedRequests: {
                    renderer.render(m, this.getNumberOfProcessedRequests());
                    continue block32;
                }
                case ServiceTime: {
                    renderer.render(m, this.getServiceTime());
                    continue block32;
                }
                case TimeToLoadMetadata: {
                    renderer.render(m, this.getTimeToLoadMetadata());
                    continue block32;
                }
                case NumbersOfInMemoryAggregates: {
                    renderer.render(m, this.getNumberOfLoadedInMemoryAggregates(), this.getNumberOfDefinedInMemoryAggregates());
                    continue block32;
                }
                case TimeToLoadInMemoryAggregates: {
                    renderer.render(m, this.getTimeToLoadInMemoryAggregates());
                    continue block32;
                }
                case AvgPercentageOfInMemoryAggregateCacheHits: {
                    renderer.render(m, this.getAvgPercentageOfInMemoryAggregateCacheHits());
                    continue block32;
                }
                case AvgPercentageOfInMemoryAggregateCacheHitsInLastHour: {
                    renderer.render(m, this.getAvgPercentageOfInMemoryAggregateCacheHitsInLastHour());
                    continue block32;
                }
                case DataCacheUsage: {
                    renderer.renderCacheSizes(m, this.getDataCacheSize(), this.getMaxDataCacheSize());
                    continue block32;
                }
                case InMemoryAggregateCacheUsage: {
                    renderer.renderCacheSizes(m, this.getAggrCacheSize(), this.getMaxAggrCacheSize());
                    continue block32;
                }
                case ResultSetCacheUsage: {
                    renderer.renderCacheSizes(m, this.getResultCacheSize(), this.getMaxResultCacheSize());
                    continue block32;
                }
                case MembersInMemberCache: {
                    renderer.render(m, new Long(this.getCachedMemberCount()));
                    continue block32;
                }
                case MemberSizingMemberNo: {
                    renderer.render(m, new Long(this.getMemberSizingMemberNo()));
                    continue block32;
                }
                case MemberSizingMemberSize: {
                    renderer.render(m, new Long(this.getMemberSizingMemberSize()));
                    continue block32;
                }
                case MemberSizingStringSize: {
                    renderer.render(m, new Long(this.getMemberSizingStringSize()));
                    continue block32;
                }
                case MemberSizingChildSize: {
                    renderer.render(m, new Long(this.getMemberSizingChildSize()));
                    continue block32;
                }
                case TIDValueOfLatestIncrement: {
                    renderer.render(m, this.getLatestIncrementTID());
                    continue block32;
                }
                case TimeLatestIncrementAvailable: {
                    long latestIncrementTime = this.getTimeLatestIncrementBecameAvailable();
                    if (latestIncrementTime != 0L) {
                        renderer.render(m, new Date(latestIncrementTime));
                        continue block32;
                    }
                    renderer.render(m, null);
                    continue block32;
                }
                case DurationToBuildLatestIncrement: {
                    renderer.render(m, this.getDurationToBuildInLatestIncrement());
                    continue block32;
                }
                case IsNRTCube: {
                    renderer.render(m, this.isNRTCube());
                    continue block32;
                }
                default: {
                    throw new IllegalStateException("Unknown metric - " + m.name());
                }
            }
        }
    }

    public static String formatCacheSizes(double size, long limit) {
        if (size == 0.0 || size >= 100.0) {
            return String.format(Locale.US, "%d %d", Math.round(size), limit);
        }
        if (size < 0.1) {
            size = 0.1;
        }
        return String.format(Locale.US, "%.1f %d", size, limit);
    }

    public static String spaceSeparatedLongs(long left, long right) {
        StringBuilder value = new StringBuilder();
        value.append(left).append(" ").append(right);
        return value.toString();
    }

    public void recordSuccessfulRequestTime(long time) {
        this.mSuccessfulRequestMetric.addValue(time, 1L);
        this.mSuccessfulRequestTimeLastHour.recordValue(time, 1L);
    }

    public void recordQueryTime(long dataRetrievalTime, long totalQueryTime) {
        long dataTime = dataRetrievalTime;
        if (dataRetrievalTime > totalQueryTime) {
            mErrorLogger.log(LogLevel.INFO, "Adjusting data retrieval time " + Long.toString(dataRetrievalTime) + " to match total query time " + Long.toString(totalQueryTime));
            dataTime = totalQueryTime;
        }
        this.mDataRetrievalMetric.addValue(dataTime, totalQueryTime);
        this.mDataRetrievalRatioLastHour.recordValue(dataTime, totalQueryTime);
    }

    public void recordDataCacheAccess(long hits, long total) {
        this.mDataCacheMetric.addValue(hits, total);
        this.mDataCacheHitRatioLastHour.recordValue(hits, total);
    }

    public void recordResultSetCacheAccess(long hits, long total) {
        this.mResultSetCacheMetric.addValue(hits, total);
        this.mResultSetCacheHitRatioLastHour.recordValue(hits, total);
    }

    public void recordAggrTableAccess(long hits, long total) {
        this.mAggrTableMetric.addValue(hits, total);
        this.mAggrTableHitRatioLastHour.recordValue(hits, total);
    }

    public void recordResponseTime(long time) {
        this.mLastResponseTime.set(time);
    }

    public void recordProcessedRequest() {
        this.mRequests.incrementAndGet();
    }

    public void recordCubeStartTime(long time) {
        this.mCubeStartTime.set(time);
    }

    public void recordMetadataLoadTime(long time) {
        this.mMetadataLoadTime.set(time);
    }

    public void notifyDataCacheCleared() {
        this.mSuccessfulRequestMetric.clear();
        this.mDataRetrievalMetric.clear();
        this.mDataCacheMetric.clear();
        this.mResultSetCacheMetric.clear();
        this.mAggrTableMetric.clear();
        this.mLastResponseTime.set(0L);
        this.mRequests.set(0L);
        this.mSuccessfulRequestTimeLastHour.clear();
        this.mDataRetrievalRatioLastHour.clear();
        this.mDataCacheHitRatioLastHour.clear();
        this.mResultSetCacheHitRatioLastHour.clear();
        this.mAggrTableHitRatioLastHour.clear();
    }

    public long getAvgTimePerSuccessfulRequest() {
        return Math.round(this.mSuccessfulRequestMetric.getValue());
    }

    public long getAvgTimePerSuccessfulRequestInLastHour() {
        return Math.round(this.mSuccessfulRequestTimeLastHour.getAverage());
    }

    public double getAvgPercentageOfTimeSpentRetrievingData() {
        return this.mDataRetrievalMetric.getValue();
    }

    public double getAvgPercentageOfTimeSpentRetrievingDataInLastHour() {
        return this.mDataRetrievalRatioLastHour.getAverage();
    }

    public double getAvgPercentageOfDataCacheHits() {
        return this.mDataCacheMetric.getValue();
    }

    public double getAvgPercentageOfDataCacheHitsInLastHour() {
        return this.mDataCacheHitRatioLastHour.getAverage();
    }

    public double getAvgPercentageOfResultSetCacheHits() {
        return this.mResultSetCacheMetric.getValue();
    }

    public double getAvgPercentageOfResultSetCacheHitsInLastHour() {
        return this.mResultSetCacheHitRatioLastHour.getAverage();
    }

    public double getAvgPercentageOfAggrTableHits() {
        return this.mAggrTableMetric.getValue();
    }

    public double getAvgPercentageOfAggrTableHitsInLastHour() {
        return this.mAggrTableHitRatioLastHour.getAverage();
    }

    public long getLastResponseTime() {
        return this.mLastResponseTime.get();
    }

    public long getNumberOfProcessedRequests() {
        return this.mRequests.get();
    }

    public long getServiceTime() {
        long startTime = this.mCubeStartTime.get();
        if (startTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - startTime;
    }

    public long getTimeToLoadMetadata() {
        return this.mMetadataLoadTime.get();
    }

    public ICacheListener getResultSetCacheListener() {
        return this.mListener;
    }

    public long getNumberOfDefinedInMemoryAggregates() {
        long numAggregates = -1L;
        try {
            ROLAPDataCache currentDataCache;
            if (this.cube.isUp() && (currentDataCache = this.cube.getCurrentDataCache()) != null) {
                numAggregates = currentDataCache.getDefinedInMemoryAggregateCount();
            }
            if (numAggregates < 0L && this.cube instanceof ROLAPBaseCube) {
                numAggregates = ((ROLAPBaseCube)this.cube).getEstimatedInMemoryAggregateCount();
            }
        }
        catch (Throwable e) {
            mErrorLogger.log(METRICS_ERROR, e);
        }
        if (numAggregates < 0L) {
            numAggregates = 0L;
        }
        return numAggregates;
    }

    public long getNumberOfLoadedInMemoryAggregates() {
        if (this.cube.isUp()) {
            try {
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null) {
                    return currentDataCache.getLoadedInMemoryAggregateCount();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public long getTimeToLoadInMemoryAggregates() {
        if (this.cube.isUp()) {
            try {
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null) {
                    long loadStartTime = currentDataCache.getInMemoryAggregateLoadStartTime();
                    long loadEndTime = currentDataCache.getInMemoryAggregateLoadEndTime();
                    if (loadStartTime == 0L) {
                        return 0L;
                    }
                    if (loadEndTime == 0L) {
                        return System.currentTimeMillis() - loadStartTime;
                    }
                    return loadEndTime - loadStartTime;
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public double getAvgPercentageOfInMemoryAggregateCacheHits() {
        if (this.cube.isUp()) {
            try {
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null) {
                    return currentDataCache.getInMemoryAggregateCacheHitRate();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0.0;
    }

    public double getAvgPercentageOfInMemoryAggregateCacheHitsInLastHour() {
        if (this.cube.isUp()) {
            try {
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null) {
                    return currentDataCache.getInMemoryAggregateCacheHitRateInLastHour();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0.0;
    }

    public static void recordGlobalMetrics(RequestEnvironment env, long time, boolean requestSucceeded) {
        ROLAPContext context = ROLAPContext.get(env.getExecutionEnvironment());
        if (context == null) {
            return;
        }
        Set<ROLAPCube> cubes = context.getCubesUsedInContext();
        HashSet<ROLAPCube> rootCubes = new HashSet<ROLAPCube>();
        for (ROLAPCube cube : cubes) {
            boolean isRoot = true;
            for (ROLAPCube depCube : cube.getDependentCubes()) {
                if (!cubes.contains(depCube)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootCubes.add(cube);
        }
        for (ROLAPCube cube : rootCubes) {
            ROLAPCubeMetrics metrics = cube.getMetrics();
            metrics.recordResponseTime(time);
            metrics.recordProcessedRequest();
            if (!requestSucceeded) continue;
            metrics.recordSuccessfulRequestTime(time);
        }
    }

    public long getMaxDataCacheSize() {
        if (this.cube.isUp()) {
            try {
                ROLAPCubeConfiguration config = this.cube.getCubeConfiguration();
                if (config != null) {
                    return config.getMaxDataCacheSize();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public long getMaxAggrCacheSize() {
        if (this.cube.isUp()) {
            try {
                ROLAPCubeConfiguration config = this.cube.getCubeConfiguration();
                if (config != null) {
                    return config.getMaxAggregateCacheSize();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public long getMaxResultCacheSize() {
        if (this.cube.isUp()) {
            try {
                ROLAPCubeConfiguration config = this.cube.getCubeConfiguration();
                if (config != null) {
                    return config.getResultSetCacheSizeLimit();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public double getDataCacheSize() {
        if (this.cube.isUp()) {
            try {
                IBlockTupleStorage tupleStorage;
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null && (tupleStorage = currentDataCache.getBlockTupleStorage()) instanceof CubeletStorage) {
                    return (double)((CubeletStorage)tupleStorage).getSize() / 1048576.0;
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0.0;
    }

    public double getAggrCacheSize() {
        if (this.cube.isUp()) {
            try {
                AggregateCubeletStorage cubeletStorage;
                ROLAPDataCache currentDataCache = this.cube.getCurrentDataCache();
                if (currentDataCache != null && (cubeletStorage = currentDataCache.getAggregateStorage()) != null) {
                    return (double)cubeletStorage.getSize() / 1048576.0;
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0.0;
    }

    public double getResultCacheSize() {
        if (this.cube.isUp()) {
            try {
                ICubeResultSetCache resultSetCache = this.cube.getResultSetCache();
                if (resultSetCache != null) {
                    return (double)resultSetCache.getCurrentCacheSize() / 1048576.0;
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0.0;
    }

    public long getCachedMemberCount() {
        if (this.cube.isUp()) {
            try {
                ROLAPMemberCache currentMemberCache;
                ROLAPCacheManager<ROLAPMemberCache> cacheManager = this.cube.getMemberCacheManager();
                if (cacheManager != null && (currentMemberCache = cacheManager.getCurrentRevision()) != null) {
                    return currentMemberCache.getCachedMemberCount();
                }
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return 0L;
    }

    public long getMemberSizingMemberNo() {
        return this.mMemberSizingMemberNo.get();
    }

    public long getMemberSizingMemberSize() {
        return this.mMemberSizingMemberSize.get();
    }

    public long getMemberSizingStringSize() {
        return this.mMemberSizingStringSize.get();
    }

    public long getMemberSizingChildSize() {
        return this.mMemberSizingChildSize.get();
    }

    public void setMemberSizingMemberNo(long val) {
        this.mMemberSizingMemberNo.set(val);
    }

    public void setMemberSizingMemberSize(long val) {
        this.mMemberSizingMemberSize.set(val);
    }

    public void setMemberSizingStringSize(long val) {
        this.mMemberSizingStringSize.set(val);
    }

    public void setMemberSizingChildSize(long val) {
        this.mMemberSizingChildSize.set(val);
    }

    public String getLatestIncrementTID() {
        IncrementMetrics metrics = this.getLatestIncrementMetrics();
        if (metrics != null) {
            return metrics.getTID();
        }
        return null;
    }

    public long getDurationToBuildInLatestIncrement() {
        IncrementMetrics metrics = this.getLatestIncrementMetrics();
        if (metrics != null) {
            return metrics.getDurationToBuildLatestIncrement();
        }
        return 0L;
    }

    public long getTimeLatestIncrementBecameAvailable() {
        IncrementMetrics metrics = this.getLatestIncrementMetrics();
        if (metrics != null) {
            return metrics.getTimeLatestIncrementBecameAvailable();
        }
        return 0L;
    }

    private IncrementMetrics getLatestIncrementMetrics() {
        IncrementMetrics metrics = null;
        if (this.cube.isUp()) {
            try {
                metrics = this.cube.getLastestIncrementMetrics();
            }
            catch (Throwable e) {
                mErrorLogger.log(METRICS_ERROR, e);
            }
        }
        return metrics;
    }

    public boolean isNRTCube() {
        if (this.cube instanceof ROLAPBaseCube) {
            return ((ROLAPBaseCube)this.cube).isNearRealTime();
        }
        return false;
    }

    private class JMXMetricRenderer
    implements IMetricContainerRenderer {
        ArrayList<Object> list;

        JMXMetricRenderer(ArrayList<Object> lst) {
            this.list = lst;
        }

        @Override
        public void render(Metric metric, Object value) {
            this.list.add(value);
        }

        @Override
        public void render(Metric metric, Long value1, Long value2) {
            this.list.add(ROLAPCubeMetrics.spaceSeparatedLongs(value1, value2));
        }

        @Override
        public void renderCacheSizes(Metric metric, Double value1, Long value2) {
            this.list.add(ROLAPCubeMetrics.formatCacheSizes(value1, value2));
        }
    }

    private class BiBusMetricRenderer
    implements IMetricContainerRenderer {
        ROLAPCubeMetricResult result;

        BiBusMetricRenderer(ROLAPCubeMetricResult res) {
            this.result = res;
        }

        @Override
        public void render(Metric metric, Object value) {
            if (!this.metricApplies(metric)) {
                return;
            }
            String[] metrics = metric.getBusNames();
            if (metrics == null || metrics.length == 0) {
                return;
            }
            if (metrics.length != 1) {
                throw new IllegalStateException("Expected single metric");
            }
            this.result.addMetric(ROLAPCubeMetrics.this.cube.getName(), metrics[0], value);
        }

        @Override
        public void render(Metric metric, Long value1, Long value2) {
            if (!this.metricApplies(metric)) {
                return;
            }
            String[] metrics = metric.getBusNames();
            if (metrics == null || metrics.length == 0) {
                return;
            }
            if (metrics.length != 2) {
                throw new IllegalStateException("Expected two metric values ");
            }
            this.result.addMetric(ROLAPCubeMetrics.this.cube.getName(), metrics[0], value1);
            this.result.addMetric(ROLAPCubeMetrics.this.cube.getName(), metrics[1], value2);
        }

        @Override
        public void renderCacheSizes(Metric metric, Double value1, Long value2) {
            if (!this.metricApplies(metric)) {
                return;
            }
            String[] metrics = metric.getBusNames();
            if (metrics == null || metrics.length == 0) {
                return;
            }
            if (metrics.length != 2) {
                throw new IllegalStateException("Expected two metric values");
            }
            if (value1 > 0.0 && value1 < 0.1) {
                value1 = 0.1;
            }
            this.result.addMetric(ROLAPCubeMetrics.this.cube.getName(), metrics[0], value1);
            this.result.addMetric(ROLAPCubeMetrics.this.cube.getName(), metrics[1], value2);
        }

        private boolean metricApplies(Metric metric) {
            if (ROLAPCubeMetrics.this.cube.isVirtual()) {
                return VIRTUAL_CUBE_METRICS.contains((Object)metric);
            }
            return BASE_CUBE_METRICS.contains((Object)metric);
        }
    }

    private static interface IMetricContainerRenderer {
        public void render(Metric var1, Object var2);

        public void render(Metric var1, Long var2, Long var3);

        public void renderCacheSizes(Metric var1, Double var2, Long var3);
    }

    public static class SlidingWindowValue {
        private ConcurrentLinkedQueue<Segment> values = new ConcurrentLinkedQueue();
        private Segment currSegment = null;

        public void recordValue(long value, long count) {
            long currTime = System.nanoTime();
            long pastHour = currTime - HOUR;
            Segment seg = null;
            Iterator<Segment> it = this.values.iterator();
            if (it.hasNext() && (seg = it.next()).getTimestamp() < pastHour) {
                it.remove();
            }
            if ((seg = this.currSegment) == null || currTime - seg.getTimestamp() > SEGMENT_DURATION) {
                seg = new Segment(currTime);
                this.values.add(seg);
                this.currSegment = seg;
            }
            seg.addValue(value, count);
        }

        void clear() {
            this.currSegment = null;
            this.values.clear();
        }

        public double getAverage() {
            long pastHour = System.nanoTime() - HOUR;
            double dividend = 0.0;
            long divisor = 0L;
            Iterator<Segment> it = this.values.iterator();
            while (it.hasNext()) {
                Segment seg = it.next();
                if (seg.getTimestamp() < pastHour) {
                    it.remove();
                    continue;
                }
                AverageComponents comp = seg.getComponents();
                dividend += (double)comp.getDividend();
                divisor += comp.getDivisor();
            }
            if (divisor == 0L) {
                return 0.0;
            }
            return dividend / (double)divisor;
        }

        private class Segment {
            private long timestamp;
            private Average value = new Average();

            Segment(long time) {
                this.timestamp = time;
            }

            void addValue(long dividend, long divisor) {
                this.value.addValue(dividend, divisor);
            }

            long getTimestamp() {
                return this.timestamp;
            }

            AverageComponents getComponents() {
                return this.value.getComponents();
            }
        }
    }

    public static class Average {
        private AtomicReference<AverageComponents> value = new AtomicReference<Object>(null);

        public void addValue(long dnd, long dor) {
            long divisor;
            long dividend;
            AverageComponents newValue;
            AverageComponents oldValue;
            do {
                oldValue = this.value.get();
                dividend = dnd;
                divisor = dor;
                if (oldValue == null) continue;
                dividend += oldValue.getDividend();
                divisor += oldValue.getDivisor();
            } while (!this.value.compareAndSet(oldValue, newValue = new AverageComponents(dividend, divisor)));
        }

        void clear() {
            this.value.set(null);
        }

        public double getValue() {
            AverageComponents val = this.value.get();
            if (val == null || val.getDivisor() == 0L) {
                return 0.0;
            }
            return (double)val.getDividend() / (double)val.getDivisor();
        }

        AverageComponents getComponents() {
            return this.value.get();
        }
    }

    public static class AverageComponents {
        private long mDividend;
        private long mDivisor;

        AverageComponents(long dnd, long dor) {
            this.mDividend = dnd;
            this.mDivisor = dor;
        }

        long getDividend() {
            return this.mDividend;
        }

        long getDivisor() {
            return this.mDivisor;
        }
    }

    public static enum Metric {
        AvgTimePerSuccessfulRequest(SimpleType.LONG, "Average time spent executing a successful request", new String[]{"averageSuccessfulRequestTime"}, new MetricFormat[]{MetricFormat.Time}),
        AvgTimePerSuccessfulRequestInLastHour(SimpleType.LONG, "Average time spent executing a successful request in the last hour", new String[]{"averageSuccessfulRequestTimeInLastHour"}, new MetricFormat[]{MetricFormat.Time}),
        AvgPercentageOfTimeSpentRetrievingData(SimpleType.DOUBLE, "Average percentage of time spent retrieving data from the underlying data source", new String[]{"percentageTimeSpentRetrievingData"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfTimeSpentRetrievingDataInLastHour(SimpleType.DOUBLE, "Average percentage of time spent retrieving data from the underlying data source in the last hour", new String[]{"percentageTimeSpentRetrievingDataInLastHour"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfDataCacheHits(SimpleType.DOUBLE, "Average percentage of data cache hits vs. total data cache accesses", new String[]{"dataCacheHitRate"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfDataCacheHitsInLastHour(SimpleType.DOUBLE, "Average percentage of data cache hits vs. total data cache accesses in the last hour", new String[]{"dataCacheHitRateInLastHour"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfResultSetCacheHits(SimpleType.DOUBLE, "Average percentage of result set cache hits vs. total result set cache accesses", new String[]{"resultSetCacheHitRate"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfResultSetCacheHitsInLastHour(SimpleType.DOUBLE, "Average percentage of result set cache hits vs. total result set cache accesses in the last hour", new String[]{"resultSetCacheHitRateInLastHour"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfAggrTableHits(SimpleType.DOUBLE, "Average percentage of aggregate table hits vs. total aggregate table reads", new String[]{"aggregateTableHitRate"}, new MetricFormat[]{MetricFormat.Percent}),
        AvgPercentageOfAggrTableHitsInLastHour(SimpleType.DOUBLE, "Average percentage of aggregate table hits vs. total aggregate table reads in the last hour", new String[]{"aggregateTableHitRateInLastHour"}, new MetricFormat[]{MetricFormat.Percent}),
        LastResponseTime(SimpleType.LONG, "Last response time for a request", new String[]{"lastResponseTime"}, new MetricFormat[]{MetricFormat.Time}),
        NumberOfProcessedRequests(SimpleType.LONG, "Number of processed requests", new String[]{"numberOfProcessedRequests"}, new MetricFormat[]{MetricFormat.Number}),
        ServiceTime(SimpleType.LONG, "Time since the time cube was started", new String[]{"upTime"}, new MetricFormat[]{MetricFormat.Time}),
        TimeToLoadMetadata(SimpleType.LONG, "Last time it took to load cube metadata", new String[]{"lastMetadataLoadTime"}, new MetricFormat[]{MetricFormat.Time}),
        NumbersOfInMemoryAggregates(SimpleType.STRING, "Numbers of loaded and defined in-memory aggregates", new String[]{"loadedInMemoryAggregates", "definedInMemoryAggregates"}, new MetricFormat[]{MetricFormat.Number, MetricFormat.Number}),
        TimeToLoadInMemoryAggregates(SimpleType.LONG, "Time to load in-memory aggregates", new String[]{"timeSpentLoadingInMemoryAggregates"}, new MetricFormat[]{MetricFormat.Time}),
        AvgPercentageOfInMemoryAggregateCacheHits(SimpleType.DOUBLE, "Average percentage of in-memory aggregate cache hits vs. total in-memory aggregate cache accesses", new String[]{"inMemoryAggregateCacheHitRate"}, new MetricFormat[]{MetricFormat.Time}),
        AvgPercentageOfInMemoryAggregateCacheHitsInLastHour(SimpleType.DOUBLE, "Average percentage of in-memory aggregate cache hits vs. total in-memory aggregate cache accesses in the last hour", new String[]{"inMemoryAggregateCacheHitRateInLastHour"}, new MetricFormat[]{MetricFormat.Time}),
        DataCacheUsage(SimpleType.STRING, "The amount of memory used as a fraction of the defined size of the data cache.", new String[]{"usedSizeOfDataCache", "definedSizeOfDataCache"}, new MetricFormat[]{MetricFormat.Usage, MetricFormat.Number}),
        InMemoryAggregateCacheUsage(SimpleType.STRING, "The amount of memory used as a fraction of the defined size of the in-memory aggregate cache.", new String[]{"usedSizeOfInMemoryAggregateCache", "definedSizeOfInMemoryAggregateCache"}, new MetricFormat[]{MetricFormat.Usage, MetricFormat.Number}),
        ResultSetCacheUsage(SimpleType.STRING, "The amount of disk space used as a fraction of the defined size of the result set cache.", new String[]{"usedSizeOfResultSetCache", "definedSizeOfResultSetCache"}, new MetricFormat[]{MetricFormat.Usage, MetricFormat.Number}),
        MembersInMemberCache(SimpleType.LONG, "The number of members loaded into the member cache for all hierarchies in a cube.", new String[]{"numberOfMembersInMemberCache"}, new MetricFormat[]{MetricFormat.Number}),
        MemberSizingMemberNo(SimpleType.LONG, "The number of members traversed.", null, null),
        MemberSizingMemberSize(SimpleType.LONG, "The total member size.", null, null),
        MemberSizingStringSize(SimpleType.LONG, "The total member string size.", null, null),
        MemberSizingChildSize(SimpleType.LONG, "The total member child size.", null, null),
        TIDValueOfLatestIncrement(SimpleType.STRING, "TID column value of latest increment", new String[]{"valueOfLastNearRealTimeTID"}, new MetricFormat[]{MetricFormat.String}),
        TimeLatestIncrementAvailable(SimpleType.DATE, "Time the latest increment became available", new String[]{"timeLastNearRealTimeUpdateAvailable"}, new MetricFormat[]{MetricFormat.Date}),
        DurationToBuildLatestIncrement(SimpleType.LONG, "Time to load latest increment", new String[]{"timeToApplyLastNearRealTimeUpdates"}, new MetricFormat[]{MetricFormat.Time}),
        IsNRTCube(SimpleType.BOOLEAN, "Is this cube an NRT cube?", new String[]{"isNRTCube"}, new MetricFormat[]{MetricFormat.Boolean});

        private final OpenType<?> type;
        private final String description;
        private final String[] busNames;
        private final MetricFormat[] busFormats;
        private static final ConcurrentHashMap<String, MetricFormat> BUS_METRIC_FORMATS;
        private static final float HUNDRED = 100.0f;

        private Metric(OpenType<?> t, String d, String[] bn, MetricFormat[] formats) {
            this.type = t;
            this.description = d;
            this.busNames = bn;
            this.busFormats = formats;
        }

        public String getDescription() {
            return this.description;
        }

        public OpenType<?> getType() {
            return this.type;
        }

        public String[] getBusNames() {
            return this.busNames;
        }

        public MetricFormat[] getBusFormats() {
            return this.busFormats;
        }

        public static String format(String name, String value) {
            MetricFormat format = BUS_METRIC_FORMATS.get(name);
            if (format == null || value == null || value.trim().equals("")) {
                return value;
            }
            switch (format) {
                case Number: {
                    try {
                        long val = Long.parseLong(value);
                        return String.format("%,d", val);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Invalid number format - '%s'", value), e);
                    }
                }
                case Percent: {
                    try {
                        float val = Float.parseFloat(value);
                        return String.format("%d%%", (long)(val * 100.0f));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Invalid percent format - '%s'", value), e);
                    }
                }
                case Time: {
                    try {
                        float val = Float.parseFloat(value);
                        return DurationFormatUtils.formatDuration((long)((long)val), (String)"HH:mm:ss.SSS");
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Invalid time format - '%s'", value), e);
                    }
                }
                case Date: {
                    return value;
                }
                case Usage: {
                    try {
                        float val = Float.parseFloat(value);
                        return String.format("%.1f", Float.valueOf(val));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(String.format("Invalid usage format - '%s'", value), e);
                    }
                }
                case String: {
                    return value;
                }
                case Boolean: {
                    return value;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown metric format '%s'", format.name()));
        }

        static {
            BUS_METRIC_FORMATS = new ConcurrentHashMap();
            for (Metric metric : EnumSet.allOf(Metric.class)) {
                String[] bn = metric.getBusNames();
                MetricFormat[] bf = metric.getBusFormats();
                if (bn == null) continue;
                if (bf == null || bn.length != bf.length) {
                    throw new IllegalArgumentException(String.format("Format specs must exist if BiBus names exist for metric '%s', and their numbers must match", metric.name()));
                }
                for (int i = 0; i < bn.length; ++i) {
                    if (bn[i] == null) {
                        throw new IllegalArgumentException(String.format("BiBus name for metric '%s' cannot be null", metric.name()));
                    }
                    if (bf[i] == null) {
                        throw new IllegalArgumentException(String.format("Format for metric '%s' cannot be null", metric.name()));
                    }
                    BUS_METRIC_FORMATS.put(bn[i], bf[i]);
                }
            }
        }
    }

    public static enum MetricFormat {
        Number,
        Percent,
        Time,
        Date,
        Usage,
        String,
        Boolean;

    }
}

