/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.trace.LogLevel;
import java.util.concurrent.atomic.AtomicInteger;

public class ROLAPCubeReservation {
    private final ROLAPCube mCube;
    private final ROLAPMemberCache mMemberCache;
    private ROLAPDataCache mDataCache;
    private ROLAPSecurityCache mSecurityCache;
    private static final AtomicInteger NEXT_RESERVATION_ID = new AtomicInteger(0);
    private final int mReservationID = NEXT_RESERVATION_ID.getAndIncrement();
    private final long mCreationTimestamp = System.currentTimeMillis();
    private int mIncrementID;
    private boolean mInvalid;
    private final ROLAPCubeReservation[] mSourceReservations;
    private ROLAPUserSecurityContext mUserSecurityContext;

    public ROLAPCubeReservation(ROLAPCube cube, ROLAPMemberCache memberCache, ROLAPDataCache dataCache, ROLAPSecurityCache securityCache, ROLAPCubeReservation[] sourceReservations) {
        this.mCube = cube;
        this.mMemberCache = memberCache;
        this.mDataCache = dataCache;
        this.mSecurityCache = securityCache;
        this.mInvalid = false;
        this.mSourceReservations = sourceReservations;
        if (securityCache != null) {
            this.mUserSecurityContext = securityCache.getSecurityManager().createUserSecurityContext();
        }
        this.mIncrementID = this.deriveIncrementId(dataCache);
        if (ROLAPLog.isOn("ROLAPCubes.Management", LogLevel.TRACE)) {
            int memberCacheID = -1;
            if (memberCache != null) {
                memberCacheID = memberCache.getID();
            }
            int dataCacheID = -1;
            if (dataCache != null) {
                dataCacheID = dataCache.getID();
            }
            int securityCacheID = -1;
            if (securityCache != null) {
                securityCacheID = securityCache.getID();
            }
            ROLAPLog.logTrace("ROLAPCubes.Management", String.format("Reservation %d (memberCache=%d, dataCache=%d, securityCache=%d, incrementID=%d) was created.", this.mReservationID, memberCacheID, dataCacheID, securityCacheID, this.mIncrementID));
        }
        if (ROLAPLog.isOn("ROLAPCubes.IncrementalUpdates", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPCubes.IncrementalUpdates", String.format("Reservation %d is using incrementID=%d.", this.mReservationID, this.mIncrementID));
        }
    }

    public ROLAPCubeReservation(ROLAPCube cube, ROLAPMemberCache memberCache, ROLAPDataCache dataCache, ROLAPSecurityCache securityCache) {
        this(cube, memberCache, dataCache, securityCache, null);
    }

    private void assertValid() {
        if (this.isInvalid()) {
            throw new OperationCanceledException();
        }
    }

    public void invalidate() {
        this.mInvalid = true;
        if (this.mMemberCache != null) {
            this.mMemberCache.invalidate();
        }
        if (this.mDataCache != null) {
            this.mDataCache.invalidate();
        }
        if (this.mSecurityCache != null) {
            this.mSecurityCache.invalidate();
        }
    }

    public boolean isInvalid() {
        return this.mInvalid;
    }

    public ROLAPCube getCube() {
        this.assertValid();
        return this.mCube;
    }

    public ROLAPMemberCache getMemberCache() {
        this.assertValid();
        return this.mMemberCache;
    }

    public ROLAPDataCache getDataCache() {
        this.assertValid();
        return this.mDataCache;
    }

    public void setDataCache(ROLAPDataCache dataCache) {
        this.mDataCache = dataCache;
        this.mIncrementID = this.deriveIncrementId(dataCache);
    }

    public void setSecurityCache(ROLAPSecurityCache securityCache) {
        this.mSecurityCache = securityCache;
    }

    public ROLAPSecurityCache getSecurityCache() {
        this.assertValid();
        return this.mSecurityCache;
    }

    public int getID() {
        return this.mReservationID;
    }

    public int getIncrementID() {
        this.assertValid();
        return this.mIncrementID;
    }

    public void setIncrementID(int newIncrementID) {
        this.assertValid();
        this.mIncrementID = newIncrementID;
    }

    private int deriveIncrementId(ROLAPDataCache dataCache) {
        IncrementManager im;
        String jvmOverride = System.getProperty("incrementIdCurrentValue");
        if (jvmOverride != null) {
            return Integer.parseInt(jvmOverride);
        }
        int id = 0;
        if (dataCache != null && (im = dataCache.getIncrementManager()) != null) {
            id = im.getCurrentIncrementID();
        }
        return id;
    }

    public long getTimestamp() {
        this.assertValid();
        return this.mCreationTimestamp;
    }

    public ROLAPCubeReservation[] getSourceReservations() {
        this.assertValid();
        return this.mSourceReservations;
    }

    public ROLAPUserSecurityContext getUserSecurityContext() {
        this.assertValid();
        return this.mUserSecurityContext;
    }
}

