/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.util.fsm.IStateGovernor;

public class ROLAPCubeReservationGovernor
implements IStateGovernor<ROLAPCubeStateEnum, ROLAPCubeStateContext> {
    @Override
    public boolean canTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
        if (ctx.getCube().isDeleted() && ROLAPCubeStateEnum.STOPPED != to && ROLAPCubeStateEnum.STOPPING != to && ROLAPCubeStateEnum.DISABLED != to) {
            return false;
        }
        if (ROLAPCubeStateEnum.STOPPED == to) {
            return ctx.isForceStop() || 0 == ctx.getCube().getReservationCount();
        }
        return true;
    }

    @Override
    public void beforeTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
        if (ROLAPCubeStateEnum.STOPPED == to && !ctx.isForceStop() && ctx.getCube().getReservationCount() != 0) {
            this.throwBadReservationCount(ctx.getCube());
        }
    }

    @Override
    public void afterTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
        if (ROLAPCubeStateEnum.STOPPED == to && !ctx.isForceStop() && ctx.getCube().getReservationCount() != 0) {
            this.throwBadReservationCount(ctx.getCube());
        }
    }

    @Override
    public void failedTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
    }

    private void throwBadReservationCount(ROLAPCube cube) {
        throw new IllegalStateException("Reservation count was non-zero for ROLAP cube " + cube.toString());
    }
}

