/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryResultIteratorFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.RolapQueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorSampleFilterPartGenerator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.QueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;

public class AdvisorMemberSample {
    private ROLAPMetaCube cubeModel;
    private ROLAPMetaMeasure metaMeasure;
    private ROLAPMetaHierarchy samplingHierarchy;
    private ROLAPMetaLevel samplingLevel;
    private ArrayList<ROLAPMetaAttribute> keysToProject = new ArrayList();
    private static final String SAMPLE_NAME = "sampling_query_name";
    private List<IValue[]> mInnerJoinResultSet = new ArrayList<IValue[]>();
    private List<IValue[]> singleMemberResultSet = new ArrayList<IValue[]>();
    private List<IValue[]> multipleMemberResultSet = new ArrayList<IValue[]>();
    private List<IValue[]> sampleOfResultSet = new ArrayList<IValue[]>();
    private List<List<String>> levelFilters = new ArrayList<List<String>>();
    private List<AdvisorSampleFilterPartGenerator> mFilterParts = new ArrayList<AdvisorSampleFilterPartGenerator>();
    private List<Integer> levelCardinalityBasedOnFactData = new ArrayList<Integer>();
    private long totalFactRowCount = 0L;
    private boolean enableTestFeatures = false;
    protected static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static final double HUNDRED_PERCENT = 100.0;
    private static final double MAX_SAMPLING_RATE = 0.05;
    private static final int MAX_NUM_SAMPLING_MEMBERS = 7;

    public void setSamplingLevel(ROLAPMetaCube aCubeModel, ROLAPMetaMeasure aMetaMeasure, ROLAPMetaHierarchy aSamplingHierarchy, ROLAPMetaLevel aSamplingLevel, boolean anEnableTestFeatures) {
        INFO_LOGGER.log("Set sampling level - begin");
        this.cubeModel = aCubeModel;
        this.metaMeasure = aMetaMeasure;
        this.samplingHierarchy = aSamplingHierarchy;
        this.samplingLevel = aSamplingLevel;
        this.enableTestFeatures = anEnableTestFeatures;
        INFO_LOGGER.log("enableTestFeatures = " + this.enableTestFeatures);
        this.init();
        this.obtainSampleDimensionMembersUsedInFact();
        this.selectMembersToUseWhenSampling();
        INFO_LOGGER.log("Set sampling level - end");
    }

    private void init() {
        this.mInnerJoinResultSet = new ArrayList<IValue[]>();
        this.singleMemberResultSet = new ArrayList<IValue[]>();
        this.multipleMemberResultSet = new ArrayList<IValue[]>();
        this.sampleOfResultSet = new ArrayList<IValue[]>();
        this.mFilterParts = new ArrayList<AdvisorSampleFilterPartGenerator>();
    }

    private void obtainSampleDimensionMembersUsedInFact() {
        INFO_LOGGER.log("Obtain members of the sampling dimension that are used by the fact - begin");
        int attributeOrdinal = -1;
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            for (ROLAPMetaAttribute attribute : level.getLevelKeys()) {
                ++attributeOrdinal;
                this.keysToProject.add(attribute);
                if (!level.getName().equals(this.samplingLevel.getName())) continue;
                this.mFilterParts.add(new AdvisorSampleFilterPartGenerator(attribute, attributeOrdinal));
            }
        }
        ArrayList<String[]> dataItemsInfo = new ArrayList<String[]>();
        for (ROLAPMetaAttribute attr : this.keysToProject) {
            dataItemsInfo.add(new String[]{attr.getName(), attr.getQueryItem()});
        }
        dataItemsInfo.add(new String[]{this.metaMeasure.getName(), this.metaMeasure.getQueryItem()});
        dataItemsInfo.add(new String[]{"IBMAdvisorCount", "count(1)"});
        this.runQuery(dataItemsInfo);
        INFO_LOGGER.log("Obtain members of the sampling dimension that are used by the fact - end");
    }

    private void runQuery(List<String[]> dataItemsInfo) {
        INFO_LOGGER.log("Execute V5 query to fetch members - begin");
        QueryHelper.AggregateQuerySetBuilder aggrQuerySetBuilder = new QueryHelper.AggregateQuerySetBuilder(this.cubeModel.getName(), SAMPLE_NAME, dataItemsInfo, null);
        PlannedV5QuerySet plannedQuery = QueryHelper.planV5QuerySet(this.cubeModel.getName(), aggrQuerySetBuilder);
        INFO_LOGGER.log(String.format("\nSQL to fetch sampling dimension members\n%s\n", this.getPlannedQuerySql(plannedQuery)));
        RSAPIDataset dataset = RolapQueryHelper.getDataset(SAMPLE_NAME, plannedQuery);
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        ROLAPCube myCube = ROLAPCubeManager.getInstance().getCube(this.cubeModel.getName());
        envHelper.setCMRequestExecutor(myCube.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        ROLAPContext.setRelQueryExecuting();
        ExecutionEnvironment execEnv = envHelper.getExecutionEnvironment();
        IROLAPQueryResultIterator rolapQueryResultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, execEnv);
        while (rolapQueryResultIterator.hasNext()) {
            IValue[] values = rolapQueryResultIterator.next().getColumns();
            this.mInnerJoinResultSet.add(new IValue[values.length]);
            IValue[] resultSetElementReference = this.mInnerJoinResultSet.get(this.mInnerJoinResultSet.size() - 1);
            int ii = 0;
            for (IValue value : values) {
                resultSetElementReference[ii++] = (IValue)value.copy();
            }
        }
        rolapQueryResultIterator.close();
        envHelper.tearDownEnvironment();
        INFO_LOGGER.log("Execute V5 query to fetch members - end");
    }

    private String getPlannedQuerySql(PlannedV5QuerySet plannedQuery) {
        String sql = "";
        IXQEQueryNode[] sqls = plannedQuery.getDescendantsOfType(501013, false);
        if (sqls != null && sqls.length > 0) {
            XSql sqlNode = (XSql)sqls[0];
            sql = sqlNode.getSqlText();
        }
        return sql;
    }

    private void selectMembersToUseWhenSampling() {
        INFO_LOGGER.log("Select the subset of members to use when sampling");
        this.traceResultSet(this.mInnerJoinResultSet);
        this.totalFactRowCount = this.countResultSet(this.mInnerJoinResultSet);
        this.traceHierarchyMembers();
        this.determineActualLevelCardinalties();
        this.getSampleOfMembersOriginal();
    }

    protected void selectLogicalSamplingLevel() {
        INFO_LOGGER.log("Select logical sampling level - begin");
        ROLAPMetaLevel logicalSamplingLevel = null;
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            List<IValue[]> levelMembers = this.getLevelMembers(level);
            double pctOfReferencedMembersInLevel = 100.0 / (double)levelMembers.size();
            INFO_LOGGER.log(String.format("Level %s has %d members (%.4f %% estimated sampling rate)", level.getName(), levelMembers.size(), pctOfReferencedMembersInLevel));
            if (logicalSamplingLevel == null && pctOfReferencedMembersInLevel < 5.0) {
                logicalSamplingLevel = level;
            }
            levelMembers.clear();
        }
        if (logicalSamplingLevel == null) {
            logicalSamplingLevel = this.samplingLevel;
        }
        INFO_LOGGER.log("Selected logical sampling level " + logicalSamplingLevel.getName());
        List<IValue[]> samplingLevelMembers = this.getLevelMembers(logicalSamplingLevel);
        IValue[] memberToSampleOn = samplingLevelMembers.get(samplingLevelMembers.size() / 2);
        List<IValue[]> membersFromOriginalSamplingLevel = this.getSubsetOfMembers(logicalSamplingLevel, memberToSampleOn, this.samplingLevel, this.mInnerJoinResultSet);
        for (IValue[] member : membersFromOriginalSamplingLevel) {
            this.sampleOfResultSet.add(member);
        }
        this.traceResultSet(this.sampleOfResultSet);
        INFO_LOGGER.log(String.format("Selected %d of %d members for sampling", this.sampleOfResultSet.size(), this.mInnerJoinResultSet.size()));
        INFO_LOGGER.log("Select logical sampling level - end");
    }

    private void traceResultSet(List<IValue[]> resultSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Result set has %d rows\n", resultSet.size()));
        sb.append(this.valuesSetAsString(resultSet));
        INFO_LOGGER.log(sb.toString());
    }

    private String valuesSetAsString(List<IValue[]> resultSet) {
        StringBuilder sb = new StringBuilder();
        int maxValuesToShow = 20;
        if (resultSet.size() <= 20) {
            for (IValue[] values : resultSet) {
                sb.append(this.valuesAsString(values));
                sb.append('\n');
            }
        } else {
            IValue[] values;
            int index;
            for (index = 0; index <= 9; ++index) {
                values = resultSet.get(index);
                sb.append(this.valuesAsString(values));
                sb.append('\n');
            }
            sb.append("  ... \n");
            for (index = resultSet.size() - 10; index <= resultSet.size() - 1; ++index) {
                values = resultSet.get(index);
                sb.append(this.valuesAsString(values));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private String valuesAsString(IValue[] values) {
        StringBuilder sb = new StringBuilder();
        for (IValue value : values) {
            sb.append(value.toString());
            sb.append(';');
        }
        return sb.toString();
    }

    private void determineActualLevelCardinalties() {
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            List<IValue[]> levelMembers = this.getLevelMembers(level);
            this.levelCardinalityBasedOnFactData.add(levelMembers.size());
        }
    }

    private void traceHierarchyMembers() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hierarchy level key attributes:\n");
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            for (ROLAPMetaAttribute attribute : level.getLevelKeys()) {
                sb.append(level.getName() + ' ' + attribute.getName() + '\n');
            }
        }
        INFO_LOGGER.log(sb.toString());
        INFO_LOGGER.log("Members of hierarchy " + this.samplingHierarchy.getName());
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            this.traceLevelMembers(level);
        }
    }

    private void traceLevelMembers(ROLAPMetaLevel level) {
        StringBuilder sb = new StringBuilder();
        List<IValue[]> levelMembers = this.getLevelMembers(level);
        sb.append(String.format("Level %s has %d members\n", level.getName(), levelMembers.size()));
        sb.append(this.valuesSetAsString(levelMembers));
        INFO_LOGGER.log(sb.toString());
        levelMembers.clear();
    }

    private List<IValue[]> getSubsetOfMembers(ROLAPMetaLevel searchLevel, IValue[] searchMember, ROLAPMetaLevel fetchLevel, List<IValue[]> resultSet) {
        ArrayList<IValue[]> members = new ArrayList<IValue[]>();
        for (IValue[] resultSetRow : resultSet) {
            IValue[] member = this.getMember(searchLevel, resultSetRow);
            if (!this.equals(member, searchMember)) continue;
            members.add(resultSetRow);
        }
        return members;
    }

    private List<IValue[]> getLevelMembers(ROLAPMetaLevel level) {
        List<IValue[]> members = this.getLevelMembers(level, this.mInnerJoinResultSet);
        return members;
    }

    private List<IValue[]> getLevelMembers(ROLAPMetaLevel level, List<IValue[]> resultSet) {
        ArrayList<IValue[]> members = new ArrayList<IValue[]>();
        for (IValue[] resultSetRow : resultSet) {
            IValue[] member = this.getMember(level, resultSetRow);
            if (this.isMemberInCollection(members, member)) continue;
            members.add(member);
        }
        return members;
    }

    private IValue[] getMember(ROLAPMetaLevel level, IValue[] resultSetRow) {
        IValue[] member = new IValue[level.getLevelKeys().size()];
        int index = -1;
        for (ROLAPMetaAttribute attribute : level.getLevelKeys()) {
            IValue attributeValue;
            member[++index] = attributeValue = resultSetRow[this.attributeIndex(attribute)];
        }
        return member;
    }

    private boolean isMemberInCollection(List<IValue[]> members, IValue[] memberToCheck) {
        for (IValue[] member : members) {
            if (!this.equals(member, memberToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(IValue[] member1, IValue[] member2) {
        for (int i = 0; i < member1.length; ++i) {
            if (member1[i].equals(member2[i])) continue;
            return false;
        }
        return true;
    }

    private int attributeIndex(ROLAPMetaAttribute attribute) {
        int index = -1;
        for (ROLAPMetaAttribute keyAttribute : this.keysToProject) {
            ++index;
            if (!keyAttribute.getName().equals(attribute.getName())) continue;
            return index;
        }
        return -1;
    }

    public List<Integer> getActualLevelCardinalties() {
        return this.levelCardinalityBasedOnFactData;
    }

    public List<String> getSamplingFilterStrings(ROLAPMetaLevel level) {
        List<String> filterStrings = null;
        int levelIndex = AdvisorUtils.getLevelIndex(this.samplingHierarchy, level.getName());
        if (levelIndex >= 0) {
            filterStrings = this.levelFilters.get(levelIndex);
        }
        return filterStrings;
    }

    public List<String> getSingleMemberSamplingFilterStrings() {
        return this.getSamplingFilterStrings(this.singleMemberResultSet);
    }

    public List<String> getMultipleMemberSamplingFilterStrings() {
        return this.getSamplingFilterStrings(this.multipleMemberResultSet);
    }

    private List<String> getSamplingFilterStrings(List<IValue[]> sampleResultSet) {
        ArrayList<String> filterStrings = new ArrayList<String>();
        for (AdvisorSampleFilterPartGenerator generator : this.mFilterParts) {
            filterStrings.add(generator.getSamplingFilterPart(sampleResultSet));
        }
        return filterStrings;
    }

    public void getSampleOfMembersOriginal() {
        INFO_LOGGER.log("Select a set of contiguous members to use when sampling");
        this.selectSingleSamplingMember();
        this.selectMultipleSamplingMember();
    }

    private void selectSingleSamplingMember() {
        long averageRowsPerMember = this.totalFactRowCount / (long)this.mInnerJoinResultSet.size();
        long smallestDelta = this.totalFactRowCount;
        IValue[] selectedMember = null;
        for (IValue[] values : this.mInnerJoinResultSet) {
            IValue value = values[values.length - 1];
            long rows = (long)Double.parseDouble(value.toString());
            long currDelta = Math.abs(averageRowsPerMember - rows);
            if (currDelta >= smallestDelta) continue;
            smallestDelta = currDelta;
            selectedMember = values;
        }
        this.singleMemberResultSet.add(selectedMember);
        this.recordSamplingMemberInformation(this.singleMemberResultSet);
    }

    private void selectMultipleSamplingMember() {
        int totalMemberCount = this.mInnerJoinResultSet.size();
        int maxNumSamplingMembersUsingSamplingRate = Math.max(1, (int)(0.05 * (double)totalMemberCount));
        int numSamplingMembers = Math.min(7, maxNumSamplingMembersUsingSamplingRate);
        int sampleLength = 0;
        int startIndex = 0;
        if (totalMemberCount > numSamplingMembers) {
            startIndex = (totalMemberCount - numSamplingMembers) / 2;
            sampleLength = numSamplingMembers;
        } else {
            startIndex = 0;
            sampleLength = totalMemberCount;
        }
        for (int ii = startIndex; ii < sampleLength + startIndex; ++ii) {
            this.multipleMemberResultSet.add(this.mInnerJoinResultSet.get(ii));
        }
        this.recordSamplingMemberInformation(this.multipleMemberResultSet);
    }

    private void recordSamplingMemberInformation(List<IValue[]> sampleResultSet) {
        this.traceResultSet(sampleResultSet);
        double ratioOfSampleMembersToTotalMembers = 1.0 * (double)sampleResultSet.size() / (double)this.mInnerJoinResultSet.size();
        INFO_LOGGER.log(String.format("Selected %,d of %,d members for sampling, ratio = %.6f", sampleResultSet.size(), this.mInnerJoinResultSet.size(), ratioOfSampleMembersToTotalMembers));
        long sampledFactRowCount = this.countResultSet(sampleResultSet);
        double ratioOfSampleFactRowsToTotalFactRows = 1.0 * (double)sampledFactRowCount / (1.0 * (double)this.totalFactRowCount);
        INFO_LOGGER.log(String.format("Selected %,d of %,d fact rows for sampling, ratio = %.6f", sampledFactRowCount, this.totalFactRowCount, ratioOfSampleFactRowsToTotalFactRows));
    }

    public double getSingleMemberSamplingRate() {
        long sampledFactRowCount = this.countResultSet(this.singleMemberResultSet);
        double ratioOfSampleFactRowsToTotalFactRows = 1.0 * (double)sampledFactRowCount / (1.0 * (double)this.totalFactRowCount);
        return ratioOfSampleFactRowsToTotalFactRows;
    }

    public double getMultipleMemberSamplingRate() {
        long sampledFactRowCount = this.countResultSet(this.multipleMemberResultSet);
        double ratioOfSampleFactRowsToTotalFactRows = 1.0 * (double)sampledFactRowCount / (1.0 * (double)this.totalFactRowCount);
        return ratioOfSampleFactRowsToTotalFactRows;
    }

    private long countResultSet(List<IValue[]> resultSet) {
        long rows = 0L;
        for (IValue[] values : resultSet) {
            IValue value = values[values.length - 1];
            rows += (long)Double.parseDouble(value.toString());
        }
        return rows;
    }
}

