/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateSQLInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.QueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadSummarizedMeasuresCollection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.AggregateType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Aggregate {
    private String name = "";
    private ROLAPMetaCube metaCube;
    private List<ROLAPMetaMeasure> measures = new ArrayList<ROLAPMetaMeasure>();
    private List<String> levelNames = new ArrayList<String>();
    private List<ROLAPMetaLevel> levels = new ArrayList<ROLAPMetaLevel>();
    private SliceCombination cachedSliceId = null;
    private AggregateAdvisor aggregateAdvisor = null;
    private long cardinality = 0L;
    private long maxCardinality = 0L;
    private long estimatedSize = 0L;
    private AggregateType type = AggregateType.IN_MEMORY;
    private AggregateRecommendedByEnum recommendedBy = AggregateRecommendedByEnum.UNKNOWN;
    private boolean deepSlice = false;
    private int hitCount;
    private double weightedHitCount;
    private long executionTime;
    private int workloadCount = 0;
    private long workloadQueryExecutionTime = 0L;
    private WorkloadSummarizedMeasuresCollection workloadMeasures = null;
    private List<String> coveredByAggregates = new ArrayList<String>();
    private List<String> coveredByExistingAggregateCubes = new ArrayList<String>();
    private List<String> coveredByExistingAggregateCubesButHasSlicer = new ArrayList<String>();
    private int numberOfInMemoryAggregatesCovered = 0;
    private List<Aggregate> coveredInMemoryAggregates = new ArrayList<Aggregate>();
    private AggregateSQLInfo aggregateSQLInfo;
    public static final String LEVEL_ALL = "[All]";
    public static final String LEVEL_ROOT = "[Root]";
    public static final String LEVEL_1 = "Level 1";
    private static final String PREFIX = "* ";
    private static final String NEW_LINE = "\n";
    private static final String SEPARATOR = " - ";
    private static final String SPACE_STR = " ";
    private static final String PADDINGSPACE_STR = "    ";
    private static final String DASHES_STR = "---------------";
    private static final int DATAITEM_MAX_LENGTH = 17;
    private static final int MAX_DUPLICATE_INDEX = 9;
    public static final String UNIQUE_KEY = "Unique Key";
    public static final String LEVEL_KEY = "Level Key";
    public static final String MEASURE = "Measure";

    public Aggregate(ROLAPMetaCube aMetaCube) {
        this.metaCube = aMetaCube;
        this.workloadMeasures = new WorkloadSummarizedMeasuresCollection();
        this.initializeLevelNames();
    }

    public Aggregate(ROLAPMetaCube aMetaCube, long workloadExecutionTime, List<String> measuresFromWorkload) {
        this.metaCube = aMetaCube;
        this.workloadMeasures = new WorkloadSummarizedMeasuresCollection();
        this.workloadMeasures.recordHits(measuresFromWorkload);
        this.workloadCount = 1;
        this.workloadQueryExecutionTime = workloadExecutionTime;
        this.initializeLevelNames();
        this.setName(this.generateDescriptiveName());
    }

    public static Aggregate createAggregateForSliceId(ROLAPMetaCube metaCube, SliceCombination sliceId) {
        Aggregate aggregate = new Aggregate(metaCube);
        aggregate.initialize(sliceId);
        return aggregate;
    }

    public Aggregate(Aggregate aggregate1, Aggregate aggregate2) {
        if (null != aggregate1 && null != aggregate2) {
            this.metaCube = aggregate1.getMetaCube();
            this.initializeLevelNames();
            SliceCombination aggregate1SliceId = aggregate1.getSliceId();
            SliceCombination aggregate2SliceId = aggregate2.getSliceId();
            aggregate1SliceId.union(aggregate2SliceId);
            this.initialize(aggregate1SliceId);
            HashMap<String, ROLAPMetaMeasure> measureMap = new HashMap<String, ROLAPMetaMeasure>();
            for (ROLAPMetaMeasure rOLAPMetaMeasure : aggregate1.measures) {
                measureMap.put(rOLAPMetaMeasure.getName(), rOLAPMetaMeasure);
            }
            for (ROLAPMetaMeasure rOLAPMetaMeasure : aggregate2.measures) {
                measureMap.put(rOLAPMetaMeasure.getName(), rOLAPMetaMeasure);
            }
            for (Map.Entry entry : measureMap.entrySet()) {
                this.addMeasure((ROLAPMetaMeasure)entry.getValue());
            }
            this.workloadMeasures = new WorkloadSummarizedMeasuresCollection();
            this.incrementWorkloadCounters(aggregate1);
            this.incrementWorkloadCounters(aggregate2);
            if (aggregate1.getRecommendedBy() == aggregate2.getRecommendedBy()) {
                this.setRecommendedBy(aggregate1.getRecommendedBy());
            } else {
                this.setRecommendedBy(AggregateRecommendedByEnum.HYBRID);
            }
            if (aggregate1.isDeepSlice() || aggregate2.isDeepSlice()) {
                this.deepSlice = true;
            }
            this.setAggregateAdvisor(aggregate1.aggregateAdvisor);
            long aggregateCardinality = this.aggregateAdvisor.getMaxSliceCardinality(this);
            this.setMaxCardinality(aggregateCardinality);
            this.setCardinality(aggregateCardinality);
            this.setHitCount(aggregate1.getHitCount() + aggregate2.getHitCount());
            this.setExecutionTime(aggregate1.getExecutionTime() + aggregate2.getExecutionTime());
            this.setName(this.generateDescriptiveName());
            HashSet<String> uniqueCoveredByAggregateNames = new HashSet<String>();
            uniqueCoveredByAggregateNames.addAll(aggregate1.coveredByAggregates);
            uniqueCoveredByAggregateNames.addAll(aggregate2.coveredByAggregates);
            this.coveredByAggregates.addAll(uniqueCoveredByAggregateNames);
            this.numberOfInMemoryAggregatesCovered = this.coveredByAggregates.size();
        }
    }

    public void initialize(Aggregate aggregate) {
        if (null != aggregate) {
            this.metaCube = aggregate.metaCube;
            this.aggregateAdvisor = aggregate.aggregateAdvisor;
            this.cardinality = aggregate.cardinality;
            this.deepSlice = aggregate.deepSlice;
            this.estimatedSize = aggregate.estimatedSize;
            this.levelNames.addAll(aggregate.levelNames);
            this.levels.addAll(aggregate.levels);
            this.cachedSliceId = new SliceCombination();
            this.cachedSliceId.copy(aggregate.getSliceId());
            this.maxCardinality = aggregate.maxCardinality;
            this.measures.addAll(aggregate.measures);
            this.hitCount = aggregate.hitCount;
            this.executionTime = aggregate.executionTime;
            this.workloadCount = aggregate.workloadCount;
            this.workloadQueryExecutionTime = aggregate.workloadQueryExecutionTime;
            this.workloadMeasures = aggregate.workloadMeasures.makeClone();
            this.name = aggregate.name;
            this.recommendedBy = aggregate.recommendedBy;
            this.type = aggregate.type;
            this.coveredByAggregates.clear();
            this.coveredByAggregates.addAll(aggregate.coveredByAggregates);
            this.coveredByExistingAggregateCubes.clear();
            this.coveredByExistingAggregateCubes.addAll(aggregate.coveredByExistingAggregateCubes);
            this.coveredByExistingAggregateCubesButHasSlicer.clear();
            this.coveredByExistingAggregateCubesButHasSlicer.addAll(aggregate.coveredByExistingAggregateCubesButHasSlicer);
            this.numberOfInMemoryAggregatesCovered = aggregate.numberOfInMemoryAggregatesCovered;
        }
    }

    public void initialize(SliceCombination sliceCombination) {
        SliceCombination newRange;
        SliceCombination cubeRange = this.getSliceId();
        if (!cubeRange.isRegionWithinRegion(newRange = sliceCombination)) {
            String msg = "Parameter slice range %s is not within current slice range %s.";
            throw new IllegalArgumentException(String.format(msg, newRange.rangeToString(), cubeRange.rangeToString()));
        }
        int sliceIndex = 0;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (hierarchy.isRecursive()) {
                    if (hierarchy.hasAllLevel()) {
                        this.setLevel(dimension.getName(), hierarchy.getName(), LEVEL_ALL);
                    } else {
                        this.setLevel(dimension.getName(), hierarchy.getName(), LEVEL_ROOT);
                    }
                } else if (sliceCombination.getValue(sliceIndex) == 0) {
                    this.setLevel(dimension.getName(), hierarchy.getName(), LEVEL_ALL);
                } else {
                    String levelName = hierarchy.getLevels()[sliceCombination.getValue(sliceIndex) - 1].getName();
                    this.setLevel(dimension.getName(), hierarchy.getName(), levelName);
                }
                ++sliceIndex;
            }
        }
        this.cachedSliceId = this.generateSliceId();
        this.setName(this.generateDescriptiveName());
    }

    public Aggregate copy() {
        Aggregate aggregateToReturn = new Aggregate(this.metaCube);
        aggregateToReturn.aggregateAdvisor = this.aggregateAdvisor;
        aggregateToReturn.cardinality = this.cardinality;
        aggregateToReturn.deepSlice = this.deepSlice;
        aggregateToReturn.estimatedSize = this.estimatedSize;
        aggregateToReturn.levelNames.clear();
        aggregateToReturn.levelNames.addAll(this.levelNames);
        aggregateToReturn.levels.clear();
        aggregateToReturn.cachedSliceId = null;
        aggregateToReturn.maxCardinality = this.maxCardinality;
        aggregateToReturn.measures.addAll(this.measures);
        aggregateToReturn.name = this.name;
        aggregateToReturn.recommendedBy = this.recommendedBy;
        aggregateToReturn.type = this.type;
        aggregateToReturn.workloadCount = this.workloadCount;
        aggregateToReturn.workloadQueryExecutionTime = this.workloadQueryExecutionTime;
        aggregateToReturn.workloadMeasures = this.workloadMeasures.makeClone();
        return aggregateToReturn;
    }

    public AggregateAdvisor getAggregateAdvisor() {
        return this.aggregateAdvisor;
    }

    public void setAggregateAdvisor(AggregateAdvisor theAggregateAdvisor) {
        this.aggregateAdvisor = theAggregateAdvisor;
    }

    public ROLAPMetaCube getMetaCube() {
        return this.metaCube;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String aName) {
        this.name = aName;
    }

    public AggregateType getType() {
        return this.type;
    }

    public void setType(AggregateType t) {
        this.type = t;
    }

    public AggregateRecommendedByEnum getRecommendedBy() {
        return this.recommendedBy;
    }

    public void setRecommendedBy(AggregateRecommendedByEnum recommender) {
        this.recommendedBy = recommender;
    }

    public boolean isDeepSlice() {
        return this.deepSlice;
    }

    public void setDeepSlice(boolean deepStatus) {
        this.deepSlice = deepStatus;
    }

    public final String generateDescriptiveName() {
        String generatedName = "";
        for (String levelName : this.levelNames) {
            if (!AdvisorUtils.isRegularLevel(levelName)) continue;
            if (generatedName.length() != 0) {
                generatedName = generatedName + SEPARATOR;
            }
            generatedName = generatedName + levelName;
        }
        if (generatedName.length() == 0) {
            generatedName = "No levels";
        }
        return generatedName;
    }

    public final String generateFullDescriptiveName() {
        String generatedName = "";
        for (String levelName : this.levelNames) {
            if (generatedName.length() != 0) {
                generatedName = generatedName + SEPARATOR;
            }
            generatedName = generatedName + levelName;
        }
        return generatedName;
    }

    public final long getCardinality() {
        return this.cardinality;
    }

    public final void setCardinality(long aCardinality) {
        this.cardinality = aCardinality;
    }

    public final long getMaxCardinality() {
        return this.maxCardinality;
    }

    public final void setMaxCardinality(long aMaxCardinality) {
        this.maxCardinality = aMaxCardinality;
    }

    public final long getNumberOfCells() {
        return this.cardinality * (long)this.measures.size();
    }

    public final long getEstimatedSize() {
        return this.estimatedSize;
    }

    public final void setEstimatedSize(long size) {
        this.estimatedSize = size;
    }

    public final List<ROLAPMetaMeasure> getMeasures() {
        return new ArrayList<ROLAPMetaMeasure>(this.measures);
    }

    public void addMeasures(String[] measureNames) {
        for (String measureName : measureNames) {
            ROLAPMetaMeasure measure = AdvisorUtils.getMetaMeasure(this.metaCube, measureName);
            if (measure == null) {
                String msg = "Measure [%s] does not exist.";
                throw new IllegalArgumentException(String.format(msg, measureName));
            }
            this.measures.add(measure);
        }
    }

    public void addMeasures(List<ROLAPMetaMeasure> theMeasures) {
        this.measures.addAll(theMeasures);
    }

    public void addMeasure(ROLAPMetaMeasure measure) {
        this.measures.add(measure);
    }

    public final List<ROLAPMetaLevel> getLevels() {
        if (this.levels.isEmpty()) {
            for (int i = 0; i < this.levelNames.size(); ++i) {
                ROLAPMetaLevel level = this.getLevel(i);
                this.levels.add(level);
            }
        }
        return this.levels;
    }

    public boolean isNear(Aggregate aggregate) {
        boolean isNear = false;
        if (null != aggregate && this.isAdditive() && aggregate.isAdditive()) {
            isNear = this.getSliceId().isNear(aggregate.getSliceId());
        }
        return isNear;
    }

    private void initializeLevelNames() {
        this.levels.clear();
        this.cachedSliceId = null;
        this.levelNames.clear();
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (hierarchy.hasAllLevel()) {
                    this.levelNames.add(LEVEL_ALL);
                    continue;
                }
                if (hierarchy.isRecursive()) {
                    this.levelNames.add(LEVEL_ROOT);
                    continue;
                }
                this.levelNames.add(hierarchy.getLevels()[0].getName());
            }
        }
    }

    public final void setLevel(String aDimensionName, String aHierarchyName, String aLevelName) {
        this.checkLevel(aDimensionName, aHierarchyName, aLevelName);
        int hierarchyIndex = this.getHierarchyIndex(aDimensionName, aHierarchyName);
        if (hierarchyIndex >= 0) {
            this.levelNames.set(hierarchyIndex, aLevelName);
        }
        this.processLevelsChange();
    }

    public final void processLevelsChange() {
        this.levels.clear();
        this.cachedSliceId = null;
    }

    public final void checkLevel(String aDimensionName, String aHierarchyName, String aLevelName) {
        boolean levelFound;
        block8: {
            ROLAPMetaHierarchy hierarchy;
            block6: {
                block7: {
                    ROLAPMetaDimension dimension = AdvisorUtils.getMetaDimension(this.metaCube, aDimensionName);
                    if (dimension == null) {
                        String msg = "Dimension [%s] does not exist.";
                        throw new IllegalArgumentException(String.format(msg, aDimensionName));
                    }
                    hierarchy = AdvisorUtils.getMetaHierarchy(this.metaCube, aDimensionName, aHierarchyName);
                    if (hierarchy == null) {
                        String msg = "Hierarchy [%s] in dimension [%s] does not exist.";
                        throw new IllegalArgumentException(String.format(msg, aHierarchyName, aDimensionName));
                    }
                    levelFound = false;
                    if (!hierarchy.isRecursive()) break block6;
                    if (!aLevelName.equals(LEVEL_ALL) || !hierarchy.hasAllLevel()) break block7;
                    levelFound = true;
                    break block8;
                }
                if (!aLevelName.equals(LEVEL_ROOT) || hierarchy.hasAllLevel()) break block8;
                levelFound = true;
                break block8;
            }
            if (aLevelName.equals(LEVEL_ALL) && hierarchy.hasAllLevel()) {
                levelFound = true;
            } else {
                for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                    if (!level.getName().equals(aLevelName)) continue;
                    levelFound = true;
                    break;
                }
            }
        }
        if (!levelFound) {
            String msg = "Level [%s] does not exist in dimension [%s] hierarchy [%s].";
            throw new IllegalArgumentException(String.format(msg, aLevelName, aDimensionName, aHierarchyName));
        }
    }

    public final ROLAPMetaLevel getLevel(String aDimensionName, String aHierarchyName) {
        String levelName = this.getLevelName(aDimensionName, aHierarchyName);
        return AdvisorUtils.getMetaLevel(this.metaCube, aDimensionName, aHierarchyName, levelName);
    }

    public String getLevelName(String dimensionName, String hierarchyName) {
        String levelName = null;
        int hierarchyIndex = this.getHierarchyIndex(dimensionName, hierarchyName);
        if (hierarchyIndex >= 0) {
            levelName = this.levelNames.get(hierarchyIndex);
        }
        return levelName;
    }

    public String getLevelName(int hierarchyIndex) {
        String levelName = null;
        if (hierarchyIndex >= 0 && hierarchyIndex < this.levelNames.size()) {
            levelName = this.levelNames.get(hierarchyIndex);
        }
        return levelName;
    }

    private ROLAPMetaLevel getLevel(int hierarchyIndex) {
        String levelName = this.levelNames.get(hierarchyIndex);
        if (!AdvisorUtils.isRegularLevel(levelName)) {
            return null;
        }
        ROLAPMetaHierarchy hierarchy = this.getHierarchyByIndex(hierarchyIndex);
        if (hierarchy != null) {
            return hierarchy.getLevel(levelName);
        }
        return null;
    }

    public SliceCombination getSliceId() {
        if (this.cachedSliceId == null) {
            this.cachedSliceId = this.generateSliceId();
        }
        SliceCombination sliceIdCopy = new SliceCombination();
        sliceIdCopy.copy(this.cachedSliceId);
        return sliceIdCopy;
    }

    private SliceCombination generateSliceId() {
        SliceCombination sliceId = new SliceCombination();
        sliceId.setNumPositions(this.levelNames.size());
        for (int hierarchyIndex = 0; hierarchyIndex < sliceId.getNumPositions(); ++hierarchyIndex) {
            ROLAPMetaHierarchy hierarchy = this.getHierarchyByIndex(hierarchyIndex);
            if (hierarchy.isRecursive()) {
                if (hierarchy.hasAllLevel()) {
                    sliceId.setMaximum(hierarchyIndex, 0);
                    sliceId.setMinimum(hierarchyIndex, 0);
                    sliceId.setValue(hierarchyIndex, 0);
                    continue;
                }
                sliceId.setMaximum(hierarchyIndex, 1);
                sliceId.setMinimum(hierarchyIndex, 1);
                sliceId.setValue(hierarchyIndex, 1);
                continue;
            }
            sliceId.setMaximum(hierarchyIndex, hierarchy.getLevels().length);
            if (hierarchy.hasAllLevel()) {
                sliceId.setMinimum(hierarchyIndex, 0);
            } else {
                sliceId.setMinimum(hierarchyIndex, 1);
            }
            String levelName = this.getLevelName(hierarchyIndex);
            int levelDepth = AdvisorUtils.getLevelDepth(hierarchy, levelName);
            int levelIndex = sliceId.getMinimum(hierarchyIndex) + levelDepth;
            sliceId.setValue(hierarchyIndex, levelIndex);
        }
        return sliceId;
    }

    public SliceCombination getDimensionSliceId() {
        SliceCombination sliceId = new SliceCombination();
        sliceId.setNumPositions(this.metaCube.getDimensions().length);
        for (int dimensionIndex = 0; dimensionIndex < sliceId.getNumPositions(); ++dimensionIndex) {
            sliceId.setMaximum(dimensionIndex, 1);
            sliceId.setMinimum(dimensionIndex, 0);
            sliceId.setValue(dimensionIndex, 0);
        }
        return sliceId;
    }

    public int getLevelDepth() {
        ROLAPMetaDimension[] dimensions;
        int totalLevelDepth = 0;
        int hierarchyIndex = 0;
        for (ROLAPMetaDimension dimension : dimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] hierarchies;
            for (ROLAPMetaHierarchy hierarchy : hierarchies = this.metaCube.getHierarchies(dimension)) {
                String levelName = this.getLevelName(hierarchyIndex);
                int levelDepth = AdvisorUtils.getLevelDepth(hierarchy, levelName);
                totalLevelDepth += levelDepth;
                ++hierarchyIndex;
            }
        }
        return totalLevelDepth;
    }

    private int getHierarchyIndex(String aDimensionName, String aHierarchyName) {
        return AdvisorUtils.getHierarchyIndex(this.metaCube, aDimensionName, aHierarchyName);
    }

    private ROLAPMetaHierarchy getHierarchyByIndex(int index) {
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (++hierarchyIndex != index) continue;
                return hierarchy;
            }
        }
        return null;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int theHitCount) {
        this.hitCount = theHitCount;
    }

    public double getWeightedHitCount() {
        return this.weightedHitCount;
    }

    public void setWeightedHitCount(double theWeightedHitCount) {
        this.weightedHitCount = theWeightedHitCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long theExecutionTime) {
        this.executionTime = theExecutionTime;
    }

    public static boolean isAggregateSame(Aggregate aggregate1, Aggregate aggregate2) {
        return aggregate1.isCovered(aggregate2) && aggregate2.isCovered(aggregate1);
    }

    public static boolean isAggregateContainedInSet(Aggregate aggregate, List<Aggregate> otherAggregates) {
        for (Aggregate otherAggregate : otherAggregates) {
            if (!Aggregate.isAggregateSame(aggregate, otherAggregate)) continue;
            return true;
        }
        return false;
    }

    public static void compareAggregateSets(List<Aggregate> aggregateSet1, List<Aggregate> aggregateSet2, List<Aggregate> aggregatesInBothSets, List<Aggregate> aggregatesInSet1Only, List<Aggregate> aggregatesInSet2Only) {
        for (Aggregate aggregate1 : aggregateSet1) {
            if (Aggregate.isAggregateContainedInSet(aggregate1, aggregateSet2)) {
                aggregatesInBothSets.add(aggregate1);
                continue;
            }
            aggregatesInSet1Only.add(aggregate1);
        }
        for (Aggregate aggregate2 : aggregateSet2) {
            if (Aggregate.isAggregateContainedInSet(aggregate2, aggregateSet1)) continue;
            aggregatesInSet2Only.add(aggregate2);
        }
    }

    public static boolean isAggregateCovered(Aggregate aggregate, List<Aggregate> otherAggregates) {
        for (Aggregate otherAggregate : otherAggregates) {
            if (!otherAggregate.isCovered(aggregate)) continue;
            return true;
        }
        return false;
    }

    public boolean isCovered(Aggregate otherAggregate) {
        return this.isCovered(otherAggregate, true);
    }

    public boolean isCovered(Aggregate otherAggregate, boolean considerAllMeasureTypes) {
        SliceCombination otherSliceId;
        SliceCombination thisSliceId = this.getSliceId();
        if (!thisSliceId.isCovered(otherSliceId = otherAggregate.getSliceId())) {
            return false;
        }
        boolean isDirectMatch = thisSliceId.isEqual(otherSliceId);
        for (ROLAPMetaMeasure otherAggregateMeasure : otherAggregate.getMeasures()) {
            if (this.aggregateAdvisor.isMeasureAdditive(otherAggregateMeasure)) continue;
            if (!considerAllMeasureTypes) {
                return false;
            }
            if (isDirectMatch) continue;
            return false;
        }
        for (ROLAPMetaMeasure otherAggregateMeasure : otherAggregate.getMeasures()) {
            boolean measureCovered = false;
            for (ROLAPMetaMeasure thisAggregateMeasure : this.measures) {
                if (!thisAggregateMeasure.getName().equals(otherAggregateMeasure.getName())) continue;
                measureCovered = true;
                break;
            }
            if (measureCovered) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameLevels(Aggregate aggregate) {
        String thisAggregateSliceId = this.getSliceId().valueToString();
        String thatAggregateSliceId = aggregate.getSliceId().valueToString();
        return thisAggregateSliceId.equals(thatAggregateSliceId);
    }

    public String getAdditiveStatus() {
        String additiveStatus = "";
        additiveStatus = this.aggregateAdvisor == null ? "Unknown" : (this.isAdditive() ? "Additive" : "Not additive");
        return additiveStatus;
    }

    public boolean isAdditive() {
        for (ROLAPMetaMeasure measure : this.measures) {
            if (this.aggregateAdvisor.isMeasureAdditive(measure)) continue;
            return false;
        }
        return true;
    }

    public final void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("aggregate", -1);
        xmlWriter.attribute("name", this.name);
        int hierarchyIndex = 0;
        ROLAPMetaDimension[] dimensions = this.metaCube.getDimensions();
        for (ROLAPMetaDimension dimension : dimensions) {
            ROLAPMetaHierarchy[] hierarchies;
            xmlWriter.beginElement("dimensionRef", -1);
            xmlWriter.attribute("name", dimension.getName());
            String dimensionCategory = "";
            dimensionCategory = dimension.getCategory().compareTo("public") == 0 ? "public" : "private";
            xmlWriter.attribute("category", dimensionCategory);
            for (ROLAPMetaHierarchy hierarchy : hierarchies = this.metaCube.getHierarchies(dimension)) {
                xmlWriter.beginElement("hierarchyRef", -1);
                xmlWriter.attribute("name", hierarchy.getName());
                String levelName = this.levelNames.get(hierarchyIndex);
                if (AdvisorUtils.isRegularLevel(levelName)) {
                    xmlWriter.beginElement("levelRef", -1);
                    xmlWriter.attribute("name", levelName);
                    xmlWriter.endElement();
                } else if (LEVEL_ALL.equals(levelName)) {
                    xmlWriter.beginElement("allLevel", -1);
                    xmlWriter.endElement();
                } else if (LEVEL_ROOT.equals(levelName)) {
                    xmlWriter.beginElement("rootLevel", -1);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
                ++hierarchyIndex;
            }
            xmlWriter.endElement();
        }
        for (ROLAPMetaMeasure measure : this.measures) {
            xmlWriter.beginElement("measureRef", -1);
            xmlWriter.attribute("name", measure.getName());
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    public final AggregateSQLInfo getSQLInfo() {
        String dimensionName;
        if (this.aggregateSQLInfo != null) {
            return this.aggregateSQLInfo;
        }
        ArrayList<String[]> dataItemsInfo = new ArrayList<String[]>();
        ArrayList<String> metaNames = new ArrayList<String>();
        int metaIndex = 0;
        HashMap<String, Map<String, Map<String, String>>> dimensionNameHierarchyNameMetaNameColumnNameMap = new HashMap<String, Map<String, Map<String, String>>>();
        HashMapIntObject<Map<String, String>> metaIndexMetaNameColumnNameMap = new HashMapIntObject<Map<String, String>>();
        for (int index = 0; index < this.levelNames.size(); ++index) {
            HashMap metaNameColumnNameMap;
            ROLAPMetaLevel aggrLevel = this.getLevel(index);
            if (aggrLevel == null) continue;
            ROLAPMetaHierarchy hierarchy = this.getHierarchyByIndex(index);
            String hierarchyName = hierarchy.getName();
            String dimensionName2 = hierarchy.getDimensionName();
            HashMap hierarchyNameMetaNameColumnNameMap = (HashMap)dimensionNameHierarchyNameMetaNameColumnNameMap.get(dimensionName2);
            if (hierarchyNameMetaNameColumnNameMap == null) {
                hierarchyNameMetaNameColumnNameMap = new HashMap();
                dimensionNameHierarchyNameMetaNameColumnNameMap.put(dimensionName2, hierarchyNameMetaNameColumnNameMap);
            }
            if ((metaNameColumnNameMap = (HashMap)hierarchyNameMetaNameColumnNameMap.get(hierarchyName)) == null) {
                metaNameColumnNameMap = new HashMap();
                hierarchyNameMetaNameColumnNameMap.put(hierarchyName, metaNameColumnNameMap);
            }
            LinkedHashSet<ROLAPMetaAttribute> keysToProject = new LinkedHashSet<ROLAPMetaAttribute>();
            if (this.getType() == AggregateType.IN_DATABASE) {
                ROLAPMetaLevel[] hierLevelList;
                for (ROLAPMetaLevel hierLevel : hierLevelList = hierarchy.getLevels()) {
                    if (hierLevel == aggrLevel) break;
                    keysToProject.addAll(hierLevel.getLevelKeys());
                }
            }
            keysToProject.addAll(aggrLevel.getLevelKeys());
            for (ROLAPMetaAttribute attr : keysToProject) {
                String levelKeyName = attr.getName();
                dataItemsInfo.add(new String[]{Aggregate.processLongName(levelKeyName, dataItemsInfo), attr.getQueryItem()});
                metaNames.add(levelKeyName);
                metaIndexMetaNameColumnNameMap.put(metaIndex, metaNameColumnNameMap);
                ++metaIndex;
            }
        }
        String hierarchyName = dimensionName = this.metaCube.getMetaCubeModel().getMeasureDimensionName();
        HashMap hierarchyNameMetaNameColumnNameMap = new HashMap();
        dimensionNameHierarchyNameMetaNameColumnNameMap.put(dimensionName, hierarchyNameMetaNameColumnNameMap);
        HashMap metaNameColumnNameMap = new HashMap();
        hierarchyNameMetaNameColumnNameMap.put(hierarchyName, metaNameColumnNameMap);
        for (ROLAPMetaMeasure measure : this.measures) {
            String measureName = measure.getName();
            dataItemsInfo.add(new String[]{Aggregate.processLongName(measureName, dataItemsInfo), measure.getQueryItem()});
            metaNames.add(measureName);
            metaIndexMetaNameColumnNameMap.put(metaIndex, metaNameColumnNameMap);
            ++metaIndex;
        }
        ArrayList<String> filters = new ArrayList<String>();
        if (this.metaCube.isNearRealTimeCube() && this.type == AggregateType.IN_DATABASE) {
            String filter = String.format("%s = null", this.metaCube.getFactTransactionIDQueryItem());
            filters.add(filter);
        }
        this.aggregateSQLInfo = QueryHelper.captureSQLInfoForAggregate(this.metaCube.getName(), this.name, dataItemsInfo, metaNames, filters, metaIndexMetaNameColumnNameMap, dimensionNameHierarchyNameMetaNameColumnNameMap);
        return this.aggregateSQLInfo;
    }

    private static String processLongName(String dataItemName, List<String[]> dataItemsInfo) {
        String trimmedItemName = Aggregate.trimDataItemName(dataItemName);
        if (Aggregate.foundDataItemInList(trimmedItemName, dataItemsInfo)) {
            for (int i = 0; i <= 9; ++i) {
                if (Aggregate.foundDataItemInList(trimmedItemName + i, dataItemsInfo)) continue;
                return trimmedItemName + i;
            }
            return dataItemName;
        }
        return trimmedItemName;
    }

    private static boolean foundDataItemInList(String dataItemName, List<String[]> dataItemsInfo) {
        for (String[] item : dataItemsInfo) {
            if (!item[0].equals(dataItemName)) continue;
            return true;
        }
        return false;
    }

    private static String trimDataItemName(String dataItemName) {
        if (dataItemName != null && dataItemName.length() > 17) {
            return dataItemName.substring(0, 16);
        }
        return dataItemName;
    }

    public final void getAggregateAsText(StringBuilder sb, AggregateSQLInfo sqlInfo, boolean describeInMemoryDependencies, boolean hasExistingInDBAggregates) {
        sb.append("/*******************************************************************************\n");
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_AggName, XQEMessages.getCurrProductLocale(), this.name)));
        int maxDimLength = DASHES_STR.length();
        int maxHierLength = DASHES_STR.length();
        int maxLevelLength = DASHES_STR.length();
        int hierarchyIndex = 0;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] rOLAPMetaHierarchyArray = this.metaCube.getHierarchies(dimension);
            int n = rOLAPMetaHierarchyArray.length;
            for (int i = 0; i < n; ++i) {
                String levelName;
                ROLAPMetaHierarchy hierarchy = rOLAPMetaHierarchyArray[i];
                if (dimension.getName().length() > maxDimLength) {
                    maxDimLength = dimension.getName().length();
                }
                if (hierarchy.getName().length() > maxHierLength) {
                    maxHierLength = hierarchy.getName().length();
                }
                if ((levelName = this.levelNames.get(hierarchyIndex)).length() > maxLevelLength) {
                    maxLevelLength = levelName.length();
                }
                ++hierarchyIndex;
            }
        }
        sb.append("* \n");
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_LevelList, XQEMessages.getCurrProductLocale())));
        sb.append("* \n");
        String dimHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_DimensionString, XQEMessages.getCurrProductLocale());
        String hierHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_HierarchyString, XQEMessages.getCurrProductLocale());
        String levelHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_LevelString, XQEMessages.getCurrProductLocale());
        sb.append(PREFIX + XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), dimHeader + this.addSpaces(maxDimLength - dimHeader.length(), true), hierHeader + this.addSpaces(maxHierLength - hierHeader.length(), true), levelHeader + this.addSpaces(maxLevelLength - levelHeader.length(), true)) + NEW_LINE);
        sb.append(PREFIX + XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), DASHES_STR + this.addSpaces(maxDimLength - DASHES_STR.length(), true), DASHES_STR + this.addSpaces(maxHierLength - DASHES_STR.length(), true), DASHES_STR + this.addSpaces(maxLevelLength - DASHES_STR.length(), true)) + NEW_LINE);
        hierarchyIndex = 0;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String dimName = dimension.getName() + this.addSpaces(maxDimLength - dimension.getName().length(), true);
                String hierName = hierarchy.getName() + this.addSpaces(maxHierLength - hierarchy.getName().length(), true);
                String levelName = this.levelNames.get(hierarchyIndex) + this.addSpaces(maxLevelLength - this.levelNames.get(hierarchyIndex).length(), true);
                if (this.levelNames.get(hierarchyIndex).equals(LEVEL_ALL)) {
                    String translatedAllName = XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDbAllLevel, XQEMessages.getCurrProductLocale());
                    levelName = translatedAllName + this.addSpaces(maxLevelLength - translatedAllName.length(), true);
                } else if (this.levelNames.get(hierarchyIndex).equals(LEVEL_ROOT)) {
                    String translatedRootName = XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDbRootLevel, XQEMessages.getCurrProductLocale());
                    levelName = translatedRootName + this.addSpaces(maxLevelLength - translatedRootName.length(), true);
                }
                sb.append(PREFIX);
                sb.append(XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), dimName, hierName, levelName));
                sb.append(NEW_LINE);
                ++hierarchyIndex;
            }
        }
        sb.append("* \n");
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_MeasureList, XQEMessages.getCurrProductLocale())));
        sb.append(this.prolog(DASHES_STR));
        for (ROLAPMetaMeasure measure : this.measures) {
            sb.append(PREFIX + measure.getName() + NEW_LINE);
        }
        sb.append("* \n");
        HashMap<String, ArrayList<String[]>> cubeModelRelationship = this.getDataForColumnType();
        sb.append(sqlInfo.dumpColumnSetInfo(PREFIX, true, cubeModelRelationship));
        sb.append("* \n");
        if (this.coveredByAggregates.isEmpty()) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DerivedFromNone, XQEMessages.getCurrProductLocale())));
        } else {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DerivedFrom, XQEMessages.getCurrProductLocale())));
            for (String aggrName : this.coveredByAggregates) {
                sb.append(this.prolog(aggrName));
            }
        }
        if (hasExistingInDBAggregates) {
            if (this.coveredByExistingAggregateCubes.isEmpty() && this.coveredByExistingAggregateCubesButHasSlicer.isEmpty()) {
                sb.append("* \n");
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DerivedFromNoneExisting, XQEMessages.getCurrProductLocale())));
            } else {
                if (!this.coveredByExistingAggregateCubes.isEmpty()) {
                    sb.append("* \n");
                    sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DerivedFromExisting, XQEMessages.getCurrProductLocale())));
                    for (String aggrName : this.coveredByExistingAggregateCubes) {
                        sb.append(this.prolog(aggrName));
                    }
                }
                if (!this.coveredByExistingAggregateCubesButHasSlicer.isEmpty()) {
                    sb.append("* \n");
                    sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DerivedFromExistingButHasSlicer, XQEMessages.getCurrProductLocale())));
                    for (String aggrName : this.coveredByExistingAggregateCubesButHasSlicer) {
                        sb.append(this.prolog(aggrName));
                    }
                }
            }
        }
        if (describeInMemoryDependencies) {
            sb.append("* \n");
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_NumInMemory, XQEMessages.getCurrProductLocale(), String.valueOf(this.numberOfInMemoryAggregatesCovered))));
        }
        sb.append("* \n");
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_RowCount, XQEMessages.getCurrProductLocale(), String.valueOf(this.cardinality))));
        sb.append("* \n");
        sb.append("*******************************************************************************/\n");
    }

    public String getStackedSql(Aggregate baseAggregate) {
        String columnType;
        String columnName;
        if (baseAggregate == null) {
            return "";
        }
        String baseAggregateSql = baseAggregate.getSQLInfo().getSQL();
        HashMap<String, ArrayList<String[]>> columnInfoMap = this.getDataForColumnType();
        Map<String, String> columnSetInfo = this.aggregateSQLInfo.getColumnSetInfo();
        Set<Map.Entry<String, String>> columnInfoSet = columnSetInfo.entrySet();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT\n");
        for (Map.Entry<String, String> columnInfo : columnInfoSet) {
            columnName = columnInfo.getKey();
            columnType = columnInfoMap.get(columnName).get(0)[0];
            if (columnType.equals(MEASURE)) {
                String aggregationFunction = this.getColumnAggregationFunction(baseAggregateSql, columnName);
                sb.append(PADDINGSPACE_STR + aggregationFunction + '(' + Aggregate.quotedName(columnName) + ')' + " AS " + Aggregate.quotedName(columnName) + ',' + NEW_LINE);
                continue;
            }
            sb.append(PADDINGSPACE_STR + Aggregate.quotedName(columnName) + ',' + NEW_LINE);
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        sb.append("FROM\n");
        sb.append("    [" + baseAggregate.getName() + ']' + NEW_LINE);
        sb.append("GROUP BY\n");
        for (Map.Entry<String, String> columnInfo : columnInfoSet) {
            columnName = columnInfo.getKey();
            columnType = columnInfoMap.get(columnName).get(0)[0];
            if (columnType.equals(MEASURE)) continue;
            sb.append(PADDINGSPACE_STR + Aggregate.quotedName(columnName) + ',' + NEW_LINE);
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    private static String quotedName(String unquotedName) {
        return '\"' + unquotedName + '\"';
    }

    private String getColumnAggregationFunction(String sql, String columnAlias) {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line;
            boolean selectSection = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equalsIgnoreCase("select")) {
                    selectSection = true;
                    continue;
                }
                if (line.equalsIgnoreCase("from")) {
                    selectSection = false;
                    continue;
                }
                if (!selectSection || !line.contains(Aggregate.quotedName(columnAlias))) continue;
                String aggFn = "";
                int pos = line.indexOf(40);
                if (pos > -1) {
                    aggFn = line.substring(0, pos);
                }
                return aggFn;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String toTraceString() {
        StringBuilder sb = new StringBuilder();
        try {
            AggregateSQLInfo sqlInfo = this.getSQLInfo();
            this.getAggregateAsText(sb, sqlInfo, true, true);
            sb.append(NEW_LINE);
            sb.append(sqlInfo.getSQL());
            sb.append(NEW_LINE);
        }
        catch (Exception ex) {
            sb.append("*** Unable to get SQL ***");
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    private HashMap<String, ArrayList<String[]>> getDataForColumnType() {
        String dimensionName;
        ROLAPMetaDimension[] dimensions;
        HashMap<String, ArrayList<String[]>> columnInfoHashDetail = new HashMap<String, ArrayList<String[]>>();
        int hierarchyIndex = 0;
        ArrayList<String[]> dataItemsInfo = new ArrayList<String[]>();
        for (ROLAPMetaDimension dimension : dimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] hierarchies;
            for (ROLAPMetaHierarchy hierarchy : hierarchies = this.metaCube.getHierarchies(dimension)) {
                LinkedHashSet<ROLAPMetaAttribute> levelKeys = new LinkedHashSet<ROLAPMetaAttribute>();
                LinkedHashSet<String> uniqueKeys = new LinkedHashSet<String>();
                ROLAPMetaLevel aggrLevel = this.getLevel(hierarchyIndex);
                String levelName = this.levelNames.get(hierarchyIndex);
                ROLAPMetaLevel[] hierLevelList = hierarchy.getLevels();
                if (levelName != LEVEL_ALL && levelName != LEVEL_ROOT) {
                    levelKeys.addAll(aggrLevel.getLevelKeys());
                    for (ROLAPMetaAttribute attr : levelKeys) {
                        String levelKeyName = attr.getName();
                        uniqueKeys.add(levelKeyName);
                    }
                }
                for (ROLAPMetaLevel hierLevel : hierLevelList) {
                    if (levelName == LEVEL_ALL || levelName == LEVEL_ROOT) break;
                    if (hierLevel != aggrLevel) {
                        levelKeys.addAll(hierLevel.getLevelKeys());
                    }
                    if (hierLevel != aggrLevel) continue;
                    String dimName = dimension.getName();
                    String hierName = hierarchy.getName();
                    for (ROLAPMetaAttribute attr : levelKeys) {
                        ArrayList<String[]> val = new ArrayList<String[]>();
                        String levelKeyName = attr.getName();
                        String uniqueAggrName = Aggregate.processLongName(levelKeyName, dataItemsInfo);
                        dataItemsInfo.add(new String[]{uniqueAggrName, attr.getQueryItem()});
                        AggregateSQLInfo sqlInfo = this.getSQLInfo();
                        String columnName = sqlInfo.getColumnNameFromAttributeName(uniqueAggrName);
                        if (uniqueKeys.contains(levelKeyName)) {
                            val.add(new String[]{UNIQUE_KEY});
                            val.add(new String[]{dimName, hierName, levelName});
                        } else {
                            val.add(new String[]{LEVEL_KEY});
                            val.add(new String[]{null});
                        }
                        columnInfoHashDetail.put(columnName, val);
                    }
                    break;
                }
                ++hierarchyIndex;
            }
        }
        String hierarchyName = dimensionName = this.metaCube.getMetaCubeModel().getMeasureDimensionName();
        for (ROLAPMetaMeasure measure : this.measures) {
            String measureName = measure.getName();
            AggregateSQLInfo sqlInfo = this.getSQLInfo();
            String columnName = sqlInfo.getColumnName(dimensionName, hierarchyName, measureName);
            ArrayList<String[]> val = new ArrayList<String[]>();
            val.add(new String[]{MEASURE});
            val.add(new String[]{measureName});
            columnInfoHashDetail.put(columnName, val);
        }
        return columnInfoHashDetail;
    }

    private String addSpaces(int length, boolean padding) {
        StringBuilder sb = new StringBuilder();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                sb.append(SPACE_STR);
            }
        }
        if (padding) {
            sb.append(PADDINGSPACE_STR);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    private String prolog(String text) {
        String line = PREFIX + text + NEW_LINE;
        return line;
    }

    public void addCoveredByAggregate(String aggregateName) {
        this.coveredByAggregates.add(aggregateName);
    }

    public List<String> getCoveredByAggregates() {
        return this.coveredByAggregates;
    }

    public void addCoveredByExistingAggregateCube(String aggregateCubeName) {
        this.coveredByExistingAggregateCubes.add(aggregateCubeName);
    }

    public void addCoveredByExistingAggregateCubeButHasSlicer(String aggregateCubeName) {
        this.coveredByExistingAggregateCubesButHasSlicer.add(aggregateCubeName);
    }

    public int getNumberOfInMemoryAggregatesCovered() {
        return this.numberOfInMemoryAggregatesCovered;
    }

    public void setNumberOfInMemoryAggregatesCovered(int num) {
        this.numberOfInMemoryAggregatesCovered = num;
    }

    public List<Aggregate> getCoveredInMemoryAggregates() {
        return this.coveredInMemoryAggregates;
    }

    public void addCoveredInMemoryAggregate(Aggregate aggregate) {
        this.coveredInMemoryAggregates.add(aggregate);
    }

    public void incrementWorkloadCounters(Aggregate countedAggregate) {
        if (null != countedAggregate) {
            this.workloadCount += countedAggregate.getWorkloadHitCount();
            this.incrementWorkloadExecutionTime(countedAggregate.getWorkloadQueryExecutionTime());
            HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureDataCollection = countedAggregate.getWorkloadMeasureSummaryData();
            for (WorkloadSummarizedMeasuresCollection.MeasureSummaryData data : measureDataCollection.values()) {
                this.workloadMeasures.recordHits(data.getMeasureName(), data.getHitCount());
            }
        }
    }

    public void incrementWorkloadCount() {
        ++this.workloadCount;
    }

    public void incrementWorkloadExecutionTime(long workloadExecutionTime) {
        this.workloadQueryExecutionTime += workloadExecutionTime;
    }

    public void incrementWorkloadMeasureHits(List<String> measuresFromWorkload) {
        this.workloadMeasures.recordHits(measuresFromWorkload);
    }

    public int getWorkloadHitCount() {
        return this.workloadCount;
    }

    public long getWorkloadQueryExecutionTime() {
        return this.workloadQueryExecutionTime;
    }

    public HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> getWorkloadMeasureSummaryData() {
        return this.workloadMeasures.getCollection();
    }
}

