/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AggregateUtils {
    public static final Comparator<Aggregate> AGGREGATE_ASCENDING_CARDINALITY_ORDER = new Comparator<Aggregate>(){

        @Override
        public int compare(Aggregate c1, Aggregate c2) {
            if (c1.getCardinality() > c2.getCardinality()) {
                return 1;
            }
            if (c1.getCardinality() < c2.getCardinality()) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<Aggregate> AGGREGATE_DESCENDING_TIME_ORDER = new Comparator<Aggregate>(){

        @Override
        public int compare(Aggregate c1, Aggregate c2) {
            if (c1.getWorkloadQueryExecutionTime() < c2.getWorkloadQueryExecutionTime()) {
                return 1;
            }
            if (c1.getWorkloadQueryExecutionTime() > c2.getWorkloadQueryExecutionTime()) {
                return -1;
            }
            return 0;
        }
    };

    public static long getAggregatesSize(List<Aggregate> aggregates) {
        long size = 0L;
        for (Aggregate aggregate : aggregates) {
            size += aggregate.getEstimatedSize();
        }
        return size;
    }

    public static Aggregate getInMemoryAggregateEngineWillUseForQuery(Aggregate query, List<Aggregate> aggregates) {
        Aggregate bestMatchAggregate = null;
        for (Aggregate aggregate : aggregates) {
            if (!aggregate.isCovered(query)) continue;
            if (bestMatchAggregate == null) {
                bestMatchAggregate = aggregate;
                continue;
            }
            if (aggregate.getNumberOfCells() >= bestMatchAggregate.getNumberOfCells()) continue;
            bestMatchAggregate = aggregate;
        }
        return bestMatchAggregate;
    }

    public static long estimateQueryTime(List<Aggregate> queries, List<Aggregate> aggregates) {
        long time = 0L;
        for (Aggregate query : queries) {
            boolean covered = false;
            for (Aggregate aggregate : aggregates) {
                if (!aggregate.isCovered(query)) continue;
                covered = true;
                break;
            }
            if (covered) {
                time += 0L;
                continue;
            }
            time += query.getWorkloadQueryExecutionTime();
        }
        return time;
    }

    public static List<Aggregate> getMatchingAggregates(Aggregate aggregateToMatch, List<Aggregate> aggregates) {
        ArrayList<Aggregate> matchingAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (!aggregate.isCovered(aggregateToMatch)) continue;
            matchingAggregates.add(aggregate);
        }
        return matchingAggregates;
    }

    public static List<Aggregate> getCoveredAggregates(List<Aggregate> upperAggregates, List<Aggregate> lowerAggregates) {
        ArrayList<Aggregate> coveredAggregates = new ArrayList<Aggregate>();
        block0: for (Aggregate upperAggregate : upperAggregates) {
            for (Aggregate lowerAggregate : lowerAggregates) {
                if (!lowerAggregate.isCovered(upperAggregate)) continue;
                coveredAggregates.add(upperAggregate);
                continue block0;
            }
        }
        return coveredAggregates;
    }

    public static List<Aggregate> getInMemoryAggregatesCoveredByInDatabaseAggregates(List<Aggregate> inMemoryAggregates, List<Aggregate> inDatabaseAggregates) {
        ArrayList<Aggregate> coveredInMemoryAggregates = new ArrayList<Aggregate>();
        for (Aggregate inMemoryAggregate : inMemoryAggregates) {
            if (!AggregateUtils.isInMemoryAggregateCoveredByInDatabaseAggregates(inMemoryAggregate, inDatabaseAggregates)) continue;
            coveredInMemoryAggregates.add(inMemoryAggregate);
        }
        return coveredInMemoryAggregates;
    }

    private static boolean isInMemoryAggregateCoveredByInDatabaseAggregates(Aggregate inMemoryAggregate, List<Aggregate> inDatabaseAggregates) {
        List<ROLAPMetaMeasure> inMemoryAggregateMeasures = inMemoryAggregate.getMeasures();
        List<ROLAPMetaMeasure> cubeAdditiveMeasures = inMemoryAggregate.getAggregateAdvisor().getAdditiveMeasures();
        ArrayList<ROLAPMetaMeasure> inMemoryAggregateAdditiveMeasures = new ArrayList<ROLAPMetaMeasure>(inMemoryAggregateMeasures);
        inMemoryAggregateAdditiveMeasures.retainAll(cubeAdditiveMeasures);
        ArrayList<ROLAPMetaMeasure> inMemoryAggregateNonAdditiveMeasures = new ArrayList<ROLAPMetaMeasure>(inMemoryAggregateMeasures);
        inMemoryAggregateNonAdditiveMeasures.removeAll(cubeAdditiveMeasures);
        for (ROLAPMetaMeasure inMemoryAggregateNonAdditiveMeasure : inMemoryAggregateNonAdditiveMeasures) {
            if (AggregateUtils.isNonAdditiveMeasureCovered(inMemoryAggregateNonAdditiveMeasure, inMemoryAggregate, inDatabaseAggregates)) continue;
            return false;
        }
        for (ROLAPMetaMeasure inMemoryAggregateAdditiveMeasure : inMemoryAggregateAdditiveMeasures) {
            if (AggregateUtils.isAdditiveMeasureCovered(inMemoryAggregateAdditiveMeasure, inMemoryAggregate, inDatabaseAggregates)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonAdditiveMeasureCovered(ROLAPMetaMeasure nonAdditiveMeasure, Aggregate inMemoryAggregate, List<Aggregate> inDatabaseAggregates) {
        SliceCombination inMemoryAggregateSliceId = inMemoryAggregate.getSliceId();
        for (Aggregate inDatabaseAggregate : inDatabaseAggregates) {
            SliceCombination inDatabaseAggregateSliceId = inDatabaseAggregate.getSliceId();
            List<ROLAPMetaMeasure> inDatabaseAggregateMeasures = inDatabaseAggregate.getMeasures();
            if (!inDatabaseAggregateSliceId.isEqual(inMemoryAggregateSliceId) || !inDatabaseAggregateMeasures.contains(nonAdditiveMeasure)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAdditiveMeasureCovered(ROLAPMetaMeasure additiveMeasure, Aggregate inMemoryAggregate, List<Aggregate> inDatabaseAggregates) {
        SliceCombination inMemoryAggregateSliceId = inMemoryAggregate.getSliceId();
        for (Aggregate inDatabaseAggregate : inDatabaseAggregates) {
            SliceCombination inDatabaseAggregateSliceId = inDatabaseAggregate.getSliceId();
            List<ROLAPMetaMeasure> inDatabaseAggregateMeasures = inDatabaseAggregate.getMeasures();
            if (!inDatabaseAggregateSliceId.isCovered(inMemoryAggregateSliceId) || !inDatabaseAggregateMeasures.contains(additiveMeasure)) continue;
            return true;
        }
        return false;
    }

    public static List<Aggregate> getAdditiveAggregates(List<Aggregate> aggregates) {
        ArrayList<Aggregate> additiveAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (!aggregate.isAdditive()) continue;
            additiveAggregates.add(aggregate);
        }
        return additiveAggregates;
    }

    public static List<Aggregate> getAggregatesRecommendedBy(List<Aggregate> aggregates, AggregateRecommendedByEnum recommendedBy) {
        ArrayList<Aggregate> subsetOfAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (aggregate.getRecommendedBy() != recommendedBy) continue;
            subsetOfAggregates.add(aggregate);
        }
        return subsetOfAggregates;
    }

    public static void removeAggregatesWithIdenticalLevels(List<Aggregate> aggregates) {
        ArrayList<Aggregate> uniqueAggregates = new ArrayList<Aggregate>();
        while (!aggregates.isEmpty()) {
            Aggregate aggregate = aggregates.get(0);
            List<Aggregate> aggregatesWithSameLevels = AggregateUtils.getAggregatesWithSameLevels(aggregate, aggregates);
            Aggregate uniqueAggregate = AggregateUtils.selectAggregateToRecommendFromAggregatesWithSameLevels(aggregatesWithSameLevels);
            uniqueAggregates.add(uniqueAggregate);
            aggregates.removeAll(aggregatesWithSameLevels);
        }
        aggregates.addAll(uniqueAggregates);
    }

    public static List<Aggregate> getAggregatesWithSameLevels(Aggregate aggregate, List<Aggregate> aggregateList) {
        ArrayList<Aggregate> aggregatesWithSameLevels = new ArrayList<Aggregate>();
        for (Aggregate aggregateListElement : aggregateList) {
            if (!aggregate.hasSameLevels(aggregateListElement)) continue;
            aggregatesWithSameLevels.add(aggregateListElement);
        }
        return aggregatesWithSameLevels;
    }

    private static Aggregate selectAggregateToRecommendFromAggregatesWithSameLevels(List<Aggregate> aggregatesWithSameLevels) {
        Aggregate aggregateToRecommend = null;
        aggregateToRecommend = AggregateUtils.getAggregateRecommendedByStrategy(aggregatesWithSameLevels, AggregateRecommendedByEnum.USER);
        if (aggregateToRecommend == null) {
            aggregateToRecommend = AggregateUtils.getAggregateRecommendedByStrategy(aggregatesWithSameLevels, AggregateRecommendedByEnum.WORKLOAD);
        }
        if (aggregateToRecommend == null) {
            aggregateToRecommend = AggregateUtils.getAggregateRecommendedByStrategy(aggregatesWithSameLevels, AggregateRecommendedByEnum.AUTONOMIC);
        }
        if (aggregateToRecommend == null) {
            aggregateToRecommend = aggregatesWithSameLevels.get(0);
        }
        return aggregateToRecommend;
    }

    private static Aggregate getAggregateRecommendedByStrategy(List<Aggregate> aggregates, AggregateRecommendedByEnum recommendedByStrategyEnum) {
        for (Aggregate aggregate : aggregates) {
            if (aggregate.getRecommendedBy() != recommendedByStrategyEnum) continue;
            return aggregate;
        }
        return null;
    }
}

