/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.util.ConfigurationValues;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class CubeCardinalityMetrics {
    private ROLAPMetaCube metaCube = null;
    private long factCardinality;
    private long factCardinalityWhenAdvisorLastRan;
    private static final double FACT_CARDINALITY_DELTA_FOR_TRIMMING = 0.2;
    private static final boolean SMART_SLICE_CARDINALITY_ESTIMATE = true;
    private static final int NUMBER_OF_DUMMY_SAMPLING_ENTRIES = 2;
    private HashMapObjectLong<String> levelCardinalities = new HashMapObjectLong();
    private HashMap<String, SliceCardinalityMetrics> sliceCardinalities = new HashMap();
    private int maxNumberOfSliceCardinalityEntries;
    private int samplingHierarchyIndex = -1;
    private static final String PCT_OF_SLICE_CARDINALITY_ENTRIES_TO_TRIM = "advisorPctOfSliceCardinalityEntriesToTrim";
    private static final int DEFAULT_PCT_OF_SLICE_CARDINALITY_ENTRIES_TO_TRIM = 5;
    private static final String KEY_SEPARATOR = " : ";
    private static final String MAX_NUMBER_OF_SLICE_CARDINALITY_ENTRIES = "advisorMaxSliceCardinalityEntries";
    private static final int DEFAULT_NUMBER_OF_SLICE_CARDINALITY_ENTRIES = 1000;
    private static final Comparator<SliceCardinalityMetrics> DESCENDING_PRIORITY_ORDER = new Comparator<SliceCardinalityMetrics>(){

        @Override
        public int compare(SliceCardinalityMetrics metrics1, SliceCardinalityMetrics metrics2) {
            if (CubeCardinalityMetrics.rateSliceCardinalityMetrics(metrics1) > CubeCardinalityMetrics.rateSliceCardinalityMetrics(metrics2)) {
                return -1;
            }
            if (CubeCardinalityMetrics.rateSliceCardinalityMetrics(metrics1) < CubeCardinalityMetrics.rateSliceCardinalityMetrics(metrics2)) {
                return 1;
            }
            return 0;
        }
    };

    public CubeCardinalityMetrics(ROLAPMetaCube aMetaCube) {
        this.metaCube = aMetaCube;
        this.maxNumberOfSliceCardinalityEntries = ConfigurationValues.getZeroOrPositiveInt(MAX_NUMBER_OF_SLICE_CARDINALITY_ENTRIES, 1000);
    }

    public ROLAPMetaCube getMetaCube() {
        return this.metaCube;
    }

    public int getSamplingHierarchyIndex() {
        return this.samplingHierarchyIndex;
    }

    public void setSamplingHierarchyIndex(int pSamplingHierarchyIndex) {
        this.samplingHierarchyIndex = pSamplingHierarchyIndex;
    }

    public int getMaxNumberOfSliceCardinalityEntries() {
        return this.maxNumberOfSliceCardinalityEntries;
    }

    public long getFactCardinality() {
        return this.factCardinality;
    }

    public void setFactCardinality(long cardinality) {
        this.factCardinality = cardinality;
    }

    public long getFactCardinalityWhenAdvisorLastRan() {
        return this.factCardinalityWhenAdvisorLastRan;
    }

    public void setFactCardinalityWhenAdvisorLastRan(long cardinality) {
        this.factCardinalityWhenAdvisorLastRan = cardinality;
    }

    public long getLevelCardinality(String dimensionName, String hierarchyName, String levelName) {
        String key = this.generateLevelCardinalityMapKey(dimensionName, hierarchyName, levelName);
        long cardinality = this.levelCardinalities.get(key);
        return cardinality;
    }

    public void setLevelCardinality(String dimensionName, String hierarchyName, String levelName, long cardinality) {
        String key = this.generateLevelCardinalityMapKey(dimensionName, hierarchyName, levelName);
        this.levelCardinalities.put(key, cardinality);
    }

    private String generateLevelCardinalityMapKey(String dimensionName, String hierarchyName, String levelName) {
        String key = dimensionName + KEY_SEPARATOR + hierarchyName + KEY_SEPARATOR + levelName;
        return key;
    }

    public int getHierarchyMemberCount(ROLAPMetaHierarchy hierarchy) {
        int numMembers = 0;
        if (!hierarchy.isRecursive()) {
            if (hierarchy.hasAllLevel()) {
                ++numMembers;
            }
            for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                long levelCardinality = this.getLevelCardinality(hierarchy.getDimensionName(), hierarchy.getName(), level.getName());
                numMembers = (int)((long)numMembers + levelCardinality);
            }
        } else {
            numMembers = 1;
        }
        return numMembers;
    }

    public int getDimensionMemberCount(ROLAPMetaDimension dimension) {
        int numMembers = 0;
        for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
            numMembers += this.getHierarchyMemberCount(hierarchy);
        }
        return numMembers;
    }

    public int[] getLevelMemberCounts(Aggregate aggregate) {
        return this.getLevelMemberCounts(aggregate, false);
    }

    public int[] getLevelMemberCounts(Aggregate aggregate, boolean includeNumberOfMeasures) {
        int hierarchyCount = aggregate.getLevels().size();
        if (includeNumberOfMeasures) {
            ++hierarchyCount;
        }
        int[] levelSizes = new int[hierarchyCount];
        int index = 0;
        if (includeNumberOfMeasures) {
            levelSizes[0] = aggregate.getMeasures().size();
            ++index;
        }
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (!hierarchy.isRecursive()) {
                    ROLAPMetaLevel level = aggregate.getLevel(dimension.getName(), hierarchy.getName());
                    if (level != null) {
                        long levelCardinality = this.getLevelCardinality(dimension.getName(), hierarchy.getName(), level.getName());
                        levelSizes[index] = (int)levelCardinality;
                    } else {
                        levelSizes[index] = 1;
                    }
                } else {
                    levelSizes[index] = 1;
                }
                ++index;
            }
        }
        return levelSizes;
    }

    public int[] getHierarchyMemberCounts(Aggregate aggregate) {
        int hierarchyCount = aggregate.getLevels().size() + 1;
        int[] hierarchyMemberCounts = new int[hierarchyCount];
        int hierarchyIndex = 0;
        hierarchyMemberCounts[0] = this.metaCube.getMeasures().length;
        ++hierarchyIndex;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                hierarchyMemberCounts[hierarchyIndex] = this.getHierarchyMemberCount(hierarchy);
                ++hierarchyIndex;
            }
        }
        return hierarchyMemberCounts;
    }

    public int[] getHierarchyDimensionMemberCounts(Aggregate aggregate) {
        int hierarchyCount = aggregate.getLevels().size() + 1;
        int[] hierarchyDimensionMemberCounts = new int[hierarchyCount];
        int hierarchyIndex = 0;
        hierarchyDimensionMemberCounts[0] = this.metaCube.getMeasures().length;
        ++hierarchyIndex;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (int index = 1; index <= this.metaCube.getHierarchies(dimension).length; ++index) {
                hierarchyDimensionMemberCounts[hierarchyIndex] = this.getDimensionMemberCount(dimension);
                ++hierarchyIndex;
            }
        }
        return hierarchyDimensionMemberCounts;
    }

    public int getSliceCardinalityCount() {
        return this.sliceCardinalities.size();
    }

    public boolean isSliceCardinalityKnown(SliceCombination sliceId) {
        String key = this.generateSliceCardinalityMapKey(sliceId);
        boolean known = this.sliceCardinalities.containsKey(key);
        return known;
    }

    public long getSliceCardinality(SliceCombination sliceId) {
        this.assertSliceExists(sliceId);
        boolean useSmartSliceCardinalityEstimateTechnique = ConfigurationValues.getBoolean("qsAdvisorSmartSliceCardinalityEstimate", true);
        SliceCardinalityMetrics sliceCardinalityMetrics = this.getSliceCardinalityMetrics(sliceId);
        if (sliceCardinalityMetrics.getActualCardinality() > 0L) {
            return sliceCardinalityMetrics.getActualCardinality();
        }
        if (useSmartSliceCardinalityEstimateTechnique) {
            return this.getExtrapolatedSliceCardinality(sliceId);
        }
        return sliceCardinalityMetrics.getEstimatedCardinality();
    }

    public long getActualSliceCardinality(SliceCombination sliceId) {
        this.assertSliceExists(sliceId);
        return this.getSliceCardinalityMetrics(sliceId).getActualCardinality();
    }

    public long getEstimatedSliceCardinality(SliceCombination sliceId) {
        this.assertSliceExists(sliceId);
        return this.getSliceCardinalityMetrics(sliceId).getEstimatedCardinality();
    }

    public long getExtrapolatedSliceCardinality(SliceCombination sliceId) {
        this.assertSliceExists(sliceId);
        SliceCardinalityMetrics sliceCardinalityMetrics = this.getSliceCardinalityMetrics(sliceId);
        long cardinality = (long)(this.determineExtrapolationRatio(sliceId) * (double)sliceCardinalityMetrics.getEstimatedCardinality());
        return cardinality;
    }

    private double determineExtrapolationRatio(SliceCombination pSliceId) {
        double ratioExtrapolate = 1.0;
        int ratioCount = 0;
        double ratioTotal = 0.0;
        if (this.samplingHierarchyIndex == -1) {
            return ratioExtrapolate;
        }
        ArrayList<SliceCombination> sliceIds = new ArrayList<SliceCombination>();
        for (SliceCombination sliceId : this.getSliceCardinalityIds()) {
            if (sliceId.getValue(this.samplingHierarchyIndex) != pSliceId.getValue(this.samplingHierarchyIndex)) continue;
            sliceIds.add(sliceId);
        }
        for (SliceCombination sliceId : sliceIds) {
            String key = this.generateSliceCardinalityMapKey(sliceId);
            SliceCardinalityMetrics sliceCardinalityMetrics = this.sliceCardinalities.get(key);
            if (sliceCardinalityMetrics.getActualCardinality() <= 0L || sliceCardinalityMetrics.getEstimatedCardinality() <= 0L) continue;
            double ratioCurrent = (double)sliceCardinalityMetrics.getActualCardinality() / (double)sliceCardinalityMetrics.getEstimatedCardinality();
            ++ratioCount;
            ratioTotal += ratioCurrent;
        }
        if (ratioCount > 0) {
            ratioExtrapolate = (ratioTotal += 2.0) / (double)(ratioCount += 2);
        }
        return ratioExtrapolate;
    }

    public List<SliceCombination> getSliceCardinalityIdsAbove(SliceCombination passedSliceId) {
        ArrayList<SliceCombination> sliceIds = new ArrayList<SliceCombination>();
        for (String key : this.sliceCardinalities.keySet()) {
            SliceCardinalityMetrics sliceCardinalityMetrics = this.sliceCardinalities.get(key);
            SliceCombination sliceId = sliceCardinalityMetrics.getSliceId();
            if (!passedSliceId.isCovered(sliceId)) continue;
            sliceIds.add(sliceId);
        }
        return sliceIds;
    }

    public List<SliceCombination> getSliceCardinalityIdsBelow(SliceCombination passedSliceId) {
        ArrayList<SliceCombination> sliceIds = new ArrayList<SliceCombination>();
        for (String key : this.sliceCardinalities.keySet()) {
            SliceCardinalityMetrics sliceCardinalityMetrics = this.sliceCardinalities.get(key);
            SliceCombination sliceId = sliceCardinalityMetrics.getSliceId();
            if (!sliceId.isCovered(passedSliceId)) continue;
            sliceIds.add(sliceId);
        }
        return sliceIds;
    }

    private void assertSliceExists(SliceCombination sliceId) {
        String key = this.generateSliceCardinalityMapKey(sliceId);
        if (!this.sliceCardinalities.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Slice %s has no cardinality information", key));
        }
    }

    public void setActualSliceCardinality(SliceCombination sliceId, long actualCardinality) {
        SliceCardinalityMetrics sliceCardinalityMetrics = this.getSliceCardinalityMetrics(sliceId);
        sliceCardinalityMetrics.setActualCardinality(actualCardinality);
        sliceCardinalityMetrics.setFactCardinality(this.factCardinality);
        this.setSliceCardinalityMetrics(sliceId, sliceCardinalityMetrics);
    }

    public void setEstimatedSliceCardinality(SliceCombination sliceId, long estimatedCardinality) {
        SliceCardinalityMetrics sliceCardinalityMetrics = this.getSliceCardinalityMetrics(sliceId);
        sliceCardinalityMetrics.setEstimatedCardinality(estimatedCardinality);
        sliceCardinalityMetrics.setFactCardinality(this.factCardinality);
        this.setSliceCardinalityMetrics(sliceId, sliceCardinalityMetrics);
    }

    public SliceCardinalityMetrics getSliceCardinalityMetrics(SliceCombination sliceId) {
        SliceCardinalityMetrics sliceCardinalityMetrics;
        SliceCombination sliceIdCopy = new SliceCombination();
        sliceIdCopy.copy(sliceId);
        String key = this.generateSliceCardinalityMapKey(sliceIdCopy);
        if (this.sliceCardinalities.containsKey(key)) {
            sliceCardinalityMetrics = this.sliceCardinalities.get(key);
        } else {
            sliceCardinalityMetrics = new SliceCardinalityMetrics();
            sliceCardinalityMetrics.setSliceId(sliceIdCopy);
        }
        return sliceCardinalityMetrics;
    }

    public void setSliceCardinalityMetrics(SliceCombination sliceId, SliceCardinalityMetrics sliceCardinalityMetrics) {
        String key = this.generateSliceCardinalityMapKey(sliceId);
        if (this.sliceCardinalities.size() >= this.maxNumberOfSliceCardinalityEntries && !this.sliceCardinalities.containsKey(key)) {
            this.trimSliceCardinalities();
        }
        this.sliceCardinalities.put(key, sliceCardinalityMetrics);
    }

    public List<SliceCombination> getSliceCardinalityIds() {
        ArrayList<SliceCombination> sliceIds = new ArrayList<SliceCombination>();
        for (String key : this.sliceCardinalities.keySet()) {
            SliceCardinalityMetrics sliceCardinalityMetrics = this.sliceCardinalities.get(key);
            sliceIds.add(sliceCardinalityMetrics.getSliceId());
        }
        return sliceIds;
    }

    public void trimSliceCardinalitiesBasedOnFactSizeChange() {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : this.sliceCardinalities.keySet()) {
            SliceCardinalityMetrics sliceCardinalityMetrics = this.sliceCardinalities.get(key);
            long deltaFactCardinality = Math.abs(sliceCardinalityMetrics.getFactCardinality() - this.factCardinality);
            double ratio = (double)deltaFactCardinality / (double)sliceCardinalityMetrics.getFactCardinality();
            if (!(ratio >= 0.2)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.sliceCardinalities.remove(key);
        }
    }

    private String generateSliceCardinalityMapKey(SliceCombination sliceId) {
        return sliceId.valueToString();
    }

    private void trimSliceCardinalities() {
        ArrayList<SliceCardinalityMetrics> sliceCardinalityMetricsCollection = new ArrayList<SliceCardinalityMetrics>(this.sliceCardinalities.values());
        Collections.sort(sliceCardinalityMetricsCollection, DESCENDING_PRIORITY_ORDER);
        Collections.reverse(sliceCardinalityMetricsCollection);
        double trimPct = ConfigurationValues.getPercentFromInt(PCT_OF_SLICE_CARDINALITY_ENTRIES_TO_TRIM, 5);
        int numberOfSliceCardinalityEntriesToTrim = (int)(trimPct * (double)this.sliceCardinalities.size());
        for (int count = 1; count <= numberOfSliceCardinalityEntriesToTrim; ++count) {
            SliceCombination sliceId = ((SliceCardinalityMetrics)sliceCardinalityMetricsCollection.get(count)).getSliceId();
            String key = this.generateSliceCardinalityMapKey(sliceId);
            this.sliceCardinalities.remove(key);
        }
    }

    private static int rateSliceCardinalityMetrics(SliceCardinalityMetrics sliceCardinalityMetrics) {
        int rating = 0;
        if (sliceCardinalityMetrics.getActualCardinality() > 0L) {
            rating += 2;
        }
        if (sliceCardinalityMetrics.getEstimatedCardinality() > 0L) {
            ++rating;
        }
        return rating;
    }
}

