/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CubeCardinalityMetricsReader {
    private XMLStreamReader reader;
    private ROLAPMetaCube metaCube;
    private CubeCardinalityMetrics cubeCardinalityMetrics;
    private boolean levelsValid;

    public static CubeCardinalityMetrics generateCubeCardinalityMetricsFromXML(String xml, ROLAPMetaCube aMetaCube) throws Exception {
        XMLStreamReader reader = StaxUtil.createXMLStreamReader(xml);
        CubeCardinalityMetricsReader cubeCardinalityMetricsReader = new CubeCardinalityMetricsReader(reader, aMetaCube);
        return cubeCardinalityMetricsReader.parseCubeCardinalityMetrics();
    }

    public CubeCardinalityMetricsReader(XMLStreamReader aReader, ROLAPMetaCube aMetaCube) {
        this.reader = aReader;
        this.metaCube = aMetaCube;
        this.cubeCardinalityMetrics = new CubeCardinalityMetrics(this.metaCube);
    }

    public CubeCardinalityMetrics parseCubeCardinalityMetrics() {
        try {
            this.reader.next();
            ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
            while (childElementIterator.next()) {
                String elementName = this.reader.getLocalName();
                if ("fact".equals(elementName)) {
                    this.parseFact();
                    continue;
                }
                if ("slices".equals(elementName)) {
                    this.parseSlices();
                    continue;
                }
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogFileCouldNotBeParsed, (Throwable)ex, (Object)"<no file>", (Object)this.metaCube.getName());
        }
        return this.cubeCardinalityMetrics;
    }

    private void parseFact() throws XMLStreamException {
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("cardinality".equals(attributeName)) {
                long cardinality = Long.valueOf(attributeValue);
                this.cubeCardinalityMetrics.setFactCardinality(cardinality);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(attributeName);
        }
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        childElementIterator.skipToEnd();
    }

    private void parseSlices() throws XMLStreamException {
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("slice".equals(elementName)) {
                this.parseSlice();
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
    }

    private void parseSlice() throws XMLStreamException {
        long actualSliceCardinality = 0L;
        long estimatedSliceCardinality = 0L;
        long factCardinalityForSliceCardinality = 0L;
        this.levelsValid = true;
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("actualCardinality".equals(attributeName)) {
                actualSliceCardinality = Long.valueOf(attributeValue);
                continue;
            }
            if ("estimatedCardinality".equals(attributeName)) {
                estimatedSliceCardinality = Long.valueOf(attributeValue);
                continue;
            }
            if (!"factCardinality".equals(attributeName)) continue;
            factCardinalityForSliceCardinality = Long.valueOf(attributeValue);
        }
        Aggregate aggregate = new Aggregate(this.metaCube);
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("levels".equals(elementName)) {
                this.parseLevels(aggregate);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
        if (this.levelsValid) {
            SliceCombination sliceId = aggregate.getSliceId();
            SliceCardinalityMetrics sliceCardinalityMetrics = this.cubeCardinalityMetrics.getSliceCardinalityMetrics(sliceId);
            sliceCardinalityMetrics.setActualCardinality(actualSliceCardinality);
            sliceCardinalityMetrics.setEstimatedCardinality(estimatedSliceCardinality);
            sliceCardinalityMetrics.setFactCardinality(factCardinalityForSliceCardinality);
            this.cubeCardinalityMetrics.setSliceCardinalityMetrics(sliceId, sliceCardinalityMetrics);
        }
    }

    private void parseLevels(Aggregate aggregate) throws XMLStreamException {
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("level".equals(elementName)) {
                this.parseLevel(aggregate);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
    }

    private void parseLevel(Aggregate aggregate) throws XMLStreamException {
        String dimensionName = "";
        String hierarchyName = "";
        String levelName = "";
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("dimension".equals(attributeName)) {
                dimensionName = attributeValue;
                continue;
            }
            if ("hierarchy".equals(attributeName)) {
                hierarchyName = attributeValue;
                continue;
            }
            if ("name".equals(attributeName)) {
                levelName = attributeValue;
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(attributeName);
        }
        try {
            aggregate.setLevel(dimensionName, hierarchyName, levelName);
        }
        catch (Exception ex) {
            this.levelsValid = false;
        }
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        childElementIterator.skipToEnd();
    }

    private void throwXQERuntimeExceptionThatElementWasUnexpected(String elementName) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogParserFoundUnexpectedElement, elementName);
    }
}

