/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CubeRegion {
    private ROLAPMetaCube metaCube = null;
    private Map<String, Boolean> levels = new HashMap<String, Boolean>();
    private static final String KEY_SEPARATOR = " : ";

    public CubeRegion(ROLAPMetaCube aMetaCube) {
        this.metaCube = aMetaCube;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (hierarchy.hasAllLevel()) {
                    this.levels.put(this.generateKey(dimension.getName(), hierarchy.getName(), "[All]"), Boolean.FALSE);
                } else if (hierarchy.isRecursive()) {
                    this.levels.put(this.generateKey(dimension.getName(), hierarchy.getName(), "[Root]"), Boolean.FALSE);
                }
                if (hierarchy.isRecursive()) continue;
                for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                    this.levels.put(this.generateKey(dimension.getName(), hierarchy.getName(), level.getName()), Boolean.FALSE);
                }
            }
        }
    }

    public ROLAPMetaCube getModel() {
        return this.metaCube;
    }

    public Boolean isSelected(String dimensionName, String hierarchyName, String levelName) {
        this.validate(dimensionName, hierarchyName, levelName);
        return this.levels.get(this.generateKey(dimensionName, hierarchyName, levelName));
    }

    public void select(String dimensionName, String hierarchyName, String levelName) {
        this.validate(dimensionName, hierarchyName, levelName);
        this.levels.put(this.generateKey(dimensionName, hierarchyName, levelName), Boolean.TRUE);
    }

    public void deselect(String dimensionName, String hierarchyName, String levelName) {
        this.validate(dimensionName, hierarchyName, levelName);
        this.levels.put(this.generateKey(dimensionName, hierarchyName, levelName), Boolean.FALSE);
    }

    public List<String> getLevels(String dimensionName, String hierarchyName) {
        ArrayList<String> selectedLevels = new ArrayList<String>();
        ROLAPMetaHierarchy hierarchy = this.getHierarchy(dimensionName, hierarchyName);
        if (hierarchy.hasAllLevel()) {
            if (this.isSelected(dimensionName, hierarchyName, "[All]").booleanValue()) {
                selectedLevels.add("[All]");
            }
        } else if (hierarchy.isRecursive() && this.isSelected(dimensionName, hierarchyName, "[Root]").booleanValue()) {
            selectedLevels.add("[Root]");
        }
        if (!hierarchy.isRecursive()) {
            for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                if (!this.isSelected(dimensionName, hierarchyName, level.getName()).booleanValue()) continue;
                selectedLevels.add(level.getName());
            }
        }
        return selectedLevels;
    }

    private ROLAPMetaHierarchy getHierarchy(String dimensionName, String hierarchyName) {
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.getName().equals(dimensionName)) continue;
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                if (!hierarchy.getName().equals(hierarchyName)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    private void validate(String dimensionName, String hierarchyName, String levelName) {
        String key = this.generateKey(dimensionName, hierarchyName, levelName);
        if (!this.levels.containsKey(key)) {
            String msg = String.format("Dimension %s hierarchy %s level %s does not exist.", dimensionName, hierarchyName, levelName);
            throw new IllegalArgumentException(msg);
        }
    }

    private String generateKey(String dimensionName, String hierarchyName, String levelName) {
        String key = dimensionName + KEY_SEPARATOR + hierarchyName + KEY_SEPARATOR + levelName;
        return key;
    }
}

