/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryType;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class WorkloadLogger {
    private String eventGroup = "ROLAP.AggregateWorkload";
    protected XQELogger logger = null;
    protected ROLAPCube mCube;
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.TRACE;
    private static final long MEMBERS_TO_DISPLAY_PER_LEVEL = 10L;
    private static final int ALL_LEVEL_INDEX = 0;
    private String mDefaultCubeName = null;
    protected boolean initialized;

    public WorkloadLogger(ROLAPCube cube) {
        if (this.logger == null) {
            this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", this.eventGroup, DEFAULT_LOG_LEVEL);
        }
        this.mCube = cube;
    }

    public abstract boolean isLoggingEnabledForCube();

    public boolean isLoggingInitialized() {
        return this.initialized;
    }

    public boolean isLoggingQueries() {
        ROLAPContext context = ROLAPContext.get();
        if (context != null) {
            return context.isLoggingQueriesAgainstCube(this);
        }
        return this.isLoggingInitialized() && this.isLoggingEnabledForCube();
    }

    public void logQueryAgainstDatabaseAggregateTable(RequestEnvironment reqEnv, String aggregateName, String id, ArrayList<ROLAPMeasure> measures, HashMap<ROLAPLevel, HashSet<IROLAPCommonMember>> levelMemberMap) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadInfo(reqEnv).getEntry(id);
        entry.setCacheHit(true);
        entry.setAggregateName(aggregateName);
        entry.setAccessType(2);
        this.doStandardDatabaseLogging(measures, levelMemberMap, entry);
    }

    public void logQueryAgainstDatabase(RequestEnvironment reqEnv, String id, ArrayList<ROLAPMeasure> measures, HashMap<ROLAPLevel, HashSet<IROLAPCommonMember>> levelMemberMap) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadInfo(reqEnv).getEntry(id);
        entry.setAccessType(1);
        this.doStandardDatabaseLogging(measures, levelMemberMap, entry);
    }

    private void doStandardDatabaseLogging(ArrayList<ROLAPMeasure> measures, HashMap<ROLAPLevel, HashSet<IROLAPCommonMember>> levelMemberMap, WorkloadInfo.WorkloadEntry entry) {
        for (ROLAPMeasure measure : measures) {
            entry.addMeasure(measure.getName());
        }
        Set<ROLAPLevel> levels = levelMemberMap.keySet();
        for (ROLAPLevel level : levels) {
            HashSet<IROLAPCommonMember> memberSet = levelMemberMap.get(level);
            int memberCount = memberSet.size();
            WorkloadInfo.HierarchyRecord hier = entry.addHierarchy(level.getHierarchy().getName(), level.getDimension().getName(), memberCount);
            hier.addLevel(level.getName());
            if (memberSet.isEmpty() || (long)memberCount >= 10L) continue;
            for (IROLAPCommonMember member : memberSet) {
                if (member instanceof ROLAPMemberProxy) {
                    hier.addMember(((ROLAPMemberProxy)member).getUniqueName());
                    continue;
                }
                if (!(member instanceof ROLAPMember)) continue;
                hier.addMember(((ROLAPMember)member).getUniqueName());
            }
        }
    }

    public void logPartialDataCacheHit(IMember[] measuresMembers, MemberLevelInfo preDataCachelevelInfo, MemberLevelInfo postDataCachelevelInfo, IHierarchy[] hierarchies) {
        if (!this.isLoggingQueries()) {
            return;
        }
        if (preDataCachelevelInfo == null) {
            return;
        }
        HashSetInt preCacheSet = null;
        HashSetInt postCacheSet = null;
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadEntry();
        entry.setCacheHit(true);
        entry.setAccessType(8);
        for (IHierarchy hier : hierarchies) {
            preCacheSet = preDataCachelevelInfo.getLevelIndexes(hier);
            if (null != postDataCachelevelInfo) {
                postCacheSet = postDataCachelevelInfo.getLevelIndexes(hier);
            }
            if (null != postCacheSet && null != preCacheSet && postCacheSet.size() != 0 && preCacheSet.size() != 0 && postCacheSet.size() != preCacheSet.size()) {
                preCacheSet.removeAll(postCacheSet);
            }
            this.logHierarchy(entry, preCacheSet, hier);
        }
        this.logMeasures(entry, measuresMembers);
    }

    public void logFullDataCacheHit(IMember[] measuresMembers, MemberLevelInfo levelInfo, IHierarchy[] hierarchies) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadEntry();
        entry.setCacheHit(true);
        entry.setAccessType(8);
        this.logMeasures(entry, measuresMembers);
        this.logSlice(entry, levelInfo, hierarchies);
    }

    public void logAggregateCacheHit(CrossJoinedSet setToFetch, String aggregateName, long totalInMemoryAggregateTime, long aggregateCacheHits) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadEntry();
        entry.setExecutionTime(totalInMemoryAggregateTime);
        entry.setCacheHit(true);
        entry.setAccessType(4);
        entry.setNumberOfRows(aggregateCacheHits);
        entry.setAggregateName(aggregateName);
        Dimension measuresDim = (Dimension)this.mCube.getMeasureDimension();
        IMember[] measuresMembers = setToFetch.getMembers(measuresDim);
        MemberLevelInfo levelInfo = setToFetch.getMemberLevelInfo();
        IHierarchy[] hiers = setToFetch.getHierarchies();
        this.logMeasures(entry, measuresMembers);
        this.logSlice(entry, levelInfo, hiers);
    }

    private void logMeasures(WorkloadInfo.WorkloadEntry entry, IMember[] measuresMembers) {
        for (IMember measure : measuresMembers) {
            entry.addMeasure(measure.getName());
        }
    }

    private WorkloadInfo.WorkloadEntry getWorkloadEntry() {
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadInfo(reqEnv).getEntry(new UID().toString());
        return entry;
    }

    private void logSlice(WorkloadInfo.WorkloadEntry entry, MemberLevelInfo levelInfo, IHierarchy[] hiers) {
        if (null != levelInfo && null != hiers) {
            for (IHierarchy hier : hiers) {
                this.logHierarchy(entry, levelInfo.getLevelIndexes(hier), hier);
            }
        }
    }

    private void logHierarchy(WorkloadInfo.WorkloadEntry entry, HashSetInt levelIndexes, IHierarchy hier) {
        if (null != levelIndexes && levelIndexes.size() > 0 && null != hier) {
            IDimension dimension = hier.getDimension();
            String dimensionName = dimension.getName();
            if (!dimension.isMeasuresDimension()) {
                Integer maximumLevelIndex = 0;
                maximumLevelIndex = levelIndexes.getMax();
                if (0 != maximumLevelIndex) {
                    String levelName = hier.getLevel(maximumLevelIndex).getName();
                    WorkloadInfo.HierarchyRecord hierarchyRecord = entry.addHierarchy(hier.getName(), dimensionName, 0);
                    hierarchyRecord.addLevel(levelName);
                }
            }
        }
    }

    public void logCellInfo(RequestEnvironment reqEnv, String queryId, long cellCount) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo.WorkloadEntry entry = this.getWorkloadInfo(reqEnv).getEntry(queryId);
        entry.setNumberOfRows(cellCount);
    }

    public void logQueryExecutionTime(RequestEnvironment reqEnv, String queryId, long executionTime) {
        WorkloadInfo.WorkloadEntry entry;
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo workloadInfo = this.getWorkloadInfo(reqEnv);
        if (null != workloadInfo && null != (entry = workloadInfo.getEntry(queryId))) {
            entry.setExecutionTime(executionTime);
        }
    }

    private WorkloadInfo getWorkloadInfo(RequestEnvironment reqEnv) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (execEnv == null) {
            return null;
        }
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContextNoThrow();
        if (multiRequestContext == null) {
            return null;
        }
        ROLAPContext context = multiRequestContext.getRolapContext();
        return context.getWorkloadInfo(this, reqEnv);
    }

    public abstract void startLogging();

    public abstract void stopLogging();

    public abstract void clearLogs();

    public final String getCubeName() {
        if (null == this.mDefaultCubeName) {
            this.mDefaultCubeName = this.mCube.getName(this.mCube.getDefaultLocale());
        }
        return this.mDefaultCubeName;
    }

    public abstract void logWorkloadInfo(WorkloadInfo var1);

    public void logQueryType(RequestEnvironment requestEnvironment, String queryId, QueryType queryType) {
        if (!this.isLoggingQueries()) {
            return;
        }
        WorkloadInfo workloadInfo = this.getWorkloadInfo(requestEnvironment);
        if (workloadInfo != null) {
            WorkloadInfo.WorkloadEntry workloadEntry = workloadInfo.getEntry(queryId);
            workloadEntry.setQueryType(queryType);
        }
    }

    protected boolean isWorkloadInfoFromAggregateLoad(WorkloadInfo workloadInfo) {
        WorkloadInfo.WorkloadEntry workloadEntry;
        QueryType queryType;
        Collection<WorkloadInfo.WorkloadEntry> workloadEntries = workloadInfo.getWorkloadEntries();
        Iterator<WorkloadInfo.WorkloadEntry> iterator = workloadEntries.iterator();
        return iterator.hasNext() && (queryType = (workloadEntry = iterator.next()).getQueryType()) == QueryType.AGGREGATE_LOAD_QUERY;
    }
}

