/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CountedWorkloadSlices;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadAggregateCacheCollection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogStatisticsElementData;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadSummarizedMeasuresCollection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.HashMap;
import java.util.List;

public class WorkloadSummary {
    private WorkloadParser mWorkloadParser = new WorkloadParser();
    private List<WorkloadParser.WorkloadAggregateTraceData> mTraces = null;
    private boolean mIsInitialized = false;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");

    public void setTestMode(String logFolderName) {
        this.mWorkloadParser.setTestMode(logFolderName);
    }

    public List<Aggregate> getCandidateCollection(ROLAPMetaCube aCube) {
        INFO_LOGGER.log("AggregateCandidates.getRawCandidates for cube " + aCube.getName());
        CountedWorkloadSlices slices = this.getSlices(aCube);
        INFO_LOGGER.log(String.format("AggregateCandidates.getRawCandidates for cube %s.  Total slice count is %d.", aCube.getName(), slices.getCollectionSizeForTracing()));
        return slices.getCollection();
    }

    public HashMap<String, WorkloadAggregateCacheCollection.AggregateCacheHitData> getAggregateCacheSummaryData() {
        INFO_LOGGER.log("AggregateCandidates.getAggregateCacheSummaryData retrieving a summarized aggregate cache hit data.");
        WorkloadAggregateCacheCollection cacheCollection = new WorkloadAggregateCacheCollection();
        if (this.mIsInitialized && null != this.mTraces) {
            WorkloadLogStatisticsElementData statisticsTraceData = null;
            long executionTime = 0L;
            String aggregateName = null;
            for (WorkloadParser.WorkloadAggregateTraceData workloadTrace : this.mTraces) {
                statisticsTraceData = workloadTrace.getStatisticsData();
                if (null == statisticsTraceData) continue;
                executionTime = statisticsTraceData.getExecutionTime();
                aggregateName = statisticsTraceData.getAggregateName();
                cacheCollection.recordHit(aggregateName, executionTime);
            }
        }
        INFO_LOGGER.log(String.format("AggregateCandidates.getAggregateCacheSummaryData.  Collection size is %d", cacheCollection.getCollectionSizeForTracing()));
        return cacheCollection.getCollection();
    }

    public HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> getMeasureSummaryData() {
        INFO_LOGGER.log("AggregateCandidates.getMeasureSummarydata.");
        WorkloadSummarizedMeasuresCollection cacheCollection = new WorkloadSummarizedMeasuresCollection();
        if (this.mIsInitialized && null != this.mTraces) {
            INFO_LOGGER.log("AggregateCandidates.getMeasureSummarydata for workload log " + this.mWorkloadParser.getWorkloadLogFileNameForTrace());
            for (WorkloadParser.WorkloadAggregateTraceData workloadTrace : this.mTraces) {
                for (String measureName : workloadTrace.getMeasures()) {
                    cacheCollection.recordHit(measureName);
                }
            }
        } else {
            INFO_LOGGER.log("AggregateCandidates.getMeasureSummarydata class not initialized properly");
        }
        INFO_LOGGER.log(String.format("AggregateCandidates.getMeasureSummarydata collection size is %d", cacheCollection.getCollectionSizeForTrace()));
        return cacheCollection.getCollection();
    }

    public boolean initialize(String cubeName, AdvisorRequestParameters requestParameters) {
        INFO_LOGGER.log("AggregateCandidates.initialize for cube name " + cubeName);
        if (!this.mIsInitialized) {
            this.mIsInitialized = this.mWorkloadParser.initializeParsing(cubeName);
            if (this.mIsInitialized) {
                this.mTraces = this.mWorkloadParser.getWorkloads(requestParameters);
                INFO_LOGGER.log(String.format("AggregateCandidates.initialize succeeded for cube name %s.  %d traces returned.", cubeName, this.mTraces.size()));
            } else {
                INFO_LOGGER.log("AggregateCandidates.initialize failed for cube name " + cubeName);
            }
        }
        return this.mIsInitialized;
    }

    public boolean containsWorkloads() {
        if (this.mIsInitialized && this.mTraces != null) {
            return this.mTraces.size() > 0;
        }
        return false;
    }

    public CountedWorkloadSlices getSlices(ROLAPMetaCube metaCube) {
        INFO_LOGGER.log("AggregateCandidates.getSlices for cube name " + metaCube.getName());
        CountedWorkloadSlices slices = new CountedWorkloadSlices();
        Aggregate aggregate = null;
        if (this.mIsInitialized && null != this.mTraces) {
            try {
                WorkloadLogStatisticsElementData statisticsTraceData = null;
                String levelName = null;
                String hierarchyName = null;
                String dimensionName = null;
                long executionTime = 0L;
                for (WorkloadParser.WorkloadAggregateTraceData workloadTrace : this.mTraces) {
                    statisticsTraceData = workloadTrace.getStatisticsData();
                    executionTime = 0L;
                    if (null != statisticsTraceData) {
                        executionTime = statisticsTraceData.getExecutionTime();
                    }
                    aggregate = new Aggregate(metaCube, executionTime, workloadTrace.getMeasures());
                    boolean isCandidate = workloadTrace.hasHierarchies();
                    for (WorkloadParser.HierarchyTraceData hierarchyTraceData : workloadTrace.getHierarchies()) {
                        hierarchyName = hierarchyTraceData.getHierarchyName();
                        dimensionName = hierarchyTraceData.getDimensionName();
                        levelName = hierarchyTraceData.getLevelName();
                        ROLAPMetaDimension metaDimension = AdvisorUtils.getMetaDimension(metaCube, dimensionName);
                        if (metaDimension == null) {
                            isCandidate = false;
                            break;
                        }
                        ROLAPMetaHierarchy metaHierarchy = AdvisorUtils.getMetaHierarchy(metaCube, dimensionName, hierarchyName);
                        if (metaHierarchy == null) {
                            isCandidate = false;
                            break;
                        }
                        ROLAPMetaLevel metaLevel = AdvisorUtils.getMetaLevel(metaCube, dimensionName, hierarchyName, levelName);
                        if (metaLevel == null) {
                            if (!metaHierarchy.isRecursive()) {
                                isCandidate = false;
                                break;
                            }
                            if (metaHierarchy.hasAllLevel()) {
                                isCandidate = false;
                                break;
                            }
                            if (!"Level 1".equals(levelName)) {
                                isCandidate = false;
                                break;
                            }
                            levelName = "[Root]";
                        }
                        aggregate.setLevel(dimensionName, hierarchyName, levelName);
                    }
                    if (!isCandidate) continue;
                    slices.addAggregate(aggregate);
                }
            }
            catch (Exception e) {
                throw new XQERuntimeException(e);
            }
        }
        INFO_LOGGER.log(String.format("AggregateCandidates.getSlices for cube name %s.  %d slices returned.", metaCube.getName(), slices.getCollectionSizeForTracing()));
        return slices;
    }

    public void tearDown() {
        if (this.mWorkloadParser != null) {
            this.mWorkloadParser.tearDown();
        }
    }
}

