/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadExceptionInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfoParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringEscapeUtils;

public class AggregateLoadInfoLogFileUtility {
    public static String getLogFileName(String cubeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getXqeLogsDirectory());
        sb.append(File.separatorChar);
        sb.append("ROLAPCubes");
        sb.append(File.separatorChar);
        sb.append(cubeName);
        sb.append(File.separatorChar);
        sb.append("advisor");
        sb.append(File.separatorChar);
        sb.append("logs");
        sb.append(File.separatorChar);
        sb.append("loads");
        sb.append(File.separatorChar);
        sb.append("aggregate_load_info_log.xml");
        String fileName = sb.toString();
        File file = new File(fileName);
        try {
            fileName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            fileName = file.getPath();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAggregateLoadManagerTaskInfo(String cubeName, AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo) throws Exception {
        boolean created;
        String fileName = AggregateLoadInfoLogFileUtility.getLogFileName(cubeName);
        File file = new File(fileName);
        File directory = file.getParentFile();
        if (!directory.exists() && !(created = directory.mkdirs())) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_ParentDirectoriesCouldNotBeCreated, fileName);
        }
        FileOutputStream fileOutputStream = null;
        XMLStreamWriter writer = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            writer = StaxUtil.createXMLStreamWriter(fileOutputStream);
            writer.setPrefix("olap", "http://www.ibm.com/olap/rolap/advisor");
            writer.writeStartDocument();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateLoadInfoLog");
            writer.writeAttribute("cube", cubeName);
            writer.writeNamespace("olap", "http://www.ibm.com/olap/rolap/advisor");
            writer.writeAttribute("version", "1.0");
            AggregateLoadInfoLogFileUtility.writeAggregateLoadManagerTaskInfo(aggregateLoadManagerTaskInfo, writer);
            writer.writeEndElement();
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void writeAggregateLoadManagerTaskInfo(AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo, XMLStreamWriter writer) throws XMLStreamException {
        writer.setPrefix("olap", "http://www.ibm.com/olap/rolap/advisor");
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateLoadManagerTaskInfo");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String loadStartTime = dateFormat.format(new Date(aggregateLoadManagerTaskInfo.getLoadStartTime()));
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "loadStartTime");
        writer.writeCharacters(loadStartTime);
        writer.writeEndElement();
        String loadEndTime = dateFormat.format(new Date(aggregateLoadManagerTaskInfo.getLoadEndTime()));
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "loadEndTime");
        writer.writeCharacters(loadEndTime);
        writer.writeEndElement();
        String escapedAggregateXML = StringEscapeUtils.escapeXml((String)aggregateLoadManagerTaskInfo.getAggregateXML());
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateXML");
        writer.writeCharacters(escapedAggregateXML);
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateLoadTaskInfos");
        List<AggregateLoadTaskInfo> aggregateLoadTaskInfos = aggregateLoadManagerTaskInfo.getAggregateLoadTaskInfos();
        for (AggregateLoadTaskInfo aggregateLoadTaskInfo : aggregateLoadTaskInfos) {
            AggregateLoadInfoLogFileUtility.writeAggregateLoadTaskInfo(aggregateLoadTaskInfo, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.flush();
    }

    private static void writeAggregateLoadTaskInfo(AggregateLoadTaskInfo aggregateLoadTaskInfo, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateLoadTaskInfo");
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateName");
        writer.writeCharacters(aggregateLoadTaskInfo.getAggregateName());
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateSizeInBytes");
        writer.writeCharacters(String.valueOf(aggregateLoadTaskInfo.getAggregateSizeInBytes()));
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateSizeInCells");
        writer.writeCharacters(String.valueOf(aggregateLoadTaskInfo.getAggregateSizeInCells()));
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateLoadTime");
        writer.writeCharacters(String.valueOf(aggregateLoadTaskInfo.getAggregateLoadTime()));
        writer.writeEndElement();
        AggregateLoadExceptionInfo aggregateLoadExceptionInfo = aggregateLoadTaskInfo.getAggregateLoadExceptionInfo();
        AggregateLoadInfoLogFileUtility.writeAggregateLoadExceptionInfo(aggregateLoadExceptionInfo, writer, "aggregateLoadExceptionInfo");
        writer.writeEndElement();
    }

    private static void writeAggregateLoadExceptionInfo(AggregateLoadExceptionInfo aggregateLoadExceptionInfo, XMLStreamWriter writer, String elementName) throws XMLStreamException {
        if (aggregateLoadExceptionInfo == null) {
            return;
        }
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", elementName);
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "exceptionClassName");
        writer.writeCharacters(aggregateLoadExceptionInfo.getExceptionClassName());
        writer.writeEndElement();
        String exceptionMessage = aggregateLoadExceptionInfo.getExceptionMessage();
        if (exceptionMessage != null) {
            exceptionMessage = StringEscapeUtils.escapeXml((String)exceptionMessage);
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "exceptionMessage");
            writer.writeCharacters(exceptionMessage);
            writer.writeEndElement();
        }
        AggregateLoadExceptionInfo exceptionCauseInfo = aggregateLoadExceptionInfo.getExceptionCauseInfo();
        AggregateLoadInfoLogFileUtility.writeAggregateLoadExceptionInfo(exceptionCauseInfo, writer, "exceptionCauseInfo");
        writer.writeEndElement();
    }

    public static AggregateLoadManagerTaskInfo readAggregateLoadManagerTaskInfo(String cubeName) {
        AggregateLoadManagerTaskInfoParser aggregateLoadManagerTaskInfoParser = new AggregateLoadManagerTaskInfoParser(cubeName);
        return aggregateLoadManagerTaskInfoParser.parseLastAggregateLoadManagerTaskInfo();
    }
}

