/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadExceptionInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadInfoLogFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;

public class AggregateLoadManagerTaskInfoParser {
    private static final String LOG_MSG_PARSING_LOADING_INFO = "Parsing the in-memory aggregate loading information from the log file for the cube %s";
    private String cubeName;
    private File logFile;
    private FileInputStream logFileInputStream;

    public AggregateLoadManagerTaskInfoParser(String theCubeName) {
        this.cubeName = theCubeName;
        String logFileName = AggregateLoadInfoLogFileUtility.getLogFileName(theCubeName);
        this.setLogFile(new File(logFileName));
    }

    public void setLogFile(File theLogFile) {
        this.logFile = theLogFile;
    }

    private void openLog() throws FileNotFoundException {
        if (this.logFile.exists()) {
            this.logFileInputStream = new FileInputStream(this.logFile);
        }
    }

    private void closeLog() throws IOException {
        if (this.logFileInputStream != null) {
            this.logFileInputStream.close();
            this.logFileInputStream = null;
        }
    }

    private XMLStreamReader createLogReader() throws XMLStreamException {
        XMLStreamReader reader;
        if (this.logFileInputStream != null && StaxUtil.moveToElement(reader = StaxUtil.createXMLStreamReader(this.logFileInputStream))) {
            String elementName = reader.getLocalName();
            String namespaceURI = reader.getNamespaceURI();
            if (!"http://www.ibm.com/olap/rolap/advisor".equals(namespaceURI)) {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
            return reader;
        }
        return null;
    }

    public AggregateLoadManagerTaskInfo parseLastAggregateLoadManagerTaskInfo() {
        AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo = null;
        List<AggregateLoadManagerTaskInfo> aggregateLoadManagerTaskInfos = this.parseAggregateLoadManagerTaskInfos(false);
        if (!aggregateLoadManagerTaskInfos.isEmpty()) {
            int indexOfLastLoadManagerTaskInfo = aggregateLoadManagerTaskInfos.size() - 1;
            aggregateLoadManagerTaskInfo = aggregateLoadManagerTaskInfos.get(indexOfLastLoadManagerTaskInfo);
        }
        return aggregateLoadManagerTaskInfo;
    }

    public List<AggregateLoadManagerTaskInfo> parseAggregateLoadManagerTaskInfos() {
        return this.parseAggregateLoadManagerTaskInfos(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AggregateLoadManagerTaskInfo> parseAggregateLoadManagerTaskInfos(boolean isAllTaskInfoRequired) {
        List<AggregateLoadManagerTaskInfo> list;
        try {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Parsing the in-memory aggregate loading information from the log file for the cube %s began.", this.cubeName));
            this.openLog();
            XMLStreamReader reader = this.createLogReader();
            List<AggregateLoadManagerTaskInfo> aggregateLoadManagerTaskInfos = this.parseAggregateLoadManagerTaskInfos(reader, isAllTaskInfoRequired);
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Parsing the in-memory aggregate loading information from the log file for the cube %s succeeded.", this.cubeName));
            list = aggregateLoadManagerTaskInfos;
        }
        catch (Exception ex) {
            try {
                ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("Parsing the in-memory aggregate loading information from the log file for the cube %s failed.", this.cubeName), ex);
                throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogFileCouldNotBeParsed, (Throwable)ex, (Object)this.logFile.getAbsolutePath(), (Object)this.cubeName);
            }
            catch (Throwable throwable) {
                try {
                    this.closeLog();
                    throw throwable;
                }
                catch (Exception ex2) {
                    ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("The log file %s for the cube %s could not be closed.", this.logFile.getAbsolutePath(), this.cubeName), ex2);
                }
                throw throwable;
            }
        }
        try {
            this.closeLog();
            return list;
        }
        catch (Exception ex) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("The log file %s for the cube %s could not be closed.", this.logFile.getAbsolutePath(), this.cubeName), ex);
        }
        return list;
    }

    private List<AggregateLoadManagerTaskInfo> parseAggregateLoadManagerTaskInfos(XMLStreamReader reader, boolean isAllTaskInfoRequired) {
        ArrayList<AggregateLoadManagerTaskInfo> aggregateLoadManagerTaskInfos = new ArrayList<AggregateLoadManagerTaskInfo>();
        try {
            if (reader != null) {
                ChildElementIterator rootChildElementIterator = new ChildElementIterator(reader);
                while (rootChildElementIterator.next()) {
                    String elementName = reader.getLocalName();
                    if ("aggregateLoadManagerTaskInfo".equals(elementName)) {
                        AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo = this.parseAggregateLoadManagerTaskInfo(reader);
                        if (isAllTaskInfoRequired || aggregateLoadManagerTaskInfos.isEmpty()) {
                            aggregateLoadManagerTaskInfos.add(aggregateLoadManagerTaskInfo);
                            continue;
                        }
                        aggregateLoadManagerTaskInfos.set(0, aggregateLoadManagerTaskInfo);
                        continue;
                    }
                    StaxUtil.moveToEndElement(reader, 0);
                }
            }
        }
        catch (XMLStreamException ex) {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Parsing the workload log file %s for the cube %s terminated with the exception: %s", this.logFile.getAbsolutePath(), this.cubeName, ex));
        }
        return aggregateLoadManagerTaskInfos;
    }

    private AggregateLoadManagerTaskInfo parseAggregateLoadManagerTaskInfo(XMLStreamReader reader) {
        String elementName = reader.getLocalName();
        try {
            AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo = new AggregateLoadManagerTaskInfo();
            ChildElementIterator aggregateLoadManagerTaskInfoChildElementIterator = new ChildElementIterator(reader);
            while (aggregateLoadManagerTaskInfoChildElementIterator.next()) {
                this.parseAggregateLoadManagerTaskInfoChild(reader, aggregateLoadManagerTaskInfo);
            }
            return aggregateLoadManagerTaskInfo;
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private void parseAggregateLoadManagerTaskInfoChild(XMLStreamReader reader, AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo) {
        String elementName = reader.getLocalName();
        try {
            if ("loadStartTime".equals(elementName)) {
                long loadStartTime = this.parseDateTime(reader);
                aggregateLoadManagerTaskInfo.setLoadStartTime(loadStartTime);
            } else if ("loadEndTime".equals(elementName)) {
                long loadEndTime = this.parseDateTime(reader);
                aggregateLoadManagerTaskInfo.setLoadEndTime(loadEndTime);
            } else if ("aggregateXML".equals(elementName)) {
                String escapedAggregateXML = reader.getElementText();
                String aggregateXML = StringEscapeUtils.unescapeXml((String)escapedAggregateXML);
                aggregateLoadManagerTaskInfo.setAggregateXML(aggregateXML);
            } else if ("aggregateLoadTaskInfos".equals(elementName)) {
                this.parseAggregateLoadTaskInfos(reader, aggregateLoadManagerTaskInfo);
            } else {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private void parseAggregateLoadTaskInfos(XMLStreamReader reader, AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo) {
        String elementName = reader.getLocalName();
        try {
            ChildElementIterator aggregateLoadTaskInfoElementIterator = new ChildElementIterator(reader);
            while (aggregateLoadTaskInfoElementIterator.next()) {
                String childElementName = reader.getLocalName();
                if ("aggregateLoadTaskInfo".equals(childElementName)) {
                    AggregateLoadTaskInfo aggregateLoadTaskInfo = this.parseAggregateLoadTaskInfo(reader);
                    aggregateLoadManagerTaskInfo.addAggregateLoadTaskInfo(aggregateLoadTaskInfo);
                    continue;
                }
                this.throwXQERuntimeExceptionThatElementWasUnexpected(childElementName);
            }
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private AggregateLoadTaskInfo parseAggregateLoadTaskInfo(XMLStreamReader reader) {
        String elementName = reader.getLocalName();
        try {
            AggregateLoadTaskInfo aggregateLoadTaskInfo = new AggregateLoadTaskInfo();
            ChildElementIterator aggregateLoadTaskInfoChildElementIterator = new ChildElementIterator(reader);
            while (aggregateLoadTaskInfoChildElementIterator.next()) {
                this.parseAggregateLoadTaskInfoChild(reader, aggregateLoadTaskInfo);
            }
            return aggregateLoadTaskInfo;
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private void parseAggregateLoadTaskInfoChild(XMLStreamReader reader, AggregateLoadTaskInfo aggregateLoadTaskInfo) {
        String elementName = reader.getLocalName();
        try {
            if ("aggregateName".equals(elementName)) {
                String aggregateName = reader.getElementText();
                aggregateLoadTaskInfo.setAggregateName(aggregateName);
            } else if ("aggregateSizeInBytes".equals(elementName)) {
                long aggregateSizeInBytes = this.parseLong(reader);
                aggregateLoadTaskInfo.setAggregateSizeInBytes(aggregateSizeInBytes);
            } else if ("aggregateSizeInCells".equals(elementName)) {
                long aggregateSizeInCells = this.parseLong(reader);
                aggregateLoadTaskInfo.setAggregateSizeInCells(aggregateSizeInCells);
            } else if ("aggregateLoadTime".equals(elementName)) {
                long aggregateLoadTime = this.parseLong(reader);
                aggregateLoadTaskInfo.setAggregateLoadTime(aggregateLoadTime);
            } else if ("aggregateLoadExceptionInfo".equals(elementName)) {
                AggregateLoadExceptionInfo aggregateLoadExceptionInfo = this.parseAggregateLoadExceptionInfo(reader);
                aggregateLoadTaskInfo.setAggregateLoadExceptionInfo(aggregateLoadExceptionInfo);
            } else {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private AggregateLoadExceptionInfo parseAggregateLoadExceptionInfo(XMLStreamReader reader) {
        String elementName = reader.getLocalName();
        try {
            AggregateLoadExceptionInfo aggregateLoadExceptionInfo = new AggregateLoadExceptionInfo();
            ChildElementIterator aggregateLoadExceptionInfoChildElementIterator = new ChildElementIterator(reader);
            while (aggregateLoadExceptionInfoChildElementIterator.next()) {
                this.parseAggregateLoadExceptionInfoChild(reader, aggregateLoadExceptionInfo);
            }
            return aggregateLoadExceptionInfo;
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private void parseAggregateLoadExceptionInfoChild(XMLStreamReader reader, AggregateLoadExceptionInfo aggregateLoadExceptionInfo) {
        String elementName = reader.getLocalName();
        try {
            if ("exceptionClassName".equals(elementName)) {
                String exceptionClassName = reader.getElementText();
                aggregateLoadExceptionInfo.setExceptionClassName(exceptionClassName);
            } else if ("exceptionMessage".equals(elementName)) {
                String escapedExceptionMessage = reader.getElementText();
                String exceptionMessage = StringEscapeUtils.unescapeXml((String)escapedExceptionMessage);
                aggregateLoadExceptionInfo.setExceptionMessage(exceptionMessage);
            } else if ("exceptionCauseInfo".equals(elementName)) {
                AggregateLoadExceptionInfo exceptionCauseInfo = this.parseAggregateLoadExceptionInfo(reader);
                aggregateLoadExceptionInfo.setExceptionCauseInfo(exceptionCauseInfo);
            } else {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
        }
        catch (Exception ex) {
            throw this.createXQERuntimeExceptionThatExceptionWasUnexpected(elementName, ex);
        }
    }

    private long parseLong(XMLStreamReader reader) throws XMLStreamException {
        String valueString = reader.getElementText();
        long valueLong = Long.parseLong(valueString);
        return valueLong;
    }

    private long parseDateTime(XMLStreamReader reader) throws XMLStreamException, ParseException {
        String valueString = reader.getElementText();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        long valueLong = dateFormat.parse(valueString).getTime();
        return valueLong;
    }

    private XQERuntimeException createXQERuntimeExceptionThatExceptionWasUnexpected(String elementName, Exception ex) {
        if (ex instanceof XQERuntimeException) {
            return (XQERuntimeException)ex;
        }
        return new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogParserEncounteredUnexpectedException, (Throwable)ex, elementName);
    }

    private void throwXQERuntimeExceptionThatElementWasUnexpected(String elementName) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogParserFoundUnexpectedElement, elementName);
    }
}

