/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class QuerySummaryInfo {
    private static final Comparator<QuerySummaryInfo> ASC_TIME_COMPARATOR = new Comparator<QuerySummaryInfo>(){

        @Override
        public int compare(QuerySummaryInfo qsi1, QuerySummaryInfo qsi2) {
            if (qsi1.lastUsedTime > qsi2.lastUsedTime) {
                return 1;
            }
            if (qsi1.lastUsedTime < qsi2.lastUsedTime) {
                return -1;
            }
            return 0;
        }
    };
    private List<String> levelNames;
    private HashMapObjectInt<String> measureNameToMeasureHitCount = new HashMapObjectInt(0);
    private int executionCount;
    private double weightedExecutionCount;
    private long executionTime;
    private long lastUsedTime = 0L;

    public static Comparator<QuerySummaryInfo> getAscendingTimeComparator() {
        return ASC_TIME_COMPARATOR;
    }

    public QuerySummaryInfo(List<String> theLevelNames) {
        this.levelNames = theLevelNames;
    }

    public List<String> getLevelNames() {
        return this.levelNames;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public void incrementExecutionCount() {
        ++this.executionCount;
        this.weightedExecutionCount += 1.0;
    }

    public void setExecutionCount(int theExecutionCount) {
        this.executionCount = theExecutionCount;
    }

    public double getWeightedExecutionCount() {
        return this.weightedExecutionCount;
    }

    public void setWeightedExecutionCount(double theWeightedExecutionCount) {
        this.weightedExecutionCount = theWeightedExecutionCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void incrementExecutionTime(long delta) {
        this.executionTime += delta;
    }

    public List<String> getMeasureNames() {
        return new ArrayList<String>(this.measureNameToMeasureHitCount.keySet());
    }

    public int getMeasureHitCount(String measureName) {
        return this.measureNameToMeasureHitCount.get(measureName);
    }

    public void incrementMeasureHitCount(String measureName) {
        int measureHitCount = this.measureNameToMeasureHitCount.get(measureName);
        this.measureNameToMeasureHitCount.put(measureName, ++measureHitCount);
    }

    public void setMeasureHitCount(String measureName, int measureHitCount) {
        this.measureNameToMeasureHitCount.put(measureName, measureHitCount);
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(long theLastUsedTime) {
        this.lastUsedTime = theLastUsedTime;
    }
}

