/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class QuerySummaryReader {
    private XMLStreamReader reader;
    private ROLAPMetaCube metaCube = null;
    private boolean levelsValid;
    private String weightedExecutionCountsUpdateDate;
    private int dateParseErrors = 0;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static QuerySummaryInfoLog generateQuerySummaryFromXML(String xml, ROLAPMetaCube aMetaCube) throws Exception {
        XMLStreamReader reader = StaxUtil.createXMLStreamReader(xml);
        QuerySummaryReader querySummaryReader = new QuerySummaryReader(reader, aMetaCube);
        QuerySummaryInfoLog infoLog = querySummaryReader.parseQuerySummary();
        if (querySummaryReader.getDateParseErrors() > 0) {
            ROLAPLog.logWarn("ROLAPCubes.AutomaticAggregateOptimization", querySummaryReader.getDateParseErrors() + " date parse errors encountered when reading query summary info.  The earliest date will be used.");
        }
        return infoLog;
    }

    public QuerySummaryReader(XMLStreamReader aReader, ROLAPMetaCube aMetaCube) {
        this.reader = aReader;
        this.metaCube = aMetaCube;
    }

    public QuerySummaryInfoLog parseQuerySummary() {
        ArrayList<QuerySummaryInfo> querySummary = new ArrayList<QuerySummaryInfo>();
        try {
            this.reader.next();
            this.parseQuerySummaryInfoLog();
            ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
            while (childElementIterator.next()) {
                String elementName = this.reader.getLocalName();
                if ("querySummaryInfo".equals(elementName)) {
                    this.levelsValid = true;
                    QuerySummaryInfo querySummaryInfo = this.parseQuerySummaryInfo();
                    if (!this.levelsValid || querySummaryInfo.getMeasureNames().isEmpty()) continue;
                    querySummary.add(querySummaryInfo);
                    continue;
                }
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogFileCouldNotBeParsed, (Throwable)ex, (Object)"<no file>", (Object)this.metaCube.getName());
        }
        QuerySummaryInfoLog querySummaryInfoLog = new QuerySummaryInfoLog(querySummary);
        querySummaryInfoLog.setWeightedExecutionCountsUpdateDate(this.weightedExecutionCountsUpdateDate);
        return querySummaryInfoLog;
    }

    private void parseQuerySummaryInfoLog() {
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if (!"weightedExecutionCountsUpdateDate".equals(attributeName)) continue;
            this.weightedExecutionCountsUpdateDate = attributeValue;
        }
    }

    private QuerySummaryInfo parseQuerySummaryInfo() throws XMLStreamException {
        QuerySummaryInfo querySummaryInfo = null;
        int executionCount = 0;
        double weightedExecutionCount = 0.0;
        long executionTime = 0L;
        long lastUsedTime = 0L;
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("executionCount".equals(attributeName)) {
                executionCount = Integer.valueOf(attributeValue);
                continue;
            }
            if ("weightedExecutionCount".equals(attributeName)) {
                weightedExecutionCount = Double.valueOf(attributeValue);
                continue;
            }
            if ("executionTime".equals(attributeName)) {
                executionTime = Long.valueOf(attributeValue);
                continue;
            }
            if ("lastUsed".equals(attributeName)) {
                lastUsedTime = this.parseLastUsedTime(attributeValue);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(attributeName);
        }
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("levels".equals(elementName)) {
                List<String> levelNames = this.parseLevels();
                querySummaryInfo = new QuerySummaryInfo(levelNames);
                continue;
            }
            if ("measures".equals(elementName)) {
                this.parseMeasures(querySummaryInfo);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
        querySummaryInfo.setExecutionCount(executionCount);
        querySummaryInfo.setWeightedExecutionCount(weightedExecutionCount);
        querySummaryInfo.incrementExecutionTime(executionTime);
        querySummaryInfo.setLastUsedTime(lastUsedTime);
        return querySummaryInfo;
    }

    private long parseLastUsedTime(String attributeValue) {
        long time = 0L;
        try {
            Date d = this.dateFormat.parse(attributeValue);
            time = d.getTime();
        }
        catch (ParseException e) {
            ++this.dateParseErrors;
        }
        return time;
    }

    private int getDateParseErrors() {
        return this.dateParseErrors;
    }

    private List<String> parseLevels() throws XMLStreamException {
        Aggregate aggregate = new Aggregate(this.metaCube);
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("level".equals(elementName)) {
                this.parseLevel(aggregate);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
        ArrayList<String> levelNames = new ArrayList<String>();
        for (ROLAPMetaLevel level : aggregate.getLevels()) {
            if (level != null) {
                levelNames.add(level.getName());
                continue;
            }
            levelNames.add(null);
        }
        return levelNames;
    }

    private void parseLevel(Aggregate aggregate) throws XMLStreamException {
        String dimensionName = "";
        String hierarchyName = "";
        String levelName = "";
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("dimension".equals(attributeName)) {
                dimensionName = attributeValue;
                continue;
            }
            if ("hierarchy".equals(attributeName)) {
                hierarchyName = attributeValue;
                continue;
            }
            if ("name".equals(attributeName)) {
                levelName = attributeValue;
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(attributeName);
        }
        try {
            aggregate.setLevel(dimensionName, hierarchyName, levelName);
        }
        catch (Exception ex) {
            this.levelsValid = false;
        }
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        childElementIterator.skipToEnd();
    }

    private void parseMeasures(QuerySummaryInfo querySummaryInfo) throws XMLStreamException {
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        while (childElementIterator.next()) {
            String elementName = this.reader.getLocalName();
            if ("measure".equals(elementName)) {
                this.parseMeasure(querySummaryInfo);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
    }

    private void parseMeasure(QuerySummaryInfo querySummaryInfo) throws XMLStreamException {
        String measureName = "";
        int hitCount = 0;
        for (int index = 0; index < this.reader.getAttributeCount(); ++index) {
            String attributeName = this.reader.getAttributeLocalName(index);
            String attributeValue = this.reader.getAttributeValue(index);
            if ("name".equals(attributeName)) {
                measureName = attributeValue;
                continue;
            }
            if ("hitCount".equals(attributeName)) {
                hitCount = Integer.valueOf(attributeValue);
                continue;
            }
            this.throwXQERuntimeExceptionThatElementWasUnexpected(attributeName);
        }
        if (AdvisorUtils.getMetaMeasure(this.metaCube, measureName) != null) {
            querySummaryInfo.setMeasureHitCount(measureName, hitCount);
        }
        ChildElementIterator childElementIterator = new ChildElementIterator(this.reader);
        childElementIterator.skipToEnd();
    }

    private void throwXQERuntimeExceptionThatElementWasUnexpected(String elementName) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.ROL_WorkloadLogParserFoundUnexpectedElement, elementName);
    }
}

