/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;

public class QuerySummaryWriter {
    private ROLAPMetaCube metaCube = null;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static String generateXML(QuerySummaryInfoLog querySummaryInfoLog, ROLAPMetaCube metaCube) {
        QuerySummaryWriter querySummaryWriter = new QuerySummaryWriter(metaCube);
        return querySummaryWriter.generateXML(querySummaryInfoLog);
    }

    public QuerySummaryWriter(ROLAPMetaCube aMetaCube) {
        this.metaCube = aMetaCube;
    }

    private String generateXML(QuerySummaryInfoLog querySummaryInfoLog) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(stringWriter);
        xmlWriter.setIndentString("  ");
        xmlWriter.writeHeader("1.0", "UTF-8");
        xmlWriter.beginElement("querySummaryInfoLog", -1);
        xmlWriter.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.attribute("xsi:noNamespaceSchemaLocation", "QuerySummaryInfoLog.xsd");
        xmlWriter.attribute("weightedExecutionCountsUpdateDate", querySummaryInfoLog.getWeightedExecutionCountsUpdateDate());
        this.writeQuerySummaryInfoLogElement(xmlWriter, querySummaryInfoLog.getQuerySummaryInfos());
        xmlWriter.endElement();
        return stringWriter.toString();
    }

    private void writeQuerySummaryInfoLogElement(XMLWriter xmlWriter, List<QuerySummaryInfo> querySummaryInfos) {
        for (QuerySummaryInfo querySummaryInfo : querySummaryInfos) {
            this.writeQuerySummaryInfoElement(xmlWriter, querySummaryInfo);
        }
    }

    private void writeQuerySummaryInfoElement(XMLWriter xmlWriter, QuerySummaryInfo querySummaryInfo) {
        xmlWriter.beginElement("querySummaryInfo", -1);
        long executionCount = querySummaryInfo.getExecutionCount();
        xmlWriter.attribute("executionCount", executionCount);
        double weightedExecutionCount = querySummaryInfo.getWeightedExecutionCount();
        xmlWriter.attribute("weightedExecutionCount", weightedExecutionCount);
        long executionTime = querySummaryInfo.getExecutionTime();
        xmlWriter.attribute("executionTime", executionTime);
        long lastUsedTime = querySummaryInfo.getLastUsedTime();
        Date d = new Date(lastUsedTime);
        xmlWriter.attribute("lastUsed", this.dateFormat.format(d));
        xmlWriter.beginElement("levels", -1);
        int hierarchyIndex = -1;
        List<String> levelNames = querySummaryInfo.getLevelNames();
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName;
                if ((levelName = levelNames.get(++hierarchyIndex)) == null) continue;
                xmlWriter.beginElement("level", -1);
                xmlWriter.attribute("name", levelName);
                xmlWriter.attribute("hierarchy", hierarchy.getName());
                xmlWriter.attribute("dimension", dimension.getName());
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
        xmlWriter.beginElement("measures", -1);
        for (String measureName : querySummaryInfo.getMeasureNames()) {
            xmlWriter.beginElement("measure", -1);
            xmlWriter.attribute("name", measureName);
            long measureHitCount = querySummaryInfo.getMeasureHitCount(measureName);
            xmlWriter.attribute("hitCount", measureHitCount);
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }
}

