/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkloadAggregateCacheCollection {
    private Map<String, AggregateCacheHitData> mCountedAggregatesCacheHitsMap = new HashMap<String, AggregateCacheHitData>();

    public void recordHit(String aggregateName, long executionTime) {
        if (this.mCountedAggregatesCacheHitsMap.containsKey(aggregateName)) {
            this.mCountedAggregatesCacheHitsMap.get(aggregateName).incrementHitCount();
            this.mCountedAggregatesCacheHitsMap.get(aggregateName).incrementExecutionTime(executionTime);
        } else {
            this.mCountedAggregatesCacheHitsMap.put(aggregateName, new AggregateCacheHitData(aggregateName, executionTime));
        }
    }

    public HashMap<String, AggregateCacheHitData> getCollection() {
        HashMap<String, AggregateCacheHitData> copyToReturn = new HashMap<String, AggregateCacheHitData>();
        Iterator<Map.Entry<String, AggregateCacheHitData>> iterator = this.mCountedAggregatesCacheHitsMap.entrySet().iterator();
        Map.Entry<String, AggregateCacheHitData> anEntry = null;
        String key = null;
        AggregateCacheHitData clonedValue = null;
        while (iterator.hasNext()) {
            anEntry = iterator.next();
            key = anEntry.getKey();
            clonedValue = new AggregateCacheHitData(anEntry.getValue());
            copyToReturn.put(key, clonedValue);
        }
        this.mCountedAggregatesCacheHitsMap.clear();
        return copyToReturn;
    }

    public int getCollectionSizeForTracing() {
        return this.mCountedAggregatesCacheHitsMap.size();
    }

    public class AggregateCacheHitData {
        private String mAggregateName = null;
        private int mNumberOfHits = 0;
        private long mQueryExecutionTime = 0L;

        public AggregateCacheHitData(String aggregateNameIn, long queryExecutionTime) {
            this.mNumberOfHits = 1;
            this.mAggregateName = aggregateNameIn;
            this.mQueryExecutionTime = queryExecutionTime;
        }

        public AggregateCacheHitData(AggregateCacheHitData countedData) {
            this.mAggregateName = countedData.mAggregateName;
            this.mQueryExecutionTime = countedData.mQueryExecutionTime;
            this.mNumberOfHits = countedData.mNumberOfHits;
        }

        public void incrementHitCount() {
            ++this.mNumberOfHits;
        }

        public int getHitCount() {
            return this.mNumberOfHits;
        }

        public void incrementExecutionTime(long queryExecutionTime) {
            this.mQueryExecutionTime += queryExecutionTime;
        }

        public long getExecutionTime() {
            return this.mQueryExecutionTime;
        }

        public String getAggregateName() {
            return this.mAggregateName;
        }
    }
}

