/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.LogConstants;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogAggregateWorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogElementParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLoggerTypes;
import com.cognos.xqe.trace.XQELogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.xml.stream.XMLStreamException;

public class WorkloadLogReportParser
extends WorkloadLogElementParser {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat(LogConstants.REPORT_DATE_TIME_FORMAT_STRING);
    private static final String REQUEST_ID_STRING = "requestID";
    private static final String SUB_REQUEST_ID_STRING = "subRequestID";
    private static final String PACKAGE_STRING = "package";
    private static final String SERVER_GROUP_STRING = "serverGroup";
    private static final String DISPATCHER_STRING = "dispatcher";
    private static final String USER_STRING = "user";
    private static final String REPORT_NAME_STRING = "reportName";
    private static final String DATE_TIME_STRING = "dateTime";
    private static final String AGGREGATE_WORKLOAD_STRING = "aggregateWorkload";
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");

    @Override
    protected void initialize() {
        this.registerType(PACKAGE_STRING, WorkloadLoggerTypes.ElementEnum.reportElementPackageName);
        this.registerType(SERVER_GROUP_STRING, WorkloadLoggerTypes.ElementEnum.reportElementServerGroup);
        this.registerType(DISPATCHER_STRING, WorkloadLoggerTypes.ElementEnum.reportElementDispatcher);
        this.registerType(USER_STRING, WorkloadLoggerTypes.ElementEnum.reportElementUserName);
        this.registerType(REPORT_NAME_STRING, WorkloadLoggerTypes.ElementEnum.reportElementReportName);
        this.registerType(REQUEST_ID_STRING, WorkloadLoggerTypes.ElementEnum.reportElementRequestID);
        this.registerType(SUB_REQUEST_ID_STRING, WorkloadLoggerTypes.ElementEnum.reportElementSubRequestID);
        this.registerType(DATE_TIME_STRING, WorkloadLoggerTypes.ElementEnum.reportElementDateTime);
        this.registerType("executionTime", WorkloadLoggerTypes.ElementEnum.reportElementReportExecutionTime);
        this.registerType(AGGREGATE_WORKLOAD_STRING, WorkloadLoggerTypes.ElementEnum.reportElementAggregateWorkload);
        this.registerType("report", WorkloadLoggerTypes.ElementEnum.reportElementReport);
    }

    @Override
    public boolean parse(WorkloadParser workloadParser, boolean start, WorkloadParser.ParseData parseData) {
        boolean moreDataAvailable = true;
        if (start) {
            parseData.createNewReportTraceTraceData();
            WorkloadParser.WorkloadReportTraceData reportData = parseData.getReportWorkloadData();
            String elementName = null;
            WorkloadLoggerTypes.ElementEnum type = WorkloadLoggerTypes.ElementEnum.unknownElement;
            try {
                block16: while (moreDataAvailable && this.locateNextStartOrEndElement()) {
                    elementName = this.getElementName();
                    type = this.getType(elementName);
                    if (this.isStartElement()) {
                        switch (type) {
                            case reportElementRequestID: {
                                reportData.setRequestID(this.getElementValue());
                                continue block16;
                            }
                            case reportElementSubRequestID: {
                                reportData.setSubRequestID(this.getElementValue());
                                continue block16;
                            }
                            case reportElementPackageName: {
                                reportData.setPackageName(this.getElementValue());
                                continue block16;
                            }
                            case reportElementServerGroup: {
                                reportData.setServerGroup(this.getElementValue());
                                continue block16;
                            }
                            case reportElementDispatcher: {
                                reportData.setDispatcher(this.getElementValue());
                                continue block16;
                            }
                            case reportElementUserName: {
                                reportData.setUserName(this.getElementValue());
                                continue block16;
                            }
                            case reportElementReportName: {
                                reportData.setReportName(this.getElementValue());
                                continue block16;
                            }
                            case reportElementDateTime: {
                                try {
                                    reportData.setDateTime(this.dateFormat.parse(this.getElementValue()));
                                    continue block16;
                                }
                                catch (ParseException ex) {
                                    throw new XQERuntimeException(XQEMessageKeys.ROL_ErrorParsingDateInReportInWorkloadLogFile, (Throwable)ex, workloadParser.getWorkloadLogPath());
                                }
                            }
                            case reportElementReportExecutionTime: {
                                reportData.setReportExecutionTime(new Long(this.getElementValue()));
                                continue block16;
                            }
                            case reportElementAggregateWorkload: {
                                WorkloadLogAggregateWorkloadParser aggregateParser = new WorkloadLogAggregateWorkloadParser();
                                aggregateParser.setReader(this.mReader);
                                moreDataAvailable = aggregateParser.parse(workloadParser, start, parseData);
                                continue block16;
                            }
                        }
                        continue;
                    }
                    if (type != WorkloadLoggerTypes.ElementEnum.reportElementReport) continue;
                    workloadParser.addWorkloadTraceData(parseData.getReportWorkloadData());
                    break;
                }
            }
            catch (XMLStreamException ex) {
                INFO_LOGGER.log(String.format("WorkloadLogReportParser encountered invalid report element while parsing %s", workloadParser.getWorkloadLogFileNameForTrace()));
                throw new XQERuntimeException(XQEMessageKeys.ROL_ErrorParsingWorkloadLogFile, (Throwable)ex, (Object)elementName, (Object)workloadParser.getWorkloadLogPath());
            }
        }
        return moreDataAvailable && this.isMoreDataAvailable();
    }
}

