/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelReason;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AdvisorCancelHandler {
    private static final long WAIT_TIME = 1000L;
    private AtomicReference<Thread> advisorThread = new AtomicReference();
    private AtomicBoolean advisorThreadCanceled = new AtomicBoolean(false);
    private AdvisorCancelReason advisorCancelReason;
    private ConcurrentHashMap<String, ExecutionEnvironment> advisorQueryExecutionEnvironments = new ConcurrentHashMap();

    public boolean isAdvisorThreadCanceled() {
        return this.advisorThreadCanceled.get();
    }

    public AdvisorCancelReason getAdvisorCancelReason() {
        return this.advisorCancelReason;
    }

    private void setAdvisorCancelReason(AdvisorCancelReason theAdvisorCancelReason) {
        this.advisorCancelReason = theAdvisorCancelReason;
    }

    public synchronized boolean registerAdvisorThread() {
        this.throwExceptionIfAdvisorThreadIsCanceled();
        return this.advisorThread.compareAndSet(null, Thread.currentThread());
    }

    public void unregisterAdvisorThread(boolean registered) {
        if (registered) {
            this.advisorThread.compareAndSet(Thread.currentThread(), null);
            ROLAPCubeManager.adminNotify(this.advisorThread);
        }
    }

    public synchronized void registerAdvisorQuery(String queryName, ExecutionEnvironment executionEnvironment) {
        this.throwExceptionIfAdvisorThreadIsCanceled();
        this.advisorQueryExecutionEnvironments.put(queryName, executionEnvironment);
    }

    public void unregisterAdvisorQuery(String queryName) {
        this.advisorQueryExecutionEnvironments.remove(queryName);
    }

    public void cancelAdvisor(AdvisorCancelReason cancelReason) {
        if (this.isAdvisorThreadCanceled()) {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The advisor was already canceled with the reason = %s.", new Object[]{this.advisorCancelReason}));
            return;
        }
        this.setAdvisorCancelReason(cancelReason);
        this.cancelAdvisorThread();
        this.cancelAdvisorQueries();
        this.interruptAdvisorThread();
        this.waitUntilAdvisorThreadExits();
    }

    private synchronized void cancelAdvisorThread() {
        this.advisorThreadCanceled.set(true);
        ROLAPLog.log("ROLAPAggregateAdvisor", "The advisor thread was canceled.");
    }

    private void cancelAdvisorQueries() {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Cancel advisor queries began.");
        Set queryNames = this.advisorQueryExecutionEnvironments.keySet();
        for (String queryName : queryNames) {
            ExecutionEnvironment executionEnvironment = this.advisorQueryExecutionEnvironments.get(queryName);
            if (executionEnvironment == null) continue;
            try {
                executionEnvironment.getCancelManager().cancel();
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The advisor query %s was canceled.", queryName));
            }
            catch (Exception ex) {
                ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("The advisor query %s was not canceled.", queryName), ex);
            }
        }
        ROLAPLog.log("ROLAPAggregateAdvisor", "Cancel advisor queries ended.");
    }

    private void interruptAdvisorThread() {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Interrupt advisor thread began.");
        Thread thread = this.advisorThread.get();
        if (thread != null) {
            try {
                thread.interrupt();
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Thread %d was interrupted.", thread.getId()));
            }
            catch (Exception ex) {
                ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("Thread %d was not interrupted.", thread.getId()), ex);
            }
        }
        ROLAPLog.log("ROLAPAggregateAdvisor", "Interrupt advisor thread ended.");
    }

    private void waitUntilAdvisorThreadExits() {
        long maxWaitTime = 1000L;
        Thread thread = this.advisorThread.get();
        while (thread != null) {
            if (maxWaitTime > 0L) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Waiting for thread %d to exit.", thread.getId()));
                maxWaitTime = ROLAPCubeManager.adminWait(maxWaitTime, this.advisorThread);
                thread = this.advisorThread.get();
                continue;
            }
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Thread %d failed to exit within the timeout period of %,d ms.  It may fail with unexpected errors.", thread.getId(), 1000L));
            break;
        }
    }

    private void throwExceptionIfAdvisorThreadIsCanceled() {
        if (this.isAdvisorThreadCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

