/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.AggregateElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.AllLevelElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.DimensionRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.HierarchyRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.LevelElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.LevelRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.MeasureRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.RootLevelElement;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AggregateXMLParser {
    private String aggregateXML;

    public AggregateXMLParser(String theAggregateXML) {
        this.aggregateXML = theAggregateXML;
    }

    private XMLStreamReader createReader() throws XMLStreamException {
        XMLStreamReader reader = StaxUtil.createXMLStreamReader(this.aggregateXML);
        if (StaxUtil.moveToElement(reader)) {
            String elementName = reader.getLocalName();
            if (!"advisorMemoryAggregates".equals(elementName)) {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
            return reader;
        }
        return null;
    }

    public List<AggregateElement> parseAggregateElements() {
        try {
            ArrayList<AggregateElement> aggregateElements = new ArrayList<AggregateElement>();
            ROLAPLog.log("ROLAPAggregateAdvisor", "Parsing the aggregate XML began.");
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate XML is: %s", this.aggregateXML));
            XMLStreamReader reader = this.createReader();
            if (reader != null) {
                ChildElementIterator rootChildElementIterator = new ChildElementIterator(reader);
                while (rootChildElementIterator.next()) {
                    String elementName = reader.getLocalName();
                    if ("aggregate".equals(elementName)) {
                        AggregateElement aggregateElement = this.parseAggregateElement(reader);
                        aggregateElements.add(aggregateElement);
                        continue;
                    }
                    this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
                }
            }
            ROLAPLog.log("ROLAPAggregateAdvisor", "Parsing the aggregate XML ended.");
            return aggregateElements;
        }
        catch (Exception ex) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", "Parsing the aggregate XML failed.", ex);
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLCouldNotBeParsed, (Throwable)ex, this.aggregateXML);
        }
    }

    private AggregateElement parseAggregateElement(XMLStreamReader reader) throws XMLStreamException {
        AggregateElement aggregateElement = new AggregateElement();
        String aggregateName = AggregateXMLParser.getName(reader);
        aggregateElement.setName(aggregateName);
        this.parseAggregateChildElements(reader, aggregateElement);
        return aggregateElement;
    }

    private void parseAggregateChildElements(XMLStreamReader reader, AggregateElement aggregateElement) throws XMLStreamException {
        ChildElementIterator aggregateChildElementIterator = new ChildElementIterator(reader);
        while (aggregateChildElementIterator.next()) {
            this.parseAggregateChildElement(reader, aggregateElement);
        }
        if (aggregateElement.getDimensionRefElements().isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLContainsNoDimensions, aggregateElement.getName());
        }
        if (aggregateElement.getMeasureRefElements().isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLContainsNoMeasures, aggregateElement.getName());
        }
    }

    private void parseAggregateChildElement(XMLStreamReader reader, AggregateElement aggregateElement) throws XMLStreamException {
        String elementName = reader.getLocalName();
        if ("dimensionRef".equals(elementName)) {
            this.parseDimensionRefElement(reader, aggregateElement);
        } else if ("measureRef".equals(elementName)) {
            this.parseMeasureRefElement(reader, aggregateElement);
        } else {
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
    }

    private void parseDimensionRefElement(XMLStreamReader reader, AggregateElement aggregateElement) throws XMLStreamException {
        DimensionRefElement dimensionRefElement = new DimensionRefElement();
        String dimensionName = AggregateXMLParser.getName(reader);
        dimensionRefElement.setName(dimensionName);
        String dimensionCategory = AggregateXMLParser.getCategory(reader);
        dimensionRefElement.setCategory(dimensionCategory);
        dimensionRefElement.setAggregateElement(aggregateElement);
        this.parseHierarchyRefElements(reader, dimensionRefElement);
        aggregateElement.addDimensionRefElement(dimensionRefElement);
    }

    private void parseHierarchyRefElements(XMLStreamReader reader, DimensionRefElement dimensionRefElement) throws XMLStreamException {
        ChildElementIterator dimensionRefChildElementIterator = new ChildElementIterator(reader);
        while (dimensionRefChildElementIterator.next()) {
            this.parseHierarchyRefElement(reader, dimensionRefElement);
            StaxUtil.moveToEndElement(reader);
        }
        if (dimensionRefElement.getHierarchyRefElements().isEmpty()) {
            String aggregateName = dimensionRefElement.getAggregateElement().getName();
            String dimensionName = dimensionRefElement.getName();
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLContainsNoHierarchies, aggregateName, dimensionName);
        }
    }

    private void parseHierarchyRefElement(XMLStreamReader reader, DimensionRefElement dimensionRefElement) throws XMLStreamException {
        String elementName = reader.getLocalName();
        if ("hierarchyRef".equals(elementName)) {
            HierarchyRefElement hierarchyRefElement = new HierarchyRefElement();
            String hierarchyName = AggregateXMLParser.getName(reader);
            hierarchyRefElement.setName(hierarchyName);
            hierarchyRefElement.setDimensionRefElement(dimensionRefElement);
            this.parseLevelElement(reader, hierarchyRefElement);
            dimensionRefElement.addHierarchyRefElement(hierarchyRefElement);
        } else {
            this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
        }
    }

    private void parseLevelElement(XMLStreamReader reader, HierarchyRefElement hierarchyRefElement) throws XMLStreamException {
        ChildElementIterator hierarchyRefChildElementIterator = new ChildElementIterator(reader);
        if (hierarchyRefChildElementIterator.next()) {
            String elementName = reader.getLocalName();
            LevelElement levelElement = null;
            if ("allLevel".equals(elementName)) {
                levelElement = new AllLevelElement();
            } else if ("rootLevel".equals(elementName)) {
                levelElement = new RootLevelElement();
            } else if ("levelRef".equals(elementName)) {
                LevelRefElement levelRefElement = new LevelRefElement();
                String levelName = AggregateXMLParser.getName(reader);
                levelRefElement.setName(levelName);
                levelElement = levelRefElement;
            } else {
                this.throwXQERuntimeExceptionThatElementWasUnexpected(elementName);
            }
            levelElement.setHierarchyRefElement(hierarchyRefElement);
            hierarchyRefElement.setLevelElement(levelElement);
            StaxUtil.moveToEndElement(reader);
        }
        if (hierarchyRefElement.getLevelElement() == null) {
            DimensionRefElement dimensionRefElement = hierarchyRefElement.getDimensionRefElement();
            AggregateElement aggregateElement = dimensionRefElement.getAggregateElement();
            String aggregateName = aggregateElement.getName();
            String dimensionName = dimensionRefElement.getName();
            String hierarchyName = hierarchyRefElement.getName();
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLContainsNoLevel, (Object)aggregateName, (Object)dimensionName, (Object)hierarchyName);
        }
    }

    private void parseMeasureRefElement(XMLStreamReader reader, AggregateElement aggregateElement) throws XMLStreamException {
        MeasureRefElement measureRefElement = new MeasureRefElement();
        String measureName = AggregateXMLParser.getName(reader);
        measureRefElement.setName(measureName);
        measureRefElement.setAggregateElement(aggregateElement);
        aggregateElement.addMeasureRefElement(measureRefElement);
        StaxUtil.moveToEndElement(reader);
    }

    private static String getName(XMLStreamReader reader) {
        return AggregateXMLParser.getAttributeValue(reader, "name");
    }

    private static String getCategory(XMLStreamReader reader) {
        return AggregateXMLParser.getAttributeValue(reader, "category");
    }

    private static String getAttributeValue(XMLStreamReader reader, String attributeName) {
        String attributeValue = reader.getAttributeValue(null, attributeName);
        if (attributeValue == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLIsMissingAttribute, reader.getLocalName(), attributeName);
        }
        return attributeValue;
    }

    private void throwXQERuntimeExceptionThatElementWasUnexpected(String elementName) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.ROL_AggregateXMLParserFoundUnexpectedElement, elementName);
    }
}

