/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import java.util.ArrayList;
import java.util.List;

public class ConsolidateAggregatesStrategy
extends AggregateRecommendationStrategy {
    private static final long SMALL_AGGREGATE_CARDINALITY = 10000L;
    private static final double AGGREGATE_CARDINALITY_SIMILAR_SIZE_RATIO = 1.5;
    private static final int AGGREGATE_LEVEL_DEPTH_DIFFERENCE_LIMIT = 0;
    private int numMergesConsidered = 0;
    private int numMergesDone = 0;

    public ConsolidateAggregatesStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> aggregates) {
        HighPrecisionStopWatch stopWatchTotalTime = new HighPrecisionStopWatch();
        stopWatchTotalTime.start();
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        this.numMergesConsidered = 0;
        this.numMergesDone = 0;
        stopWatch.start();
        int originalNumberOfAggregates = aggregates.size();
        INFO_LOGGER.log(String.format("Consolidate %d aggregates based on coverage", originalNumberOfAggregates));
        this.consolidateBasedOnCoverage(aggregates);
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        INFO_LOGGER.log(String.format("Consolidated based on coverage from %d to %d aggregates in %.3f seconds.", originalNumberOfAggregates, aggregates.size(), (double)elapsedTime / 1000.0));
        stopWatch.start();
        int preNearnessConsolidationNumberOfAggregates = aggregates.size();
        INFO_LOGGER.log(String.format("Consolidate %d aggregates based on nearness", preNearnessConsolidationNumberOfAggregates));
        this.consolidateBasedOnNearness(aggregates);
        elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        INFO_LOGGER.log(String.format("Consolidated based on nearness from %d to %d aggregates in %.3f seconds.", preNearnessConsolidationNumberOfAggregates, aggregates.size(), (double)elapsedTime / 1000.0));
        elapsedTime = stopWatchTotalTime.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("ConsolidateAggregatesStrategy", elapsedTime);
        String text = "Consolidated from %d to %d aggregates in %.3f seconds.  Merges: %d done and %d too large.";
        INFO_LOGGER.log(String.format(text, originalNumberOfAggregates, aggregates.size(), (double)elapsedTime / 1000.0, this.numMergesDone, this.numMergesConsidered - this.numMergesDone));
    }

    private void consolidateBasedOnNearness(List<Aggregate> aggregates) {
        ArrayList<Aggregate> mergeResultAggregates = new ArrayList<Aggregate>();
        Aggregate mergedNear = null;
        boolean addConsolidatedAggregate = true;
        for (Aggregate consolidatedAggregate : aggregates) {
            addConsolidatedAggregate = true;
            ArrayList mergeCopy = new ArrayList(mergeResultAggregates);
            for (Aggregate mergedAggregate : mergeCopy) {
                mergedNear = this.mergeIfNear(consolidatedAggregate, mergedAggregate);
                if (null == mergedNear) continue;
                mergeResultAggregates.remove(mergedAggregate);
                mergeResultAggregates.add(mergedNear);
                addConsolidatedAggregate = false;
            }
            if (!addConsolidatedAggregate) continue;
            mergeResultAggregates.add(consolidatedAggregate);
        }
        if (mergeResultAggregates.size() > 0) {
            aggregates.clear();
            aggregates.addAll(mergeResultAggregates);
        }
    }

    private void consolidateBasedOnCoverage(List<Aggregate> aggregates) {
        ArrayList<Aggregate> consolidatedAggregates = new ArrayList<Aggregate>();
        for (Aggregate currentAggregate : aggregates) {
            boolean includeAggregate;
            boolean bl = includeAggregate = currentAggregate.getRecommendedBy() == AggregateRecommendedByEnum.USER || !this.isCoveredByExistingInDatabaseAggregate(currentAggregate);
            if (includeAggregate) {
                for (Aggregate consolidatedAggregate : consolidatedAggregates) {
                    if (!this.shouldConsolidateBasedOnCoverage(consolidatedAggregate, currentAggregate)) continue;
                    if (consolidatedAggregate.getRecommendedBy() != currentAggregate.getRecommendedBy() && consolidatedAggregate.getRecommendedBy() != AggregateRecommendedByEnum.USER) {
                        consolidatedAggregate.setRecommendedBy(AggregateRecommendedByEnum.HYBRID);
                    }
                    includeAggregate = false;
                    break;
                }
            }
            if (!includeAggregate) continue;
            ArrayList<Aggregate> copyOfConsolidatedAggregates = new ArrayList<Aggregate>();
            copyOfConsolidatedAggregates.addAll(consolidatedAggregates);
            for (Aggregate consolidatedAggregate : copyOfConsolidatedAggregates) {
                if (!this.shouldConsolidateBasedOnCoverage(currentAggregate, consolidatedAggregate)) continue;
                currentAggregate.incrementWorkloadCounters(consolidatedAggregate);
                consolidatedAggregates.remove(consolidatedAggregate);
            }
            consolidatedAggregates.add(currentAggregate);
        }
        aggregates.clear();
        aggregates.addAll(consolidatedAggregates);
    }

    private boolean shouldConsolidateBasedOnCoverage(Aggregate aggregate1, Aggregate aggregate2) {
        boolean consolidate = false;
        if (aggregate2.getRecommendedBy() == AggregateRecommendedByEnum.USER) {
            consolidate = false;
        } else if (aggregate1.isCovered(aggregate2)) {
            consolidate = this.checkCardinality(aggregate1, aggregate2);
        }
        return consolidate;
    }

    private Aggregate mergeIfNear(Aggregate aggregate1, Aggregate aggregate2) {
        Aggregate mergedAggregate = null;
        if (aggregate1.getRecommendedBy() == AggregateRecommendedByEnum.USER || aggregate2.getRecommendedBy() == AggregateRecommendedByEnum.USER) {
            return null;
        }
        if (aggregate1.isNear(aggregate2)) {
            ++this.numMergesConsidered;
            Aggregate proposedMergedAggregate = new Aggregate(aggregate1, aggregate2);
            INFO_LOGGER.log(String.format("Consider merging aggregates [%s] and [%s] to [%s].", aggregate1.getName(), aggregate2.getName(), proposedMergedAggregate.getName()));
            this.getCardinality(proposedMergedAggregate);
            long aggregate1Cardinality = aggregate1.getCardinality();
            long aggregate2Cardinality = aggregate2.getCardinality();
            if (0L == aggregate1Cardinality) {
                this.getCardinality(aggregate1);
            }
            if (0L == aggregate2.getCardinality()) {
                this.getCardinality(aggregate2);
            }
            if (10000000000000000L != aggregate1Cardinality && 10000000000000000L != aggregate2Cardinality) {
                boolean doMerge = false;
                doMerge = aggregate1Cardinality < aggregate2Cardinality ? this.checkCardinality(proposedMergedAggregate, aggregate1) : this.checkCardinality(proposedMergedAggregate, aggregate2);
                if (doMerge) {
                    mergedAggregate = proposedMergedAggregate;
                }
            }
            if (mergedAggregate != null) {
                ++this.numMergesDone;
                INFO_LOGGER.log(String.format("Merged aggregates [%s] and [%s] to [%s].", aggregate1.getName(), aggregate2.getName(), proposedMergedAggregate.getName()));
            } else {
                INFO_LOGGER.log(String.format("Did not merge aggregates [%s] and [%s] to [%s].", aggregate1.getName(), aggregate2.getName(), proposedMergedAggregate.getName()));
            }
        }
        return mergedAggregate;
    }

    private void getCardinality(Aggregate aggregate) {
        try {
            long cardinality = this.aggregateAdvisor.getSliceCardinality(aggregate, "ConsolidateAggregatesStrategy");
            aggregate.setMaxCardinality(cardinality);
            aggregate.setCardinality(cardinality);
        }
        catch (OperationCanceledException canceled) {
            throw canceled;
        }
        catch (Exception ex) {
            aggregate.setCardinality(10000000000000000L);
            String fmt = "Get slice cardinality failed for aggregate %s.  Continue processing.  Exception: %s";
            INFO_LOGGER.log(String.format(fmt, aggregate.getName(), ex.getMessage()));
        }
    }

    private boolean checkCardinality(Aggregate lowerAggregate, Aggregate higherAggregate) {
        boolean consolidate = lowerAggregate.getCardinality() == 1000000000000000L ? false : (lowerAggregate.getCardinality() == 10000000000000000L ? false : (!this.aggregateAdvisor.isAggregateSmallRelativetoFact(lowerAggregate) ? false : (lowerAggregate.getCardinality() <= 10000L ? true : (double)lowerAggregate.getCardinality() <= 1.5 * (double)higherAggregate.getCardinality())));
        return consolidate;
    }

    private boolean isCoveredByExistingInDatabaseAggregate(Aggregate aggregate) {
        List<ExistingInDatabaseAggregate> existingInDatabaseAggregates = this.aggregateAdvisor.getExistingInDatabaseAggregates();
        if (!existingInDatabaseAggregates.isEmpty()) {
            int aggregateLevelDepth = aggregate.getLevelDepth();
            for (ExistingInDatabaseAggregate existingInDatabaseAggregate : existingInDatabaseAggregates) {
                int existingInDatabaseAggregateLevelDepth;
                int levelDepthDifference;
                if (!existingInDatabaseAggregate.covers(aggregate) || (levelDepthDifference = (existingInDatabaseAggregateLevelDepth = existingInDatabaseAggregate.getLevelDepth()) - aggregateLevelDepth) > 0) continue;
                return true;
            }
        }
        return false;
    }
}

