/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadSummary;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadInfoLogFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadAggregateCacheCollection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.AggregateElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.AggregateXMLParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.AllLevelElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.DimensionRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.HierarchyRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.LevelElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.LevelRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.MeasureRefElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.xml.RootLevelElement;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LastAggregateLoadStrategy
extends AggregateRecommendationStrategy {
    private static final double SIZE_LIMIT_PERCENTAGE = 0.75;
    private static final String LOG_MSG_RECOMMENDING_AGGREGATES = "Recommend aggregates based on the last in-memory aggregate load in the workload log - %s";
    private static final String LOG_MSG_REMOVED_AGGREGATE = "Removed the aggregate \"%s\"";
    private static final String LOG_MSG_AGGREGATE_CANNOT_BE_USED = "The aggregate \"%s\" cannot be used as a candidate because ";
    private static final String LOG_MSG_UPDATED_AGGREGATE = "Updated the %s of the aggregate \"%s\"";
    private List<Aggregate> loadedAggregates = new ArrayList<Aggregate>();
    private Map<String, Aggregate> aggregateMap = new HashMap<String, Aggregate>();

    public LastAggregateLoadStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> aggregates) {
        try {
            ROLAPLog.log("ROLAPAggregateAdvisor", AdvisorTrace.majorHeading(String.format(LOG_MSG_RECOMMENDING_AGGREGATES, "begin")));
            List<Aggregate> aggregatesToAdd = this.createAggregates();
            this.loadedAggregates.addAll(aggregatesToAdd);
            this.aggregateAdvisor.setLastAggregateLoadStrategy(this);
            ROLAPLog.log("ROLAPAggregateAdvisor", AdvisorTrace.majorHeading(String.format(LOG_MSG_RECOMMENDING_AGGREGATES, "end")));
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", String.format(LOG_MSG_RECOMMENDING_AGGREGATES, "failed"), ex);
        }
    }

    public List<Aggregate> getLoadedAggregates() {
        return this.loadedAggregates;
    }

    private List<Aggregate> createAggregates() {
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>();
        if (this.aggregateAdvisor.getUnitTestParameters().getAggregateLoadSummary() != null) {
            aggregates.addAll(this.aggregateAdvisor.getUnitTestParameters().getAggregateLoadSummary());
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("%nCandidates - last in-memory aggregate load:%n%s ", AdvisorTrace.formatAggregates(aggregates)));
            this.saveSliceCardinalities(aggregates);
            return aggregates;
        }
        String cubeName = this.metaCube.getName();
        AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo = AggregateLoadInfoLogFileUtility.readAggregateLoadManagerTaskInfo(cubeName);
        if (aggregateLoadManagerTaskInfo != null) {
            this.createAggregates(aggregateLoadManagerTaskInfo);
            this.initializeAggregateSizeInfo(aggregateLoadManagerTaskInfo);
            this.initializeAggregateUsageInfo();
            this.traceAggregateUsageAndSizeInfo();
            aggregates.addAll(this.aggregateMap.values());
            this.removeAggregatesBasedOnOptimizationRegion(aggregates);
            this.removeAggregates(aggregates);
            this.updateAggregates(aggregates);
            this.saveSliceCardinalities(aggregates);
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("%nCandidates - last in-memory aggregate load:%n%s", AdvisorTrace.formatAggregates(aggregates)));
        }
        return aggregates;
    }

    private void saveSliceCardinalities(List<Aggregate> aggregates) {
        for (Aggregate aggregate : aggregates) {
            CubeCardinalityMetrics cubeCardinalityMetrics = this.aggregateAdvisor.getCubeCardinalityMetrics();
            cubeCardinalityMetrics.setActualSliceCardinality(aggregate.getSliceId(), aggregate.getCardinality());
        }
    }

    private void createAggregates(AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo) {
        String aggregateXML = aggregateLoadManagerTaskInfo.getAggregateXML();
        AggregateXMLParser aggregateXMLParser = new AggregateXMLParser(aggregateXML);
        List<AggregateElement> aggregateElements = aggregateXMLParser.parseAggregateElements();
        for (AggregateElement aggregateElement : aggregateElements) {
            if (!this.aggregateDefinitionMatchesCubeDefinition(aggregateElement)) continue;
            Aggregate aggregate = this.createAggregate(aggregateElement);
            if (!aggregate.getMeasures().isEmpty()) {
                this.aggregateMap.put(aggregateElement.getName(), aggregate);
                continue;
            }
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_REMOVED_AGGREGATE, aggregate.getName()));
        }
    }

    private void initializeAggregateSizeInfo(AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo) {
        List<AggregateLoadTaskInfo> aggregateLoadTaskInfos = aggregateLoadManagerTaskInfo.getAggregateLoadTaskInfos();
        for (AggregateLoadTaskInfo aggregateLoadTaskInfo : aggregateLoadTaskInfos) {
            long sizeInCells;
            String aggregateName = aggregateLoadTaskInfo.getAggregateName();
            Aggregate aggregate = this.aggregateMap.get(aggregateName);
            if (aggregate == null) continue;
            long sizeInBytes = aggregateLoadTaskInfo.getAggregateSizeInBytes();
            if (sizeInBytes > 0L) {
                aggregate.setEstimatedSize(sizeInBytes);
            }
            if ((sizeInCells = aggregateLoadTaskInfo.getAggregateSizeInCells()) <= 0L) continue;
            int measureCount = aggregate.getMeasures().size();
            long cardinality = sizeInCells / (long)measureCount;
            aggregate.setCardinality(cardinality);
        }
    }

    private void initializeAggregateUsageInfo() {
        WorkloadSummary workloadSummary = this.aggregateAdvisor.getWorkloadSummary();
        if (workloadSummary == null) {
            ROLAPLog.log("ROLAPAggregateAdvisor", "No information about the usage of the in-memory aggregates is available.");
            return;
        }
        HashMap<String, WorkloadAggregateCacheCollection.AggregateCacheHitData> aggregateCacheHitDataMap = workloadSummary.getAggregateCacheSummaryData();
        Set<Map.Entry<String, Aggregate>> aggregateEntries = this.aggregateMap.entrySet();
        for (Map.Entry<String, Aggregate> aggregateEntry : aggregateEntries) {
            String aggregateName = aggregateEntry.getKey();
            Aggregate aggregate = aggregateEntry.getValue();
            WorkloadAggregateCacheCollection.AggregateCacheHitData aggregateCacheHitData = (WorkloadAggregateCacheCollection.AggregateCacheHitData)aggregateCacheHitDataMap.get(aggregateName);
            if (aggregateCacheHitData == null) continue;
            int hitCount = aggregateCacheHitData.getHitCount();
            aggregate.setHitCount(hitCount);
            long executionTime = aggregateCacheHitData.getExecutionTime();
            aggregate.setExecutionTime(executionTime);
        }
    }

    private Aggregate createAggregate(AggregateElement aggregateElement) {
        Aggregate aggregate = new Aggregate(this.metaCube);
        aggregate.setAggregateAdvisor(this.aggregateAdvisor);
        aggregate.setRecommendedBy(AggregateRecommendedByEnum.CUBE_LOAD);
        aggregate.setName(aggregateElement.getName());
        this.addDimensions(aggregate, aggregateElement);
        this.addMeasures(aggregate, aggregateElement);
        return aggregate;
    }

    private void addDimensions(Aggregate aggregate, AggregateElement aggregateElement) {
        List<DimensionRefElement> dimensionRefElements = aggregateElement.getDimensionRefElements();
        for (DimensionRefElement dimensionRefElement : dimensionRefElements) {
            this.addHierarchies(aggregate, dimensionRefElement);
        }
    }

    private void addHierarchies(Aggregate aggregate, DimensionRefElement dimensionRefElement) {
        List<HierarchyRefElement> hierarchyRefElements = dimensionRefElement.getHierarchyRefElements();
        for (HierarchyRefElement hierarchyRefElement : hierarchyRefElements) {
            this.addLevel(aggregate, hierarchyRefElement);
        }
    }

    private void addLevel(Aggregate aggregate, HierarchyRefElement hierarchyRefElement) {
        DimensionRefElement dimensionRefElement = hierarchyRefElement.getDimensionRefElement();
        String dimensionName = dimensionRefElement.getName();
        String hierarchyName = hierarchyRefElement.getName();
        String levelName = null;
        LevelElement levelElement = hierarchyRefElement.getLevelElement();
        if (levelElement instanceof LevelRefElement) {
            LevelRefElement levelRefElement = (LevelRefElement)levelElement;
            levelName = levelRefElement.getName();
        } else if (levelElement instanceof AllLevelElement) {
            levelName = "[All]";
        } else if (levelElement instanceof RootLevelElement) {
            levelName = "[Root]";
        }
        aggregate.setLevel(dimensionName, hierarchyName, levelName);
    }

    private void addMeasures(Aggregate aggregate, AggregateElement aggregateElement) {
        List<MeasureRefElement> measureRefElements = aggregateElement.getMeasureRefElements();
        for (MeasureRefElement measureRefElement : measureRefElements) {
            this.addMeasure(aggregate, measureRefElement);
        }
    }

    private void addMeasure(Aggregate aggregate, MeasureRefElement measureRefElement) {
        String measureName = measureRefElement.getName();
        ROLAPMetaMeasure metaMeasure = AdvisorUtils.getMetaMeasure(this.metaCube, measureName);
        if (metaMeasure != null && this.aggregateAdvisor.isMeasureSupported(metaMeasure)) {
            aggregate.addMeasure(metaMeasure);
        }
    }

    private boolean aggregateDefinitionMatchesCubeDefinition(AggregateElement aggregateElement) {
        return this.aggregateDimensionsMatchCubeDimensions(aggregateElement) && this.aggregateMeasuresMatchCubeMeasures(aggregateElement);
    }

    private boolean aggregateDimensionsMatchCubeDimensions(AggregateElement aggregateElement) {
        String aggregateName = aggregateElement.getName();
        List<DimensionRefElement> aggregateDimensions = aggregateElement.getDimensionRefElements();
        ROLAPMetaDimension[] cubeDimensions = this.metaCube.getDimensions();
        if (aggregateDimensions.size() != cubeDimensions.length) {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the aggregate does not contain the same number of dimensions as the cube.", aggregateName));
            return false;
        }
        for (DimensionRefElement aggregateDimension : aggregateDimensions) {
            String cubeDimensionCategory;
            String dimensionName = aggregateDimension.getName();
            ROLAPMetaDimension cubeDimension = AdvisorUtils.getMetaDimension(this.metaCube, dimensionName);
            if (cubeDimension == null) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the aggregate contains the dimension \"%s\" but the cube does not.", aggregateName, dimensionName));
                return false;
            }
            String aggregateDimensionCategory = aggregateDimension.getCategory();
            if (!aggregateDimensionCategory.equals(cubeDimensionCategory = cubeDimension.getCategory())) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the dimension \"%s\" in the aggregate is %s but the corresponding dimension in the cube is %s.", aggregateName, dimensionName, aggregateDimensionCategory, cubeDimensionCategory));
                return false;
            }
            if (this.aggregateHierarchiesMatchCubeHierarchies(aggregateDimension, cubeDimension)) continue;
            return false;
        }
        return true;
    }

    private boolean aggregateHierarchiesMatchCubeHierarchies(DimensionRefElement aggregateDimension, ROLAPMetaDimension cubeDimension) {
        String aggregateName = aggregateDimension.getAggregateElement().getName();
        String dimensionName = aggregateDimension.getName();
        List<HierarchyRefElement> aggregateHierarchies = aggregateDimension.getHierarchyRefElements();
        ROLAPMetaHierarchy[] cubeHierarchies = this.metaCube.getHierarchies(cubeDimension);
        if (aggregateHierarchies.size() != cubeHierarchies.length) {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the dimension \"%s\" in the aggregate does not contain the same number of hierarchies as the corresponding dimension in the cube.", aggregateName, dimensionName));
            return false;
        }
        for (HierarchyRefElement aggregateHierarchy : aggregateHierarchies) {
            String hierarchyName = aggregateHierarchy.getName();
            ROLAPMetaHierarchy cubeHierarchy = AdvisorUtils.getMetaHierarchy(this.metaCube, dimensionName, hierarchyName);
            if (cubeHierarchy == null) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the dimension \"%s\" in the aggregate contains the hierarchy \"%s\" but the corresponding dimension in the cube does not.", aggregateName, dimensionName, hierarchyName));
                return false;
            }
            if (this.aggregateLevelMatchesCubeLevel(aggregateHierarchy, cubeHierarchy)) continue;
            return false;
        }
        return true;
    }

    private boolean aggregateLevelMatchesCubeLevel(HierarchyRefElement aggregateHierarchy, ROLAPMetaHierarchy cubeHierarchy) {
        DimensionRefElement aggregateDimension = aggregateHierarchy.getDimensionRefElement();
        String aggregateName = aggregateDimension.getAggregateElement().getName();
        String dimensionName = aggregateDimension.getName();
        String hierarchyName = aggregateHierarchy.getName();
        LevelElement aggregateLevel = aggregateHierarchy.getLevelElement();
        if (aggregateLevel instanceof AllLevelElement) {
            if (!cubeHierarchy.hasAllLevel()) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the hierarchy \"%s\" in the dimension \"%s\" in the aggregate has an all level but the corresponding hierarchy in the cube does not.", aggregateName, hierarchyName, dimensionName));
                return false;
            }
        } else if (aggregateLevel instanceof RootLevelElement) {
            if (!cubeHierarchy.isRecursive()) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the hierarchy \"%s\" in the dimension \"%s\" in the aggregate is recursive but the corresponding hierarchy in the cube is not.", aggregateName, hierarchyName, dimensionName));
                return false;
            }
            if (cubeHierarchy.hasAllLevel()) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the hierarchy \"%s\" in the dimension \"%s\" in the aggregate does not have an all level but the corresponding hierarchy in the cube does.", aggregateName, hierarchyName, dimensionName));
                return false;
            }
        } else if (aggregateLevel instanceof LevelRefElement) {
            if (cubeHierarchy.isRecursive()) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the hierarchy \"%s\" in the dimension \"%s\" in the aggregate is not recursive but the corresponding hierarchy in the cube is.", aggregateName, hierarchyName, dimensionName));
                return false;
            }
            String levelName = ((LevelRefElement)aggregateLevel).getName();
            ROLAPMetaLevel cubeLevel = cubeHierarchy.getLevel(levelName);
            if (cubeLevel == null) {
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the hierarchy \"%s\" in the dimension \"%s\" in the aggregate contains the level \"%s\" but the corresponding hierarchy in the cube does not.", aggregateName, hierarchyName, dimensionName, levelName));
                return false;
            }
        }
        return true;
    }

    private boolean aggregateMeasuresMatchCubeMeasures(AggregateElement aggregateElement) {
        String aggregateName = aggregateElement.getName();
        List<MeasureRefElement> aggregateMeasures = aggregateElement.getMeasureRefElements();
        for (MeasureRefElement aggregateMeasure : aggregateMeasures) {
            String measureName = aggregateMeasure.getName();
            ROLAPMetaMeasure cubeMeasure = AdvisorUtils.getMetaMeasure(this.metaCube, measureName);
            if (cubeMeasure != null) continue;
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The aggregate \"%s\" cannot be used as a candidate because the aggregate contains the measure \"%s\" but the cube does not.", aggregateName, measureName));
            return false;
        }
        return true;
    }

    private void removeAggregates(List<Aggregate> aggregates) {
        this.removeAggregatesBasedOnOptimizationRegion(aggregates);
        this.removeAggregatesBasedOnWorkloadLog(aggregates);
    }

    private void removeAggregatesBasedOnOptimizationRegion(List<Aggregate> aggregates) {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Removing in-memory aggregates based on cube optimization region");
        ArrayList<Aggregate> aggregatesInOptimizationRegion = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (this.aggregateAdvisor.getOptimizationRegion().isSliceWithinRegion(aggregate.getSliceId())) {
                aggregatesInOptimizationRegion.add(aggregate);
                continue;
            }
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_REMOVED_AGGREGATE, aggregate.getName()));
        }
        aggregates.clear();
        aggregates.addAll(aggregatesInOptimizationRegion);
    }

    private void removeAggregatesBasedOnWorkloadLog(List<Aggregate> aggregates) {
        long totalSize;
        if (!this.aggregateAdvisor.isIncludeWorkloadInfo()) {
            ROLAPLog.log("ROLAPAggregateAdvisor", "The workload log is not being analyzed; in-memory aggregates will not be removed based on usage.");
            return;
        }
        long totalSizeLimit = (long)(0.75 * (double)this.aggregateAdvisor.getInMemoryAggregatesLimit());
        if (this.aggregateAdvisor.isCubeAutonomic()) {
            totalSizeLimit = this.aggregateAdvisor.getInMemoryAggregatesLimit();
        }
        if ((totalSize = this.getTotalSize()) > totalSizeLimit) {
            this.removeAggregatesBasedOnLoadFailure(aggregates);
            this.removeAggregatesBasedOnUsageAndSizeInfo(aggregates, totalSize, totalSizeLimit);
        } else {
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The size of the in-memory aggregates (%,d bytes) does not exceed the size limit (%,d bytes) for removing aggregates based on usage.", totalSize, totalSizeLimit));
        }
    }

    private void removeAggregatesBasedOnLoadFailure(List<Aggregate> aggregates) {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Removing in-memory aggregates based on load failure");
        Set<Map.Entry<String, Aggregate>> aggregateEntries = this.aggregateMap.entrySet();
        for (Map.Entry<String, Aggregate> aggregateEntry : aggregateEntries) {
            boolean removed;
            String aggregateName = aggregateEntry.getKey();
            Aggregate aggregate = aggregateEntry.getValue();
            long aggregateSize = aggregate.getEstimatedSize();
            if (aggregateSize > 0L || !(removed = aggregates.remove(aggregate))) continue;
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_REMOVED_AGGREGATE, aggregateName));
        }
    }

    private void removeAggregatesBasedOnUsageAndSizeInfo(List<Aggregate> aggregates, long totalSize, long totalSizeLimit) {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Removing in-memory aggregates based on usage and size");
        ArrayList<Aggregate> aggregatesSortedByUsageAndSize = new ArrayList<Aggregate>(this.aggregateMap.values());
        Collections.sort(aggregatesSortedByUsageAndSize, new AggregateComparator());
        for (Aggregate aggregateSortedByUsageAndSize : aggregatesSortedByUsageAndSize) {
            boolean removed = aggregates.remove(aggregateSortedByUsageAndSize);
            if (!removed) continue;
            String aggregateName = aggregateSortedByUsageAndSize.getName();
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_REMOVED_AGGREGATE, aggregateName));
            long aggregateSize = aggregateSortedByUsageAndSize.getEstimatedSize();
            if ((totalSize -= aggregateSize) > totalSizeLimit) continue;
            break;
        }
    }

    private void updateAggregates(List<Aggregate> aggregates) {
        ROLAPLog.log("ROLAPAggregateAdvisor", "Updating in-memory aggregates that are missing information");
        for (Aggregate aggregate : aggregates) {
            long aggregateSize;
            String aggregateName = aggregate.getName();
            long aggregateCardinality = aggregate.getCardinality();
            if (aggregateCardinality <= 0L) {
                aggregateCardinality = this.getCardinality(aggregate);
                aggregate.setCardinality(aggregateCardinality);
                ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_UPDATED_AGGREGATE, "cardinality", aggregateName));
            }
            if ((aggregateSize = aggregate.getEstimatedSize()) > 0L) continue;
            aggregateSize = this.aggregateAdvisor.estimateInMemoryAggregateSize(aggregate);
            aggregate.setEstimatedSize(aggregateSize);
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format(LOG_MSG_UPDATED_AGGREGATE, "estimated size", aggregateName));
        }
    }

    private long getCardinality(Aggregate aggregate) {
        long cardinality = 0L;
        try {
            cardinality = this.aggregateAdvisor.getActualSliceCardinality(aggregate, "LastAggregateLoadStrategy");
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cardinality = 10000000000000000L;
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("Get cardinality failed for aggregate %s due to the exception: %s", aggregate.getName(), ex.getMessage()));
        }
        return cardinality;
    }

    private long getTotalSize() {
        long totalSize = 0L;
        Collection<Aggregate> aggregates = this.aggregateMap.values();
        for (Aggregate aggregate : aggregates) {
            long size = aggregate.getEstimatedSize();
            totalSize += size;
        }
        return totalSize;
    }

    private void traceAggregateUsageAndSizeInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nIn-memory aggregate usage and size:\n\n");
        sb.append(String.format("%15s  %15s  %15s  %15s  %s%n", "Hit count", "Execution time", "Size in bytes", "Cell count", "Aggregate name"));
        long totalHitCount = 0L;
        long totalExecutionTime = 0L;
        long totalSizeInBytes = 0L;
        long totalCellCount = 0L;
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>(this.aggregateMap.values());
        Collections.sort(aggregates, new AggregateComparator());
        for (Aggregate aggregate : aggregates) {
            String aggregateName = aggregate.getName();
            int hitCount = aggregate.getHitCount();
            long executionTime = aggregate.getExecutionTime();
            long sizeInBytes = aggregate.getEstimatedSize();
            long cellCount = aggregate.getNumberOfCells();
            totalHitCount += (long)hitCount;
            totalExecutionTime += executionTime;
            totalSizeInBytes += sizeInBytes;
            totalCellCount += cellCount;
            sb.append(String.format("%,15d  %,15d  %,15d  %,15d  %s%n", hitCount, executionTime, sizeInBytes, cellCount, aggregateName));
        }
        sb.append(String.format("%,15d  %,15d  %,15d  %,15d  Total for %d aggregates%n", totalHitCount, totalExecutionTime, totalSizeInBytes, totalCellCount, aggregates.size()));
        ROLAPLog.log("ROLAPAggregateAdvisor", sb.toString());
    }

    public static class AggregateComparator
    implements Comparator<Aggregate> {
        @Override
        public int compare(Aggregate aggregate1, Aggregate aggregate2) {
            long sizeInBytes2;
            int hitCount2;
            int hitCount1 = aggregate1.getHitCount();
            if (hitCount1 < (hitCount2 = aggregate2.getHitCount())) {
                return -1;
            }
            if (hitCount1 > hitCount2) {
                return 1;
            }
            long sizeInBytes1 = aggregate1.getEstimatedSize();
            if (sizeInBytes1 < (sizeInBytes2 = aggregate2.getEstimatedSize())) {
                return 1;
            }
            if (sizeInBytes1 > sizeInBytes2) {
                return -1;
            }
            return 0;
        }
    }
}

