/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeRegion;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.ConsolidateAggregatesStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import java.util.ArrayList;
import java.util.List;

public class ModelBasedUpperSlicesStrategy
extends AggregateRecommendationStrategy {
    private static final int NUM_AGGREGATES_TO_CONSIDER_IF_WORKLOAD = 25;
    private static final int NUM_AGGREGATES_TO_CONSIDER_IF_NO_WORKLOAD = 75;
    private static final int LOW_CARDINALITY_LEVEL = 100;

    public ModelBasedUpperSlicesStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> aggregates) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend upper slices based on the model - begin"));
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        ArrayList<Aggregate> upperAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> upperAggregatesSizeOk = new ArrayList<Aggregate>();
        ArrayList<Aggregate> upperAggregatesTooBig = new ArrayList<Aggregate>();
        ConsolidateAggregatesStrategy consolidateStrategy = new ConsolidateAggregatesStrategy(this.metaCube, this.aggregateAdvisor);
        CubeRegion region = this.selectRegion();
        INFO_LOGGER.log("\nSelect aggregates from this region \n" + AdvisorTrace.cubeRegionToTraceString(this.metaCube, region));
        int numAggregatesToConsider = 0;
        numAggregatesToConsider = this.aggregateAdvisor.getRequestParameters().getIncludeWorkloadInfo() ? 25 : 75;
        Aggregate upperAggregate = null;
        for (int i = 1; i <= numAggregatesToConsider; ++i) {
            upperAggregate = this.randomAggregateInRegion(region);
            upperAggregates.add(upperAggregate);
        }
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(upperAggregates, upperAggregatesSizeOk, upperAggregatesTooBig);
        consolidateStrategy.recommendAggregates(upperAggregatesSizeOk);
        INFO_LOGGER.log("\n\nCandidate aggregates - high level slices (maximum cardinalities):\n" + AdvisorTrace.formatAggregates(upperAggregatesSizeOk) + "\nAggregates rejected because cardinality too high:\n" + AdvisorTrace.formatAggregates(upperAggregatesTooBig));
        aggregates.addAll(upperAggregatesSizeOk);
        consolidateStrategy.recommendAggregates(aggregates);
        this.aggregateAdvisor.saveRecommendations(aggregates);
        this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 100);
        upperAggregates.retainAll(upperAggregatesTooBig);
        this.aggregateAdvisor.improveCardinalityEstimates(upperAggregates, "ModelBasedUpperSlicesStrategy");
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(upperAggregates, upperAggregatesSizeOk, upperAggregatesTooBig);
        this.aggregateAdvisor.addRejectedAggregates(upperAggregatesTooBig);
        aggregates.addAll(upperAggregatesSizeOk);
        this.aggregateAdvisor.improveCardinalityEstimates(aggregates, "ModelBasedUpperSlicesStrategy");
        consolidateStrategy.recommendAggregates(aggregates);
        this.aggregateAdvisor.saveRecommendations(aggregates);
        this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 100);
        INFO_LOGGER.log("\n\nCandidate aggregates - current candidates + high level slices:\n" + AdvisorTrace.formatAggregates(aggregates) + "\nAggregates rejected because cardinality too high:\n " + AdvisorTrace.formatAggregates(upperAggregatesTooBig));
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("ModelBasedUpperSlicesStrategy", elapsedTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend upper slices based on the model - end"));
    }

    private Aggregate randomAggregateInRegion(CubeRegion region) {
        Aggregate upperAggregate = this.aggregateAdvisor.randomAggregateInRegion(region);
        upperAggregate.setAggregateAdvisor(this.aggregateAdvisor);
        upperAggregate.setRecommendedBy(AggregateRecommendedByEnum.MODEL);
        upperAggregate.addMeasures(this.aggregateAdvisor.selectMeasuresBasedOnModel());
        upperAggregate.setName(upperAggregate.generateDescriptiveName());
        long cardinality = this.aggregateAdvisor.getMaxSliceCardinality(upperAggregate);
        upperAggregate.setMaxCardinality(cardinality);
        upperAggregate.setCardinality(cardinality);
        return upperAggregate;
    }

    private CubeRegion selectRegion() {
        ROLAPMetaDimension timeDimension = this.aggregateAdvisor.determineTimeDimension();
        int position = -1;
        CubeRegion region = new CubeRegion(this.metaCube);
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                SliceCombination sliceId;
                if (hierarchy.isRecursive()) {
                    if (hierarchy.hasAllLevel()) {
                        region.select(dimension.getName(), hierarchy.getName(), "[All]");
                    } else {
                        region.select(dimension.getName(), hierarchy.getName(), "[Root]");
                    }
                } else if (timeDimension != null && dimension.getName().equals(timeDimension.getName())) {
                    ROLAPMetaLevel[] levels = hierarchy.getLevels();
                    for (int index = levels.length - 1; index >= 0; --index) {
                        if (index < levels.length / 2) continue;
                        region.select(dimension.getName(), hierarchy.getName(), levels[index].getName());
                    }
                } else {
                    if (hierarchy.hasAllLevel()) {
                        region.select(dimension.getName(), hierarchy.getName(), "[All]");
                    }
                    for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                        long levelCardinality = this.aggregateAdvisor.getCubeCardinalityMetrics().getLevelCardinality(dimension.getName(), hierarchy.getName(), level.getName());
                        if (levelCardinality > 100L && region.getLevels(dimension.getName(), hierarchy.getName()).size() != 0) continue;
                        region.select(dimension.getName(), hierarchy.getName(), level.getName());
                    }
                }
                if (hierarchy.isRecursive() || (sliceId = this.aggregateAdvisor.getOptimizationRegion()).getMinimum(++position) != sliceId.getMaximum(position)) continue;
                ROLAPMetaLevel[] levels = hierarchy.getLevels();
                for (int index = 0; index < levels.length; ++index) {
                    region.deselect(dimension.getName(), hierarchy.getName(), levels[index].getName());
                }
                if (sliceId.getMaximum(position) == 0) {
                    region.select(dimension.getName(), hierarchy.getName(), "[All]");
                    continue;
                }
                region.select(dimension.getName(), hierarchy.getName(), levels[0].getName());
            }
        }
        return region;
    }
}

